/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cluster.core;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import jet.server.api.cluster.ClusterException;
import jet.server.cluster.core.ClusterServer;
import jet.server.cluster.core.JRChannel;
import jet.server.cluster.core.JRMessage;
import jet.server.cluster.core.JRView;
import jet.server.cluster.core.MemberService;
import jet.server.cluster.core.MembershipListener;
import jet.server.cluster.core.Topic;
import jet.server.jrc.JRMember;
import jet.server.log.ServiceLogger;

public class Transceiver
implements MembershipListener {
    private final Topic beforeClose;
    private JRChannel castRequest;
    private boolean getChannel;

    public Transceiver(Topic topic) {
        if (topic == null) {
            throw new NullPointerException("null topic.");
        }
        this.beforeClose = topic;
        this.connect();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + (Object)((Object)this.beforeClose) + "]";
    }

    public final boolean hasConnected() {
        return this.getChannel;
    }

    private void SEDU() throws ClusterException {
        if (!this.hasConnected()) {
            throw new ClusterException(new IllegalStateException("channel has closed."));
        }
    }

    private void connect() {
        if (this.hasConnected()) {
            return;
        }
        this.castRequest = ClusterServer.getChannel();
        this.castRequest.registerTransceiver(this);
        this.getChannel = true;
    }

    public final synchronized void disconnect() {
        if (!this.hasConnected()) {
            return;
        }
        this.getChannel = false;
        this.castRequest.unregisterTransceiver(this);
        this.castRequest = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void close() {
        if (!this.hasConnected()) {
            return;
        }
        try {
            this.beforeClose();
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        finally {
            this.castRequest = null;
            this.getChannel = false;
        }
    }

    public final Topic getTopic() {
        return this.beforeClose;
    }

    public final MemberService getMemberService() {
        return this.castRequest.getMemberService();
    }

    public final List getMembers() {
        return this.castRequest.getMemberService().getMembers();
    }

    public final Set getMembersIdSet() {
        return this.castRequest.getMemberService().getMembersIdSet();
    }

    public final JRMember getMemberByID(int n) {
        return this.castRequest.getMemberService().getMemberById(n);
    }

    public final JRMember getLocalMember() {
        return this.castRequest.getLocalMember();
    }

    public final JRMember getCoordinator() {
        return this.castRequest.getMemberService().getCoordinator();
    }

    public final boolean isCoordinator() {
        return this.castRequest.getMemberService().isCoordinator();
    }

    public final JRView getView() {
        return this.castRequest.getMemberService().getView();
    }

    public final void sendMessage(int n, JRMessage jRMessage) throws ClusterException {
        this.SEDU();
        jRMessage.setTopic(this.beforeClose);
        if (n == -1) {
            n = this.getCoordinator().getID();
        }
        jRMessage.setDest(n);
        jRMessage.setSource(this.castRequest.getLocalMember().getID());
        this.castRequest.sendMessage(jRMessage);
    }

    public final void castMessage(JRMessage jRMessage) throws ClusterException {
        this.SEDU();
        jRMessage.setTopic(this.beforeClose);
        jRMessage.setDest(-1);
        jRMessage.setSource(this.castRequest.getLocalMember().getID());
        this.castRequest.castMessage(jRMessage);
    }

    public final void castMessage(List list, JRMessage jRMessage) throws ClusterException {
        this.SEDU();
        jRMessage.setTopic(this.beforeClose);
        jRMessage.setDest(-1);
        jRMessage.setSource(this.castRequest.getLocalMember().getID());
        this.castRequest.castMessage(list, jRMessage);
    }

    public final Object sendRequest(int n, JRMessage jRMessage, long l) throws ClusterException {
        this.SEDU();
        jRMessage.setTopic(this.beforeClose);
        jRMessage.setDest(n);
        jRMessage.setSource(this.castRequest.getLocalMember().getID());
        return this.castRequest.sendRequest(jRMessage, l);
    }

    public final List castRequest(JRMessage jRMessage, long l) throws ClusterException {
        this.SEDU();
        jRMessage.setTopic(this.beforeClose);
        jRMessage.setSource(this.castRequest.getLocalMember().getID());
        return this.castRequest.castRequest(jRMessage, l);
    }

    public final List castRequest(List list, JRMessage jRMessage, long l) throws ClusterException {
        this.SEDU();
        jRMessage.setTopic(this.beforeClose);
        jRMessage.setSource(this.castRequest.getLocalMember().getID());
        return this.castRequest.castRequest(list, jRMessage, l);
    }

    public final Object castRequestAndReturnFirstResult(List list, JRMessage jRMessage, boolean bl, long l) throws ClusterException {
        this.SEDU();
        jRMessage.setTopic(this.beforeClose);
        jRMessage.setSource(this.castRequest.getLocalMember().getID());
        return this.castRequest.castRequestAndReturnFirstResult(list, jRMessage, bl, l);
    }

    @Override
    public void viewAccepted(JRView jRView) {
    }

    @Override
    public void suspect(JRMember jRMember) {
    }

    public void handleMessage(JRMessage jRMessage) {
    }

    public Serializable handleRequest(JRMessage jRMessage) {
        return null;
    }

    public void beforeClose() {
    }

    public void checkState() {
    }
}

