/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cluster.rmi;

import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jet.ReportEnv;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.cluster.ClusterException;
import jet.server.cluster.ClusterEnv;
import jet.server.cluster.core.ChannelAdapter;
import jet.server.cluster.core.JRMessage;
import jet.server.cluster.core.JRView;
import jet.server.cluster.core.MemberService;
import jet.server.cluster.core.MembershipListener;
import jet.server.cluster.core.MessageReceiver;
import jet.server.cluster.core.Response;
import jet.server.cluster.rmi.JRMITransport;
import jet.server.cluster.rmi.RMITransport;
import jet.server.jrc.JRMember;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.util.ServerUtil;

public class JRMIChannel
implements ChannelAdapter {
    private JRMember SEDU;
    private MessageReceiver add;
    private MembershipListener append;
    private MemberService castMessage;
    private Map castRequest;
    private JRMITransport checkConnection;
    private boolean clear;
    private boolean currentTimeMillis;

    public JRMIChannel(JRMember jRMember, MessageReceiver messageReceiver, MembershipListener membershipListener, MemberService memberService) {
        this.SEDU = jRMember;
        this.add = messageReceiver;
        this.append = membershipListener;
        this.castMessage = memberService;
        this.castRequest = new ConcurrentHashMap();
    }

    private boolean SEDU() {
        return this.clear;
    }

    private boolean add() {
        return this.currentTimeMillis;
    }

    @Override
    public void startup() throws ClusterException {
        if (this.SEDU()) {
            return;
        }
        try {
            if (!RemoteObjectFactory.init(CSUtil.parseInt(this.SEDU.getPort()), ReportEnv.homePath)) {
                throw new ClusterException("RMIChannel: init rmi failed, please check previous error.");
            }
            this.checkConnection = new JRMITransport(this.add);
            if (ServerEnv.shouldStartRMI()) {
                UnicastRemoteObject.exportObject((Remote)this.checkConnection, CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
            }
            RemoteObjectFactory.register("RMITransport", this.checkConnection);
            this.clear = true;
        }
        catch (RemoteException remoteException) {
            throw new ClusterException(remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws ClusterException {
        try {
            if (!this.SEDU()) {
                return;
            }
            this.clear = false;
        }
        finally {
            this.append();
        }
    }

    private void append() {
        if (this.add()) {
            return;
        }
        this.clear = false;
        this.currentTimeMillis = true;
        this.castRequest.clear();
        this.castRequest = null;
        this.add = null;
        this.append = null;
        this.castMessage = null;
        this.checkConnection = null;
    }

    private RMITransport castMessage(int n) throws MalformedURLException, RemoteException, NotBoundException, ClusterException {
        RMITransport rMITransport = (RMITransport)this.castRequest.get(n);
        if (rMITransport == null) {
            JRMember jRMember = this.castMessage.getMemberById(n);
            if (jRMember == null) {
                throw new ClusterException("RMIChannel:: dest member not exists: " + n);
            }
            rMITransport = (RMITransport)RemoteObjectFactory.getRemoteObject(jRMember.getHost(), CSUtil.parseInt(jRMember.getPort()), "RMITransport");
            this.castRequest.put(n, rMITransport);
        }
        return rMITransport;
    }

    private void castRequest(int n, JRMessage jRMessage) throws ClusterException {
        try {
            this.castMessage(n).message(jRMessage);
        }
        catch (ClusterException clusterException) {
            throw clusterException;
        }
        catch (Throwable throwable) {
            ServiceLogger.logDebug(4650081, new Object[]{n, "message", jRMessage}, 4);
            this.append.suspect(this.castMessage.getMemberById(n));
            throw new ClusterException(throwable);
        }
    }

    private Object checkConnection(int n, JRMessage jRMessage) throws ClusterException {
        try {
            return this.castMessage(n).request(jRMessage);
        }
        catch (ClusterException clusterException) {
            throw clusterException;
        }
        catch (Throwable throwable) {
            ServiceLogger.logDebug(4650081, new Object[]{n, "request", jRMessage}, 4);
            this.append.suspect(this.castMessage.getMemberById(n));
            throw new ClusterException(throwable);
        }
    }

    private long[] clear(JRMember jRMember) throws MalformedURLException, RemoteException, NotBoundException, ClusterException {
        RMITransport rMITransport = (RMITransport)this.castRequest.get(jRMember.getID());
        if (rMITransport == null) {
            rMITransport = (RMITransport)RemoteObjectFactory.getRemoteObject(jRMember.getHost(), CSUtil.parseInt(jRMember.getPort()), "RMITransport");
        }
        long l = System.currentTimeMillis();
        long l2 = rMITransport.checkConnection(this.SEDU.getID(), l);
        long l3 = System.currentTimeMillis() - l;
        long l4 = l + l3 / 2L;
        long l5 = l2 - l4;
        try {
            if (ServerUtil.isLocalAddress(jRMember.getHost())) {
                l5 = 0L;
            }
        }
        catch (UnknownHostException unknownHostException) {
            ServiceLogger.logError(unknownHostException);
        }
        return new long[]{l5, l3};
    }

    @Override
    public void castMessage(JRMessage jRMessage) throws ClusterException {
        this.castMessage(new ArrayList(this.castMessage.getMembersIdSet()), jRMessage);
    }

    @Override
    public void castMessage(List list, JRMessage jRMessage) throws ClusterException {
        for (Integer n : list) {
            if (n.intValue() == this.SEDU.getID()) continue;
            try {
                this.castRequest(n, jRMessage);
            }
            catch (ClusterException clusterException) {
                ServiceLogger.logError((Throwable)((Object)clusterException));
            }
        }
    }

    @Override
    public List castRequest(JRMessage jRMessage, long l) throws ClusterException {
        return this.castRequest(new ArrayList(this.castMessage.getMembersIdSet()), jRMessage, l);
    }

    @Override
    public List castRequest(List list, JRMessage jRMessage, long l) throws ClusterException {
        ArrayList<Response> arrayList = new ArrayList<Response>();
        for (Integer n : list) {
            if (n.intValue() == this.SEDU.getID()) continue;
            try {
                Object object = this.checkConnection(n, jRMessage);
                arrayList.add(new Response((int)n, object));
            }
            catch (ClusterException clusterException) {
                arrayList.add(new Response((int)n, (Throwable)((Object)clusterException)));
                ServiceLogger.logError((Throwable)((Object)clusterException));
            }
        }
        return arrayList;
    }

    @Override
    public Object castRequestAndReturnFirstResult(List list, JRMessage jRMessage, boolean bl, long l) throws ClusterException {
        Object object = null;
        boolean bl2 = false;
        for (Integer n : list) {
            if (n.intValue() == this.SEDU.getID()) continue;
            try {
                if (bl2) {
                    this.castRequest(n, jRMessage);
                    continue;
                }
                object = this.checkConnection(n, jRMessage);
            }
            catch (ClusterException clusterException) {
                ServiceLogger.logError((Throwable)((Object)clusterException));
            }
        }
        return object;
    }

    @Override
    public void sendMessage(JRMessage jRMessage) throws ClusterException {
        this.castRequest(jRMessage.getDest(), jRMessage);
    }

    @Override
    public Object sendRequest(JRMessage jRMessage, long l) throws ClusterException {
        return this.checkConnection(jRMessage.getDest(), jRMessage);
    }

    @Override
    public JRView verifyView(JRView jRView, Set set, JRView jRView2) throws ClusterException {
        Object object;
        Object object2;
        long l = System.currentTimeMillis();
        this.castRequest.clear();
        ArrayList<JRMember> arrayList = new ArrayList<JRMember>(jRView2.getMembers());
        boolean bl = jRView2.isMergeView();
        if (jRView != null) {
            object2 = JRView.minus(jRView, jRView2);
            if (set != null) {
                object2.removeAll(set);
            }
            if (object2.size() > 0) {
                ServiceLogger.logDebug("RMIChannel:: verifyView: confirm removed members...");
                object = new HashSet();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Integer n = (Integer)iterator.next();
                    JRMember jRMember = jRView.getMemberById(n);
                    try {
                        ServiceLogger.logDebug("RMIChannel:: checkConnection: " + jRMember);
                        this.clear(jRMember);
                        arrayList.add(jRMember);
                    }
                    catch (Throwable throwable) {
                        object.add(n);
                        object2.remove(n);
                        ServiceLogger.logError(throwable, 3);
                        ServiceLogger.logDebug("RMIChannel:: dead member: " + jRMember);
                    }
                }
                ServiceLogger.logDebug(4650082, new Object[]{object, object2}, 4);
            }
        } else {
            object2 = jRView2.getCoordinator();
            if (!((JRMember)object2).equals(this.SEDU)) {
                try {
                    object = this.clear((JRMember)object2);
                    ClusterEnv.setClusterTimeDiff(object[0]);
                    new ClusterTimeSynchronizer().start();
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                    throw new ClusterException(exception);
                }
            }
        }
        object2 = jRView2.getViewId();
        object = new JRView(jRView, this.SEDU, (String)object2, arrayList, bl);
        ServiceLogger.logDebug("RMIChannel:: verifyView elapsed=" + (System.currentTimeMillis() - l) + ", verifiedView=" + object);
        if (!bl && ((JRView)object).equals(jRView)) {
            ServiceLogger.logDebug("RMIChannel:: viewAccepted: view not change: " + object);
            return jRView;
        }
        return object;
    }

    class ClusterTimeSynchronizer
    extends Thread {
        ClusterTimeSynchronizer() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (JRMIChannel.this.clear) {
                block5: {
                    try {
                        Thread.sleep(3600000L);
                    }
                    catch (InterruptedException interruptedException) {
                        if (JRMIChannel.this.clear) break block5;
                        return;
                    }
                }
                try {
                    long[] lArray;
                    if (JRMIChannel.this.SEDU.equals(JRMIChannel.this.castMessage.getCoordinator()) || (lArray = JRMIChannel.this.clear(JRMIChannel.this.castMessage.getCoordinator()))[1] >= 1000L) continue;
                    ClusterEnv.setClusterTimeDiff(lArray[0]);
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
            }
        }
    }
}

