/*
 * Decompiled with CFR 0.152.
 */
package jet.server.crd;

import com.jinfonet.api.crd.DataResult;
import com.jinfonet.api.crd.QueryInformation;
import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.api.objectmanager.CatalogKeyImp;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import jet.JException;
import jet.cs.CSUtil;
import jet.dataengine.api.DSException;
import jet.dataengine.api.query.DatabaseMetadataInfo;
import jet.dataengine8.olap.util.CubeSizeCalc;
import jet.dataservice.api.JDataService;
import jet.exception.InvalidParameterException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.ParamDesc;
import jet.formula.formulaExecutor.ExecFormulaFailedException;
import jet.server.api.CatalogInfo;
import jet.server.api.ParamInfo;
import jet.server.api.ParameterManager;
import jet.server.api.PathInfo;
import jet.server.api.ResourceManager;
import jet.server.api.RptServerException;
import jet.server.api.crd.CRDInfoKey;
import jet.server.api.crd.CubeInfoKey;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.crd.CRDResultKey;
import jet.server.crd.CRDSimpleResult;
import jet.server.crd.ExtCRDInfo;
import jet.server.intf.engine.ConnectionInfoProvider;
import jet.server.jrc.JRRemoteCRDManager;
import jet.server.jrserver.JRParamInfo;
import jet.server.log.ServiceLogger;
import jet.server.objmanager.ObjectManagerImpl;
import jet.server.schedule.jrtasks.JRTUtil;
import jet.server.schedule.util.ConnectionInfo;
import jet.server.schedule.util.DatasourceInfo;
import jet.server.util.DatabaseMetadataInfoMaker;
import jet.server.util.ParamUtil;
import jet.server.util.ServerUtil;
import jet.server.util.StringUtil;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUQueriable;
import jet.universe.JetUUniverse;

public class CRDResultToolkit {
    public static CRDSimpleResult generateCRDResult(JRRemoteCRDManager jRRemoteCRDManager, JDataService jDataService, ExtCRDInfo extCRDInfo) throws IOException, InvalidParameterException, DSException, JException {
        DataResult[] dataResultArray;
        ServiceLogger.trace("CRDManager: CRDResultToolkit.generateCRDResult...(crdInfo=%s)", extCRDInfo);
        int n = extCRDInfo.getResultVersion();
        CRDInfoKey cRDInfoKey = extCRDInfo.getCRDKey();
        CRDResultKey cRDResultKey = new CRDResultKey(cRDInfoKey, n);
        QueryInformation[] queryInformationArray = CRDResultToolkit.convert(jRRemoteCRDManager, extCRDInfo);
        int n2 = extCRDInfo.getCacheType();
        String string = extCRDInfo.getLoginUser();
        double d = extCRDInfo.getMaxAllowMemory();
        if (string == null || string.trim().length() == 0) {
            string = "JReport_System_User";
        }
        if ((dataResultArray = CRDResultToolkit.SEDU(jDataService, queryInformationArray, string, (long)(d * 1024.0 * 1024.0), extCRDInfo.getCanSwaptoDisk())) == null || dataResultArray.length == 0) {
            ServiceLogger.trace("CRDManager: CRDResultToolkit.generateCRDResult: failed! result is null [crdInfo=%s]", extCRDInfo);
            return null;
        }
        CRDSimpleResult cRDSimpleResult = new CRDSimpleResult(cRDResultKey, dataResultArray[0].getType());
        try {
            if (dataResultArray.length == 1) {
                if (n2 == 1) {
                    cRDSimpleResult.setStream(dataResultArray[0].getStream());
                    cRDSimpleResult.setDataResult(dataResultArray[0]);
                } else {
                    cRDSimpleResult.setBVStream(dataResultArray[0].getStream());
                    cRDSimpleResult.setBVDataResult(dataResultArray[0]);
                }
            } else {
                cRDSimpleResult.setStream(dataResultArray[0].getStream());
                cRDSimpleResult.setDataResult(dataResultArray[0]);
                cRDSimpleResult.setBVStream(dataResultArray[1].getStream());
                cRDSimpleResult.setBVDataResult(dataResultArray[1]);
            }
            extCRDInfo.setActualUsedMemory(cRDSimpleResult.getCubeActualMemorySize());
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            ServiceLogger.trace("CRDManager: CRDResultToolkit.generateCRDResult DataResult.getStream: failed! %s [crdInfo=%s]", exception, extCRDInfo);
        }
        ServiceLogger.trace("CRDManager: CRDResultToolkit.generateCRDResult: success! [crdInfo=%s]", extCRDInfo);
        return cRDSimpleResult;
    }

    public static void cancelGenerateCRDResult(JRRemoteCRDManager jRRemoteCRDManager, JDataService jDataService, ExtCRDInfo extCRDInfo) throws IOException, DSException {
        ServiceLogger.trace("CRDManager: CRDResultToolkit.cancelGenerateCRDResult...(crdInfo=%s)", extCRDInfo);
        QueryInformation[] queryInformationArray = CRDResultToolkit.convert(jRRemoteCRDManager, extCRDInfo);
        try {
            ServiceLogger.trace("CRDManager: JDataService.cancelCRDTask... (queryInfos[0]=%s, queryInfos[1]=%s)", queryInformationArray[0], queryInformationArray.length > 1 ? queryInformationArray[1] : "<NULL>");
            jDataService.cancelCRDTask(queryInformationArray);
            ServiceLogger.trace("CRDManager: JDataService.cancelCRDTask: success. (queryInfos[0]=%s, queryInfos[1]=%s)", queryInformationArray[0], queryInformationArray.length > 1 ? queryInformationArray[1] : "<NULL>");
            ServiceLogger.trace("CRDManager: CRDResultToolkit.cancelGenerateCRDResult: success! [crdInfo=%s]", extCRDInfo);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            ServiceLogger.trace("CRDManager: JDataService.cancelCRDTask: failed! %s (queryInfos[0]=%s, queryInfos[1]=%s)", throwable, queryInformationArray[0], queryInformationArray.length > 1 ? queryInformationArray[1] : "<NULL>");
        }
    }

    private static QueryInformation[] convert(JRRemoteCRDManager jRRemoteCRDManager, ExtCRDInfo extCRDInfo) {
        QueryInformation[] queryInformationArray;
        Object object2;
        int n = 1;
        if (extCRDInfo.getQueryType() == 6) {
            n = 2;
        }
        Map map = extCRDInfo.getConnInfoMap();
        Hashtable<String, Properties> hashtable = new Hashtable<String, Properties>();
        for (Object object2 : map.keySet()) {
            hashtable.put((String)object2, (Properties)((Properties)map.get(object2)).clone());
        }
        Date date = extCRDInfo.getCatalogLastModified();
        object2 = new CatalogKeyImp(extCRDInfo.getCatalogPath(), date == null ? 0L : date.getTime(), extCRDInfo.getCatalogVersion());
        String string = extCRDInfo.getQueryName();
        String string2 = extCRDInfo.getDataSource();
        Map<String, String[]> map2 = extCRDInfo.getRuntimeParamValues();
        Locale locale = Locale.getDefault();
        QueryInformation queryInformation = new QueryInformation((CatalogKey)object2, string, n, string2, map2, locale);
        queryInformation.setJdbcUrls(null);
        queryInformation.setJndiNames(null);
        if (extCRDInfo.getUserNames() != null && extCRDInfo.getPasswords() != null) {
            queryInformation.setUsers(new Hashtable<String, String>(extCRDInfo.getUserNames()));
            queryInformation.setPwds(new Hashtable<String, String>(extCRDInfo.getPasswords()));
        }
        Map map3 = extCRDInfo.getRuntimeJdbcUrls();
        Map map4 = extCRDInfo.getRuntimeJndiNames();
        Map map5 = extCRDInfo.getRuntimePasswords();
        Map map6 = extCRDInfo.getRuntimeUserNames();
        Hashtable<String, DatabaseMetadataInfo> hashtable2 = new Hashtable<String, DatabaseMetadataInfo>();
        for (String string3 : hashtable.keySet()) {
            String string4;
            String string5;
            String string6;
            Properties properties = (Properties)hashtable.get(string3);
            String string7 = (String)map3.get(string3);
            if (string7 == null || string7.trim().length() == 0) {
                properties.remove("jrs.jdbc_url");
            }
            if ((string6 = (String)map4.get(string3)) == null || string6.trim().length() == 0) {
                properties.remove("jrs.jndi_datasource");
            }
            if ((string5 = (String)map5.get(string3)) == null || string5.trim().length() == 0) {
                properties.remove("jrs.ds_pswd");
            }
            if ((string4 = (String)map6.get(string3)) == null || string4.trim().length() == 0) {
                properties.remove("jrs.ds_user");
            }
            DatabaseMetadataInfo databaseMetadataInfo = DatabaseMetadataInfoMaker.make(properties);
            hashtable2.put(string3, databaseMetadataInfo);
            properties.remove("jrs.db_date_format");
            properties.remove("jrs.db_datetime_format");
            properties.remove("jrs.db_extra_characters");
            properties.remove("jrs.db_quote_character");
            properties.remove("jrs.db_transaction_readonly");
            properties.remove("jrs.db_refresh_support_info");
            properties.remove("jrs.db_time_format");
            properties.remove("jrs.db_transaction_mode");
            properties.remove("jrs.db_char_to_be_replaced");
            properties.remove("jrs.db_char_replaced_by");
        }
        queryInformation.setConnectionInfoMap(hashtable);
        queryInformation.setDatabaseMetadataInfoMap(hashtable2);
        int n2 = extCRDInfo.getCacheType();
        if (n2 == 3) {
            queryInformationArray = new QueryInformation[2];
            queryInformationArray[0] = queryInformation.clone();
            queryInformationArray[0].setBV(false);
            queryInformationArray[0].setBVName(extCRDInfo.getBVName());
            queryInformationArray[1] = queryInformation.clone();
            queryInformationArray[1].setBV(true);
            queryInformationArray[1].setBVName(extCRDInfo.getBVName());
        } else {
            queryInformationArray = new QueryInformation[1];
            if (n2 == 1) {
                queryInformationArray[0] = queryInformation.clone();
                queryInformationArray[0].setBV(false);
            } else {
                queryInformationArray[0] = queryInformation.clone();
                queryInformationArray[0].setBV(true);
                queryInformationArray[0].setBVName(extCRDInfo.getBVName());
            }
        }
        return queryInformationArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataResult[] SEDU(JDataService jDataService, QueryInformation[] queryInformationArray, String string, long l, boolean bl) throws IOException, InvalidParameterException, JException {
        CatalogKey catalogKey = queryInformationArray[0].getCatalogKey();
        DataResult[] dataResultArray = null;
        JetUUniverse jetUUniverse = null;
        try {
            ObjectManagerImpl objectManagerImpl;
            ObjectManagerImpl objectManagerImpl2 = objectManagerImpl = ObjectManagerImpl.getInstance();
            synchronized (objectManagerImpl2) {
                jetUUniverse = JRTUtil.getCatalog(catalogKey, string);
                jDataService.registCatalog(catalogKey, jetUUniverse);
            }
            ServiceLogger.trace("CRDManager: JDataService.getDataResult... (queryInfos[0]=%s, queryInfos[1]=%s, maxAllowMemory=%s)", queryInformationArray[0], queryInformationArray.length > 1 ? queryInformationArray[1] : "<NULL>", l);
            dataResultArray = jDataService.getDataResult(queryInformationArray, l, bl);
            ServiceLogger.trace("CRDManager: JDataService.getDataResult: success? %s (queryInfos[0]=%s, queryInfos[1]=%s, maxAllowMemory=%s)", dataResultArray != null, queryInformationArray[0], queryInformationArray.length > 1 ? queryInformationArray[1] : "<NULL>", l);
        }
        finally {
            if (jetUUniverse != null) {
                try {
                    jDataService.unregistCatalog(catalogKey);
                }
                catch (DSException dSException) {
                    ServiceLogger.logError(dSException, 3);
                }
                jetUUniverse.free();
            }
        }
        return dataResultArray;
    }

    private static Map calculateCubeMemorySize(Properties properties) {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("jrs.param$")) continue;
            Object object = properties.get(string);
            if (object instanceof String) {
                hashMap.put(string.substring("jrs.param$".length()), new String[]{(String)object});
                continue;
            }
            if (!(object instanceof String[])) continue;
            hashMap.put(string.substring("jrs.param$".length()), (String[])object);
        }
        return hashMap;
    }

    private static void cancelCRDTask(CubeInfoKey cubeInfoKey, int n, String string, Map map) throws RptServerException, ExecFormulaFailedException, InvalidParameterException, ParseFormulaFailedException {
        CatalogInfo catalogInfo = HttpUtil.getHttpRptServer().getCatalogInfo(string, cubeInfoKey.getCatalogPath(), n);
        ParameterManager parameterManager = catalogInfo.getParameterManager(cubeInfoKey.getDataSource(), new String[]{cubeInfoKey.getQueryName()});
        Vector<ParamInfo> vector = parameterManager.getAllParametersWithChanging(new HashMap());
        long l = System.currentTimeMillis();
        if (vector != null) {
            for (ParamInfo paramInfo : vector) {
                String string2 = paramInfo.getName();
                ParamDesc paramDesc = ((JRParamInfo)paramInfo).getParamDesc();
                Locale locale = Locale.getDefault();
                paramInfo.setLocale(locale);
                String[] stringArray = (String[])map.get(string2);
                if (stringArray == null || stringArray.length <= 0) continue;
                Object object = null;
                object = ParamUtil.isDateTime(paramDesc) ? (!paramDesc.isMultipleValue() ? ParamUtil.makeUserInput(stringArray)[0] : ParamUtil.makeUserInput(stringArray)) : (!paramDesc.isMultipleValue() ? stringArray[0] : stringArray);
                ParamUtil.setParamValue(paramDesc, object, locale, l);
            }
            parameterManager.clear();
            ServiceLogger.trace("CRDManager: validate params for calculating cube memory size: success! [crdKey=%s, resultSize=%s]", cubeInfoKey, vector.size());
        }
    }

    private static void clear(JetUConnection[] jetUConnectionArray, CubeInfoKey cubeInfoKey, Properties properties, QueryInformation queryInformation, String string) throws RemoteException {
        boolean bl;
        Object object2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        HashMap<String, String> hashMap4 = new HashMap<String, String>();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ConnectionInfoProvider connectionInfoProvider = (ConnectionInfoProvider)((Object)httpRptServer.getAdminService().getConnectionInfoProviderService());
        String string2 = properties.getProperty("jrs.datasources");
        ArrayList arrayList = DatasourceInfo.parseJSonStr(string2);
        DatasourceInfo datasourceInfo = null;
        if (arrayList != null) {
            for (Object object2 : arrayList) {
                if (!((DatasourceInfo)object2).getName().equals(cubeInfoKey.getDataSource())) continue;
                datasourceInfo = object2;
                break;
            }
        }
        Map map = datasourceInfo == null ? null : datasourceInfo.getConnectionInfos();
        object2 = null;
        for (JetUConnection jetUConnection : jetUConnectionArray) {
            String string3;
            String string4;
            if (!(jetUConnection instanceof JetUJDBCConnection)) continue;
            String string5 = jetUConnection.getResourceName();
            JetUJDBCConnection jetUJDBCConnection = (JetUJDBCConnection)jetUConnection;
            hashMap3.put(string5, jetUJDBCConnection.getUID());
            hashMap4.put(string5, jetUJDBCConnection.getPSWD());
            hashMap2.put(string5, jetUJDBCConnection.getURL());
            Properties properties2 = connectionInfoProvider.getConnectionInfo(string5);
            if (map != null) {
                object2 = (ConnectionInfo)map.get(string5);
            }
            if (ServiceLogger.isLoggable(4, 6)) {
                ServiceLogger.trace("CRDManager: calculate cube memory size... [crdKey=%s, connName=%s, connInfo=%s]", cubeInfoKey, string5, StringUtil.toString(properties2));
            }
            String string6 = "";
            String string7 = "";
            if (object2 != null && ((ConnectionInfo)object2).isUseDefaultUser()) {
                string7 = ((ConnectionInfo)object2).getUser();
                string6 = ((ConnectionInfo)object2).getPassword();
                String string8 = string7 = string7 == null ? "" : string7.trim();
                if (string7.length() == 0 && properties2 != null) {
                    string7 = properties2.getProperty("jrs.ds_user");
                }
                string6 = string6 == null ? "" : string6.trim();
                String string9 = string6 = string6 == null ? "" : string6.trim();
                if (string6.equals("") && properties2 != null) {
                    string6 = (String)properties2.get("jrs.ds_pswd");
                }
                string6 = string6 == null ? "" : string6.trim();
            }
            String string10 = "";
            if (properties2 != null && (string4 = (String)properties2.get("jrs.catalog_connection_type")) != null && string4.equalsIgnoreCase("JDBC")) {
                string10 = (String)properties2.get("jrs.jdbc_url");
            }
            string10 = string10 == null ? "" : string10.trim();
            string4 = "";
            if (properties2 != null && (string3 = (String)properties2.get("jrs.catalog_connection_type")) != null && string3.equalsIgnoreCase("JNDI")) {
                string4 = (String)properties2.get("jrs.jndi_datasource");
            }
            string4 = string4 == null ? "" : string4.trim();
            hashtable.put(string5, string6);
            hashtable2.put(string5, string7);
            hashtable3.put(string5, string10);
            hashtable4.put(string5, string4);
        }
        boolean bl2 = bl = ServerUtil.mapContains(hashMap4, hashtable) && ServerUtil.mapContains(hashMap3, hashtable2) && ServerUtil.mapContains(hashMap2, hashtable3) && ServerUtil.mapContains(hashMap, hashtable4);
        if (!bl) {
            queryInformation.setPwds(hashtable);
            queryInformation.setUsers(hashtable2);
            queryInformation.setJdbcUrls(hashtable3);
            queryInformation.setJndiNames(hashtable4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long calculateCubeMemorySize(CubeInfoKey cubeInfoKey, Properties properties, String string) throws Exception {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ResourceManager resourceManager = httpRptServer.getResourceManager();
        PathInfo pathInfo = resourceManager.getPathInfo(string, cubeInfoKey.getCatalogPath());
        CatalogKeyImp catalogKeyImp = new CatalogKeyImp(cubeInfoKey.getCatalogPath(), pathInfo.getLastModified(), pathInfo.getLatestVersionNumber());
        JetUUniverse jetUUniverse = null;
        try {
            ObjectManagerImpl objectManagerImpl;
            ObjectManagerImpl objectManagerImpl2 = objectManagerImpl = ObjectManagerImpl.getInstance();
            synchronized (objectManagerImpl2) {
                jetUUniverse = JRTUtil.getCatalog(catalogKeyImp, string);
            }
            long l = CRDResultToolkit.calculateCubeMemorySize(cubeInfoKey, jetUUniverse, properties, string, false);
            return l;
        }
        finally {
            if (jetUUniverse != null) {
                jetUUniverse.free();
            }
        }
    }

    public static long calculateCubeMemorySize(CubeInfoKey cubeInfoKey, JetUUniverse jetUUniverse, Properties properties, String string, boolean bl) throws Exception {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ResourceManager resourceManager = httpRptServer.getResourceManager();
        Map map = CRDResultToolkit.calculateCubeMemorySize(properties);
        PathInfo pathInfo = resourceManager.getPathInfo(string, cubeInfoKey.getCatalogPath());
        CRDResultToolkit.cancelCRDTask(cubeInfoKey, pathInfo.getLatestVersionNumber(), string, map);
        CatalogKeyImp catalogKeyImp = new CatalogKeyImp(cubeInfoKey.getCatalogPath(), pathInfo.getLastModified(), pathInfo.getLatestVersionNumber());
        QueryInformation queryInformation = new QueryInformation(catalogKeyImp, cubeInfoKey.getQueryName(), cubeInfoKey.getQueryType(), cubeInfoKey.getDataSource(), map, Locale.getDefault());
        queryInformation.setBVName(cubeInfoKey.getBVName());
        JetUDatabase jetUDatabase = jetUUniverse.getDatabase(cubeInfoKey.getDataSource());
        if (jetUDatabase != null) {
            JetUQueriable jetUQueriable = jetUDatabase.getQueriableByResourceName(cubeInfoKey.getQueryName());
            JetUConnection[] jetUConnectionArray = jetUQueriable.getConnections();
            if (!bl) {
                CRDResultToolkit.clear(jetUConnectionArray, cubeInfoKey, properties, queryInformation, string);
            } else {
                boolean bl2;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                HashMap<String, String> hashMap3 = new HashMap<String, String>();
                HashMap<String, String> hashMap4 = new HashMap<String, String>();
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                Map map2 = CRDResultToolkit.clone(properties);
                HashMap<String, Properties> hashMap5 = new HashMap<String, Properties>();
                for (Object object : map2.keySet()) {
                    String object2 = (String)map2.get(object);
                    hashMap5.put((String)object, CSUtil.parseQuery(object2));
                }
                for (JetUConnection jetUConnection : jetUConnectionArray) {
                    Object object;
                    if (!(jetUConnection instanceof JetUJDBCConnection)) continue;
                    JetUJDBCConnection jetUJDBCConnection = (JetUJDBCConnection)jetUConnection;
                    String string2 = jetUConnection.getResourceName();
                    hashMap3.put(string2, jetUJDBCConnection.getUID());
                    hashMap4.put(string2, jetUJDBCConnection.getPSWD());
                    hashMap2.put(string2, jetUJDBCConnection.getURL());
                    object = (Properties)hashMap5.get(string2);
                    String string3 = (String)((Properties)object).get("jrs.ds_pswd");
                    String string4 = ((Properties)object).getProperty("jrs.ds_user");
                    string4 = string4 == null ? "" : string4.trim();
                    string3 = string3 == null ? "" : string3.trim();
                    String string5 = "";
                    String string6 = (String)((Properties)object).get("jrs.catalog_connection_type");
                    if (string6 != null && string6.equalsIgnoreCase("JDBC")) {
                        string5 = (String)((Properties)object).get("jrs.jdbc_url");
                    }
                    string5 = string5 == null ? "" : string5.trim();
                    String string7 = "";
                    if (string6 != null && string6.equalsIgnoreCase("JNDI")) {
                        string7 = (String)((Properties)object).get("jrs.jndi_datasource");
                    }
                    string7 = string7 == null ? "" : string7.trim();
                    hashtable.put(string2, string3);
                    hashtable2.put(string2, string4);
                    hashtable3.put(string2, string5);
                    hashtable4.put(string2, string7);
                }
                boolean bl3 = bl2 = ServerUtil.mapContains(hashMap4, hashtable) && ServerUtil.mapContains(hashMap3, hashtable2) && ServerUtil.mapContains(hashMap2, hashtable3) && ServerUtil.mapContains(hashMap, hashtable4);
                if (!bl2) {
                    queryInformation.setPwds(hashtable);
                    queryInformation.setUsers(hashtable2);
                    queryInformation.setJdbcUrls(hashtable3);
                    queryInformation.setJndiNames(hashtable4);
                }
            }
        }
        return CubeSizeCalc.getSize((JetUUniverse)jetUUniverse, (QueryInformation)queryInformation);
    }

    private static Map clone(Properties properties) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = "jrs.conn_info1$";
        for (Object object : properties.keySet()) {
            String string2 = (String)object;
            if (!string2.startsWith(string)) continue;
            hashMap.put(string2.substring(string.length()), properties.getProperty(string2));
        }
        return hashMap;
    }
}

