/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import java.sql.SQLException;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.log.ServiceLogger;

public class UpdateDetailsTableImpl
extends TableImpl
implements Table,
UpdateDetailsTable {
    public static final int VERSION = 1;
    public static final String TABLENAME = "UPDATEDETAILS_1";
    static final String[] COLNAMES = new String[2];

    public static UpdateDetailsTableImpl newInstance(Database database) {
        try {
            return new UpdateDetailsTableImpl(database);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private UpdateDetailsTableImpl(Database database) throws SQLException, InstantiationException {
        super(database, TABLENAME);
        super.append(new FieldImpl(this.getName(), COLNAMES[0], JDBCType.VARCHAR, 32, 9, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[1], JDBCType.BIT, 0, 1, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        ((DatabaseImpl)database).appendSystemTable(this);
        ((DatabaseImpl)database).appendProfileTable(this);
    }

    @Override
    public boolean setUpdateDetails(String string, boolean bl) {
        FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[0].setValue(string);
        fieldValueArray[1].setValue(bl ? Boolean.TRUE : Boolean.FALSE);
        try {
            super.insert(fieldValueArray);
            return true;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    @Override
    public boolean removeUpdateDetails(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
        try {
            int n = super.delete(stringBuffer.toString(), new ParameterMetaInfo().add("updateItem", string));
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUpdating(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), string, 12);
        stringBuffer.append("WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
        Field[] fieldArray = new Field[]{this.fields(COLNAMES[1])};
        Recordset recordset = null;
        boolean bl = false;
        try {
            recordset = super.query(fieldArray, stringBuffer.toString(), parameterMetaInfo, false);
            if (recordset.next()) {
                bl = recordset.getBoolean(COLNAMES[1]);
            }
            boolean bl2 = bl;
            return bl2;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return bl;
    }

    static {
        UpdateDetailsTableImpl.COLNAMES[0] = "update_item";
        UpdateDetailsTableImpl.COLNAMES[1] = "update_state";
    }
}

