/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import jet.JSvrResource;
import jet.connect.DbInteger;
import jet.connect.DbValue;
import jet.connect.jdbms.JDbConnection;
import jet.connect.jdbms.JDbTableDesc;
import jet.connect.jdbms.JDbTables;
import jet.connect.jdbms.JResultSet;
import jet.cs.CSUtil;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.db.TableIndexManager;
import jet.server.db.VersionRecord;
import jet.server.log.ServiceLogger;
import jet.server.schedule.CommitRunner;
import jet.server.schedule.Committer;
import jet.server.schedule.SchdTools;
import jet.util.IntKeyHashtable;

public class VersionRecordContainer
implements Committer {
    private static final String C = "version";
    private static final String SEDU = ".jtb";
    private static final int addElement = 180;
    private static final int addIndex = 3;
    private String addVersionRecord = "";
    private JDbTableDesc append = null;
    private JDbConnection appendTableFull = null;
    IntKeyHashtable hashRecordIndexs = new IntKeyHashtable();
    JResultSet resultset = null;
    boolean bLoadAllVersionsInStart = false;
    boolean isSubtable = false;
    private TableIndexManager checkTable = null;
    private CommitRunner close = null;
    int iMaxReachedRecordIndex = 0;
    long lastModify = -1L;
    private long commit = 0L;
    private boolean commitIndexFile = true;
    private boolean connect = false;
    private File copyFile = null;
    private File createTable = null;
    private File currentTimeMillis = null;
    String appendTableName = null;
    VersionRecordContainer currentTable = null;
    private String delete = "";
    private String deleteAllIndexRecord = "";
    private String deleteIndex = "";

    public VersionRecordContainer(boolean bl, String string, String string2, String string3) {
        this.delete = string2;
        this.deleteAllIndexRecord = string3;
        this.deleteIndex = string;
        File file = new File(this.deleteIndex, C);
        this.addVersionRecord = file.exists() ? C : "version.jtb";
        this.bLoadAllVersionsInStart = bl;
        try {
            this.checkTable = new TableIndexManager(this.deleteIndex, C, SEDU, 1620);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
        this.appendTableFull();
        this.connect();
        this.appendTableName = this.checkTable.getAppendTableName();
        this.currentTable = this.connect(true, this.appendTableName);
    }

    public VersionRecordContainer(boolean bl) {
        this.addVersionRecord = "version.jtb";
        this.bLoadAllVersionsInStart = bl;
        this.deleteAllIndexRecord = ServerEnv.getActiveRealm();
        this.deleteIndex = ServerEnv.propertiesPath;
        try {
            this.checkTable = new TableIndexManager(this.deleteIndex, C, SEDU, 1620);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
        this.appendTableFull();
        this.connect();
        this.appendTableName = this.checkTable.getAppendTableName();
        this.currentTable = this.connect(true, this.appendTableName);
    }

    public VersionRecordContainer(boolean bl, String string) {
        this.bLoadAllVersionsInStart = bl;
        this.isSubtable = true;
        this.deleteAllIndexRecord = ServerEnv.getActiveRealm();
        this.deleteIndex = ServerEnv.propertiesPath;
        this.addVersionRecord = string;
        this.appendTableFull();
        this.connect();
        if (bl) {
            this.loadAllVersionRecords();
        }
    }

    public VersionRecordContainer(boolean bl, String string, String string2, String string3, String string4) {
        this.bLoadAllVersionsInStart = bl;
        this.isSubtable = true;
        this.delete = string3;
        this.deleteAllIndexRecord = string4;
        this.deleteIndex = string2;
        this.addVersionRecord = string;
        this.appendTableFull();
        this.connect();
        if (bl) {
            this.loadAllVersionRecords();
        }
    }

    public void init() {
        this.SEDU();
        this.addElement();
    }

    private ExProperties C() {
        String string = this.delete + this.deleteAllIndexRecord + File.separator + "resource.alias";
        ExProperties exProperties = new ExProperties();
        if (new File(string).exists()) {
            try {
                exProperties.load(string);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return exProperties;
    }

    private void SEDU() {
        try {
            VersionRecordContainer versionRecordContainer = this.connect(false, C);
            Vector vector = versionRecordContainer.getVersionRecords();
            versionRecordContainer.close();
            if (vector.size() == 0) {
                return;
            }
            File file = new File(this.deleteIndex, C);
            File file2 = new File(this.deleteIndex, "version.OldVersion");
            SchdTools.copyFile(file, file2);
            file.delete();
            String string = this.deleteAllIndexRecord;
            ExProperties exProperties = this.C();
            int n = vector.size();
            int n2 = 0;
            System.out.println(JSvrResource.getMessage("SVR_80", C));
            for (int i = 0; i < vector.size(); ++i) {
                VersionRecord versionRecord = (VersionRecord)vector.elementAt(i);
                String string2 = versionRecord.getCatFile();
                String string3 = null;
                int n3 = 0;
                String string4 = null;
                String string5 = null;
                Object object = exProperties.keys();
                while (object.hasMoreElements()) {
                    String string6 = (String)object.nextElement();
                    String string7 = exProperties.getProperty(string6);
                    if (string7.equalsIgnoreCase(string2)) {
                        string3 = string6;
                        break;
                    }
                    if (!string2.startsWith(string7) || string7.length() <= n3) continue;
                    n3 = string7.length();
                    string4 = string6;
                    string5 = string7;
                }
                if (string3 == null) {
                    if (string4 != null) {
                        object = string2.substring(n3 + 1);
                        object = ((String)object).replace(File.separatorChar, '/');
                        string3 = !string4.endsWith("/") && !((String)object).startsWith("/") ? string4 + "/" + (String)object : (string4.endsWith("/") && ((String)object).startsWith("/") ? string4 + ((String)object).substring(1) : string4 + (String)object);
                        if (string3.endsWith("/")) {
                            string3 = string3.substring(0, string3.length() - 1);
                        }
                    } else {
                        string3 = string2;
                    }
                }
                this.addVersionRecord(versionRecord.getVersionId(), string3, CSUtil.getFileNameOnly(versionRecord.getReportFile()), CSUtil.getFileNameOnly(versionRecord.getParamFile()), CSUtil.getFileNameOnly(versionRecord.getResultFile()), versionRecord.getResultFormats(), versionRecord.getGenerateTime(), versionRecord.getSubmitUser(), versionRecord.getExpire(), versionRecord.getExpirationTime(), versionRecord.getVersionName(), versionRecord.getLaunchType(), versionRecord.getTaskId());
                int n4 = ++n2 * 100 / n;
                if (n4 > 98) continue;
                System.out.print(JSvrResource.getMessage("SVR_81", String.valueOf(n4)));
            }
            System.out.print(JSvrResource.getMessage("SVR_81", "99"));
            this.commit();
            System.out.println(JSvrResource.getMessage("SVR_82", C));
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    private void addElement() {
        if (this.checkTable.getRealRecordCount() - this.checkTable.getAvailableRecordCount() >= 540) {
            try {
                Vector vector = this.getVersionRecords();
                this.addIndex();
                for (int i = 0; i < vector.size(); ++i) {
                    VersionRecord versionRecord = (VersionRecord)vector.elementAt(i);
                    this.addVersionRecord(versionRecord.getVersionId(), versionRecord.getCatFile(), versionRecord.getReportFile(), versionRecord.getParamFile(), versionRecord.getResultFile(), versionRecord.getResultFormats(), versionRecord.getGenerateTime(), versionRecord.getSubmitUser(), versionRecord.getExpire(), versionRecord.getExpirationTime(), versionRecord.getVersionName(), versionRecord.getLaunchType(), versionRecord.getTaskId());
                }
                this.commit();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
    }

    private synchronized boolean addIndex() {
        if (!this.isSubtable) {
            boolean bl = true;
            Enumeration enumeration = this.checkTable.getAllTableNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                boolean bl2 = string.equals(this.currentTable.getName()) ? this.currentTable.addIndex() : this.connect(false, string).addIndex();
                if (bl2) continue;
                bl = false;
                ServiceLogger.logError(2640003, string, 2);
            }
            this.checkTable.deleteAllIndexRecord();
            this.appendTableName = this.checkTable.getAppendTableName();
            this.currentTable = this.connect(false, this.appendTableName);
            return bl;
        }
        try {
            this.commit();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        this.close();
        File file = new File(this.deleteIndex, this.addVersionRecord);
        return file.delete();
    }

    private void addVersionRecord() {
        if (this.close == null && ServerEnv.isCommitInThread()) {
            this.close = new CommitRunner(this);
        }
    }

    private void append() {
        if (this.close != null) {
            this.close.stop();
            this.close = null;
        }
    }

    public String getName() {
        return this.addVersionRecord;
    }

    private void appendTableFull() {
        try {
            JDbTableDesc jDbTableDesc = new JDbTableDesc(this.deleteIndex, this.addVersionRecord, 11, 180, 3);
            jDbTableDesc.setColumnDesc(1, "VersionId", 4, 0, 10, 0, false);
            jDbTableDesc.setColumnDesc(2, "CatFile", 1, 255, 0, 0, false);
            jDbTableDesc.setColumnDesc(3, "RptFile", 1, 255, 0, 0, false);
            jDbTableDesc.setColumnDesc(4, "ParamFile", 1, 255, 0, 1, false);
            jDbTableDesc.setColumnDesc(5, "ResultFile", 1, 255, 0, 0, false);
            jDbTableDesc.setColumnDesc(6, "CreateDate", 93, 19, 0, 0, false);
            jDbTableDesc.setColumnDesc(7, "SubmitUser", 1, 255, 0, 0, false);
            jDbTableDesc.setColumnDesc(8, "Expire", -7, 1, 0, 0, false);
            jDbTableDesc.setColumnDesc(9, "ExpireDate", 93, 19, 0, 1, false);
            jDbTableDesc.setColumnDesc(10, "VersionName", 1, 255, 0, 1, false);
            jDbTableDesc.setNewColDescs(14);
            jDbTableDesc.setNewColumnDesc(1, "VersionId", 4, 0, 10, 0, false);
            jDbTableDesc.setNewColumnDesc(2, "CatFile", 1, 255, 0, 0, false);
            jDbTableDesc.setNewColumnDesc(3, "RptFile", 1, 255, 0, 0, false);
            jDbTableDesc.setNewColumnDesc(4, "ParamFile", 1, 255, 0, 1, false);
            jDbTableDesc.setNewColumnDesc(5, "ResultFile", 1, 255, 0, 0, false);
            jDbTableDesc.setNewColumnDesc(6, "CreateDate", 93, 19, 0, 0, false);
            jDbTableDesc.setNewColumnDesc(7, "SubmitUser", 1, 255, 0, 0, false);
            jDbTableDesc.setNewColumnDesc(8, "Expire", -7, 1, 0, 0, false);
            jDbTableDesc.setNewColumnDesc(9, "ExpireDate", 93, 19, 0, 1, false);
            jDbTableDesc.setNewColumnDesc(10, "VersionName", 1, 255, 0, 1, false);
            jDbTableDesc.setNewColumnDesc(11, "LaunchType", 4, 0, 10, 1, false);
            jDbTableDesc.setNewColumnDesc(12, "TaskId", 1, 255, 0, 1, false);
            jDbTableDesc.setNewColumnDesc(13, "ResultFormats", -5, 0, 10, 1, false);
            if (!jDbTableDesc.isUpgraded()) {
                jDbTableDesc.upgrade();
            }
            JDbTables.createTable(jDbTableDesc);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    protected void connect() {
        try {
            String string = this.deleteIndex;
            File file = new File(string);
            this.checkTable(file, this.addVersionRecord);
            if (this.isSubtable) {
                this.appendTableFull = JDbConnection.connect(file, this.addVersionRecord, 180, 3);
                this.resultset = this.appendTableFull.select(null);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
    }

    protected boolean checkTable(File file, String string) {
        if (!file.exists()) {
            file.mkdirs();
        }
        if (file.exists()) {
            File file2 = new File(file.getPath(), string);
            this.commit = file2.length();
            this.copyFile = new File(file.getPath(), string + ".bak");
            this.createTable = new File(file.getPath(), string + ".old");
            this.currentTimeMillis = new File(file.getPath(), string + ".old2");
            if (!file2.exists()) {
                try {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
                    randomAccessFile.writeInt(8);
                    randomAccessFile.writeInt(0);
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            try {
                if (!this.copyFile.exists()) {
                    SchdTools.copyFile(file2, this.copyFile);
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
            return true;
        }
        return false;
    }

    public synchronized void close() {
        if (!this.isSubtable) {
            this.currentTable.close();
            this.checkTable.close();
            return;
        }
        this.disconnect();
    }

    protected void disconnect() {
        try {
            if (this.close != null) {
                this.close.stop();
            }
            this.appendTableFull.disconnect();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        if (this.connect && this.copyFile != null && this.createTable != null && this.copyFile.exists()) {
            try {
                if (this.createTable.exists()) {
                    if (this.currentTimeMillis.exists()) {
                        this.currentTimeMillis.delete();
                    }
                    this.createTable.renameTo(this.currentTimeMillis);
                }
                this.copyFile.renameTo(this.createTable);
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
    }

    private void appendTableName() {
        String string = this.currentTable.getName();
        if (!this.appendTableName.equals(string) || this.appendTableName.equals(string) && this.checkTable.appendTableFull()) {
            try {
                this.currentTable.commit();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            this.currentTable.close();
            this.appendTableName = this.checkTable.getAppendTableName();
            this.currentTable = this.connect(true, this.appendTableName);
        }
    }

    public synchronized VersionRecord addVersionRecord(int n, String string, String string2, String string3, String string4, long l, Date date, String string5, boolean bl, Date date2, String string6, int n2, String string7) {
        if (!this.isSubtable) {
            VersionRecord versionRecord = null;
            this.appendTableName();
            versionRecord = this.currentTable.addVersionRecord(n, string, string2, string3, string4, l, date, string5, bl, date2, string6, n2, string7);
            if (versionRecord != null) {
                try {
                    this.checkTable.addIndex(String.valueOf(n), this.appendTableName);
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException);
                }
            }
            return versionRecord;
        }
        try {
            int n3 = this.insert();
            VersionRecord versionRecord = new VersionRecord(this.resultset.getValueArray());
            versionRecord.setRecord(n, string, string2, string3, string4, l, date, string5, bl, date, string6, n2, string7);
            this.hashRecordIndexs.put(n, (Object)new Integer(n3));
            this.update(versionRecord);
            this.connect = true;
            this.bLoadAllVersionsInStart();
            return versionRecord;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }

    private void bLoadAllVersionsInStart() throws Exception {
        this.commitIndexFile = false;
        this.addVersionRecord();
        if (this.close != null) {
            this.close.notifyCommit();
        } else {
            this.commitIndexFile();
            this.commit();
        }
    }

    public synchronized void removeVersionRecord(VersionRecord versionRecord) {
        if (!this.isSubtable) {
            try {
                String string = this.checkTable.getTableNameById(String.valueOf(versionRecord.getVersionId()));
                if (string == null) {
                    return;
                }
                if (!string.equals(this.currentTable.getName())) {
                    try {
                        this.currentTable.commit();
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                    this.currentTable.close();
                    this.currentTable = this.connect(true, string);
                }
                this.currentTable.removeVersionRecord(versionRecord);
                this.checkTable.deleteIndex(String.valueOf(versionRecord.getVersionId()));
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
            return;
        }
        try {
            Integer n = (Integer)this.hashRecordIndexs.get(versionRecord.getVersionId());
            if (n != null) {
                this.hashRecordIndexs.remove(versionRecord.getVersionId());
                int n2 = n;
                this.delete(n2);
                this.connect = true;
                this.bLoadAllVersionsInStart();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public synchronized void removeVersionRecord(int n) {
        if (!this.isSubtable) {
            String string = this.checkTable.getTableNameById(String.valueOf(n));
            if (string == null) {
                return;
            }
            try {
                if (!string.equals(this.currentTable.getName())) {
                    try {
                        this.currentTable.commit();
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                    this.currentTable.close();
                    this.currentTable = this.connect(true, string);
                }
                this.currentTable.removeVersionRecord(n);
                this.checkTable.deleteIndex(String.valueOf(n));
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
            return;
        }
        try {
            VersionRecord versionRecord = this.getVersionRecord(n);
            if (versionRecord != null) {
                this.removeVersionRecord(versionRecord);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public synchronized VersionRecord getVersionRecord(int n) {
        if (!this.isSubtable) {
            VersionRecord versionRecord = null;
            String string = this.checkTable.getTableNameById(String.valueOf(n));
            if (string != null) {
                VersionRecordContainer versionRecordContainer = null;
                versionRecordContainer = string.equals(this.currentTable.getName()) ? this.currentTable : this.connect(true, string);
                versionRecord = versionRecordContainer.getVersionRecord(n);
                if (versionRecordContainer != this.currentTable) {
                    versionRecordContainer.close();
                }
            }
            return versionRecord;
        }
        VersionRecord versionRecord = null;
        Integer n2 = (Integer)this.hashRecordIndexs.get(n);
        int n3 = n2 != null ? n2.intValue() : this.loadVersionRecord(n);
        if (n3 != -1) {
            this.checkTable(n3);
            versionRecord = new VersionRecord(this.resultset.getValueArray());
        }
        return versionRecord;
    }

    public synchronized Vector getVersionRecords(String string, String string2, String string3, Date date, String string4, int n, String string5) {
        if (!this.isSubtable) {
            Vector vector = new Vector();
            Enumeration enumeration = this.checkTable.getAllTableNames();
            while (enumeration.hasMoreElements()) {
                String string6 = (String)enumeration.nextElement();
                try {
                    VersionRecordContainer versionRecordContainer = null;
                    versionRecordContainer = string6.equals(this.currentTable.getName()) ? this.currentTable : this.connect(false, string6);
                    Vector vector2 = versionRecordContainer.getVersionRecords(string, string2, string3, date, string4, n, string5);
                    for (int i = 0; i < vector2.size(); ++i) {
                        vector.addElement(vector2.elementAt(i));
                    }
                    if (versionRecordContainer == this.currentTable) continue;
                    versionRecordContainer.close();
                }
                catch (NullPointerException nullPointerException) {
                    ServiceLogger.logError(nullPointerException, 3);
                }
            }
            return vector;
        }
        Vector<VersionRecord> vector = new Vector<VersionRecord>();
        try {
            int n2;
            this.resultset.setCursor(0);
            while ((n2 = this.resultset.nextRecord()) != -1) {
                VersionRecord versionRecord = new VersionRecord(this.resultset.getValueArray());
                if (string != null && !string.equalsIgnoreCase(versionRecord.getCatFile()) || string2 != null && !string2.equalsIgnoreCase(versionRecord.getReportFile()) || string3 != null && !string3.equalsIgnoreCase(versionRecord.getParamFile()) || date != null && !date.equals(versionRecord.getGenerateTime()) || string4 != null && !string4.equalsIgnoreCase(versionRecord.getSubmitUser()) || n != -1 && n != versionRecord.getLaunchType() || string5 != null && !string5.equalsIgnoreCase(versionRecord.getTaskId())) continue;
                vector.addElement(versionRecord);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return vector;
    }

    public synchronized Vector getVersionRecords() {
        int n;
        if (!this.isSubtable) {
            Vector vector = new Vector();
            Enumeration enumeration = this.checkTable.getAllTableNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                VersionRecordContainer versionRecordContainer = null;
                versionRecordContainer = string.equals(this.currentTable.getName()) ? this.currentTable : this.connect(false, string);
                Vector vector2 = versionRecordContainer.getVersionRecords();
                for (int i = 0; i < vector2.size(); ++i) {
                    vector.addElement(vector2.elementAt(i));
                }
                if (versionRecordContainer == this.currentTable) continue;
                versionRecordContainer.close();
            }
            return vector;
        }
        Vector<VersionRecord> vector = new Vector<VersionRecord>();
        this.loadAllVersionRecords();
        this.resultset.setCursor(0);
        while ((n = this.resultset.nextRecord()) != -1) {
            vector.addElement(new VersionRecord(this.resultset.getValueArray()));
        }
        return vector;
    }

    protected synchronized int loadVersionRecord(int n) {
        int n2;
        this.resultset.setCursor(this.iMaxReachedRecordIndex);
        while ((n2 = this.resultset.nextRecord()) != -1) {
            this.iMaxReachedRecordIndex = n2;
            DbValue[] dbValueArray = this.resultset.getValueArray();
            int n3 = ((DbInteger)dbValueArray[1]).get();
            this.hashRecordIndexs.put(n3, (Object)new Integer(n2));
            if (n3 != n) continue;
            return n2;
        }
        return -1;
    }

    protected synchronized void loadAllVersionRecords() {
        int n;
        this.resultset.setCursor(this.iMaxReachedRecordIndex);
        while ((n = this.resultset.nextRecord()) != -1) {
            this.iMaxReachedRecordIndex = n;
            DbValue[] dbValueArray = this.resultset.getValueArray();
            int n2 = ((DbInteger)dbValueArray[1]).get();
            this.hashRecordIndexs.put(n2, (Object)new Integer(n));
        }
    }

    @Override
    public synchronized void commit() throws Exception {
        if (!this.isSubtable) {
            this.currentTable.commit();
            this.checkTable.commitIndexFile();
            return;
        }
        if (!this.isCommitted()) {
            this.appendTableFull.commit();
            this.commitIndexFile = true;
        }
        this.append();
    }

    private void checkTable(int n) {
        this.resultset.setCursor(n);
        this.resultset.nextRecord();
    }

    protected void update(VersionRecord versionRecord) throws SQLException {
        DbValue[] dbValueArray = versionRecord.getValues();
        DbValue[] dbValueArray2 = this.resultset.getValueArray();
        for (int i = 0; i < dbValueArray2.length; ++i) {
            dbValueArray2[i] = dbValueArray[i];
        }
        this.resultset.update();
    }

    protected void delete(int n) throws SQLException {
        this.checkTable(n);
        this.resultset.delete();
    }

    protected int insert() throws SQLException {
        return this.resultset.insert();
    }

    private synchronized void commitIndexFile() {
        this.lastModify = System.currentTimeMillis();
    }

    public synchronized boolean isCommitted() {
        return this.commitIndexFile;
    }

    public synchronized long getLastModify() {
        return this.lastModify;
    }

    private VersionRecordContainer connect(boolean bl, String string) {
        return new VersionRecordContainer(bl, string, this.deleteIndex, this.delete, this.deleteAllIndexRecord);
    }
}

