/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import jet.JCliResource;
import jet.cs.CSUtil;
import jet.cs.PrefixFilenameFilter;
import jet.server.ServerEnv;
import jet.server.api.ResultVersionRecord;
import jet.server.api.RptServerException;
import jet.server.db.AbstractDataTable;
import jet.server.db.ResultVersionRecordImpl;
import jet.server.db.VersionLimitTable;
import jet.server.db.VersionTable;
import jet.server.db.core.Dbs;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.jrc.param.ParameterFileManager;
import jet.server.log.ServiceLogger;
import jet.server.schedule.JRResultFiles;
import jet.server.schedule.ResultFolderManager;
import jet.server.schedule.SchdTools;
import jet.server.util.ParamUtil;

public class VersionTableImpl
extends AbstractDataTable
implements VersionTable,
Runnable {
    public static final int version = 1;
    public static final String TABLE_PREFIX = "VERSIONR";
    private static final String EMPTY = " id\t\t\t\tINTEGER NOT NULL IDENTITY, VersionId\t\t\tINTEGER NOT NULL, VersionName\t\tVARCHAR(256), CatFile           VARCHAR(256), RptFile           VARCHAR(256), ParamFile         VARCHAR(256), ResultFile        VARCHAR(256), TaskId\t\t\tVARCHAR(128), Submitter\t\t\tVARCHAR(128), ResultFormats     BIGINT, CreatedTime  \t\tBIGINT, ExpirationTime    BIGINT, LaunchType        INTEGER, Expire        \tBIT, UNIQUE(id, VersionId)";
    private static final String J = " (VersionId,VersionName,CatFile,RptFile,ParamFile,ResultFile, TaskId,Submitter,ResultFormats,CreatedTime,ExpirationTime, LaunchType,Expire) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?);";
    private String SEDU = null;
    private PreparedStatement add = null;
    private String addRecord = null;
    private ResultFolderManager append = null;
    private VersionLimitTable catalogFile = null;
    private boolean checkDoCommit = true;
    private boolean clear = false;
    private static VersionTableImpl close = null;
    private boolean copyFile = false;

    public static VersionTableImpl newInstance(String string, String string2, String string3, String string4) throws RemoteException {
        if (close == null) {
            close = new VersionTableImpl(string, string2, string3, string4);
        }
        return close;
    }

    public static VersionTable getVersionTable() {
        return close;
    }

    private VersionTableImpl(String string, String string2, String string3, String string4) throws RemoteException {
        super(string, string2, string3);
        this.SEDU = super.makeTableName(TABLE_PREFIX, string4, 1);
        if (!super.isValidTable(this.SEDU)) {
            super.createTable(this.SEDU, EMPTY);
        }
        try {
            this.add = this.conn.prepareStatement("INSERT INTO " + this.SEDU + J);
        }
        catch (Exception exception) {
            throw new RemoteException("FailedConstructor", exception);
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    public String getTableName() {
        return this.SEDU;
    }

    public void setVersionDir(String string) {
        this.addRecord = string;
        this.append = new ResultFolderManager(string, ServerEnv.getMaxVersionAmountPerSubfolder());
    }

    public ResultFolderManager getResultFolderManager() {
        return this.append;
    }

    public void setVersionLimitTable(VersionLimitTable versionLimitTable) {
        this.catalogFile = versionLimitTable;
    }

    @Override
    public void close() {
        this.checkDoCommit = false;
        try {
            close = null;
            while (this.clear) {
                Thread.sleep(1000L);
            }
            while (this.copyFile) {
                Thread.sleep(1000L);
            }
            this.add.close();
            super.close();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
    }

    @Override
    public void publishResultToVersion(String string, String string2, String string3, String string4, String string5, Properties properties, String string6) throws RemoteException {
        Object object;
        String string7;
        Object object2;
        String string8 = CSUtil.getNameWithoutExt(string2);
        String string9 = this.append.getNextResultName(string8);
        if (string9 == null) {
            throw new ServerException(JCliResource.getMessage("CS_ERR_47"));
        }
        int n = string9.lastIndexOf(File.separator);
        String string10 = string9.substring(n);
        String string11 = string9 + string10;
        String string12 = CSUtil.getNameWithoutExt(string3);
        String string13 = CSUtil.getExtName(string3);
        JRResultFiles jRResultFiles = new JRResultFiles(string11, string13, 0L, 0L, 0L);
        int n2 = string12.indexOf(95);
        if (n2 != -1) {
            string12 = string12.substring(0, n2);
        }
        String string14 = string5 + string11;
        int n3 = string12.length();
        File file = new File(string4);
        PrefixFilenameFilter prefixFilenameFilter = new PrefixFilenameFilter(string12);
        String[] stringArray = file.list(prefixFilenameFilter);
        int n4 = stringArray.length;
        if (n4 > 0) {
            for (int i = 0; i < n4; ++i) {
                String string15 = string14 + stringArray[i].substring(n3);
                SchdTools.copyFile(new File(string4 + stringArray[i]), new File(string15));
                if (!CSUtil.getExtName(stringArray[i]).equals(".html")) continue;
                object2 = string11.substring(string11.lastIndexOf(File.separator) + 1, string11.length());
                SchdTools.replaceStringInFile(string15, string12, (String)object2);
            }
        }
        String string16 = null;
        object2 = null;
        FileOutputStream fileOutputStream = null;
        try {
            if (properties != null) {
                string16 = string11 + ".param";
                object2 = new File(string5, string16);
                fileOutputStream = new FileOutputStream((File)object2);
                string7 = null;
                ParamUtil.evalExpressionValues(properties);
                object = properties.keys();
                while (object.hasMoreElements()) {
                    string7 = (String)object.nextElement();
                    Object object3 = properties.get(string7);
                    fileOutputStream.write((string7 + "=" + object3 + "\n").getBytes());
                }
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException2) {
                    ServiceLogger.logError(iOException2, 3);
                }
            }
            ServiceLogger.logError(iOException, 2);
            throw new ServerException("", iOException);
        }
        string7 = string11 + string13;
        object = string4 + CSUtil.getNameWithoutExt(string3) + ".rst";
        if (new File((String)object).exists()) {
            string7 = string11 + ".rst";
        }
        this.addRecord(null, string, string2, string16, jRResultFiles.getSharedPrefix(), null, string6, jRResultFiles.getResultFormats(), new Date(), null, 0, false);
    }

    @Override
    public synchronized ResultVersionRecord addRecord(String string, String string2, String string3, String string4, String string5, String string6, String string7, long l, Date date, Date date2, int n, boolean bl) throws RemoteException {
        ResultVersionRecordImpl resultVersionRecordImpl = new ResultVersionRecordImpl(string, string2, string3, string4, string5, string6, string7, l, date, date2, n, bl, 1, -1);
        try {
            this.EMPTY(resultVersionRecordImpl);
            super.checkDoCommit(false);
        }
        catch (Exception exception) {
            throw new RemoteException("FailedInsertRecord", exception);
        }
        int n2 = this.catalogFile.getMaxAmount(resultVersionRecordImpl.catalogFile, resultVersionRecordImpl.reportFile, resultVersionRecordImpl.submitter);
        String string8 = null;
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        this.sqlbuf.delete(0, this.sqlbuf.length());
        this.sqlbuf.append(" CatFile=?");
        this.sqlbuf.append(" AND RptFile=?");
        parameterMetaInfo.add("CatFile", resultVersionRecordImpl.catalogFile).add("RptFile", resultVersionRecordImpl.reportFile);
        if (resultVersionRecordImpl.submitter != null && resultVersionRecordImpl.submitter.length() != 0) {
            this.sqlbuf.append(" AND Submitter=?");
            parameterMetaInfo.add("submitter", resultVersionRecordImpl.submitter);
        }
        string8 = this.sqlbuf.toString();
        int n3 = super.getRecordsAmount(this.SEDU, string8, parameterMetaInfo);
        if (n2 > 0 && n2 < n3) {
            this.sqlbuf.delete(0, this.sqlbuf.length());
            this.sqlbuf.append("SELECT * FROM ").append(this.SEDU).append(" WHERE ID IN(");
            this.sqlbuf.append("SELECT MIN(ID) FROM ").append(this.SEDU).append(" WHERE ");
            this.sqlbuf.append(string8).append(")");
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            ResultVersionRecordImpl resultVersionRecordImpl2 = null;
            try {
                preparedStatement = this.conn.prepareStatement(this.sqlbuf.toString());
                Dbs.setParameterMetaInfo(preparedStatement, parameterMetaInfo);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    resultVersionRecordImpl2 = this.J(resultSet);
                    this.SEDU(resultVersionRecordImpl2);
                    this.add(resultVersionRecordImpl2);
                }
            }
            catch (SQLException sQLException) {
                throw new RemoteException("FailedInsertRecord", sQLException);
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
            }
        }
        return resultVersionRecordImpl;
    }

    @Override
    public synchronized void delRecord(int n) throws RemoteException {
        ResultVersionRecordImpl resultVersionRecordImpl = (ResultVersionRecordImpl)this.getRecord(n);
        if (resultVersionRecordImpl == null) {
            return;
        }
        try {
            this.SEDU(resultVersionRecordImpl);
            this.add(resultVersionRecordImpl);
        }
        catch (Exception exception) {
            throw new RemoteException("FailedDeleteRecord", exception);
        }
    }

    @Override
    public synchronized ResultVersionRecord getRecord(int n) throws RemoteException {
        PreparedStatement preparedStatement = null;
        ResultVersionRecordImpl resultVersionRecordImpl = null;
        ResultSet resultSet = null;
        this.sqlbuf.delete(0, this.sqlbuf.length());
        this.sqlbuf.append("SELECT * FROM ").append(this.SEDU);
        this.sqlbuf.append(" WHERE VersionId=?");
        try {
            preparedStatement = this.conn.prepareStatement(this.sqlbuf.toString());
            Dbs.setParameterMetaInfo(preparedStatement, new ParameterMetaInfo().add("versionId", n));
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                resultVersionRecordImpl = this.J(resultSet);
            }
        }
        catch (Exception exception) {
            throw new RemoteException("FailedSelectRecord", exception);
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
        return resultVersionRecordImpl;
    }

    @Override
    public synchronized Vector getRecords(String string, String string2, String string3, String string4, Date date, int n) throws RemoteException {
        this.sqlbuf.delete(0, this.sqlbuf.length());
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        this.sqlbuf.append("SELECT * FROM ").append(this.SEDU).append(" WHERE ");
        if (n != -1) {
            this.sqlbuf.append(" LaunchType=?");
            parameterMetaInfo.add("launchType", n);
        } else {
            this.sqlbuf.append(" LaunchType!=?");
            parameterMetaInfo.add("launchType", -1);
        }
        if (string != null) {
            this.sqlbuf.append(" AND CatFile=?");
            parameterMetaInfo.add("catFile", string);
        }
        if (string2 != null) {
            this.sqlbuf.append(" AND RptFile=?");
            parameterMetaInfo.add("rptFile", string2);
        }
        if (string3 != null) {
            this.sqlbuf.append(" AND TaskId=?");
            parameterMetaInfo.add("taskId", string3);
        }
        if (string4 != null && string4.length() != 0) {
            this.sqlbuf.append(" AND Submitter=?");
            parameterMetaInfo.add("submitter", string4);
        }
        if (date != null) {
            this.sqlbuf.append(" AND CreatedTime=?");
            parameterMetaInfo.add("createdTime", String.valueOf(date.getTime()));
        }
        this.sqlbuf.append(" ORDER BY ID DESC");
        try {
            int n2 = this.catalogFile.getMaxAmount(string, string2, string4);
            return this.append(this.sqlbuf.toString(), parameterMetaInfo, n2);
        }
        catch (Exception exception) {
            throw new RemoteException("FailedSelectRecord", exception);
        }
    }

    @Override
    public synchronized Vector getAllRecords() throws RemoteException {
        this.sqlbuf.delete(0, this.sqlbuf.length());
        this.sqlbuf.append("SELECT * FROM ").append(this.SEDU);
        this.sqlbuf.append(" ORDER BY ID DESC");
        try {
            return this.append(this.sqlbuf.substring(0), ParameterMetaInfo.EMPTY, 0);
        }
        catch (Exception exception) {
            throw new RemoteException("FailedSelectRecord", exception);
        }
    }

    public synchronized void adjustAmount(String string, String string2, String string3, int n) throws RemoteException {
        try {
            this.addRecord(string, string2, null, n);
        }
        catch (Exception exception) {
            throw new RemoteException("FailedAdjustAmount", exception);
        }
    }

    public synchronized void expireDelete() throws RemoteException {
        Date date = new Date();
        ResultVersionRecordImpl resultVersionRecordImpl = null;
        this.sqlbuf.delete(0, this.sqlbuf.length());
        this.sqlbuf.append("SELECT * FROM ").append(this.SEDU);
        this.sqlbuf.append(" WHERE Expire=?");
        this.sqlbuf.append(" AND ExpirationTime<=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo().add("Expire", true).add("ExpirationTime", date.getTime());
        try {
            Vector vector = this.append(this.sqlbuf.toString(), parameterMetaInfo, 0);
            while (!vector.isEmpty()) {
                resultVersionRecordImpl = (ResultVersionRecordImpl)vector.remove(0);
                this.SEDU(resultVersionRecordImpl);
                this.add(resultVersionRecordImpl);
            }
        }
        catch (Exception exception) {
            throw new RemoteException("FailedSelectRecord", exception);
        }
    }

    public void insertRecord(ResultVersionRecordImpl resultVersionRecordImpl) throws RemoteException {
        try {
            this.EMPTY(resultVersionRecordImpl);
            super.checkDoCommit(false);
        }
        catch (Exception exception) {
            throw new RemoteException("FailedInsertRecord", exception);
        }
    }

    @Override
    public void run() {
        long l = 1440000L;
        while (this.checkDoCommit) {
            try {
                this.clear = true;
                this.expireDelete();
                this.clear = false;
            }
            catch (Exception exception) {
                super.logException(exception);
            }
            Thread.yield();
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                super.logException(exception);
            }
        }
    }

    @Override
    protected void finalize() {
        this.close();
    }

    private void EMPTY(ResultVersionRecordImpl resultVersionRecordImpl) throws SQLException {
        this.add.setInt(1, resultVersionRecordImpl.versionID);
        this.add.setString(2, resultVersionRecordImpl.versionName);
        this.add.setString(3, resultVersionRecordImpl.catalogFile);
        this.add.setString(4, resultVersionRecordImpl.reportFile);
        this.add.setString(5, resultVersionRecordImpl.paramFile);
        this.add.setString(6, resultVersionRecordImpl.resultFile);
        this.add.setString(7, resultVersionRecordImpl.taskID);
        this.add.setString(8, resultVersionRecordImpl.submitter);
        this.add.setLong(9, resultVersionRecordImpl.resultFormats);
        this.add.setLong(10, resultVersionRecordImpl.createdTime.getTime());
        this.add.setLong(11, resultVersionRecordImpl.expirationTime.getTime());
        this.add.setInt(12, resultVersionRecordImpl.launchType);
        this.add.setBoolean(13, resultVersionRecordImpl.expire);
        this.add.executeUpdate();
    }

    private ResultVersionRecordImpl J(ResultSet resultSet) throws SQLException {
        ResultVersionRecordImpl resultVersionRecordImpl = new ResultVersionRecordImpl();
        resultVersionRecordImpl.id = resultSet.getInt("id");
        resultVersionRecordImpl.versionID = resultSet.getInt("VersionID");
        resultVersionRecordImpl.versionName = resultSet.getString("VersionName");
        resultVersionRecordImpl.catalogFile = resultSet.getString("CatFile");
        resultVersionRecordImpl.reportFile = resultSet.getString("RptFile");
        resultVersionRecordImpl.paramFile = resultSet.getString("ParamFile");
        resultVersionRecordImpl.resultFile = resultSet.getString("ResultFile");
        resultVersionRecordImpl.taskID = resultSet.getString("TaskId");
        resultVersionRecordImpl.submitter = resultSet.getString("Submitter");
        resultVersionRecordImpl.resultFormats = resultSet.getLong("ResultFormats");
        resultVersionRecordImpl.createdTime = new Date(resultSet.getLong("CreatedTime"));
        resultVersionRecordImpl.expirationTime = new Date(resultSet.getLong("ExpirationTime"));
        resultVersionRecordImpl.launchType = resultSet.getInt("LaunchType");
        resultVersionRecordImpl.expire = resultSet.getBoolean("Expire");
        return resultVersionRecordImpl;
    }

    private void SEDU(ResultVersionRecordImpl resultVersionRecordImpl) throws RemoteException {
        super.delRecord(this.SEDU, "VersionId=?", new ParameterMetaInfo().add("versionID", resultVersionRecordImpl.versionID), false);
    }

    private void add(ResultVersionRecordImpl resultVersionRecordImpl) {
        if (resultVersionRecordImpl == null) {
            return;
        }
        File file = new File(resultVersionRecordImpl.resultFile);
        file.delete();
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = resultVersionRecordImpl.resultFile.lastIndexOf(File.separator);
        if (n != -1) {
            string3 = resultVersionRecordImpl.resultFile.substring(0, n);
            if ((n = string3.lastIndexOf(File.separator)) != -1) {
                string2 = string3.substring(0, n);
            }
        } else {
            string3 = resultVersionRecordImpl.resultFile;
        }
        if ((string = string3) != null && string.length() > 0) {
            if (this.addRecord != null) {
                SchdTools.deleteDir(this.addRecord + string);
            }
            if (string2 != null) {
                this.append.decreaseResultAmount(string2);
            }
            try {
                ParameterFileManager.getInstance().delete(resultVersionRecordImpl.paramFile);
            }
            catch (RptServerException rptServerException) {
                ServiceLogger.logError((Throwable)((Object)rptServerException));
            }
        }
    }

    private void addRecord(String string, String string2, String string3, int n) throws RemoteException, SQLException, Exception {
        ResultVersionRecordImpl resultVersionRecordImpl = null;
        Vector vector = null;
        String string4 = null;
        int n2 = n;
        int n3 = 0;
        this.sqlbuf.delete(0, this.sqlbuf.length());
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        this.sqlbuf.append(" CatFile=?");
        this.sqlbuf.append(" AND RptFile=?");
        parameterMetaInfo.add("catFile", string).add("rptFile", string2);
        if (string3 != null && string3.length() != 0) {
            this.sqlbuf.append(" AND Submitter=?");
            parameterMetaInfo.add("submitter", string3);
        }
        string4 = this.sqlbuf.toString();
        n3 = super.getRecordsAmount(this.SEDU, string4, parameterMetaInfo);
        if (n2 > 0 && n3 > n2) {
            this.sqlbuf.delete(0, this.sqlbuf.length());
            this.sqlbuf.append("SELECT * FROM ").append(this.SEDU).append(" WHERE ");
            this.sqlbuf.append(string4).append(" ORDER BY ID DESC");
            vector = this.append(this.sqlbuf.toString(), parameterMetaInfo, 0);
            resultVersionRecordImpl = (ResultVersionRecordImpl)vector.get(n2);
            this.sqlbuf.delete(0, this.sqlbuf.length());
            this.sqlbuf.append(" CatFile=?");
            this.sqlbuf.append(" AND RptFile=?");
            this.sqlbuf.append(" AND id<=?");
            parameterMetaInfo.clear();
            parameterMetaInfo.add("catFile", string).add("rptFile", string2).add("id", resultVersionRecordImpl.id);
            super.delRecord(this.SEDU, this.sqlbuf.substring(0), parameterMetaInfo, false);
            if (15 > n3 - n2) {
                for (int i = n2; i < n3; ++i) {
                    resultVersionRecordImpl = (ResultVersionRecordImpl)vector.get(i);
                    this.add(resultVersionRecordImpl);
                }
                vector.clear();
            } else {
                class DeleteThread
                implements Runnable {
                    private Vector v = null;
                    private int SEDU = 0;
                    private int access$002 = 0;

                    public DeleteThread(Vector vector, int n, int n2) {
                        this.v = vector;
                        this.SEDU = n;
                        this.access$002 = n2;
                    }

                    @Override
                    public void run() {
                        VersionTableImpl.this.copyFile = true;
                        if (this.v != null) {
                            for (int i = this.SEDU; i < this.access$002; ++i) {
                                ResultVersionRecordImpl resultVersionRecordImpl = (ResultVersionRecordImpl)this.v.get(i);
                                try {
                                    VersionTableImpl.this.add(resultVersionRecordImpl);
                                    continue;
                                }
                                catch (Exception exception) {
                                    ServiceLogger.logError(exception, 3);
                                }
                            }
                            this.v.clear();
                        }
                        VersionTableImpl.this.copyFile = false;
                    }
                }
                Thread thread = new Thread(new DeleteThread(vector, n2, n3));
                thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector append(String string, ParameterMetaInfo parameterMetaInfo, int n) throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement(string);
        ResultSet resultSet = null;
        Vector<ResultVersionRecordImpl> vector = new Vector<ResultVersionRecordImpl>();
        try {
            Dbs.setParameterMetaInfo(preparedStatement, parameterMetaInfo);
            preparedStatement.setMaxRows(n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                vector.add(this.J(resultSet));
            }
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
        return vector;
    }
}

