/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.core;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Table;
import jet.server.db.core.AbstractDBObject;
import jet.server.log.ServiceLogger;

public final class FieldImpl
extends AbstractDBObject
implements Field,
Cloneable {
    private static final BigDecimal SEDU = new BigDecimal("0");
    private static final char[] append = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private Table clone;
    private JDBCType getName;
    private String getTableName;
    private String getUCName;
    private int isForeignKey = 0;
    private int printStackTrace = 0;
    private int setName = 0;
    private String setParentTable = null;

    protected FieldImpl() {
    }

    public FieldImpl(String string) {
        super(FieldImpl.getUCName(string));
    }

    public FieldImpl(String string, String string2, JDBCType jDBCType, int n, int n2, int n3, String string3) {
        super(FieldImpl.getUCName(string2));
        this.setTableName(string);
        this.getName = jDBCType;
        this.isForeignKey = n;
        this.printStackTrace = n2;
        this.setName = n3;
        if (this.isForeignKey()) {
            this.setParentTable = string3;
        }
    }

    public FieldImpl(String string, String string2, JDBCType jDBCType, int n, int n2, int n3) {
        super(FieldImpl.getUCName(string2));
        this.setTableName(string);
        this.getName = jDBCType;
        this.isForeignKey = n;
        this.printStackTrace = n2;
        this.setName = n3;
    }

    public FieldImpl(String string, JDBCType jDBCType, int n, int n2) {
        super(FieldImpl.getUCName(string));
        this.getName = jDBCType;
        this.isForeignKey = n;
        this.setName = n2;
    }

    public FieldImpl(Table table, String string, JDBCType jDBCType, int n, int n2, int n3) {
        super(FieldImpl.getUCName(string));
        this.setParentTable(table);
        this.getName = jDBCType;
        this.isForeignKey = n;
        this.printStackTrace = n2;
        this.setName = n3;
    }

    @Override
    public Table getParentTable() {
        return this.clone;
    }

    @Override
    public JDBCType getJDBCType() {
        return this.getName;
    }

    @Override
    public int getSize() {
        return this.isForeignKey;
    }

    @Override
    public boolean isNotNull() {
        return (this.printStackTrace & 1) != 0;
    }

    @Override
    public boolean isIdentity() {
        return (this.printStackTrace & 2) != 0;
    }

    @Override
    public boolean isUnique() {
        return (this.printStackTrace & 4) != 0;
    }

    @Override
    public boolean isPrimaryKey() {
        return (this.printStackTrace & 8) != 0;
    }

    @Override
    public boolean isTruncated() {
        return (this.printStackTrace & 0x10) != 0;
    }

    @Override
    public boolean isForeignKey() {
        return (this.printStackTrace & 0x20) != 0;
    }

    @Override
    public FieldValue createFieldValue() {
        return new FieldValueImpl(this.getName());
    }

    @Override
    public int getCalculating() {
        return this.setName;
    }

    @Override
    public String getTableName() {
        return this.getTableName;
    }

    @Override
    public String getDispName() {
        return this.getUCName == null ? this.getName() : this.getUCName;
    }

    public void setDispName(String string) {
        this.getUCName = FieldImpl.getUCName(string);
    }

    @Override
    public String getFullyQualifiedName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTableName()).append(".").append(this.getName());
        return stringBuffer.substring(0);
    }

    public void setParentTable(Table table) {
        this.clone = table;
        this.getTableName = this.clone.getName();
    }

    public void setCalculating(int n) {
        this.setName = n;
    }

    public void setFieldName(String string) {
        super.setName(FieldImpl.getUCName(string));
    }

    public void setSize(int n) {
        this.isForeignKey = n;
    }

    public void setTableName(String string) {
        this.getTableName = string;
    }

    public void setType(JDBCType jDBCType) {
        this.getName = jDBCType;
    }

    public void setNotNull(boolean bl) {
        if (bl) {
            this.printStackTrace |= 1;
        }
    }

    public void setIdentity(boolean bl) {
        if (bl) {
            this.printStackTrace |= 2;
        }
    }

    @Override
    public Field createClone() {
        Field field = null;
        try {
            field = (Field)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return field;
    }

    public static String byteToHex(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            stringBuffer.append(append[n2 >> 4 & 0xF]);
            stringBuffer.append(append[n2 & 0xF]);
        }
        return stringBuffer.toString();
    }

    @Override
    public String getForeignTableName() {
        return this.setParentTable;
    }

    public void setForeignTableName(String string) {
        this.printStackTrace |= 0x20;
        this.setParentTable = string;
    }

    private final class FieldValueImpl
    extends AbstractDBObject
    implements FieldValue {
        private Object SEDU;

        public FieldValueImpl(String string) {
            super(FieldValueImpl.getUCName(string));
        }

        @Override
        public Object getValue() {
            return this.SEDU(this.SEDU, this.getJDBCType().dataType());
        }

        @Override
        public void setValue(Object object) {
            int n = this.getJDBCType().dataType();
            if (n == 12 || n == 1 || n == -1) {
                int n2 = FieldImpl.this.getSize();
                if (object == null) {
                    this.SEDU = null;
                } else {
                    String string = null;
                    if (object instanceof String) {
                        string = (String)object;
                    }
                    if (object instanceof byte[]) {
                        string = FieldImpl.byteToHex((byte[])object);
                    }
                    this.SEDU = n2 != 0 && string != null && FieldImpl.this.isTruncated() && string.length() > n2 ? string.substring(0, n2 - 3) + "..." : string;
                }
            } else {
                this.SEDU = this.SEDU(object, n);
            }
        }

        @Override
        public JDBCType getJDBCType() {
            return FieldImpl.this.getJDBCType();
        }

        @Override
        public boolean isIdentity() {
            return FieldImpl.this.isIdentity();
        }

        public String toString() {
            return this.SEDU.toString();
        }

        @Override
        public String getTableName() {
            return FieldImpl.this.getTableName();
        }

        @Override
        public boolean getBoolean() {
            Object object = this.SEDU(this.getValue(), -7);
            return object == null ? false : (Boolean)object;
        }

        @Override
        public byte getByte() {
            Object object = this.SEDU(this.getValue(), 5);
            return object == null ? (byte)0 : ((Number)object).byteValue();
        }

        @Override
        public short getShort() {
            Object object = this.SEDU(this.getValue(), 5);
            return object == null ? (short)0 : ((Number)object).shortValue();
        }

        @Override
        public int getInt() {
            Object object = this.SEDU(this.getValue(), 4);
            return object == null ? 0 : ((Number)object).intValue();
        }

        @Override
        public long getLong() {
            Object object = this.SEDU(this.getValue(), -5);
            return object == null ? 0L : ((Number)object).longValue();
        }

        @Override
        public float getFloat() {
            Object object = this.SEDU(this.getValue(), 7);
            return object == null ? 0.0f : ((Number)object).floatValue();
        }

        @Override
        public double getDouble() {
            Object object = this.SEDU(this.getValue(), 8);
            return object == null ? 0.0 : ((Number)object).doubleValue();
        }

        @Override
        public String getString() {
            Object object = this.getValue();
            return object == null ? null : object.toString();
        }

        @Override
        public byte[] getBytes() {
            Object object = this.getValue();
            if (object == null) {
                return null;
            }
            if (object instanceof byte[]) {
                return (byte[])object;
            }
            if (object instanceof String) {
                return ((String)object).getBytes();
            }
            object = this.SEDU(this.getValue(), -2);
            return (byte[])object;
        }

        @Override
        public Date getDate() {
            return (Date)this.SEDU(this.getValue(), 91);
        }

        @Override
        public Time getTime() {
            return (Time)this.SEDU(this.getValue(), 92);
        }

        @Override
        public Timestamp getTimestamp() {
            return (Timestamp)this.SEDU(this.getValue(), 93);
        }

        private Object SEDU(Object object, int n) throws NumberFormatException {
            if (object == null) {
                return n == 2004 ? new byte[]{} : null;
            }
            switch (n) {
                case -6: {
                    if (object instanceof String) {
                        object = new Integer((String)object);
                    }
                    if (object instanceof Integer || object instanceof Long) {
                        int n2 = ((Number)object).intValue();
                        if (127 < n2 || n2 < -128) {
                            throw new NumberFormatException();
                        }
                        return object;
                    }
                    if (object instanceof Byte) {
                        return new Integer(((Number)object).intValue());
                    }
                    if (!(object instanceof Float) && !(object instanceof Double)) break;
                    int n3 = ((Number)object).intValue();
                    if (Short.MAX_VALUE < n3 || n3 < Short.MIN_VALUE) {
                        throw new NumberFormatException();
                    }
                    return new Integer(((Number)object).intValue());
                }
                case 5: {
                    if (object instanceof String) {
                        object = new Integer((String)object);
                    }
                    if (object instanceof Integer || object instanceof Long) {
                        int n4 = ((Number)object).intValue();
                        if (Short.MAX_VALUE < n4 || n4 < Short.MIN_VALUE) {
                            throw new NumberFormatException();
                        }
                        return object;
                    }
                    if (object instanceof Byte || object instanceof Short) {
                        return new Integer(((Number)object).intValue());
                    }
                    if (!(object instanceof Float) && !(object instanceof Double)) break;
                    int n5 = ((Number)object).intValue();
                    if (Short.MAX_VALUE < n5 || n5 < Short.MIN_VALUE) {
                        throw new NumberFormatException();
                    }
                    return new Integer(((Number)object).intValue());
                }
                case 4: {
                    if (object instanceof String) {
                        return new Integer((String)object);
                    }
                    if (object instanceof Integer) {
                        return object;
                    }
                    if (!(object instanceof Long) && !(object instanceof Float) && !(object instanceof Double)) break;
                    int n6 = ((Number)object).intValue();
                    if (Integer.MAX_VALUE < n6 || n6 < Integer.MIN_VALUE) {
                        throw new NumberFormatException();
                    }
                    return new Integer(((Number)object).intValue());
                }
                case -5: {
                    if (object instanceof Long) {
                        return object;
                    }
                    if (object instanceof String) {
                        return new Long((String)object);
                    }
                    if (object instanceof Integer) {
                        return new Long(((Integer)object).longValue());
                    }
                    if (!(object instanceof Float) && !(object instanceof Double)) break;
                    long l = ((Number)object).longValue();
                    if (Long.MAX_VALUE < l || l < Long.MIN_VALUE) {
                        throw new NumberFormatException();
                    }
                    return new Long(((Number)object).longValue());
                }
                case 6: 
                case 7: 
                case 8: {
                    if (object instanceof Double) {
                        return object;
                    }
                    if (object instanceof String) {
                        return new Double((String)object);
                    }
                    if (!(object instanceof Number)) break;
                    return new Double(((Number)object).doubleValue());
                }
                case 2: 
                case 3: {
                    if (!(object instanceof BigDecimal)) break;
                    return object;
                }
                case -7: {
                    if (object instanceof Boolean) {
                        return object;
                    }
                    if (object instanceof Byte) {
                        boolean bl = ((Number)object).byteValue() != 0;
                        return new Boolean(bl);
                    }
                    if (object instanceof String) {
                        return new Boolean((String)object);
                    }
                    if (object instanceof Short || object instanceof Integer || object instanceof Long) {
                        boolean bl = ((Number)object).longValue() != 0L;
                        return new Boolean(bl);
                    }
                    if (object instanceof Double) {
                        boolean bl = (Double)object != 0.0;
                        return new Boolean(bl);
                    }
                    if (!(object instanceof BigDecimal)) break;
                    boolean bl = ((BigDecimal)object).compareTo(SEDU) != 0;
                    return new Boolean(bl);
                }
                case -1: 
                case 1: 
                case 12: {
                    if (object instanceof String) {
                        return object;
                    }
                    if (object instanceof byte[]) {
                        return FieldImpl.byteToHex((byte[])object);
                    }
                    if (!(object instanceof Clob)) break;
                    try {
                        this.SEDU = ((Clob)object).getSubString(1L, Integer.MAX_VALUE);
                        return this.SEDU;
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException);
                        break;
                    }
                }
                case 92: {
                    if (object instanceof Timestamp) {
                        return new Time(((Timestamp)object).getTime());
                    }
                    if (object instanceof Date) {
                        return new Time(0L);
                    }
                    if (!(object instanceof Time)) break;
                    return object;
                }
                case 91: {
                    if (object instanceof Timestamp) {
                        return new Date(((Timestamp)object).getTime());
                    }
                    if (!(object instanceof Date)) break;
                    return object;
                }
                case 93: {
                    if (object instanceof Date) {
                        return new Timestamp(((Date)object).getTime());
                    }
                    if (!(object instanceof Time)) break;
                    return new Timestamp(((Time)object).getTime());
                }
                case -4: 
                case -3: 
                case -2: {
                    if (object instanceof byte[]) {
                        return object;
                    }
                    if (!(object instanceof Blob)) break;
                    try {
                        Blob blob = (Blob)object;
                        byte[] byArray = ((Blob)object).getBytes(1L, Integer.MAX_VALUE);
                        this.SEDU = byArray;
                        return byArray;
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException);
                        break;
                    }
                }
                case 2004: {
                    if (!(object instanceof Blob)) break;
                    return object;
                }
                case 2005: {
                    if (!(object instanceof Clob)) break;
                    return object;
                }
                default: {
                    return object;
                }
            }
            return object;
        }
    }
}

