/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.core;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ParameterMetaInfo
implements Serializable {
    private static final long serialVersionUID = 8434692088908755153L;
    public static final int parameterModeUnknown = 0;
    public static final int parameterModeIn = 1;
    public static final int parameterModeInOut = 2;
    public static final int parameterModeOut = 3;
    public static final int parameterModeInnerObject = 4;
    public static final ParameterMetaInfo EMPTY = new ParameterMetaInfo(true);
    private List paras = new ArrayList();

    public ParameterMetaInfo() {
    }

    private ParameterMetaInfo(boolean bl) {
        if (bl) {
            this.paras = Collections.unmodifiableList(this.paras);
        }
    }

    public String toString() {
        return this.paras.toString();
    }

    public ParameterMetaInfo add(String string, String string2) {
        return this.add(string, string2, 12);
    }

    public ParameterMetaInfo add(String string, long l) {
        return this.add(string, new Long(l), -5);
    }

    public ParameterMetaInfo add(String string, int n) {
        return this.add(string, new Integer(n), 4);
    }

    public ParameterMetaInfo add(String string, byte by) {
        return this.add(string, new Byte(by), -6);
    }

    public ParameterMetaInfo add(String string, boolean bl) {
        return this.add(string, new Boolean(bl), -7);
    }

    public ParameterMetaInfo add(String string, Timestamp timestamp) {
        return this.add(string, timestamp, 93);
    }

    public ParameterMetaInfo add(String string, Object object, int n) {
        return this.add(string, object, n, 1);
    }

    public ParameterMetaInfo add(String string, Object object, int n, int n2) {
        ParaMetaInfo paraMetaInfo = new ParaMetaInfo(string, object, n, n2);
        this.paras.add(paraMetaInfo);
        return this;
    }

    public ParameterMetaInfo add(ParameterMetaInfo parameterMetaInfo) {
        if (parameterMetaInfo == null || parameterMetaInfo.getParameterCount() == 0) {
            return this;
        }
        for (int i = 1; i <= parameterMetaInfo.getParameterCount(); ++i) {
            this.paras.add(parameterMetaInfo.get(i));
        }
        return this;
    }

    private ParaMetaInfo get(int n) {
        if (this.paras == null || n > this.paras.size() || n < 1) {
            return null;
        }
        return (ParaMetaInfo)this.paras.get(n - 1);
    }

    public void remove(int n) {
        if (this.paras == null || n > this.paras.size() || n < 1) {
            return;
        }
        int n2 = n - 1;
        this.paras.remove(n2);
    }

    public void clear() {
        this.paras.clear();
    }

    public int getParameterCount() {
        if (this.paras == null) {
            return 0;
        }
        return this.paras.size();
    }

    public int getParameterMode(int n) {
        if (this.paras == null || n > this.paras.size() || n < 1) {
            return 0;
        }
        ParaMetaInfo paraMetaInfo = (ParaMetaInfo)this.paras.get(n - 1);
        return paraMetaInfo.getMode();
    }

    public int getJDBCType(int n) {
        if (this.paras == null || n > this.paras.size() || n < 1) {
            return 0;
        }
        ParaMetaInfo paraMetaInfo = (ParaMetaInfo)this.paras.get(n - 1);
        return paraMetaInfo.getJDBCType();
    }

    public String getName(int n) {
        if (this.paras == null || n > this.paras.size() || n < 1) {
            return null;
        }
        ParaMetaInfo paraMetaInfo = (ParaMetaInfo)this.paras.get(n - 1);
        return paraMetaInfo.getName();
    }

    public Object getValue(int n) {
        if (this.paras == null || n > this.paras.size() || n < 1) {
            return null;
        }
        ParaMetaInfo paraMetaInfo = (ParaMetaInfo)this.paras.get(n - 1);
        return paraMetaInfo.getValue();
    }

    private final class ParaMetaInfo {
        private String SEDU;
        private Object append;
        private int toString;
        private int I;

        public ParaMetaInfo(String string, Object object, int n, int n2) {
            this.SEDU = string;
            this.append = object;
            this.toString = n;
            this.I = n2;
        }

        public String toString() {
            return this.SEDU + "=" + this.append;
        }

        public String getName() {
            return this.SEDU;
        }

        public void setName(String string) {
            this.SEDU = string;
        }

        public Object getValue() {
            return this.append;
        }

        public void setValue(Object object) {
            this.append = object;
        }

        public int getJDBCType() {
            return this.toString;
        }

        public void setJDBCType(int n) {
            this.toString = n;
        }

        public int getMode() {
            return this.I;
        }

        public void setMode(int n) {
            this.I = n;
        }
    }
}

