/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.core;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.Fields;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.api.db.Unique;
import jet.server.api.db.Uniques;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.adapter.DBAdapter;
import jet.server.db.adapter.DBFactory;
import jet.server.db.core.AbstractDBObject;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.Dbs;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.FieldsImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.UniquesImpl;
import jet.server.db.event.RecordEventListener;
import jet.server.log.ServiceLogger;

public class TableImpl
extends AbstractDBObject
implements Table {
    private Database C;
    protected FieldsImpl fields = new FieldsImpl();
    protected UniquesImpl unqs = new UniquesImpl();
    protected DBAdapter adapter;
    protected List listeners;
    private Set clear = new HashSet();
    public static Map _DDLTables;

    private static boolean C() {
        return _DDLTables != null;
    }

    private static void EMPTY(TableImpl tableImpl) {
        if (!TableImpl.C()) {
            return;
        }
        TableImpl tableImpl2 = _DDLTables.put(tableImpl.getName(), tableImpl);
        if (tableImpl2 != null && !tableImpl2.fields().isEmpty()) {
            new Exception(tableImpl.getName()).printStackTrace();
        }
        System.out.println(String.format("    %-28s: %s", tableImpl.getName(), tableImpl.getClass().getName()));
    }

    public TableImpl(String string) {
        super(TableImpl.getUCName(string));
        TableImpl.EMPTY(this);
    }

    public TableImpl(String string, Field[] fieldArray) {
        this(string);
        for (Field field : fieldArray) {
            this.append(field);
        }
    }

    public TableImpl(Database database, String string) throws InstantiationException {
        this(string);
        TableImpl tableImpl;
        String string2;
        if (TableImpl.C()) {
            return;
        }
        this.C = database;
        String string3 = database.getProperty("tablespace");
        if (string3 != null) {
            this.setProperty("tablespace", string3);
        }
        if ((string2 = database.getProperty("schema")) != null) {
            this.setProperty("schema", string2);
        }
        if ((tableImpl = (TableImpl)database.tables(string)) != null) {
            this.adapter = tableImpl.getDBAdapter();
        }
        if (this.adapter == null) {
            this.adapter = DBFactory.create(((DatabaseImpl)database).getConnector());
        }
        this.adapter.setIDGenerator(((DatabaseImpl)database).getIDGenerator());
    }

    public Set getForeignTableNames() {
        return this.clear;
    }

    @Override
    public Database getDatabase() {
        return this.C;
    }

    @Override
    public String getNameWithoutSchema() {
        return super.getName();
    }

    @Override
    public String getName() {
        return Dbs.fullTableName(this.getProperty("schema"), super.getName());
    }

    @Override
    public final Fields fields() {
        return this.fields;
    }

    @Override
    public final Field fields(int n) {
        return (Field)this.fields.get(n);
    }

    @Override
    public final Field fields(String string) {
        return (Field)this.fields.get(string);
    }

    public final void append(Field field) {
        this.fields.append(field);
        if (field.isForeignKey()) {
            this.clear.add(((FieldImpl)field).getForeignTableName());
        }
    }

    public final void remove(Field field) {
        this.fields.remove(field.getName());
    }

    public void close() {
        this.fields.clear();
        this.adapter = null;
    }

    @Override
    public final Recordset query(Field[] fieldArray, String string, boolean bl) throws SQLException {
        return this.query(fieldArray, string, null, bl, 1);
    }

    @Override
    public final Recordset query(Field[] fieldArray, String string, boolean bl, int n) throws SQLException {
        return this.query(fieldArray, string, null, bl, n, 1004);
    }

    @Override
    public final Recordset query(Field[] fieldArray, String string, boolean bl, int n, int n2) throws SQLException {
        Table[] tableArray = new Table[]{this};
        return this.adapter.select(fieldArray, tableArray, string, null, bl, n, n2);
    }

    @Override
    public final Recordset query(Field[] fieldArray, String string, ParameterMetaInfo parameterMetaInfo, boolean bl) throws SQLException {
        return this.query(fieldArray, string, parameterMetaInfo, bl, 1);
    }

    @Override
    public final Recordset query(Field[] fieldArray, String string, ParameterMetaInfo parameterMetaInfo, boolean bl, int n) throws SQLException {
        return this.query(fieldArray, string, parameterMetaInfo, bl, n, 1004);
    }

    @Override
    public final Recordset query(Field[] fieldArray, String string, ParameterMetaInfo parameterMetaInfo, boolean bl, int n, int n2) throws SQLException {
        Table[] tableArray = new Table[]{this};
        return this.adapter.select(fieldArray, tableArray, string, parameterMetaInfo, bl, n, n2);
    }

    @Override
    public final int queryCountValue(String string, String string2, boolean bl) throws SQLException {
        Field[] fieldArray = new Field[]{this.fields(string).createClone()};
        ((FieldImpl)fieldArray[0]).setType(JDBCType.INTEGER);
        ((FieldImpl)fieldArray[0]).setCalculating(1);
        Recordset recordset = this.query(fieldArray, string2, null, bl);
        int n = Integer.MIN_VALUE;
        if (recordset.next()) {
            n = recordset.getInt(0);
        }
        recordset.close();
        recordset = null;
        return n;
    }

    @Override
    public final int queryCountValue(String string, String string2, ParameterMetaInfo parameterMetaInfo, boolean bl) throws SQLException {
        Field[] fieldArray = new Field[]{this.fields(string).createClone()};
        ((FieldImpl)fieldArray[0]).setType(JDBCType.INTEGER);
        ((FieldImpl)fieldArray[0]).setCalculating(1);
        Recordset recordset = this.query(fieldArray, string2, parameterMetaInfo, bl);
        int n = Integer.MIN_VALUE;
        if (recordset.next()) {
            n = recordset.getInt(0);
        }
        recordset.close();
        recordset = null;
        return n;
    }

    @Override
    public final Number querySumValue(String string, String string2, boolean bl) throws SQLException {
        Field[] fieldArray = new Field[]{this.fields(string).createClone()};
        ((FieldImpl)fieldArray[0]).setCalculating(2);
        Recordset recordset = this.query(fieldArray, string2, null, bl);
        Number number = null;
        number = recordset.next() ? (Number)((Number)recordset.getValue(0)) : (Number)this.INTEGER(fieldArray[0].getJDBCType());
        recordset.close();
        recordset = null;
        return number;
    }

    @Override
    public final Number querySumValue(String string, String string2, ParameterMetaInfo parameterMetaInfo, boolean bl) throws SQLException {
        Field[] fieldArray = new Field[]{this.fields(string).createClone()};
        ((FieldImpl)fieldArray[0]).setCalculating(2);
        Recordset recordset = this.query(fieldArray, string2, parameterMetaInfo, bl);
        Number number = null;
        number = recordset.next() ? (Number)((Number)recordset.getValue(0)) : (Number)this.INTEGER(fieldArray[0].getJDBCType());
        recordset.close();
        recordset = null;
        return number;
    }

    @Override
    public final Number queryAvgValue(String string, String string2, boolean bl) throws SQLException {
        Field[] fieldArray = new Field[]{this.fields(string).createClone()};
        ((FieldImpl)fieldArray[0]).setCalculating(3);
        Recordset recordset = this.query(fieldArray, string2, null, bl);
        Number number = null;
        number = recordset.next() ? (Number)((Number)recordset.getValue(0)) : (Number)this.INTEGER(fieldArray[0].getJDBCType());
        recordset.close();
        recordset = null;
        return number;
    }

    @Override
    public final Number queryAvgValue(String string, String string2, ParameterMetaInfo parameterMetaInfo, boolean bl) throws SQLException {
        Field[] fieldArray = new Field[]{this.fields(string).createClone()};
        ((FieldImpl)fieldArray[0]).setCalculating(3);
        Recordset recordset = this.query(fieldArray, string2, parameterMetaInfo, bl);
        Number number = null;
        number = recordset.next() ? (Number)((Number)recordset.getValue(0)) : (Number)this.INTEGER(fieldArray[0].getJDBCType());
        recordset.close();
        recordset = null;
        return number;
    }

    @Override
    public final Number queryMaxValue(String string, String string2, boolean bl) throws SQLException {
        Field[] fieldArray = new Field[]{this.fields(string).createClone()};
        ((FieldImpl)fieldArray[0]).setCalculating(4);
        Recordset recordset = this.query(fieldArray, string2, null, bl);
        Number number = null;
        if (recordset.next()) {
            number = (Number)recordset.getValue(0);
            if (number == null) {
                number = this.INTEGER(fieldArray[0].getJDBCType());
            }
        } else {
            number = this.INTEGER(fieldArray[0].getJDBCType());
        }
        recordset.close();
        recordset = null;
        return number;
    }

    @Override
    public final Number queryMaxValue(String string, String string2, ParameterMetaInfo parameterMetaInfo, boolean bl) throws SQLException {
        Field[] fieldArray = new Field[]{this.fields(string).createClone()};
        ((FieldImpl)fieldArray[0]).setCalculating(4);
        Recordset recordset = this.query(fieldArray, string2, parameterMetaInfo, bl);
        Number number = null;
        if (recordset.next()) {
            number = (Number)recordset.getValue(0);
            if (number == null) {
                number = this.INTEGER(fieldArray[0].getJDBCType());
            }
        } else {
            number = this.INTEGER(fieldArray[0].getJDBCType());
        }
        recordset.close();
        recordset = null;
        return number;
    }

    @Override
    public final Number queryMinValue(String string, String string2, boolean bl) throws SQLException {
        Field[] fieldArray = new Field[]{this.fields(string).createClone()};
        ((FieldImpl)fieldArray[0]).setCalculating(5);
        Recordset recordset = this.query(fieldArray, string2, null, bl);
        Number number = null;
        if (recordset.next()) {
            number = (Number)recordset.getValue(0);
            if (number == null) {
                number = this.INTEGER(fieldArray[0].getJDBCType());
            }
        } else {
            number = this.INTEGER(fieldArray[0].getJDBCType());
        }
        recordset.close();
        recordset = null;
        return number;
    }

    @Override
    public final Number queryMinValue(String string, String string2, ParameterMetaInfo parameterMetaInfo, boolean bl) throws SQLException {
        Field[] fieldArray = new Field[]{this.fields(string).createClone()};
        ((FieldImpl)fieldArray[0]).setCalculating(5);
        Recordset recordset = this.query(fieldArray, string2, parameterMetaInfo, bl);
        Number number = null;
        if (recordset.next()) {
            number = (Number)recordset.getValue(0);
            if (number == null) {
                number = this.INTEGER(fieldArray[0].getJDBCType());
            }
        } else {
            number = this.INTEGER(fieldArray[0].getJDBCType());
        }
        recordset.close();
        recordset = null;
        return number;
    }

    @Override
    public int insert(List list) throws SQLException {
        return this.adapter.insert((Table)this, list);
    }

    @Override
    public int insert2(List list) throws SQLException {
        return this.adapter.insert((Table)this, list);
    }

    @Override
    public final int insert(FieldValue[] fieldValueArray) throws SQLException {
        return this.adapter.insert((Table)this, fieldValueArray);
    }

    @Override
    public final int update(FieldValue[] fieldValueArray, String string) throws SQLException {
        return this.adapter.update(this, fieldValueArray, string, null);
    }

    @Override
    public final int update(FieldValue[] fieldValueArray, String string, ParameterMetaInfo parameterMetaInfo) throws SQLException {
        return this.adapter.update(this, fieldValueArray, string, parameterMetaInfo);
    }

    @Override
    public final int delete(String string) throws SQLException {
        return this.adapter.delete(this, string, null);
    }

    @Override
    public final int delete(String string, ParameterMetaInfo parameterMetaInfo) throws SQLException {
        return this.adapter.delete(this, string, parameterMetaInfo);
    }

    @Override
    public boolean hasExternalData() {
        return false;
    }

    @Override
    public String getExternalDataPath(FieldValue[] fieldValueArray) {
        return null;
    }

    private Number INTEGER(JDBCType jDBCType) {
        switch (jDBCType.dataType()) {
            case -6: {
                return new Byte(-128);
            }
            case 5: {
                return new Short(Short.MIN_VALUE);
            }
            case 4: {
                return new Integer(Integer.MIN_VALUE);
            }
            case -5: {
                return new Long(Long.MIN_VALUE);
            }
            case 6: {
                return new Float(Float.MIN_VALUE);
            }
            case 3: 
            case 7: 
            case 8: {
                return new Double(Double.MIN_VALUE);
            }
        }
        return null;
    }

    public DBAdapter getDBAdapter() {
        return this.adapter;
    }

    @Override
    public final Uniques uniques() {
        return this.unqs;
    }

    @Override
    public final Unique uniques(int n) {
        return (Unique)this.unqs.get(n);
    }

    @Override
    public final Unique uniques(String string) {
        return (Unique)this.unqs.get(string);
    }

    public final void append(Unique unique) {
        this.unqs.append(unique);
    }

    public final void remove(Unique unique) {
        this.unqs.remove(unique.getName());
    }

    protected String rulesFilePath(String string) {
        String string2 = string;
        if (string != null && string.trim().length() > 0) {
            if (string.indexOf(47) != -1 && File.separatorChar != '/') {
                string2 = this.replacePathSeparator(string, '/', File.separatorChar);
            } else if (string.indexOf(92) != -1 && File.separatorChar != '\\') {
                string2 = this.replacePathSeparator(string, '\\', File.separatorChar);
            }
        }
        return string2;
    }

    protected String replacePathSeparator(String string, char c, char c2) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            cArray[i] = c2;
        }
        return new String(cArray);
    }

    public void addListener(RecordEventListener recordEventListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(recordEventListener);
    }

    protected final void upgradeOldTable(Database database, UpdateDetailsTable updateDetailsTable, String string, int n) throws SQLException {
        String string2 = Dbs.fullTableName(database.getProperty("schema"), string);
        if (database.tables().contains(string2)) {
            boolean bl = updateDetailsTable.isUpdating(string);
            Table table = database.tables(string2);
            if (!bl) {
                this.mergeOldTable(table, n);
                table.delete(null, ParameterMetaInfo.EMPTY);
                updateDetailsTable.setUpdateDetails(string, true);
            }
            ((DatabaseImpl)database).remove(table);
            try {
                this.adapter.dropTable(table);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(3640001, string, 3);
                ServiceLogger.logError(sQLException, 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeOldTable(Table table, int n) throws SQLException {
        Recordset recordset = null;
        try {
            recordset = table.query(table.fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
            while (recordset.next()) {
                this.insert(recordset.fields());
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
    }
}

