/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import jet.server.api.db.Database;
import jet.server.api.db.JDBCType;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.dao.AbstractDAO;
import jet.server.db.dao.CRDInfoDAO;
import jet.server.db.model.CRDRunDetailModel;
import jet.server.log.ServiceLogger;

public class CRDRunDetailDAO
extends AbstractDAO {
    public static final String TABLE_NAME = "CRDRUNDETAIL_1";
    private static final String BIGINT = "ID";
    private static final String BIT = "ACTIVITY";
    private static final String INTEGER = "STARTTIME";
    private static final String SEDU = "ENDTIME";
    private static final String TINYINT = "SUCC";
    private static CRDRunDetailDAO add;
    private static final String append = "SELECT * FROM {0} ORDER BY ID, STARTTIME";
    private static final String buildInsertSql;
    private static final String closeResultSet = "DELETE FROM {0} WHERE ID = ?";

    private CRDRunDetailDAO(Database database, CRDInfoDAO cRDInfoDAO, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), BIGINT, JDBCType.INTEGER, 0, 32, 0, cRDInfoDAO.getName()));
        super.append(new FieldImpl(this.getName(), BIT, JDBCType.TINYINT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), INTEGER, JDBCType.BIGINT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), SEDU, JDBCType.BIGINT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), TINYINT, JDBCType.BIT, 0, 0, 0));
        if (!database.tables().contains(this.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
    }

    public static CRDRunDetailDAO newInstance(Database database, CRDInfoDAO cRDInfoDAO, UpdateDetailsTable updateDetailsTable) {
        if (add == null) {
            try {
                add = new CRDRunDetailDAO(database, cRDInfoDAO, updateDetailsTable);
            }
            catch (Exception exception) {
                ServiceLogger.logError(1640001, TABLE_NAME, 1);
                ServiceLogger.logError(exception, 1);
            }
        }
        return add;
    }

    public static CRDRunDetailDAO getInstance() {
        return add;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Connection connection, CRDRunDetailModel cRDRunDetailModel) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(buildInsertSql));
            int n2 = 1;
            preparedStatement.setInt(n2++, cRDRunDetailModel.getId());
            preparedStatement.setShort(n2++, cRDRunDetailModel.getActivity());
            preparedStatement.setLong(n2++, cRDRunDetailModel.getStartTime());
            preparedStatement.setLong(n2++, cRDRunDetailModel.getEndTime());
            preparedStatement.setBoolean(n2++, cRDRunDetailModel.isSucc());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Connection connection, int n) throws SQLException {
        int n2;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(closeResultSet));
            int n3 = 1;
            preparedStatement.setInt(n3++, n);
            n2 = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap listAll(Connection connection) throws SQLException {
        Object object;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(append));
            resultSet = preparedStatement.executeQuery();
            HashMap hashMap = new HashMap();
            ArrayList<Object> arrayList = null;
            int n = -1;
            while (resultSet.next()) {
                object = new CRDRunDetailModel();
                ((CRDRunDetailModel)object).setId(resultSet.getInt(BIGINT));
                ((CRDRunDetailModel)object).setActivity(resultSet.getShort(BIT));
                ((CRDRunDetailModel)object).setStartTime(resultSet.getLong(INTEGER));
                ((CRDRunDetailModel)object).setEndTime(resultSet.getLong(SEDU));
                ((CRDRunDetailModel)object).setSucc(resultSet.getBoolean(TINYINT));
                if (((CRDRunDetailModel)object).getId() != n) {
                    arrayList = new ArrayList<Object>();
                    hashMap.put(((CRDRunDetailModel)object).getId(), arrayList);
                    n = ((CRDRunDetailModel)object).getId();
                }
                arrayList.add(object);
            }
            object = hashMap;
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return object;
    }

    static {
        buildInsertSql = CRDRunDetailDAO.buildInsertSql(new String[]{BIGINT, BIT, INTEGER, SEDU, TINYINT});
    }
}

