/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jet.server.api.db.Database;
import jet.server.api.db.JDBCType;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.dao.AbstractDAO;
import jet.server.db.dao.CompletedCRDInfoDAO;
import jet.server.db.model.CRDConnInfoModel;
import jet.server.db.model.CompletedCRDInfoModel;
import jet.server.log.ServiceLogger;

public class CompletedCRDConnInfoDAO
extends AbstractDAO {
    public static final String TABLE_NAME = "COMP_CRD_CONN_INFO_1";
    private static final String INTEGER = "ID";
    private static CompletedCRDConnInfoDAO SEDU;
    private static final String VARCHAR = "SELECT * FROM {0} ORDER BY ID";
    private static final String addPassword;
    private static final String addUserName = "DELETE FROM {0} WHERE ID = ?";

    private CompletedCRDConnInfoDAO(Database database, CompletedCRDInfoDAO completedCRDInfoDAO, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), INTEGER, JDBCType.INTEGER, 0, 32, 0, completedCRDInfoDAO.getName()));
        super.append(new FieldImpl(this.getName(), "CONNNAME", JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), "USERNAME", JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), "PWD", JDBCType.VARCHAR, 256, 0, 0));
        if (!database.tables().contains(this.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
    }

    public static CompletedCRDConnInfoDAO newInstance(Database database, CompletedCRDInfoDAO completedCRDInfoDAO, UpdateDetailsTable updateDetailsTable) {
        if (SEDU == null) {
            try {
                SEDU = new CompletedCRDConnInfoDAO(database, completedCRDInfoDAO, updateDetailsTable);
            }
            catch (Exception exception) {
                ServiceLogger.logError(1640001, TABLE_NAME, 1);
                ServiceLogger.logError(exception, 1);
            }
        }
        return SEDU;
    }

    public static CompletedCRDConnInfoDAO getInstance() {
        return SEDU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Connection connection, CompletedCRDInfoModel completedCRDInfoModel) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        this.delete(connection, completedCRDInfoModel.getId());
        Map map = completedCRDInfoModel.getUserNames();
        Map map2 = completedCRDInfoModel.getPasswords();
        if (map == null || map2 == null) {
            return 0;
        }
        try {
            preparedStatement = connection.prepareStatement(this.rtp(addPassword));
            int n2 = 0;
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                int n3 = 1;
                String string = (String)iterator.next();
                preparedStatement.setInt(n3++, completedCRDInfoModel.getId());
                preparedStatement.setString(n3++, string);
                preparedStatement.setString(n3++, (String)map.get(string));
                preparedStatement.setString(n3++, (String)map2.get(string));
                n2 += preparedStatement.executeUpdate();
            }
            n = n2;
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Connection connection, int n) throws SQLException {
        int n2;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(addUserName));
            int n3 = 1;
            preparedStatement.setInt(n3++, n);
            n2 = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap listAll(Connection connection) throws SQLException {
        HashMap<Integer, CRDConnInfoModel> hashMap;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(VARCHAR));
            resultSet = preparedStatement.executeQuery();
            HashMap<Integer, CRDConnInfoModel> hashMap2 = new HashMap<Integer, CRDConnInfoModel>();
            int n = -1;
            CRDConnInfoModel cRDConnInfoModel = null;
            while (resultSet.next()) {
                int n2 = resultSet.getInt(INTEGER);
                if (n2 != n) {
                    cRDConnInfoModel = new CRDConnInfoModel();
                    cRDConnInfoModel.setId(n2);
                    hashMap2.put(n2, cRDConnInfoModel);
                    n = cRDConnInfoModel.getId();
                }
                String string = resultSet.getString("CONNNAME");
                String string2 = resultSet.getString("USERNAME");
                String string3 = resultSet.getString("PWD");
                cRDConnInfoModel.addUserName(string, string2);
                cRDConnInfoModel.addPassword(string, string3);
            }
            hashMap = hashMap2;
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return hashMap;
    }

    static {
        addPassword = CompletedCRDConnInfoDAO.buildInsertSql(new String[]{INTEGER, "CONNNAME", "USERNAME", "PWD"});
    }
}

