/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.event;

import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapFlags;
import jet.server.cluster.blocks.MapListenerAdapter;
import jet.server.db.event.NodeRecordEvent;
import jet.server.db.event.RecordEventListener;
import jet.server.db.event.RecordEventType;
import jet.server.db.resource.FolderRecord;
import jet.server.db.resource.NodeRecord;
import jet.server.db.resource.ResourceNodeRecord;
import jet.server.intf.jrs.VersionService;
import jet.server.intf.resource.ResourceInfo;
import jet.server.jrc.resource.FolderImpl;
import jet.server.jrc.resource.NodeImpl;
import jet.server.jrc.resource.ResourceImpl;
import jet.server.log.ServiceLogger;

public class NodeEventListener
extends MapListenerAdapter
implements RecordEventListener {
    private VersionService SEDU;
    private Map addChild;
    private Hashtable afterPut;
    private ClusterMap afterRemove;

    NodeEventListener() {
    }

    public void onChanged(NodeRecordEvent nodeRecordEvent) {
        ServiceLogger.logDebug(6690060, new Object[]{nodeRecordEvent.getType(), nodeRecordEvent.getNewRecord(), nodeRecordEvent.getOldRecordId()}, 6);
        RecordEventType recordEventType = nodeRecordEvent.getType();
        if (recordEventType == RecordEventType.deleted) {
            this.delete((NodeRecord)this.afterRemove.get(nodeRecordEvent.getOldRecordId()));
        } else if (recordEventType == RecordEventType.inserted) {
            this.SEDU(nodeRecordEvent.getNewRecord());
        } else if (recordEventType == RecordEventType.updated) {
            this.update((NodeRecord)this.afterRemove.get(nodeRecordEvent.getOldRecordId()), nodeRecordEvent.getNewRecord());
        } else if (recordEventType == RecordEventType.deletedAll) {
            this.clear();
        }
    }

    private void update(NodeRecord nodeRecord, NodeRecord nodeRecord2) {
        if (this.afterRemove != null && nodeRecord2 != null) {
            this.afterRemove.put((Object)nodeRecord2.getID(), nodeRecord2);
        }
    }

    private void SEDU(NodeRecord nodeRecord) {
        if (this.afterRemove != null) {
            this.afterRemove.put((Object)nodeRecord.getID(), nodeRecord);
        }
    }

    private void delete(NodeRecord nodeRecord) {
        if (this.afterRemove != null) {
            this.afterRemove.remove(nodeRecord.getID());
        }
    }

    private void clear() {
        if (this.afterRemove != null) {
            this.afterRemove.clear();
        }
    }

    public Map getNodeIdMap() {
        return this.addChild;
    }

    public void setNodeIdMap(Map map) {
        this.addChild = map;
    }

    public Hashtable getNodePathMap() {
        return this.afterPut;
    }

    public void setNodePathMap(Hashtable hashtable) {
        this.afterPut = hashtable;
    }

    public ClusterMap getNodeRecordMap() {
        return this.afterRemove;
    }

    public void setNodeRecordMap(ClusterMap clusterMap) {
        this.afterRemove = clusterMap;
    }

    private void addChild(NodeImpl nodeImpl, NodeImpl nodeImpl2) {
        if (nodeImpl2 == null) {
            nodeImpl2 = (NodeImpl)this.addChild.get(nodeImpl.getParentID());
        }
        if (nodeImpl2 == null) {
            if (!nodeImpl.isRoot()) {
                return;
            }
            nodeImpl2 = nodeImpl;
        }
        if (nodeImpl2.getParent() == null && nodeImpl != nodeImpl2) {
            this.addChild(nodeImpl2, (FolderImpl)this.addChild.get(nodeImpl2.getParentID()));
        }
        nodeImpl.setParent(nodeImpl2);
        if (nodeImpl2 != nodeImpl) {
            if (nodeImpl2.getNodeType() == 2) {
                ((ResourceImpl)nodeImpl2).setResult((ResourceImpl)nodeImpl);
            } else {
                ((FolderImpl)nodeImpl2).addChild(nodeImpl);
            }
        }
    }

    private String afterPut(String string) {
        String string2 = null;
        if (string.startsWith("/USERFOLDERPATH") || string.startsWith("/COMPONENT_LIB/USERFOLDERPATH")) {
            int n = string.indexOf("/USERFOLDERPATH");
            int n2 = string.indexOf("/", n + "/USERFOLDERPATH".length() + 1);
            if (n2 > -1) {
                String string3 = string.substring(n2);
                string2 = string.substring(0, n2) + string3.toUpperCase();
            } else {
                string2 = string;
            }
        } else {
            string2 = string.toUpperCase();
        }
        return string2;
    }

    private NodeImpl afterRemove(NodeRecord nodeRecord) {
        if (nodeRecord == null) {
            return null;
        }
        ServiceLogger.logDebug(6690061, new Object[]{nodeRecord}, 6);
        NodeImpl nodeImpl = (NodeImpl)this.addChild.get(nodeRecord.getID());
        if (nodeImpl != null && nodeImpl.getParent() != null) {
            int n = nodeImpl.getParentID();
            NodeImpl nodeImpl2 = (NodeImpl)this.addChild.get(n);
            if (nodeImpl2 instanceof FolderImpl) {
                FolderImpl folderImpl = (FolderImpl)nodeImpl2;
                folderImpl.removeChild(nodeImpl);
            } else if (nodeImpl2 instanceof ResourceImpl) {
                ((ResourceImpl)nodeImpl2).setResult(null);
            }
            this.addChild.remove(nodeImpl.getID());
            this.afterPut.remove(this.afterPut(nodeImpl.getAbsolutePath()));
        }
        return nodeImpl;
    }

    public VersionService getVersionService() {
        return this.SEDU;
    }

    public void setVersionService(VersionService versionService) {
        this.SEDU = versionService;
    }

    public void afterPut(String string, int n, Integer n2, NodeRecord nodeRecord, NodeRecord nodeRecord2, MapFlags mapFlags) {
        int n3;
        NodeImpl nodeImpl;
        NodeRecord nodeRecord3;
        if (NodeEventListener.isLocalEvent(n)) {
            return;
        }
        ServiceLogger.logDebug(6690062, new Object[]{nodeRecord, nodeRecord2}, 6);
        NodeImpl nodeImpl2 = this.afterRemove(nodeRecord2);
        NodeImpl nodeImpl3 = null;
        if (nodeRecord.getNodeType() == 2) {
            nodeRecord3 = (ResourceNodeRecord)nodeRecord;
            nodeImpl = new ResourceImpl((ResourceNodeRecord)nodeRecord3);
            ResourceInfo resourceInfo = this.SEDU.getLatestVersion(nodeRecord.getID(), ((ResourceNodeRecord)nodeRecord3).getResourceType());
            ((ResourceImpl)nodeImpl).setEntity(resourceInfo);
            nodeImpl3 = nodeImpl;
            this.addChild.put(nodeRecord.getID(), nodeImpl3);
        } else if (nodeRecord.getNodeType() == 1) {
            nodeRecord3 = (FolderRecord)nodeRecord;
            nodeImpl3 = nodeImpl = new FolderImpl((FolderRecord)nodeRecord3);
            this.addChild.put(nodeRecord.getID(), nodeImpl3);
            FolderImpl folderImpl = (FolderImpl)nodeImpl2;
            if (folderImpl != null) {
                Vector vector = folderImpl.getChildren();
                for (Object e : vector) {
                    NodeImpl nodeImpl4 = (NodeImpl)e;
                    ((FolderImpl)nodeImpl).addChild(nodeImpl4);
                    this.addChild(nodeImpl4, nodeImpl3);
                }
            }
        }
        if (nodeImpl3.getParent() == null && (nodeImpl = (NodeImpl)this.addChild.get(n3 = nodeImpl3.getParentID())) != null) {
            this.addChild(nodeImpl3, nodeImpl);
        }
        this.afterPut.put(this.afterPut(nodeImpl3.getAbsolutePath()), nodeImpl3);
        ServiceLogger.logDebug(6690063, new Object[]{nodeRecord, nodeRecord2}, 6);
    }

    public void afterRemove(String string, int n, Integer n2, NodeRecord nodeRecord, MapFlags mapFlags) {
        if (NodeEventListener.isLocalEvent(n)) {
            return;
        }
        this.afterRemove(nodeRecord);
    }
}

