/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.lc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.core.trans.ExecuteCallback;
import jet.server.db.core.trans.LockException;
import jet.server.db.lc.AliasMappingTable;
import jet.server.db.lc.KeyRecord;

public class AliasMappingKeyTable
extends TableImpl {
    public static final String TABLE_NAME = "ALIAS_MAPPING_KEY";
    private static final String[] EMPTY = new String[]{"ID", "MAPPING_KEY"};
    private static final int INTEGER = 0;
    private static final int SEDU = 1;
    private AliasMappingTable VARCHAR = null;

    public AliasMappingKeyTable(Database database) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), EMPTY[0], JDBCType.INTEGER, 0, 11, 0));
        super.append(new FieldImpl(this.getName(), EMPTY[1], JDBCType.VARCHAR, 256, 5, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
    }

    public void setAliasMappingTable(AliasMappingTable aliasMappingTable) {
        this.VARCHAR = aliasMappingTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllKeys() throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Recordset recordset = super.query(new Field[]{super.fields(1)}, null, ParameterMetaInfo.EMPTY, true);
        try {
            while (recordset.next()) {
                arrayList.add(recordset.getString(0));
            }
        }
        finally {
            recordset.close();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllRecords() throws SQLException {
        ArrayList<KeyRecord> arrayList = new ArrayList<KeyRecord>();
        Recordset recordset = super.query(new Field[]{super.fields(0), super.fields(1)}, null, ParameterMetaInfo.EMPTY, true);
        try {
            while (recordset.next()) {
                KeyRecord keyRecord = new KeyRecord(recordset.getInt(0), recordset.getString(1));
                arrayList.add(keyRecord);
            }
        }
        finally {
            recordset.close();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyRecord queryKey(String string) throws SQLException {
        KeyRecord keyRecord = null;
        StringBuilder stringBuilder = new StringBuilder("where ").append(EMPTY[1]).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(EMPTY[1], string, 12);
        Recordset recordset = super.query(new Field[]{super.fields(0), super.fields(1)}, stringBuilder.toString(), parameterMetaInfo, true);
        try {
            if (recordset.next()) {
                keyRecord = new KeyRecord(recordset.getInt(0), recordset.getString(1));
            }
        }
        finally {
            recordset.close();
        }
        return keyRecord;
    }

    public int saveAliasMapping(final String string, final List list) throws SQLException {
        final StringBuilder stringBuilder = new StringBuilder("delete from ").append(super.getName()).append(" WHERE ").append(EMPTY[1]).append("=?");
        final StringBuilder stringBuilder2 = new StringBuilder("select max(").append(EMPTY[0]).append(") from ").append(super.getName());
        final StringBuilder stringBuilder3 = new StringBuilder("insert into ").append(super.getName()).append("(").append(EMPTY[0]).append(",").append(EMPTY[1]).append(") values(").append("?,?").append(")");
        try {
            Integer n = (Integer)((DatabaseImpl)super.getDatabase()).getTransExecutor().executeInLock(TABLE_NAME, new ExecuteCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object execute(Connection connection) throws SQLException {
                    boolean bl = false;
                    PreparedStatement preparedStatement = null;
                    try {
                        preparedStatement = connection.prepareStatement(stringBuilder.toString());
                        preparedStatement.setString(1, string);
                        preparedStatement.execute();
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    int n = 0;
                    try {
                        preparedStatement = connection.prepareStatement(stringBuilder2.toString());
                        ResultSet resultSet = preparedStatement.executeQuery();
                        if (resultSet.next()) {
                            n = resultSet.getInt(1) + 1;
                        }
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    try {
                        preparedStatement = connection.prepareStatement(stringBuilder3.toString());
                        preparedStatement.setInt(1, n);
                        preparedStatement.setString(2, string);
                        bl = preparedStatement.execute();
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    AliasMappingKeyTable.this.VARCHAR.saveFields(connection, n, list);
                    return bl ? 0 : -1;
                }
            });
            return n;
        }
        catch (LockException lockException) {
            throw new SQLException("lock error: " + lockException.getMessage());
        }
    }

    public List queryAliasMapping(final String string) throws SQLException {
        final StringBuilder stringBuilder = new StringBuilder("select ").append(EMPTY[0]).append(" from ").append(super.getName()).append(" where Key=?");
        try {
            List list = (List)((DatabaseImpl)super.getDatabase()).getTransExecutor().executeInLock(TABLE_NAME, new ExecuteCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object execute(Connection connection) throws SQLException {
                    Object object;
                    boolean bl = false;
                    PreparedStatement preparedStatement = null;
                    int n = -1;
                    try {
                        preparedStatement = connection.prepareStatement(stringBuilder.toString());
                        preparedStatement.setString(1, string);
                        object = preparedStatement.executeQuery();
                        if (object.next()) {
                            n = object.getInt(1);
                        }
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    object = AliasMappingKeyTable.this.VARCHAR.queryFieldsByKey(connection, n);
                    return object;
                }
            });
            return list;
        }
        catch (LockException lockException) {
            throw new SQLException("lock error: " + lockException.getMessage());
        }
    }

    public Map queryAllAliasMapping() throws SQLException {
        final StringBuilder stringBuilder = new StringBuilder("select ").append(EMPTY[0]).append(", ").append(EMPTY[1]).append(" from ").append(super.getName());
        final HashMap hashMap = new HashMap();
        try {
            Integer n = (Integer)((DatabaseImpl)super.getDatabase()).getTransExecutor().executeInLock(TABLE_NAME, new ExecuteCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object execute(Connection connection) throws SQLException {
                    PreparedStatement preparedStatement = null;
                    ArrayList<KeyRecord> arrayList = new ArrayList<KeyRecord>();
                    try {
                        preparedStatement = connection.prepareStatement(stringBuilder.toString());
                        ResultSet resultSet = preparedStatement.executeQuery();
                        while (resultSet.next()) {
                            KeyRecord keyRecord = new KeyRecord(resultSet.getInt(1), resultSet.getString(2));
                            arrayList.add(keyRecord);
                        }
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    for (KeyRecord keyRecord : arrayList) {
                        List list = AliasMappingKeyTable.this.VARCHAR.queryFieldsByKey(connection, keyRecord.getID());
                        hashMap.put(keyRecord.getKey(), list);
                    }
                    return 0;
                }
            });
            return hashMap;
        }
        catch (LockException lockException) {
            throw new SQLException("lock error: " + lockException.getMessage());
        }
    }

    public void deleteAliasMapping(final String string) throws SQLException {
        final StringBuilder stringBuilder = new StringBuilder("select ").append(EMPTY[0]).append(" from ").append(super.getName()).append(" where ").append(EMPTY[1]).append("=?");
        final StringBuilder stringBuilder2 = new StringBuilder("delete from ").append(super.getName()).append(" WHERE ").append(EMPTY[1]).append("=?");
        try {
            ((DatabaseImpl)super.getDatabase()).getTransExecutor().executeInLock(TABLE_NAME, new ExecuteCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object execute(Connection connection) throws SQLException {
                    PreparedStatement preparedStatement = null;
                    int n = -1;
                    try {
                        preparedStatement = connection.prepareStatement(stringBuilder.toString());
                        preparedStatement.setString(1, string);
                        ResultSet resultSet = preparedStatement.executeQuery();
                        if (resultSet.next()) {
                            n = resultSet.getInt(1);
                        }
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    AliasMappingKeyTable.this.VARCHAR.deleteFieldsByKey(connection, n);
                    try {
                        preparedStatement = connection.prepareStatement(stringBuilder2.toString());
                        preparedStatement.setString(1, string);
                        preparedStatement.execute();
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    return null;
                }
            });
            return;
        }
        catch (LockException lockException) {
            throw new SQLException("lock error: " + lockException.getMessage());
        }
    }

    public void deleteAllAliasMapping() throws SQLException {
        final StringBuilder stringBuilder = new StringBuilder("select ").append(EMPTY[0]).append(", ").append(EMPTY[1]).append(" from ").append(super.getName());
        final StringBuilder stringBuilder2 = new StringBuilder("delete from ").append(super.getName());
        try {
            ((DatabaseImpl)super.getDatabase()).getTransExecutor().executeInLock(TABLE_NAME, new ExecuteCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object execute(Connection connection) throws SQLException {
                    PreparedStatement preparedStatement = null;
                    ArrayList<KeyRecord> arrayList = new ArrayList<KeyRecord>();
                    try {
                        preparedStatement = connection.prepareStatement(stringBuilder.toString());
                        ResultSet resultSet = preparedStatement.executeQuery();
                        while (resultSet.next()) {
                            KeyRecord keyRecord = new KeyRecord(resultSet.getInt(1), resultSet.getString(2));
                            arrayList.add(keyRecord);
                        }
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    for (KeyRecord keyRecord : arrayList) {
                        AliasMappingKeyTable.this.VARCHAR.deleteFieldsByKey(connection, keyRecord.getID());
                    }
                    try {
                        preparedStatement = connection.prepareStatement(stringBuilder2.toString());
                        preparedStatement.execute();
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    return null;
                }
            });
            return;
        }
        catch (LockException lockException) {
            throw new SQLException("lock error: " + lockException.getMessage());
        }
    }

    public int deleteKey(String string) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder("where ").append(EMPTY[1]).append("=?");
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(EMPTY[1], string, 12);
        return super.delete(stringBuilder.toString(), parameterMetaInfo);
    }

    public int deleteKey() throws SQLException {
        return super.delete(null, ParameterMetaInfo.EMPTY);
    }
}

