/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.nls;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import jet.server.api.db.Database;
import jet.server.api.nls.FontNLSEntry;
import jet.server.api.nls.FormatNLSEntry;
import jet.server.api.nls.NLSEntry;
import jet.server.api.nls.TextNLSEntry;
import jet.server.db.nls.GlobalNLSFontTable;
import jet.server.db.nls.GlobalNLSFormatTable;
import jet.server.db.nls.GlobalNLSTextTable;

public class GlobalNLSTable {
    private GlobalNLSTextTable SEDU;
    private GlobalNLSFormatTable add;
    private GlobalNLSFontTable addAll;

    public GlobalNLSTable(Database database) throws InstantiationException, SQLException {
        this.SEDU = new GlobalNLSTextTable(database);
        this.add = new GlobalNLSFormatTable(database);
        this.addAll = new GlobalNLSFontTable(database);
    }

    public void close() {
        this.SEDU.close();
        this.add.close();
        this.addAll.close();
        this.SEDU = null;
        this.add = null;
        this.addAll = null;
    }

    public List availableLocales() throws SQLException {
        Object object2;
        List list = this.SEDU.queryNLSLocales();
        List list2 = this.add.queryNLSLocales();
        for (Object object2 : list2) {
            if (list.contains(object2)) continue;
            list.add(object2);
        }
        List list3 = this.addAll.queryNLSLocales();
        object2 = list3.iterator();
        while (object2.hasNext()) {
            Locale locale = (Locale)object2.next();
            if (list.contains(locale)) continue;
            list.add(locale);
        }
        return list;
    }

    public List queryNLS(Locale locale) throws SQLException {
        List list = this.SEDU.queryNLS(locale);
        List list2 = this.add.queryNLS(locale);
        list.addAll(list2);
        List list3 = this.addAll.queryNLS(locale);
        list.addAll(list3);
        return list;
    }

    public boolean queryNLS(Locale locale, NLSEntry nLSEntry) throws SQLException {
        boolean bl = false;
        bl = nLSEntry instanceof TextNLSEntry ? this.SEDU.queryNLS(locale, (TextNLSEntry)nLSEntry) : (nLSEntry instanceof FormatNLSEntry ? this.add.queryNLS(locale, (FormatNLSEntry)nLSEntry) : this.addAll.queryNLS(locale, (FontNLSEntry)nLSEntry));
        return bl;
    }

    public int saveNLS(Locale locale, List list) throws SQLException {
        ArrayList<TextNLSEntry> arrayList = new ArrayList<TextNLSEntry>();
        ArrayList<FormatNLSEntry> arrayList2 = new ArrayList<FormatNLSEntry>();
        ArrayList<FontNLSEntry> arrayList3 = new ArrayList<FontNLSEntry>();
        for (NLSEntry nLSEntry : list) {
            if (nLSEntry instanceof TextNLSEntry) {
                arrayList.add((TextNLSEntry)nLSEntry);
                continue;
            }
            if (nLSEntry instanceof FormatNLSEntry) {
                arrayList2.add((FormatNLSEntry)nLSEntry);
                continue;
            }
            arrayList3.add((FontNLSEntry)nLSEntry);
        }
        int n = this.SEDU.saveNLS(locale, arrayList);
        n += this.add.saveNLS(locale, arrayList2);
        return n += this.addAll.saveNLS(locale, arrayList3);
    }

    public int saveTextNLS(Locale locale, List list) throws SQLException {
        int n = this.SEDU.saveNLS(locale, list);
        return n;
    }

    public int saveFormatNLS(Locale locale, List list) throws SQLException {
        int n = this.add.saveNLS(locale, list);
        return n;
    }

    public int saveFontNLS(Locale locale, List list) throws SQLException {
        int n = this.addAll.saveNLS(locale, list);
        return n;
    }

    public int deleteNLS(Locale locale) throws SQLException {
        int n = this.SEDU.deleteNLS(locale);
        n += this.add.deleteNLS(locale);
        return n += this.addAll.deleteNLS(locale);
    }
}

