/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.resource;

import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.event.RecordEventListener;
import jet.server.db.event.RecordEventListenerManager;
import jet.server.db.event.RecordEventType;
import jet.server.db.event.VersionNodeRecordEvent;
import jet.server.db.resource.NodeTableImpl;
import jet.server.db.resource.VersionNodeRecord;
import jet.server.db.resource.VersionNodeTable;
import jet.server.log.ServiceLogger;
import jet.util.IntKeyHashtable;

public class VersionNodeTableImpl
extends TableImpl
implements Table,
VersionNodeTable {
    public static final int version = 3;
    public static final int oldversion_1 = 1;
    public static final int oldversion_2 = 2;
    public static final String TABLE_NAME = "VERSIONNODES_3";
    private static final String[] B = new String[]{"id", "resourceID", "versionNumber", "expirationTime", "author", "authorEmail", "buildinDesc"};
    private NodeTableImpl BIGINT = null;

    public static VersionNodeTableImpl newInstance(Database database, NodeTableImpl nodeTableImpl, UpdateDetailsTable updateDetailsTable) {
        try {
            VersionNodeTableImpl versionNodeTableImpl = new VersionNodeTableImpl(database, nodeTableImpl, updateDetailsTable);
            RecordEventListenerManager.initListener(versionNodeTableImpl);
            return versionNodeTableImpl;
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, TABLE_NAME, 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private VersionNodeTableImpl(Database database, NodeTableImpl nodeTableImpl, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        this.BIGINT = nodeTableImpl;
        super.append(new FieldImpl(this.getName(), B[0], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), B[1], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), B[2], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), B[3], JDBCType.BIGINT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), B[4], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), B[5], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), B[6], JDBCType.VARCHAR, 256, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        super.upgradeOldTable(database, updateDetailsTable, "VERSIONNODES_1", 1);
        super.upgradeOldTable(database, updateDetailsTable, "VERSIONNODES_2", 2);
    }

    @Override
    public synchronized boolean deleteRecord(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            int n2 = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n2 > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    @Override
    public synchronized VersionNodeRecord addRecord(String string, String string2, String string3, Date date, int n, int n2, String string4, int n3, int n4, long l, String string5, String string6, String string7) {
        VersionNodeRecord versionNodeRecord = null;
        try {
            versionNodeRecord = new VersionNodeRecord(this.BIGINT.nextRecordID(), string, string2, string3, date, n, n2, string4, n3, n4, l, string5, string6, string7);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
        boolean bl = this.BIGINT.addRecord(versionNodeRecord);
        if (bl) {
            FieldValue[] fieldValueArray = super.fields().values();
            fieldValueArray[0].setValue(new Integer(versionNodeRecord.getID()));
            fieldValueArray[1].setValue(new Integer(n3));
            fieldValueArray[2].setValue(new Integer(n4));
            fieldValueArray[3].setValue(new Long(l));
            fieldValueArray[4].setValue(string5);
            fieldValueArray[5].setValue(string6);
            fieldValueArray[6].setValue(string7);
            try {
                super.insert(fieldValueArray);
                this.fireEvent(RecordEventType.inserted, versionNodeRecord);
                return versionNodeRecord;
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
            }
        }
        return null;
    }

    @Override
    public synchronized boolean deleteAll() {
        try {
            int n = super.delete(null, ParameterMetaInfo.EMPTY);
            return n > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized VersionNodeRecord getVersionByID(int n) throws SQLException {
        Recordset recordset = null;
        VersionNodeRecord versionNodeRecord = null;
        Table[] tableArray = new Table[]{this, this.BIGINT};
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getFullyQualifiedName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(this.B()).append(" AND ").append(super.fields(0).getFullyQualifiedName()).append("=?");
        try {
            recordset = this.adapter.select(this.BIGINT(), tableArray, stringBuffer.toString(), parameterMetaInfo, true);
            if (recordset.next()) {
                versionNodeRecord = this.EMPTY(recordset);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return versionNodeRecord;
    }

    private String B() {
        return this.BIGINT.fields(0).getFullyQualifiedName() + "=" + super.fields(0).getFullyQualifiedName();
    }

    private Field[] BIGINT() {
        Field[] fieldArray = new Field[]{this.BIGINT.fields(0), this.BIGINT.fields(1), this.BIGINT.fields(2), this.BIGINT.fields(3), this.BIGINT.fields(4), this.BIGINT.fields(5), this.BIGINT.fields(6), this.BIGINT.fields(7), super.fields(1), super.fields(2), super.fields(3), super.fields(4), super.fields(5), super.fields(6), this.BIGINT.fields(12)};
        return fieldArray;
    }

    private synchronized VersionNodeRecord EMPTY(Recordset recordset) throws SQLException {
        VersionNodeRecord versionNodeRecord = new VersionNodeRecord();
        versionNodeRecord.recordID = recordset.getInt(0);
        versionNodeRecord.name = recordset.getString(1);
        versionNodeRecord.creatorName = recordset.getString(2);
        versionNodeRecord.createTime = new Date(recordset.getLong(3));
        versionNodeRecord.parentID = recordset.getInt(4);
        versionNodeRecord.nodeType = recordset.getByte(5);
        versionNodeRecord.aclID = recordset.getInt(6);
        versionNodeRecord.description = recordset.getString(7);
        versionNodeRecord.resourceID = recordset.getInt(8);
        versionNodeRecord.versionNumber = recordset.getInt(9);
        versionNodeRecord.expirationTime = recordset.getLong(10);
        versionNodeRecord.author = recordset.getString(11);
        versionNodeRecord.authorEmail = recordset.getString(12);
        versionNodeRecord.buildinDescription = recordset.getString(13);
        versionNodeRecord.organization = recordset.getString(14);
        return versionNodeRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized IntKeyHashtable getAllVersions() throws SQLException {
        Table[] tableArray = new Table[]{this, this.BIGINT};
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(this.B()).append(" ORDER BY ").append(super.fields(1).getFullyQualifiedName());
        Recordset recordset = null;
        IntKeyHashtable intKeyHashtable = new IntKeyHashtable();
        Vector<VersionNodeRecord> vector = null;
        VersionNodeRecord versionNodeRecord = null;
        int n = -1;
        try {
            recordset = this.adapter.select(this.BIGINT(), tableArray, stringBuffer.toString(), ParameterMetaInfo.EMPTY, true);
            while (recordset.next()) {
                versionNodeRecord = this.EMPTY(recordset);
                if (n != versionNodeRecord.getResourceID()) {
                    if (n != -1) {
                        intKeyHashtable.put(n, (Object)vector);
                    }
                    n = versionNodeRecord.getResourceID();
                    vector = new Vector<VersionNodeRecord>();
                }
                vector.addElement(versionNodeRecord);
            }
            if (vector != null) {
                intKeyHashtable.put(n, vector);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return intKeyHashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getExpiredVersions() throws SQLException {
        Table[] tableArray = new Table[2];
        Recordset recordset = null;
        Vector<VersionNodeRecord> vector = new Vector<VersionNodeRecord>();
        tableArray[0] = this;
        tableArray[1] = this.BIGINT;
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(3).getName(), String.valueOf(System.currentTimeMillis()), -5);
        stringBuffer.append("WHERE ").append(this.B()).append(" AND ").append(super.fields(3).getName()).append("<?");
        try {
            recordset = this.adapter.select(this.BIGINT(), tableArray, stringBuffer.toString(), parameterMetaInfo, true);
            if (recordset != null) {
                while (recordset.next()) {
                    vector.addElement(this.EMPTY(recordset));
                }
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    @Override
    public synchronized boolean deleteExpiredVersions() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(3).getName(), String.valueOf(System.currentTimeMillis()), -5);
        stringBuffer.append("WHERE ").append(super.fields(3).getName()).append("<?");
        try {
            int n = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    @Override
    public synchronized boolean deleteRecordsByResource(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(1).getName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(super.fields(1).getName()).append("=?");
        try {
            int n2 = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n2 > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getRecordsByResource(int n) throws SQLException {
        Table[] tableArray = new Table[]{this, this.BIGINT};
        StringBuffer stringBuffer = new StringBuffer();
        Recordset recordset = null;
        Vector<VersionNodeRecord> vector = new Vector<VersionNodeRecord>();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(1).getFullyQualifiedName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(this.B()).append(" AND ").append(super.fields(1).getFullyQualifiedName()).append("=?");
        try {
            recordset = this.adapter.select(this.BIGINT(), tableArray, stringBuffer.toString(), parameterMetaInfo, true);
            while (recordset.next()) {
                vector.addElement(this.EMPTY(recordset));
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized VersionNodeRecord getRecord(int n, int n2) throws SQLException {
        Table[] tableArray = new Table[]{this, this.BIGINT};
        StringBuffer stringBuffer = new StringBuffer();
        Recordset recordset = null;
        VersionNodeRecord versionNodeRecord = null;
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(1).getFullyQualifiedName(), String.valueOf(n), 4);
        parameterMetaInfo.add(super.fields(2).getFullyQualifiedName(), String.valueOf(n2), 4);
        stringBuffer.append("WHERE ").append(this.B()).append(" AND ").append(super.fields(1).getFullyQualifiedName()).append("=? AND ").append(super.fields(2).getFullyQualifiedName()).append("=?");
        try {
            recordset = this.adapter.select(this.BIGINT(), tableArray, stringBuffer.toString(), parameterMetaInfo, true);
            if (recordset.next()) {
                versionNodeRecord = this.EMPTY(recordset);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return versionNodeRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized VersionNodeRecord getEarliestVersion(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(1).getFullyQualifiedName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(super.fields(1).getFullyQualifiedName()).append("=?");
        int n2 = -1;
        try {
            n2 = super.queryMinValue(B[2], stringBuffer.toString(), parameterMetaInfo, true).intValue();
            Table[] tableArray = new Table[]{this, this.BIGINT};
            stringBuffer.delete(0, stringBuffer.length());
            parameterMetaInfo.clear();
            parameterMetaInfo.add(super.fields(1).getFullyQualifiedName(), String.valueOf(n), 4);
            parameterMetaInfo.add(super.fields(2).getFullyQualifiedName(), String.valueOf(n2), 4);
            stringBuffer.append("WHERE ").append(this.B()).append(" AND ").append(super.fields(1).getFullyQualifiedName()).append("=?").append(" AND ").append(super.fields(2).getFullyQualifiedName()).append("=?");
            Recordset recordset = null;
            VersionNodeRecord versionNodeRecord = null;
            try {
                recordset = this.adapter.select(this.BIGINT(), tableArray, stringBuffer.toString(), parameterMetaInfo, true);
                if (recordset.next()) {
                    versionNodeRecord = this.EMPTY(recordset);
                }
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
            }
            finally {
                try {
                    if (recordset != null) {
                        recordset.close();
                    }
                    recordset = null;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
            }
            return versionNodeRecord;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
    }

    @Override
    public synchronized int getVersionNodeAmount(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(1).getFullyQualifiedName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(super.fields(1).getFullyQualifiedName()).append("=?");
        try {
            return super.queryCountValue(B[2], stringBuffer.toString(), parameterMetaInfo, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return -1;
        }
    }

    @Override
    public synchronized int getLatestVersionID(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(1).getFullyQualifiedName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(super.fields(1).getFullyQualifiedName()).append("=?");
        try {
            return super.queryMaxValue(B[0], stringBuffer.toString(), parameterMetaInfo, true).intValue();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return -1;
        }
    }

    @Override
    public synchronized boolean updateExpirationTime(int n, long l) {
        FieldValue[] fieldValueArray = new FieldValue[]{super.fields(3).createFieldValue()};
        fieldValueArray[0].setValue(new Long(l));
        StringBuffer stringBuffer = new StringBuffer();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(super.fields(0).getName()).append("=?");
        try {
            super.update(fieldValueArray, stringBuffer.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized VersionNodeRecord getRecord(int n) throws SQLException {
        Table[] tableArray = new Table[]{this, this.BIGINT};
        StringBuffer stringBuffer = new StringBuffer();
        Recordset recordset = null;
        VersionNodeRecord versionNodeRecord = null;
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getFullyQualifiedName(), String.valueOf(n), 4);
        stringBuffer.append("WHERE ").append(this.B()).append(" AND ").append(super.fields(0).getFullyQualifiedName()).append("=?");
        try {
            recordset = this.adapter.select(this.BIGINT(), tableArray, stringBuffer.toString(), parameterMetaInfo, true);
            if (recordset.next()) {
                versionNodeRecord = this.EMPTY(recordset);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return versionNodeRecord;
    }

    protected void fireEvent(RecordEventType recordEventType, VersionNodeRecord versionNodeRecord) {
        if (this.listeners == null) {
            return;
        }
        VersionNodeRecordEvent versionNodeRecordEvent = new VersionNodeRecordEvent(recordEventType, versionNodeRecord);
        for (RecordEventListener recordEventListener : this.listeners) {
            recordEventListener.onChanged(versionNodeRecordEvent);
        }
    }
}

