/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.security2;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.security2.GroupProfileRecord;
import jet.server.db.security2.GroupProfileTable;
import jet.server.log.ServiceLogger;

public class GroupProfileTableImpl
extends TableImpl
implements Table,
GroupProfileTable {
    public static final int VERSION = 2;
    public static final String TABLENAME = "GROUPPROFILES_2";
    public static final int OLDVERSION = 1;
    static final String[] COLNAMES = new String[2];

    public static GroupProfileTableImpl newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        try {
            return new GroupProfileTableImpl(database, updateDetailsTable);
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, TABLENAME, 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private GroupProfileTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws SQLException, InstantiationException {
        super(database, TABLENAME);
        super.append(new FieldImpl(this.getName(), COLNAMES[0], JDBCType.VARCHAR, 65, 0, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[1], JDBCType.VARCHAR, 65, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        super.upgradeOldTable(database, updateDetailsTable, "GROUPPROFILES_1", 1);
    }

    @Override
    public synchronized GroupProfileRecord addRecord(String string, String string2) {
        GroupProfileRecord groupProfileRecord = new GroupProfileRecord(string, string2);
        FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[0].setValue(groupProfileRecord.getGroupName());
        fieldValueArray[1].setValue(groupProfileRecord.getSubGroupName());
        try {
            super.insert(fieldValueArray);
            return groupProfileRecord;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
    }

    @Override
    public synchronized boolean deleteRecordBySubGroupName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[1]).getName(), String.valueOf(string), 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[1]).getName()).append("=?");
            n = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    @Override
    public synchronized boolean deleteRecordByGroupName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), String.valueOf(string), 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
            n = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    @Override
    public synchronized boolean deleteRecord(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), String.valueOf(string), 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
            parameterMetaInfo.add(super.fields(COLNAMES[1]).getName(), String.valueOf(string2), 12);
            stringBuffer.append(" AND ").append(super.fields(COLNAMES[1]).getName()).append("=?");
            n = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getParentGroupsName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Field[] fieldArray = new Field[]{this.fields(COLNAMES[0])};
        Vector<String> vector = null;
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[1]).getName(), string, 12);
            stringBuffer.append("WHERE ").append(super.fields(COLNAMES[1]).getName()).append("=?");
            recordset = super.query(fieldArray, stringBuffer.toString(), parameterMetaInfo, false);
            vector = new Vector<String>();
            while (recordset.next()) {
                vector.add(recordset.getString(COLNAMES[0]));
            }
            Vector<String> vector2 = vector;
            return vector2;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    private synchronized GroupProfileRecord COLNAMES(Recordset recordset) throws SQLException {
        GroupProfileRecord groupProfileRecord = new GroupProfileRecord();
        groupProfileRecord.setGroupName(recordset.getString(COLNAMES[0]));
        groupProfileRecord.setSubGroupName(recordset.getString(COLNAMES[1]));
        return groupProfileRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getSubGroups(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Field[] fieldArray = new Field[]{this.fields(COLNAMES[1])};
        Vector<String> vector = null;
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), string, 12);
            stringBuffer.append("WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
            recordset = super.query(fieldArray, stringBuffer.toString(), parameterMetaInfo, false);
            vector = new Vector<String>();
            while (recordset.next()) {
                vector.add(recordset.getString(COLNAMES[1]));
            }
            Vector<String> vector2 = vector;
            return vector2;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    @Override
    public synchronized int getParentGroupsCount(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[1]).getName(), String.valueOf(string), 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[1]).getName()).append("=?");
            n = super.queryCountValue(COLNAMES[0], stringBuffer.toString(), parameterMetaInfo, false);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return n;
    }

    @Override
    public synchronized int getSubGroupsCount(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), String.valueOf(string), 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
            n = super.queryCountValue(COLNAMES[1], stringBuffer.toString(), parameterMetaInfo, false);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized GroupProfileRecord getRecord(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        GroupProfileRecord groupProfileRecord = null;
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), string, 12);
            parameterMetaInfo.add(super.fields(COLNAMES[1]).getName(), string2, 12);
            stringBuffer.append("WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=? AND ").append(super.fields(COLNAMES[1]).getName()).append("=?");
            recordset = super.query(this.fields().toArray(), stringBuffer.toString(), parameterMetaInfo, true);
            while (recordset.next()) {
                groupProfileRecord = this.COLNAMES(recordset);
            }
        }
        catch (SQLException sQLException) {
            groupProfileRecord = null;
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return groupProfileRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Hashtable[] getAllRecords() {
        Hashtable[] hashtableArray = new Hashtable[]{new Hashtable(), new Hashtable()};
        Recordset recordset = null;
        try {
            recordset = super.query(this.fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
            while (recordset.next()) {
                Vector<String> vector;
                String string = recordset.getString(COLNAMES[0]);
                String string2 = recordset.getString(COLNAMES[1]);
                Vector vector2 = (Vector)hashtableArray[0].get(string);
                Vector vector3 = (Vector)hashtableArray[1].get(string2);
                if (vector2 != null) {
                    vector2.add(string2);
                } else {
                    vector = new Vector<String>();
                    vector.add(string2);
                    hashtableArray[0].put(string, vector);
                }
                if (vector3 != null) {
                    vector3.add(string);
                    continue;
                }
                vector = new Vector();
                vector.add(string);
                hashtableArray[1].put(string2, vector);
            }
        }
        catch (SQLException sQLException) {
            hashtableArray = null;
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return hashtableArray;
    }

    @Override
    public boolean deleteRecordByOrganization(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), string + "\\" + "%", 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[0]).getName()).append(" LIKE ?");
            parameterMetaInfo.add(super.fields(COLNAMES[1]).getName(), string + "\\" + "%", 12);
            stringBuffer.append(" OR ").append(super.fields(COLNAMES[1]).getName()).append(" LIKE ?");
            n = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    static {
        GroupProfileTableImpl.COLNAMES[0] = "group_name";
        GroupProfileTableImpl.COLNAMES[1] = "sub_group_name";
    }
}

