/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.security2;

import java.sql.SQLException;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.security2.RoleRecord;
import jet.server.db.security2.RoleTable;
import jet.server.log.ServiceLogger;

public class RoleTableImpl
extends TableImpl
implements Table,
RoleTable {
    public static final int VERSION = 4;
    public static final int OLDVERSION = 1;
    public static final int OLDVERSION2 = 2;
    public static final int OLDVERSION3 = 3;
    private static final String BIT = "ROLES_4";
    static final String[] COLNAMES = new String[4];

    public static RoleTableImpl newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        try {
            return new RoleTableImpl(database, updateDetailsTable);
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, BIT, 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private RoleTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, BIT);
        super.append(new FieldImpl(this.getName(), COLNAMES[0], JDBCType.VARCHAR, 65, 9, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[1], JDBCType.BIT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[2], JDBCType.VARCHAR, 256, 16, 0));
        super.append(new FieldImpl(this.getName(), COLNAMES[3], JDBCType.INTEGER, 0, 1, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        super.upgradeOldTable(database, updateDetailsTable, "ROLES_1", 1);
        super.upgradeOldTable(database, updateDetailsTable, "ROLES_2", 2);
        super.upgradeOldTable(database, updateDetailsTable, "ROLES_3", 3);
    }

    @Override
    public synchronized RoleRecord addRecord(String string, boolean bl, String string2, int n) {
        RoleRecord roleRecord = new RoleRecord(string, bl, string2, n);
        FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[0].setValue(roleRecord.getName());
        fieldValueArray[1].setValue(new Boolean(roleRecord.isBuiltin()));
        fieldValueArray[2].setValue(roleRecord.getDescription());
        fieldValueArray[3].setValue(new Integer(n));
        try {
            super.insert(fieldValueArray);
            return roleRecord;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
    }

    @Override
    public synchronized boolean deleteRole(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), String.valueOf(string), 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
            n = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized RoleRecord getRole(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        RoleRecord roleRecord = null;
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), string, 12);
            stringBuffer.append("WHERE ").append(super.fields(COLNAMES[0]).getName()).append("=?");
            recordset = super.query(this.fields().toArray(), stringBuffer.substring(0), parameterMetaInfo, true);
            while (recordset.next()) {
                roleRecord = this.BIT(recordset);
                if (roleRecord.getName().equals(string)) {
                    break;
                }
                roleRecord = null;
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return roleRecord;
    }

    private synchronized RoleRecord BIT(Recordset recordset) throws SQLException {
        RoleRecord roleRecord = new RoleRecord();
        roleRecord.setName(recordset.getString(COLNAMES[0]));
        roleRecord.setBuiltin(recordset.getBoolean(COLNAMES[1]));
        roleRecord.setDescription(recordset.getString(COLNAMES[2]));
        roleRecord.setType(recordset.getInt(COLNAMES[3]));
        return roleRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getAllRoles() {
        Vector<RoleRecord> vector = new Vector<RoleRecord>();
        Recordset recordset = null;
        try {
            recordset = super.query(this.fields().toArray(), null, ParameterMetaInfo.EMPTY, true);
            while (recordset.next()) {
                RoleRecord roleRecord = this.BIT(recordset);
                if (roleRecord == null) continue;
                vector.add(roleRecord);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getAllRolesName() {
        Vector<Object> vector = new Vector<Object>();
        FieldValue[] fieldValueArray = new FieldValue[]{this.fields(COLNAMES[0]).createFieldValue()};
        Recordset recordset = null;
        try {
            Object object;
            recordset = super.query(this.fields().toArray(), null, ParameterMetaInfo.EMPTY, true);
            if (recordset.next() && (object = recordset.getString(COLNAMES[0])) != null) {
                vector.add(object);
            }
            object = vector;
            return object;
        }
        catch (SQLException sQLException) {
            vector = null;
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    private void COLNAMES(Table table) throws SQLException {
        Recordset recordset = table.query(table.fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
        while (recordset.next()) {
            FieldValue[] fieldValueArray = super.fields().values();
            fieldValueArray[0].setValue(recordset.fields("name").getValue());
            fieldValueArray[1].setValue(recordset.fields("builtin").getValue());
            fieldValueArray[2].setValue(recordset.fields("description").getValue());
            fieldValueArray[3].setValue(new Integer(0));
            super.insert(fieldValueArray);
        }
        recordset.close();
    }

    @Override
    protected void mergeOldTable(Table table, int n) throws SQLException {
        if (n == 1) {
            this.COLNAMES(table);
        } else {
            super.mergeOldTable(table, n);
        }
    }

    @Override
    public boolean deleteRecordByOrganization(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(COLNAMES[0]).getName(), string + "\\" + "%", 12);
            stringBuffer.append(" WHERE ").append(super.fields(COLNAMES[0]).getName()).append(" LIKE ?");
            n = super.delete(stringBuffer.toString(), parameterMetaInfo);
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    static {
        RoleTableImpl.COLNAMES[0] = "name";
        RoleTableImpl.COLNAMES[1] = "buildin";
        RoleTableImpl.COLNAMES[2] = "description";
        RoleTableImpl.COLNAMES[3] = "role_type";
    }
}

