/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.storage;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.storage.StorageRecord;
import jet.server.log.ServiceLogger;
import jet.server.storage.util.CompressBitSet;

public class StorageMemberTable
extends TableImpl {
    public static final int VERSION = 1;
    public static final String TABLE_NAME = "STORAGE_MEMBER_1";
    private static final String[] BIGINT = new String[]{"fileID", "unitIndex", "bits"};
    public static final int ID_COL = 0;
    public static final int UNIT_INDEX_COL = 1;
    public static final int BITS_COL = 2;

    public StorageMemberTable(Database database) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), BIGINT[0], JDBCType.INTEGER, 0, 5, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[1], JDBCType.INTEGER, 0, 5, 0));
        super.append(new FieldImpl(this.getName(), BIGINT[2], JDBCType.BIGINT, 0, 1, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
    }

    public synchronized boolean addMember(StorageRecord storageRecord, boolean bl, Integer ... integerArray) {
        int n;
        CompressBitSet compressBitSet = new CompressBitSet();
        Object object = integerArray;
        int n2 = ((Integer[])object).length;
        for (int i = 0; i < n2; ++i) {
            n = object[i];
            compressBitSet.set(n, true);
        }
        object = new CompressBitSet();
        if (bl) {
            this.deleteFile(storageRecord);
        } else {
            List list = this.getMember(storageRecord.getID());
            if (list.size() == 0) {
                return false;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                ((CompressBitSet)object).set(n, true);
            }
        }
        for (int n3 : compressBitSet.noneZeroUnits()) {
            long l = compressBitSet.getUnit(n3) | ((CompressBitSet)object).getUnit(n3);
            if (l == ((CompressBitSet)object).getUnit(n3)) continue;
            if (((CompressBitSet)object).getUnit(n3) == 0L) {
                this.EMPTY(storageRecord.getID(), n3, l);
            } else {
                this.BIGINT(storageRecord.getID(), n3, l);
            }
            compressBitSet.setUnit(n3, l);
        }
        storageRecord.getMembers().addAll(compressBitSet.noneZeroBits());
        return true;
    }

    public synchronized boolean deleteFile(StorageRecord ... storageRecordArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("WHERE ").append(this.fields(0).getName());
        if (storageRecordArray.length == 1) {
            stringBuilder.append("=?");
        } else {
            stringBuilder.append(" IN(");
            for (int i = 0; i < storageRecordArray.length; ++i) {
                stringBuilder.append("?");
                if (i >= storageRecordArray.length - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append(")");
        }
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        for (StorageRecord storageRecord : storageRecordArray) {
            parameterMetaInfo.add(this.fields(0).getName(), storageRecord.getID(), 4);
        }
        try {
            return super.delete(stringBuilder.toString(), parameterMetaInfo) > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMember(int n) {
        ArrayList arrayList = new ArrayList();
        Recordset recordset = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("WHERE ").append(this.fields(0).getName()).append("=?");
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(this.fields(0).getName(), n, 4);
            recordset = super.query(this.fields().toArray(), stringBuffer.toString(), parameterMetaInfo, true);
            CompressBitSet compressBitSet = new CompressBitSet();
            while (recordset.next()) {
                int n2 = recordset.getInt(1);
                long l = recordset.getLong(2);
                compressBitSet.setUnit(n2, l);
            }
            arrayList.addAll(compressBitSet.noneZeroBits());
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAll() {
        HashMap<Integer, List> hashMap = new HashMap<Integer, List>();
        Recordset recordset = null;
        try {
            recordset = super.query(this.fields().toArray(), null, ParameterMetaInfo.EMPTY, true);
            CompressBitSet compressBitSet = new CompressBitSet();
            while (recordset.next()) {
                compressBitSet.clear();
                int n = recordset.getInt(0);
                compressBitSet.setUnit(recordset.getInt(1), recordset.getLong(2));
                if (hashMap.containsKey(n)) {
                    ((List)hashMap.get(n)).addAll(compressBitSet.noneZeroBits());
                    continue;
                }
                hashMap.put(n, compressBitSet.noneZeroBits());
            }
        }
        catch (SQLException sQLException) {
            hashMap = null;
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        return hashMap;
    }

    private boolean BIGINT(int n, int n2, long l) {
        boolean bl = false;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("WHERE ").append(this.fields(0).getName()).append("=?").append(" AND ").append(this.fields(1).getName()).append("=?");
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(this.fields(0).getName(), n, 4);
            parameterMetaInfo.add(this.fields(1).getName(), n2, 4);
            FieldValue fieldValue = this.fields(2).createFieldValue();
            fieldValue.setValue(l);
            bl = super.update(new FieldValue[]{fieldValue}, stringBuffer.toString(), parameterMetaInfo) > 0;
        }
        catch (SQLException sQLException) {
            bl = false;
            ServiceLogger.logError(sQLException);
        }
        return bl;
    }

    private boolean EMPTY(int n, int n2, long l) {
        boolean bl = false;
        try {
            FieldValue[] fieldValueArray = this.fields().values();
            fieldValueArray[0].setValue(n);
            fieldValueArray[1].setValue(n2);
            fieldValueArray[2].setValue(l);
            bl = super.insert(fieldValueArray) > 0;
        }
        catch (SQLException sQLException) {
            bl = false;
            ServiceLogger.logError(sQLException);
        }
        return bl;
    }
}

