/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.version;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.trans.ExecuteCallback;
import jet.server.db.core.trans.LockException;
import jet.server.db.event.RecordEventListenerManager;
import jet.server.db.event.RecordEventType;
import jet.server.db.version.AbstractVersionTableImpl;
import jet.server.db.version.ReportVersionRecord;
import jet.server.intf.version.ReportVersionTable;
import jet.server.log.ServiceLogger;

public class ReportVersionTableImpl
extends AbstractVersionTableImpl
implements ReportVersionTable {
    public static final String TABLE_NAME = "REPORTVERSION_4";
    private static String BIGINT = "REPORTVERSION_3";
    private static String EMPTY = "REPORTVERSION_2";
    private static String INTEGER = "REPORTVERSION_1";
    private static final String[] SEDU = new String[]{"versionNumber", "versionName", "resourceID", "creator", "createTime", "modifier", "modifiedTime", "reportFile", "id", "diskSize"};

    public static ReportVersionTableImpl newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        try {
            ReportVersionTableImpl reportVersionTableImpl = new ReportVersionTableImpl(database, updateDetailsTable);
            RecordEventListenerManager.initListener(reportVersionTableImpl);
            return reportVersionTableImpl;
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, TABLE_NAME, 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private ReportVersionTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), SEDU[0], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), SEDU[1], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), SEDU[2], JDBCType.INTEGER, 0, 5, 0));
        super.append(new FieldImpl(this.getName(), SEDU[3], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), SEDU[4], JDBCType.BIGINT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), SEDU[5], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), SEDU[6], JDBCType.BIGINT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), SEDU[7], JDBCType.VARCHAR, 512, 1, 0));
        super.append(new FieldImpl(this.getName(), SEDU[8], JDBCType.BIGINT, 0, 7, 0));
        super.append(new FieldImpl(this.getName(), SEDU[9], JDBCType.BIGINT, 0, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        super.upgradeOldTable(database, updateDetailsTable, INTEGER, 1);
        super.upgradeOldTable(database, updateDetailsTable, EMPTY, 2);
        super.upgradeOldTable(database, updateDetailsTable, BIGINT, 3);
        try {
            this.adapter.setID(this, this.fields(SEDU[8]), this.SEDU() + 1);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
    }

    @Override
    protected void mergeOldTable(Table table, int n) throws SQLException {
        this.EMPTY(table);
    }

    @Override
    public synchronized int addRecord(String string, final int n, String string2, long l, String string3, long l2, String string4, long l3) {
        final FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[1].setValue(string);
        fieldValueArray[2].setValue(new Integer(n));
        fieldValueArray[3].setValue(string2);
        fieldValueArray[4].setValue(new Long(l));
        fieldValueArray[5].setValue(string3);
        fieldValueArray[6].setValue(new Long(l2));
        String string5 = this.ruleExternalDataPath(string4, this.getHistDir());
        fieldValueArray[7].setValue(string5);
        fieldValueArray[8].setValue(new Integer(this.VARCHAR()));
        fieldValueArray[9].setValue(new Long(l3));
        try {
            int n2 = (Integer)((DatabaseImpl)super.getDatabase()).getTransExecutor().executeInLock(TABLE_NAME, new ExecuteCallback(){

                @Override
                public Object execute(Connection connection) throws SQLException {
                    int n2 = ReportVersionTableImpl.this.INTEGER(n);
                    fieldValueArray[0].setValue(n2);
                    ReportVersionTableImpl.this.insert(fieldValueArray);
                    return n2;
                }
            });
            ReportVersionRecord reportVersionRecord = new ReportVersionRecord();
            reportVersionRecord.setVersionID(n2);
            this.fireEvent(RecordEventType.inserted, reportVersionRecord, string5);
            return n2;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return -1;
        }
        catch (LockException lockException) {
            ServiceLogger.logError(lockException);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object getRecord(int n, int n2) {
        ReportVersionRecord reportVersionRecord = new ReportVersionRecord();
        Recordset recordset = null;
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        try {
            parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
            parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(n2), 4);
            String string = "WHERE " + super.fields(0).getName() + "=? AND " + super.fields(2).getName() + "=?";
            recordset = super.query(this.fields().toArray(), string, parameterMetaInfo, true);
            if (recordset.next()) {
                reportVersionRecord = this.BIGINT(recordset);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return reportVersionRecord;
    }

    @Override
    public synchronized boolean delRecord(int n, int n2) {
        ReportVersionRecord reportVersionRecord = (ReportVersionRecord)this.getRecord(n, n2);
        try {
            int n3 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(0).getName()).append("=?");
            parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(n2), 4);
            stringBuffer.append(" AND ").append(super.fields(2).getName()).append("=?");
            n3 = super.delete(stringBuffer.toString(), parameterMetaInfo);
            this.fireEvent(RecordEventType.deleted, reportVersionRecord, reportVersionRecord.getReportFile());
            return n3 > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    @Override
    public synchronized boolean delRecords(int n) {
        Vector vector = this.getAllRecords(n);
        try {
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(2).getName()).append("=?");
            n2 = super.delete(stringBuffer.toString(), parameterMetaInfo);
            for (ReportVersionRecord reportVersionRecord : vector) {
                this.fireEvent(RecordEventType.deleted, reportVersionRecord, reportVersionRecord.getReportFile());
            }
            return n2 > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    private ReportVersionRecord BIGINT(Recordset recordset) throws SQLException {
        ReportVersionRecord reportVersionRecord = new ReportVersionRecord();
        reportVersionRecord.setVersionID(recordset.getInt(SEDU[0]));
        reportVersionRecord.setVersionName(recordset.getString(SEDU[1]));
        reportVersionRecord.setResourceID(recordset.getInt(SEDU[2]));
        reportVersionRecord.setCreator(recordset.getString(SEDU[3]));
        reportVersionRecord.setCreatedTime(recordset.getLong(SEDU[4]));
        reportVersionRecord.setModifier(recordset.getString(SEDU[5]));
        reportVersionRecord.setModifiedTime(recordset.getLong(SEDU[6]));
        reportVersionRecord.setReportFile(recordset.getString(SEDU[7]));
        reportVersionRecord.setDiskSize(recordset.getLong(SEDU[9]));
        return reportVersionRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getAllRecords(int n) {
        Vector<ReportVersionRecord> vector = new Vector<ReportVersionRecord>();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        Recordset recordset = null;
        try {
            parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(n), 4);
            String string = "WHERE " + super.fields(2).getName() + "=?";
            recordset = super.query(this.fields().toArray(), string, parameterMetaInfo, true);
            while (recordset.next()) {
                vector.addElement(this.BIGINT(recordset));
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getAllRecords() {
        Vector<ReportVersionRecord> vector = new Vector<ReportVersionRecord>();
        Recordset recordset = null;
        try {
            recordset = super.query(this.fields().toArray(), null, null, true);
            while (recordset.next()) {
                vector.addElement(this.BIGINT(recordset));
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getAllRecordsByPath(String string) {
        Vector<ReportVersionRecord> vector = new Vector<ReportVersionRecord>();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        Recordset recordset = null;
        try {
            parameterMetaInfo.add(super.fields(7).getName(), string + "%", 12);
            String string2 = "WHERE " + super.fields(7).getName() + " LIKE ?";
            recordset = super.query(this.fields().toArray(), string2, parameterMetaInfo, true);
            while (recordset.next()) {
                vector.addElement(this.BIGINT(recordset));
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    private void EMPTY(Table table) throws SQLException {
        Recordset recordset = table.query(table.fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
        while (recordset.next()) {
            String string = recordset.fields(SEDU[7]).getString();
            recordset.fields(SEDU[7]).setValue(this.ruleExternalDataPath(string, this.getHistDir()));
            super.insert(recordset.fields());
        }
        recordset.close();
    }

    @Override
    public synchronized boolean updateRecord(Object object) {
        ReportVersionRecord reportVersionRecord = (ReportVersionRecord)object;
        FieldValue[] fieldValueArray = super.fields().values();
        FieldValue[] fieldValueArray2 = new FieldValue[fieldValueArray.length - 1];
        for (int i = 0; i < fieldValueArray.length - 1; ++i) {
            fieldValueArray2[i] = fieldValueArray[i];
        }
        fieldValueArray2[fieldValueArray2.length - 1] = fieldValueArray[fieldValueArray.length - 1];
        fieldValueArray2[0].setValue(new Integer(reportVersionRecord.getVersionID()));
        fieldValueArray2[1].setValue(reportVersionRecord.getVersionName());
        fieldValueArray2[2].setValue(new Integer(reportVersionRecord.getResourceID()));
        fieldValueArray2[3].setValue(reportVersionRecord.getCreator());
        fieldValueArray2[4].setValue(new Long(reportVersionRecord.getCreatedTime()));
        fieldValueArray2[5].setValue(reportVersionRecord.getModifier());
        fieldValueArray2[6].setValue(new Long(reportVersionRecord.getModifiedTime()));
        fieldValueArray2[7].setValue(this.ruleExternalDataPath(reportVersionRecord.getReportFile(), this.getHistDir()));
        fieldValueArray2[8].setValue(reportVersionRecord.getDiskSize());
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        parameterMetaInfo.add(super.fields(0).getName(), String.valueOf(reportVersionRecord.getVersionID()), 4);
        parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(reportVersionRecord.getResourceID()), 4);
        String string = " WHERE " + super.fields(0).getName() + "=? AND " + super.fields(2).getName() + "=?";
        try {
            int n = super.update(fieldValueArray2, string, parameterMetaInfo);
            ReportVersionRecord reportVersionRecord2 = null;
            reportVersionRecord2 = (ReportVersionRecord)this.getRecord(reportVersionRecord.getVersionID(), reportVersionRecord.getResourceID());
            String string2 = reportVersionRecord.getReportFile();
            String string3 = reportVersionRecord2.getReportFile();
            if (!string2.equals(string3)) {
                this.fireEvent(RecordEventType.deleted, reportVersionRecord, string2);
                this.fireEvent(RecordEventType.inserted, reportVersionRecord, string3);
            }
            return n > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    @Override
    public synchronized Object getLatestVerRec(int n) {
        Number number = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(SEDU[2]).getName()).append("=?");
            number = super.queryMaxValue(SEDU[0], stringBuffer.toString(), parameterMetaInfo, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        if (number != null) {
            return this.getRecord(number.intValue(), n);
        }
        return null;
    }

    @Override
    public synchronized Object getEarliestVerRec(int n) {
        Number number = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(SEDU[2]).getName()).append("=?");
            number = super.queryMaxValue(SEDU[0], stringBuffer.toString(), parameterMetaInfo, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        if (number != null) {
            return this.getRecord(number.intValue(), n);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Vector getVersionNumbers(int n) {
        Vector<Integer> vector = new Vector<Integer>();
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        Recordset recordset = null;
        Field[] fieldArray = new Field[]{this.fields(SEDU[0])};
        try {
            parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(n), 4);
            String string = "WHERE " + super.fields(2).getName() + "=?";
            recordset = super.query(fieldArray, string, parameterMetaInfo, true);
            while (recordset.next()) {
                vector.addElement(new Integer(recordset.getInt(SEDU[0])));
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                recordset.close();
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    @Override
    public synchronized int getVersionAmount(int n) {
        Number number = 0;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(SEDU[2]).getName()).append("=?");
            number = super.querySumValue(SEDU[0], stringBuffer.toString(), parameterMetaInfo, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return number;
    }

    @Override
    public synchronized boolean delEarliestVersion(int n) {
        Number number = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(SEDU[2]).getName()).append("=?");
            number = super.queryMinValue(SEDU[0], stringBuffer.toString(), parameterMetaInfo, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        if (number != null) {
            return this.delRecord(number.intValue(), n);
        }
        return false;
    }

    private synchronized int INTEGER(int n) {
        Number number = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(super.fields(2).getName(), String.valueOf(n), 4);
            stringBuffer.append(" WHERE ").append(super.fields(2).getName()).append("=?");
            number = super.queryMaxValue(SEDU[0], stringBuffer.toString(), parameterMetaInfo, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        if (number == null || number.intValue() <= 0) {
            return 1;
        }
        return number.intValue() + 1;
    }

    private synchronized int SEDU() {
        Number number = null;
        try {
            number = super.queryMaxValue(SEDU[8], null, ParameterMetaInfo.EMPTY, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return number == null ? -1 : number.intValue();
    }

    private synchronized int VARCHAR() {
        try {
            return this.adapter.getID(this, this.fields(SEDU[8]));
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return 1;
        }
    }

    @Override
    public boolean hasExternalData() {
        return true;
    }

    @Override
    public String getExternalDataPath(FieldValue[] fieldValueArray) {
        int n;
        String string = (String)fieldValueArray[7].getValue();
        if (string != null && string.length() != 0 && (n = string.lastIndexOf(File.separator)) > 0) {
            string = string.substring(0, n);
        }
        String string2 = this.getHistDir();
        return string2 + string;
    }
}

