/*
 * Decompiled with CFR 0.152.
 */
package jet.server.event;

import jet.server.event.Selector;

public final class SelectorImpl
implements Selector {
    private static final long serialVersionUID = -418771824319094952L;
    private static final int SEDU = 6;
    private static final int append = 64;
    private static final int select = 63;
    private String substring;
    private long[] toString;
    private int I = 0;

    public SelectorImpl(String string, int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("types < 0: " + n);
        }
        this.substring = string == null ? "Unknown" : string;
        this.I = n;
        this.toString = new long[SelectorImpl.unitIndex(n - 1) + 1];
    }

    @Override
    public String getTopic() {
        return this.substring;
    }

    @Override
    public synchronized boolean select(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("type < 0: " + n);
        }
        boolean bl = false;
        if (n < this.I) {
            int n2 = SelectorImpl.unitIndex(n);
            bl = (this.toString[n2] & SelectorImpl.bit(n)) != 0L;
        }
        return bl;
    }

    @Override
    public synchronized void enable(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("type < 0: " + n);
        }
        if (n < this.I) {
            int n2;
            int n3 = n2 = SelectorImpl.unitIndex(n);
            this.toString[n3] = this.toString[n3] | SelectorImpl.bit(n);
        }
    }

    @Override
    public synchronized void enableAll() {
        for (int i = 0; i < this.toString.length; ++i) {
            this.toString[i] = -1L;
        }
    }

    @Override
    public synchronized void disable(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("type < 0: " + n);
        }
        if (n < this.I) {
            int n2;
            int n3 = n2 = SelectorImpl.unitIndex(n);
            this.toString[n3] = this.toString[n3] & (SelectorImpl.bit(n) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    @Override
    public synchronized void disableAll() {
        for (int i = 0; i < this.toString.length; ++i) {
            this.toString[i] = 0L;
        }
    }

    public int size() {
        return this.I;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.substring).append(" {");
        for (int i = 0; i < this.I; ++i) {
            if (this.select(i)) {
                stringBuffer.append(i);
            }
            if (i >= this.I - 1 || this.I <= 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("}");
        return stringBuffer.substring(0);
    }

    private static int unitIndex(int n) {
        return n >> 6;
    }

    private static long bit(int n) {
        return 1L << (n & 0x3F);
    }
}

