/*
 * Decompiled with CFR 0.152.
 */
package jet.server.event.util;

import jet.server.event.util.Queue;

public class PriorityQueue {
    public static final int INIT_QUEUE_LEN = 32;
    private Queue[] append;

    public PriorityQueue(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("The queues argument (" + n + ") is not a positive integer.");
        }
        this.append = new Queue[n];
        for (int i = 0; i < this.append.length; ++i) {
            this.append[i] = new Queue(32);
        }
    }

    public void distroy() {
        this.clear();
        this.append = null;
    }

    public final int getMaxQueues() {
        return this.append.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        for (int i = 0; i < this.append.length; ++i) {
            Queue queue = this.append[i];
            synchronized (queue) {
                this.append[i].clear();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        int n = 0;
        for (int i = 0; i < this.append.length; ++i) {
            Queue queue = this.append[i];
            synchronized (queue) {
                n += this.append[i].size();
                continue;
            }
        }
        return n;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object object, int n) {
        Queue queue = this.append[n];
        synchronized (queue) {
            this.append[n].enqueue(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dequeue() {
        Object object = null;
        for (int i = 0; i < this.append.length; ++i) {
            Queue queue = this.append[i];
            synchronized (queue) {
                object = this.append[i].isEmpty() ? null : this.append[i].dequeue();
            }
            if (object != null) break;
        }
        return object;
    }
}

