/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import jet.server.api.admin.cfg.custom.CustomField;
import jet.server.api.admin.cfg.custom.CustomFieldManageException;
import jet.server.db.dao.CustomFieldDAO;
import jet.server.db.model.CustomFieldModel;
import jet.server.intf.jrs.RemoteCustomFieldManager;
import jet.server.log.ServiceLogger;

public class JRRemoteCustomFieldManager
implements RemoteCustomFieldManager {
    @Override
    public void createField(String string, String string2, boolean bl) throws CustomFieldManageException {
        CustomFieldDAO customFieldDAO = CustomFieldDAO.getInstance();
        Connection connection = null;
        try {
            connection = customFieldDAO.getConnection();
            connection.setAutoCommit(false);
            if (string == null || string.trim().length() == 0) {
                throw new CustomFieldManageException("EXCEPTION_0000001;");
            }
            if (customFieldDAO.existed(connection, string)) {
                throw new CustomFieldManageException("EXCEPTION_0000002;" + string);
            }
            CustomFieldModel customFieldModel = new CustomFieldModel();
            customFieldModel.setName(string);
            customFieldModel.setDescription(string2);
            customFieldModel.setEnabled(bl);
            customFieldDAO.insert(connection, customFieldModel);
            connection.commit();
        }
        catch (CustomFieldManageException customFieldManageException) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 3);
            }
            throw customFieldManageException;
        }
        catch (Exception exception) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 3);
            }
            throw new CustomFieldManageException(exception);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 3);
                }
            }
        }
    }

    @Override
    public void deleteField(String string) throws CustomFieldManageException {
        CustomFieldDAO customFieldDAO = CustomFieldDAO.getInstance();
        Connection connection = null;
        try {
            connection = customFieldDAO.getConnection();
            connection.setAutoCommit(false);
            customFieldDAO.deleteByName(connection, string);
            connection.commit();
        }
        catch (Exception exception) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 3);
            }
            throw new CustomFieldManageException(exception);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public void deleteFields(List list) throws CustomFieldManageException {
        CustomFieldDAO customFieldDAO = CustomFieldDAO.getInstance();
        Connection connection = null;
        try {
            connection = customFieldDAO.getConnection();
            connection.setAutoCommit(false);
            for (int i = list.size() - 1; i >= 0; --i) {
                String string = (String)list.get(i);
                customFieldDAO.deleteByName(connection, string);
            }
            connection.commit();
        }
        catch (Exception exception) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 3);
            }
            throw new CustomFieldManageException(exception);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getAllFields() {
        CustomFieldDAO customFieldDAO = CustomFieldDAO.getInstance();
        Connection connection = null;
        try {
            connection = customFieldDAO.getConnection();
            Vector vector = customFieldDAO.listAll(connection);
            return vector;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 3);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomField getField(String string) {
        CustomFieldDAO customFieldDAO = CustomFieldDAO.getInstance();
        Connection connection = null;
        try {
            connection = customFieldDAO.getConnection();
            CustomFieldModel customFieldModel = customFieldDAO.getFieldByName(connection, string);
            return customFieldModel;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 3);
                }
            }
        }
        return null;
    }

    @Override
    public void updateField(String string, String string2, String string3, boolean bl) throws CustomFieldManageException {
        CustomFieldDAO customFieldDAO = CustomFieldDAO.getInstance();
        Connection connection = null;
        try {
            connection = customFieldDAO.getConnection();
            connection.setAutoCommit(false);
            String string4 = string2;
            if (string4 == null || string4.trim().length() == 0) {
                throw new CustomFieldManageException("EXCEPTION_0000001;");
            }
            CustomFieldModel customFieldModel = customFieldDAO.getFieldByName(connection, string2);
            CustomFieldModel customFieldModel2 = customFieldDAO.getFieldByName(connection, string);
            if (customFieldModel != null && customFieldModel2 != null && customFieldModel.getId() != customFieldModel2.getId()) {
                throw new CustomFieldManageException("EXCEPTION_0000002;" + string4);
            }
            CustomFieldModel customFieldModel3 = new CustomFieldModel();
            customFieldModel3.setName(string2);
            customFieldModel3.setDescription(string3);
            customFieldModel3.setEnabled(bl);
            customFieldDAO.updateByName(connection, string, customFieldModel3);
            connection.commit();
        }
        catch (CustomFieldManageException customFieldManageException) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 3);
            }
            throw customFieldManageException;
        }
        catch (Exception exception) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 3);
            }
            throw new CustomFieldManageException(exception);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

