/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jet.server.api.DashboardListenerInfo;
import jet.server.api.cluster.ClusterException;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.cluster.blocks.MapFlags;
import jet.server.cluster.blocks.MapListenerAdapter;
import jet.server.cluster.util.ClusterInitLocker;
import jet.server.db.dao.DashboardListenerInfoDAO;
import jet.server.db.model.DashboardListenerInfoModel;
import jet.server.intf.jrs.RemoteDashboardListenerManager;
import jet.server.jrserver.JRDashboardListenerInfo;
import jet.server.log.ServiceLogger;
import jet.server.util.StringUtils;

public class JRRemoteDashboardListenerManager
implements RemoteDashboardListenerManager {
    private static final long serialVersionUID = -2742686194383875685L;
    private ClusterMap JRDashboardListenerInfo = null;
    private HashMap SEDU = null;

    public JRRemoteDashboardListenerManager() throws InterruptedException, Exception {
        this.init();
    }

    public void init() throws ClusterException, InterruptedException, Exception {
        if (!ClusterInitLocker.hasInited(this.getClass().getName())) {
            try {
                this.JRDashboardListenerInfo();
                this.access$302();
                ClusterInitLocker.setInited(this.getClass().getName());
            }
            catch (Exception exception) {
                ClusterInitLocker.cancelInit(this.getClass().getName());
                throw exception;
            }
        } else {
            this.JRDashboardListenerInfo();
            this.access$402();
        }
    }

    private void JRDashboardListenerInfo() throws ClusterException {
        this.SEDU = new HashMap();
        this.JRDashboardListenerInfo = MapFactory.getMap(MapAttr.JRDashboardListenerInfo);
        this.JRDashboardListenerInfo.addListener(new MapListenerAdapter(){

            @Override
            public void afterClear(String string, int n, MapFlags mapFlags) {
                JRRemoteDashboardListenerManager.this.SEDU.clear();
            }

            public void afterPut(String string, int n, String string2, JRDashboardListenerInfo jRDashboardListenerInfo, JRDashboardListenerInfo jRDashboardListenerInfo2, MapFlags mapFlags) {
                ArrayList<String> arrayList = null;
                if (jRDashboardListenerInfo2 != null) {
                    List list = jRDashboardListenerInfo2.getTarget();
                    List list2 = jRDashboardListenerInfo.getTarget();
                    for (String string3 : list) {
                        if (list2.contains(string3)) continue;
                        if (arrayList == null) {
                            arrayList = new ArrayList<String>();
                        }
                        arrayList.add(string3);
                    }
                }
                JRRemoteDashboardListenerManager.this.add(jRDashboardListenerInfo, arrayList);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterRemove(String string, int n, String string2, JRDashboardListenerInfo jRDashboardListenerInfo, MapFlags mapFlags) {
                if (jRDashboardListenerInfo != null) {
                    List list = jRDashboardListenerInfo.getTarget();
                    for (String string3 : list) {
                        List list2;
                        List list3 = list2 = (List)JRRemoteDashboardListenerManager.this.SEDU.get(string3);
                        synchronized (list3) {
                            for (ApplyInfo applyInfo : list2) {
                                if (!StringUtils.equals(applyInfo.SEDU, jRDashboardListenerInfo.getClassName())) continue;
                                list2.remove(applyInfo);
                                break;
                            }
                            if (list2.size() == 0) {
                                JRRemoteDashboardListenerManager.this.SEDU.remove(string3);
                            }
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addDashboardListener(DashboardListenerInfo dashboardListenerInfo) throws RemoteException {
        ServiceLogger.trace("DashboardListenerManager: add: [Info=%s]", dashboardListenerInfo);
        if (dashboardListenerInfo == null) {
            return false;
        }
        boolean bl = false;
        DashboardListenerInfoModel dashboardListenerInfoModel = this.SEDU((JRDashboardListenerInfo)dashboardListenerInfo);
        DashboardListenerInfoDAO dashboardListenerInfoDAO = DashboardListenerInfoDAO.getInstance();
        Connection connection = null;
        try {
            connection = dashboardListenerInfoDAO.getConnection();
            connection.setAutoCommit(false);
            dashboardListenerInfoDAO.insert(connection, dashboardListenerInfoModel);
            connection.commit();
            this.access$300(dashboardListenerInfo);
            bl = true;
        }
        catch (Exception exception) {
            ServiceLogger.trace("DashboardListenerManager: add: failed! %s [Info=%s]", exception, dashboardListenerInfo);
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 2);
            }
            ServiceLogger.logError(exception, 2);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 2);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteDashboardListeners(List list) throws RemoteException {
        ServiceLogger.trace("DashboardListenerManager: delete: [classNames=%s]", list);
        try {
            if (list == null) {
                return false;
            }
            boolean bl = false;
            DashboardListenerInfoDAO dashboardListenerInfoDAO = DashboardListenerInfoDAO.getInstance();
            Connection connection = null;
            try {
                connection = dashboardListenerInfoDAO.getConnection();
                connection.setAutoCommit(false);
                for (String string : list) {
                    dashboardListenerInfoDAO.delete(connection, string);
                }
                connection.commit();
                for (String string : list) {
                    this.JRDashboardListenerInfo.remove(string);
                }
                bl = true;
            }
            catch (Exception exception) {
                ServiceLogger.trace("DashboardListenerManager: delete: failed! %s [classNames=%s]", exception, list);
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 2);
                }
                ServiceLogger.logError(exception, 2);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException, 2);
                    }
                }
            }
            return bl;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return false;
        }
    }

    @Override
    public DashboardListenerInfo getDashboardListenerByName(String string) throws RemoteException {
        ServiceLogger.trace("DashboardListenerManager: getByName: [className=%s]", string);
        try {
            if (string != null) {
                DashboardListenerInfo dashboardListenerInfo = null;
                dashboardListenerInfo = (DashboardListenerInfo)this.JRDashboardListenerInfo.get(string);
                return dashboardListenerInfo;
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return null;
    }

    @Override
    public DashboardListenerInfo getDashboardListenerByTarget(String string) throws RemoteException {
        ServiceLogger.trace("DashboardListenerManager: getByTarget: [target=%s]", string);
        List list = null;
        JRDashboardListenerInfo jRDashboardListenerInfo = null;
        ApplyInfo applyInfo = null;
        block0: for (String string2 : this.SEDU.keySet()) {
            if (!string2.equals("<ALL>") && !string2.equalsIgnoreCase(string) && !string.startsWith(string2 + "/") && (!string2.equals("/") || string.startsWith("/USERFOLDERPATH") || string.startsWith("/COMPONENT_LIB")) || (list = (List)this.SEDU.get(string2)) == null) continue;
            for (ApplyInfo applyInfo2 : list) {
                JRDashboardListenerInfo jRDashboardListenerInfo2 = (JRDashboardListenerInfo)this.JRDashboardListenerInfo.get(applyInfo2.SEDU);
                if (jRDashboardListenerInfo2 == null || !jRDashboardListenerInfo2.isEnabled() || applyInfo != null && applyInfo2.Z >= applyInfo.Z) continue;
                applyInfo = applyInfo2;
                continue block0;
            }
        }
        if (applyInfo != null) {
            jRDashboardListenerInfo = (JRDashboardListenerInfo)this.JRDashboardListenerInfo.get(applyInfo.SEDU);
        }
        ServiceLogger.trace("DashboardListenerManager: getByTarget: [target=%s], [ret=%s]", string, jRDashboardListenerInfo);
        return jRDashboardListenerInfo;
    }

    @Override
    public Vector getDashboardListeners() throws RemoteException {
        ServiceLogger.trace("DashboardListenerManager: getListeners......", new Object[0]);
        Vector<JRDashboardListenerInfo> vector = new Vector<JRDashboardListenerInfo>();
        try {
            for (JRDashboardListenerInfo jRDashboardListenerInfo : this.JRDashboardListenerInfo.values()) {
                vector.add(jRDashboardListenerInfo);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setMultiEnabled(List list, boolean bl) throws RemoteException {
        block18: {
            try {
                ServiceLogger.trace("DashboardListenerManager: setEnabled: [classNames=%s, isEnabled=%s]", list, bl);
                if (list == null) break block18;
                boolean bl2 = false;
                DashboardListenerInfoDAO dashboardListenerInfoDAO = DashboardListenerInfoDAO.getInstance();
                Connection connection = null;
                try {
                    connection = dashboardListenerInfoDAO.getConnection();
                    connection.setAutoCommit(false);
                    for (String string : list) {
                        dashboardListenerInfoDAO.update(connection, string, bl);
                    }
                    connection.commit();
                    for (String string : list) {
                        JRDashboardListenerInfo jRDashboardListenerInfo = (JRDashboardListenerInfo)this.JRDashboardListenerInfo.get(string);
                        if (jRDashboardListenerInfo == null) continue;
                        jRDashboardListenerInfo.setEnabled(bl);
                        this.access$300(jRDashboardListenerInfo);
                    }
                    bl2 = true;
                }
                catch (Exception exception) {
                    ServiceLogger.trace("DashboardListenerManager: update enabled: failed! %s [classNames=%s]", exception, list);
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException, 2);
                    }
                    ServiceLogger.logError(exception, 2);
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sQLException) {
                            ServiceLogger.logError(sQLException, 2);
                        }
                    }
                }
                return bl2;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateDashboardListener(DashboardListenerInfo dashboardListenerInfo) throws RemoteException {
        block16: {
            try {
                ServiceLogger.trace("DashboardListenerManager: updateListener: [info=%s]", dashboardListenerInfo);
                if (dashboardListenerInfo == null) break block16;
                boolean bl = false;
                DashboardListenerInfoModel dashboardListenerInfoModel = this.SEDU((JRDashboardListenerInfo)dashboardListenerInfo);
                DashboardListenerInfoDAO dashboardListenerInfoDAO = DashboardListenerInfoDAO.getInstance();
                Connection connection = null;
                try {
                    connection = dashboardListenerInfoDAO.getConnection();
                    connection.setAutoCommit(false);
                    dashboardListenerInfoDAO.update(connection, dashboardListenerInfoModel);
                    connection.commit();
                    this.access$300(dashboardListenerInfo);
                    bl = true;
                }
                catch (Exception exception) {
                    ServiceLogger.trace("DashboardListenerManager: update: failed! %s [info=%s]", exception, dashboardListenerInfo);
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException, 2);
                    }
                    ServiceLogger.logError(exception, 2);
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sQLException) {
                            ServiceLogger.logError(sQLException, 2);
                        }
                    }
                }
                return bl;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return false;
    }

    private DashboardListenerInfoModel SEDU(JRDashboardListenerInfo jRDashboardListenerInfo) {
        this.access$202(jRDashboardListenerInfo);
        DashboardListenerInfoModel dashboardListenerInfoModel = new DashboardListenerInfoModel();
        dashboardListenerInfoModel.setClassName(jRDashboardListenerInfo.getClassName());
        dashboardListenerInfoModel.setTargets(jRDashboardListenerInfo.getTargets());
        dashboardListenerInfoModel.setDescription(jRDashboardListenerInfo.getDescription());
        dashboardListenerInfoModel.setEnabled(jRDashboardListenerInfo.isEnabled());
        dashboardListenerInfoModel.setCreateTime(jRDashboardListenerInfo.getCreateTime());
        return dashboardListenerInfoModel;
    }

    private DashboardListenerInfo access$200(DashboardListenerInfoModel dashboardListenerInfoModel) {
        JRDashboardListenerInfo jRDashboardListenerInfo = new JRDashboardListenerInfo(dashboardListenerInfoModel.getClassName(), dashboardListenerInfoModel.getTargets(), dashboardListenerInfoModel.getDescription(), dashboardListenerInfoModel.isEnabled(), dashboardListenerInfoModel.getCreateTime());
        return jRDashboardListenerInfo;
    }

    private void access$202(JRDashboardListenerInfo jRDashboardListenerInfo) {
        JRDashboardListenerInfo jRDashboardListenerInfo2 = (JRDashboardListenerInfo)this.JRDashboardListenerInfo.get(jRDashboardListenerInfo.getClassName());
        if (jRDashboardListenerInfo2 != null) {
            jRDashboardListenerInfo.setCreateTime(jRDashboardListenerInfo2.getCreateTime());
            HashMap hashMap = jRDashboardListenerInfo2.getTargets();
            HashMap hashMap2 = jRDashboardListenerInfo.getTargets();
            for (String string : hashMap.keySet()) {
                if (!hashMap2.containsKey(string)) continue;
                hashMap2.put(string, hashMap.get(string));
            }
        }
    }

    private void access$300(DashboardListenerInfo dashboardListenerInfo) {
        if (dashboardListenerInfo == null) {
            return;
        }
        String string = dashboardListenerInfo.getClassName();
        this.JRDashboardListenerInfo.put(string, (JRDashboardListenerInfo)dashboardListenerInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void access$302() {
        ServiceLogger.trace("DashboardListenerManager: recoverListeners......", new Object[0]);
        DashboardListenerInfoDAO dashboardListenerInfoDAO = DashboardListenerInfoDAO.getInstance();
        Connection connection = null;
        try {
            connection = dashboardListenerInfoDAO.getConnection();
            List list = dashboardListenerInfoDAO.listAll(connection);
            for (DashboardListenerInfoModel dashboardListenerInfoModel : list) {
                DashboardListenerInfo dashboardListenerInfo = this.access$200(dashboardListenerInfoModel);
                this.access$300(dashboardListenerInfo);
            }
        }
        catch (Exception exception) {
            ServiceLogger.trace("DashboardListenerManager: recoverListeners: failed! %s ", exception);
            ServiceLogger.logError(exception, 2);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 2);
                }
            }
        }
    }

    private void access$402() {
        Iterator iterator = this.JRDashboardListenerInfo.values().iterator();
        while (iterator.hasNext()) {
            this.add((JRDashboardListenerInfo)iterator.next(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(JRDashboardListenerInfo jRDashboardListenerInfo, List list) {
        List list2 = jRDashboardListenerInfo.getTarget();
        HashMap hashMap = jRDashboardListenerInfo.getTargets();
        for (String string : list2) {
            ArrayList<ApplyInfo> arrayList = null;
            if (list != null && list.contains(string)) {
                HashMap hashMap2 = this.SEDU;
                synchronized (hashMap2) {
                    arrayList = (List)this.SEDU.get(string);
                    if (arrayList != null) {
                        for (ApplyInfo applyInfo : arrayList) {
                            if (!applyInfo.SEDU.equals(jRDashboardListenerInfo.getClassName())) continue;
                            arrayList.remove(applyInfo);
                            break;
                        }
                    }
                    continue;
                }
            }
            HashMap hashMap3 = this.SEDU;
            synchronized (hashMap3) {
                arrayList = (ArrayList<ApplyInfo>)this.SEDU.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<ApplyInfo>();
                    this.SEDU.put(string, arrayList);
                }
            }
            long l = (Long)hashMap.get(string);
            ApplyInfo applyInfo = new ApplyInfo();
            applyInfo.SEDU = jRDashboardListenerInfo.getClassName();
            applyInfo.I = string;
            applyInfo.Z = l;
            ArrayList<ApplyInfo> arrayList2 = arrayList;
            synchronized (arrayList2) {
                int n;
                for (n = 0; n < arrayList.size() && !applyInfo.SEDU.equals(((ApplyInfo)arrayList.get(n)).SEDU); ++n) {
                    if (l >= ((ApplyInfo)arrayList.get(n)).Z) continue;
                    arrayList.add(n, applyInfo);
                    break;
                }
                if (n == arrayList.size()) {
                    arrayList.add(applyInfo);
                }
            }
        }
    }

    class ApplyInfo {
        private String SEDU;
        private String I;
        private long Z;

        ApplyInfo() {
        }
    }
}

