/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import jet.server.ServerEnv;
import jet.server.api.OndemandReportRecord;
import jet.server.api.ReportSheetInfo;
import jet.server.api.cluster.ClusterException;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.cluster.ClusterEnv;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.cluster.blocks.MapFlags;
import jet.server.cluster.blocks.MapListenerAdapter;
import jet.server.intf.jrs.RemoteOndemandManager;
import jet.server.jrc.JRTaskManager;
import jet.server.jrserver.JROndemandReportRecord;
import jet.server.log.ServiceLogger;
import jet.server.resstore.ServerDiskStore;
import jet.server.resstore.ServerResourceStoreFactory;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;
import jet.server.util.IOUtil;

public class JRRemoteOndemandManager
implements RemoteOndemandManager {
    private ClusterMap JROndemandReportRecord = null;
    private Map SEDU = new HashMap();
    private Map TEMP = new Hashtable(20);
    private JRTaskManager add = null;
    private int addListener = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRRemoteOndemandManager() throws ClusterException, RemoteException {
        this.JROndemandReportRecord = MapFactory.getMap(MapAttr.JROndemandReportRecord);
        this.JROndemandReportRecord.addListener(new OndemandMapListener());
        Map map = this.TEMP;
        synchronized (map) {
            ArrayList arrayList = new ArrayList();
            for (Object object : this.JROndemandReportRecord.entrySet()) {
                arrayList.add(object.getValue());
                this.SEDU((JROndemandReportRecord)object.getValue());
            }
            Collections.sort(arrayList, new Comparator(){

                public int compare(JROndemandReportRecord jROndemandReportRecord, JROndemandReportRecord jROndemandReportRecord2) {
                    return (int)(jROndemandReportRecord.getStartedTime() - jROndemandReportRecord2.getStartedTime());
                }
            });
            for (Object object : arrayList) {
                CopyOnWriteArrayList<String> copyOnWriteArrayList = (CopyOnWriteArrayList<String>)this.TEMP.get(((JROndemandReportRecord)object).getUserID());
                if (copyOnWriteArrayList == null) {
                    copyOnWriteArrayList = new CopyOnWriteArrayList<String>();
                    this.TEMP.put(((JROndemandReportRecord)object).getUserID(), copyOnWriteArrayList);
                }
                copyOnWriteArrayList.add(((JROndemandReportRecord)object).getOndemandID());
            }
        }
        this.addListener = ServerEnv.getOndemandUserMaxRecords();
    }

    private ServerDiskStore JROndemandReportRecord(JROndemandReportRecord jROndemandReportRecord) {
        return ServerResourceStoreFactory.getInstance().getResourceStoreByUser(jROndemandReportRecord.getUserID()).getDiskStore();
    }

    private void SEDU(JROndemandReportRecord jROndemandReportRecord) {
        Long l = this.SEDU.put(jROndemandReportRecord.getOndemandID(), jROndemandReportRecord.getResultFilesLength());
        long l2 = jROndemandReportRecord.getResultFilesLength() - (l == null ? 0L : l);
        this.JROndemandReportRecord(jROndemandReportRecord).getSpaceAllocator().allocateForce(l2);
    }

    private void TEMP(JROndemandReportRecord jROndemandReportRecord) {
        Long l = (Long)this.SEDU.remove(jROndemandReportRecord.getOndemandID());
        if (l != null && l > 0L) {
            this.JROndemandReportRecord(jROndemandReportRecord).getSpaceAllocator().deallocate(l);
        }
    }

    public void setTaskManager(JRTaskManager jRTaskManager) {
        this.add = jRTaskManager;
    }

    @Override
    public Vector getOndemandReports(String string) throws RemoteException {
        try {
            Vector<Object> vector = new Vector<Object>();
            List list = (List)this.TEMP.get(string);
            if (list != null) {
                for (String string2 : list) {
                    OndemandReportRecord ondemandReportRecord = (OndemandReportRecord)this.JROndemandReportRecord.get(string2);
                    if (ondemandReportRecord == null) continue;
                    vector.add(this.JROndemandReportRecord.get(string2));
                }
            }
            return vector;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }

    @Override
    public OndemandReportRecord getOndemandReportRecord(String string) throws RemoteException {
        try {
            return (OndemandReportRecord)this.JROndemandReportRecord.get(string);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }

    @Override
    public OndemandReportRecord notifyCompleted(String string) throws RemoteException {
        try {
            if (string == null) {
                return null;
            }
            JROndemandReportRecord jROndemandReportRecord = (JROndemandReportRecord)this.JROndemandReportRecord.get(string);
            if (jROndemandReportRecord == null) {
                return null;
            }
            if (jROndemandReportRecord.getFormat() != 8) {
                try {
                    ServerDiskStore serverDiskStore = this.JROndemandReportRecord(jROndemandReportRecord);
                    StorageEnv.setThreadMember(jROndemandReportRecord.getMemberID());
                    StorageEnv storageEnv = StorageEnv.getStorageEnv(jROndemandReportRecord.getMemberID());
                    for (String string2 : jROndemandReportRecord.getResultFiles()) {
                        String string3 = storageEnv.relativeDiskPath(Storage.StorageRoot.TEMP, string2);
                        StorageEnv.getStorage().add(Storage.StorageRoot.TEMP, string3, jROndemandReportRecord.getMemberID(), false);
                        File file = StorageEnv.getStorage().map(Storage.StorageRoot.TEMP, string3);
                        serverDiskStore.remove(file);
                        jROndemandReportRecord.setResultFilesLength(jROndemandReportRecord.getResultFilesLength() + IOUtil.getFileLength(file));
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
            }
            jROndemandReportRecord.setCompleted();
            this.JROndemandReportRecord.put(string, jROndemandReportRecord);
            return jROndemandReportRecord;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }

    @Override
    public OndemandReportRecord changeStatus(String string, String string2) throws RemoteException {
        try {
            if (string == null) {
                return null;
            }
            JROndemandReportRecord jROndemandReportRecord = (JROndemandReportRecord)this.JROndemandReportRecord.get(string);
            if (jROndemandReportRecord != null) {
                jROndemandReportRecord.setStatus(string2);
                this.JROndemandReportRecord.put(string, jROndemandReportRecord);
            }
            return jROndemandReportRecord;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }

    @Override
    public void removeOndemandReport(String string, boolean bl) throws RemoteException {
        if (string == null) {
            return;
        }
        try {
            JROndemandReportRecord jROndemandReportRecord = (JROndemandReportRecord)this.JROndemandReportRecord.get(string);
            if (jROndemandReportRecord == null) {
                return;
            }
            this.JROndemandReportRecord.remove((Object)string, MapFlags.create(bl).forceDests(jROndemandReportRecord.getMemberID()));
            if (jROndemandReportRecord.getFormat() == 8) {
                return;
            }
            try {
                List list = jROndemandReportRecord.getResultFiles();
                String string2 = StorageEnv.getStorage().map(Storage.StorageRoot.TEMP.getRootPath()).getCanonicalPath();
                for (String string3 : list) {
                    StorageEnv.getStorage().delete(Storage.StorageRoot.TEMP, string3);
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public String registerOndemandReport(int n, String string, String string2, String string3, int n2, String string4, ReportSheetInfo reportSheetInfo, int n3, Properties properties, String string5, boolean bl, String string6, String string7, int n4) throws RemoteException {
        try {
            JROndemandReportRecord jROndemandReportRecord = new JROndemandReportRecord(n, string, string2, string3, n2, string4, reportSheetInfo, n3, properties, string5, bl, string6, string7, n4);
            jROndemandReportRecord = (JROndemandReportRecord)this.JROndemandReportRecord.put(jROndemandReportRecord.getOndemandID(), jROndemandReportRecord);
            return string;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }

    @Override
    public void setErrorMessage(String string, String string2) throws RemoteException {
        try {
            JROndemandReportRecord jROndemandReportRecord = (JROndemandReportRecord)this.JROndemandReportRecord.get(string);
            if (jROndemandReportRecord != null) {
                jROndemandReportRecord.setErrorMessage(string2);
                this.JROndemandReportRecord.put(string, jROndemandReportRecord);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public void addResultFiles(String string, List list) {
        JROndemandReportRecord jROndemandReportRecord = (JROndemandReportRecord)this.JROndemandReportRecord.get(string);
        if (jROndemandReportRecord != null) {
            jROndemandReportRecord.addResultFiles(list);
            this.JROndemandReportRecord.put(string, jROndemandReportRecord);
        }
    }

    @Override
    public void removeOndemandReport(String string) throws RemoteException {
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            Object var2_2 = null;
            String string2 = string;
            String string3 = File.separator;
            if (string2.indexOf(string3) != -1) {
                string2 = string2.substring(string2.lastIndexOf(string3) + 1);
            }
            for (JROndemandReportRecord jROndemandReportRecord : this.JROndemandReportRecord.values()) {
                if (!string.equals(jROndemandReportRecord.getResult())) continue;
                this.removeOndemandReport(jROndemandReportRecord.getOndemandID(), true);
                return;
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public void removeAllOndemandReport(String string) throws RemoteException {
        try {
            List list = (List)this.TEMP.remove(string);
            if (list != null) {
                for (String string2 : list) {
                    this.removeOndemandReport(string2, true);
                }
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public void clearUserOndemandList(String string, boolean bl) throws RemoteException {
        try {
            HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
            List list = (List)this.TEMP.remove(string);
            if (list != null) {
                for (String string2 : list) {
                    JROndemandReportRecord jROndemandReportRecord;
                    if (httpRptServer.getDHTMLClientService().getBackgroundReportInfo(string2) != null) {
                        httpRptServer.getDHTMLClientService().closeBackgroundReport(null, string2);
                    }
                    if ((jROndemandReportRecord = (JROndemandReportRecord)this.JROndemandReportRecord.get(string2)) == null || jROndemandReportRecord.getMemberID() != ClusterEnv.getMemberID()) {
                        ServiceLogger.logDebug("clearUserOndemandList skip remote ondemand task: " + jROndemandReportRecord);
                        continue;
                    }
                    this.removeOndemandReport(string2, bl);
                }
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public String getOndemandID(String string, String string2) throws RemoteException {
        try {
            if (string == null || string2 == null || string2.length() == 0) {
                return "";
            }
            List list = (List)this.TEMP.get(string);
            if (list != null) {
                for (String string3 : list) {
                    JROndemandReportRecord jROndemandReportRecord = (JROndemandReportRecord)this.JROndemandReportRecord.get(string3);
                    if (!string2.equals(jROndemandReportRecord.getResult())) continue;
                    return string3;
                }
            }
            return "";
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return "";
        }
    }

    @Override
    public void removeOndemandReport(String string, String string2, boolean bl) throws RemoteException {
        try {
            String string3 = this.getOndemandID(string, string2);
            if (string3 != null && string3.length() > 0) {
                this.removeOndemandReport(string3, bl);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    class OndemandMapListener
    extends MapListenerAdapter {
        OndemandMapListener() {
        }

        public void afterPut(String string, int n, String string2, JROndemandReportRecord jROndemandReportRecord, JROndemandReportRecord jROndemandReportRecord2, MapFlags mapFlags) {
            if (jROndemandReportRecord == null) {
                return;
            }
            if (jROndemandReportRecord.getFormat() != 8) {
                JRRemoteOndemandManager.this.SEDU(jROndemandReportRecord);
            }
            if (jROndemandReportRecord2 != null) {
                return;
            }
            CopyOnWriteArrayList<String> copyOnWriteArrayList = (CopyOnWriteArrayList<String>)JRRemoteOndemandManager.this.TEMP.get(jROndemandReportRecord.getUserID());
            if (copyOnWriteArrayList == null) {
                copyOnWriteArrayList = new CopyOnWriteArrayList<String>();
                JRRemoteOndemandManager.this.TEMP.put(jROndemandReportRecord.getUserID(), copyOnWriteArrayList);
            }
            if (!copyOnWriteArrayList.contains(string2)) {
                copyOnWriteArrayList.add(string2);
            }
            if (JRRemoteOndemandManager.this.addListener > 0 && copyOnWriteArrayList.size() > JRRemoteOndemandManager.this.addListener) {
                String string3 = (String)copyOnWriteArrayList.get(0);
                try {
                    JRRemoteOndemandManager.this.removeOndemandReport(string3, false);
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 5);
                }
            }
        }

        public void afterRemove(String string, int n, String string2, JROndemandReportRecord jROndemandReportRecord, MapFlags mapFlags) {
            if (jROndemandReportRecord == null) {
                return;
            }
            List list = (List)JRRemoteOndemandManager.this.TEMP.get(jROndemandReportRecord.getUserID());
            if (list != null) {
                list.remove(string2);
            }
            if (jROndemandReportRecord.getFormat() == 8) {
                return;
            }
            JRRemoteOndemandManager.this.TEMP(jROndemandReportRecord);
            if (jROndemandReportRecord.isLocal()) {
                if (jROndemandReportRecord.isCompleted()) {
                    if (ServerEnv.isPipeline() && jROndemandReportRecord.getResult().endsWith(".html")) {
                        String string3 = jROndemandReportRecord.getResult();
                        if ((string3 = string3.substring(0, string3.length() - ".html".length())).indexOf("_") != -1) {
                            string3 = string3.substring(0, string3.indexOf("_"));
                        }
                        JRRemoteOndemandManager.this.add.removePipelineFilenames(string3);
                    }
                    return;
                }
                boolean bl = false;
                Object[] objectArray = MapFlags.getUserFlags(mapFlags);
                if (objectArray != null && objectArray.length > 0) {
                    bl = (Boolean)objectArray[0];
                }
                if (bl) {
                    try {
                        JRRemoteOndemandManager.this.add.deleteOndemandReport(jROndemandReportRecord.getOndemandID());
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
        }
    }
}

