/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.io.File;
import java.io.FilenameFilter;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.security.acl.Permission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import jet.ReportEnv;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.CatalogVersionRecord;
import jet.server.api.LCVersionRecord;
import jet.server.api.PathInfo;
import jet.server.api.ReportVersionRecord;
import jet.server.api.ResultVersionRecord;
import jet.server.api.RptServerException;
import jet.server.api.VersionRecord;
import jet.server.api.admin.AdminService;
import jet.server.api.admin.SecurityAdminService;
import jet.server.api.cluster.Member;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.NoSuchOrganizationException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.NodeExistsException;
import jet.server.api.exception.UnknownResource;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.api.nls.TextNLSEntry;
import jet.server.intf.jrs.RemoteResourceManager;
import jet.server.intf.jrs.VersionService;
import jet.server.intf.resource.Folder;
import jet.server.intf.resource.Node;
import jet.server.intf.resource.Resource;
import jet.server.intf.resource.ResourceInfo;
import jet.server.intf.resource.Version;
import jet.server.intf.security.Role;
import jet.server.intf.security.SecurityService;
import jet.server.intf.security.User;
import jet.server.jrc.JRRemoteFileService;
import jet.server.jrc.JRRemotePathInfo;
import jet.server.jrc.resource.NodeImpl;
import jet.server.jrc.resource.PathInfoImpl;
import jet.server.jrc.resource.ResourceToolkit;
import jet.server.jrc.resource.ResourceTreeManagerImpl;
import jet.server.jrc.resource.nls.NLSUtil;
import jet.server.jrc.resource.nls.RemoteResourceNLSManagerImpl;
import jet.server.jrc.security.Realm;
import jet.server.log.ServiceLogger;
import jet.server.resource.RptResourceManager;
import jet.server.storage.StorageEnv;
import jet.server.util.RefResource;
import jet.server.util.ServerUtil;
import jet.server.util.WebSecurityUtil;
import jet.server.util.ui.UITree;
import jet.util.WildcardMatcher;

public class JRRemoteResourceManager
implements RemoteResourceManager {
    private static final long serialVersionUID = -3127157092778451524L;
    private RptResourceManager SEDU = null;
    private String add = null;
    private String addElement = null;
    private ResourceTreeManagerImpl addResource = null;
    private RemoteResourceNLSManagerImpl addResult = null;
    private VersionService addResultInReport = null;
    private Realm addSubFolder = null;

    public JRRemoteResourceManager(String string, String string2, String string3, ResourceTreeManagerImpl resourceTreeManagerImpl, RemoteResourceNLSManagerImpl remoteResourceNLSManagerImpl) throws RemoteException {
        this.add = string2;
        this.addElement = string3;
        this.addResource = resourceTreeManagerImpl;
        this.addResult = remoteResourceNLSManagerImpl;
        this.addResultInReport = resourceTreeManagerImpl.getVersionService();
        try {
            this.addSubFolder = Realm.get(string);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 5);
        }
    }

    @Override
    public UITree refreshFolders(String string) throws RemoteException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/USERFOLDERPATH");
        arrayList.add("/");
        return this.addResource.getUITree(string, arrayList, new ArrayList(), null);
    }

    @Override
    public UITree getUiTree(String string, List list, List list2, Locale locale) throws RemoteException {
        return this.addResource.getUITree(string, list, list2, locale);
    }

    @Override
    public String getMIMEType(String string) {
        return ServerEnv.getMimeTypeTable().getMimeType(string);
    }

    @Override
    public String[] getExtensions(String string) {
        return ServerEnv.getMimeTypeTable().getExts(string);
    }

    @Override
    public String getRealm() {
        return this.addSubFolder.getName();
    }

    @Override
    public String getRealmDir() {
        return ServerEnv.realmsPath;
    }

    @Override
    public PathInfo getPathInfo(String string, String string2) throws RptServerException {
        try {
            Node node = this.addResource.getNodeByPath(string2, string);
            if (node != null) {
                this.addResource.checkLinkedCatalog((NodeImpl)node);
                node = this.addResource.checkNode(node, string2, string);
                return this.charAt((PathInfoImpl)node.toPathInfo(string));
            }
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
        return null;
    }

    @Override
    public Vector getSubpaths(String string, String string2) throws RptServerException {
        if (string2 != null && string2.startsWith("/USERFOLDERPATH")) {
            return new Vector(1);
        }
        return this.getSubnodes(string, string2);
    }

    @Override
    public Vector getSubpathsAndCatalogs(String string, String string2) throws RptServerException, RemoteException {
        int n;
        Vector vector = null;
        try {
            vector = this.getFoldersInPath(string, string2);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
        Vector vector2 = this.getCatalogsInPath(string, string2);
        Vector vector3 = new Vector();
        if (vector != null) {
            for (n = 0; n < vector.size(); ++n) {
                vector3.addElement(vector.elementAt(n));
            }
        }
        if (vector2 != null) {
            for (n = 0; n < vector2.size(); ++n) {
                vector3.addElement(vector2.elementAt(n));
            }
        }
        return vector3;
    }

    @Override
    public Vector getSubnodes(String string, String string2) throws RptServerException {
        if (string2.length() > 1 && string2.endsWith("/") && !string2.endsWith(">/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        try {
            Node node = this.addResource.getNodeByPath(string2, string);
            Vector<PathInfoImpl> vector = null;
            if (node != null && node.getNodeType() == 1) {
                Node node2;
                int n;
                Vector vector2;
                vector = new Vector<PathInfoImpl>();
                if (!this.addResource.getResourceAliasManager().isAliasNode(string2, string)) {
                    vector2 = this.addResource.getChildren((Folder)node, string);
                    n = vector2.size();
                    for (int i = 0; i < n; ++i) {
                        node2 = (Node)vector2.elementAt(i);
                        this.addResource.checkLinkedCatalog((NodeImpl)node);
                        node2 = this.addResource.checkNode(node2, string2 + "/" + node2.getName(), string);
                        PathInfo pathInfo = node2.toPathInfo(string);
                        if (pathInfo.isJDashboard() && !ServerEnv.isEnabledDashboard() || pathInfo.isVA() && !ServerEnv.isEnabledVA() || !ReportEnv.isLive() && pathInfo.isLiveReport()) continue;
                        vector.add(this.charAt((PathInfoImpl)pathInfo));
                    }
                }
                vector2 = null;
                if (this.addResource.getResourceAliasManager().isAliasNode(string2, string) || this.addResource.getResourceAliasManager().isAliasSubNode(string2, string) || string2.equalsIgnoreCase("/")) {
                    vector2 = this.addResource.getAliasChildrenByPath(string2, string);
                }
                if (vector2 != null && vector2.size() > 0) {
                    for (n = 0; n < vector2.size(); ++n) {
                        node2 = (Node)vector2.elementAt(n);
                        this.addResource.checkLinkedCatalog((NodeImpl)node);
                        PathInfo pathInfo = node2.toPathInfo(string);
                        if (pathInfo.isJDashboard() && !ServerEnv.isEnabledDashboard() || pathInfo.isVA() && !ServerEnv.isEnabledVA() || !ReportEnv.isLive() && pathInfo.isLiveReport()) continue;
                        vector.add(this.charAt((PathInfoImpl)pathInfo));
                    }
                }
                return vector;
            }
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
        return null;
    }

    @Override
    public Vector getFileSysDirsInPath(String string, String string2) throws RptServerException {
        if (string2 != null && string2.startsWith("/USERFOLDERPATH")) {
            return new Vector(1);
        }
        try {
            return this.getFoldersInPath(string, string2);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
    }

    @Override
    public Vector getCatalogsInPath(String string, String string2) throws RptServerException {
        try {
            return this.SEDU(string, string2, (byte)1);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
    }

    @Override
    public Vector getLCsInPath(String string, String string2) throws RptServerException {
        try {
            return this.SEDU(string, string2, (byte)4);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
    }

    private Vector SEDU(String string, String string2, byte by) throws NoPrivilegeException, UnknownResource {
        if (string2.length() > 1 && string2.endsWith("/") && !string2.endsWith(">/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        Node node = this.addResource.getNodeByPath(string2, string);
        Vector<PathInfoImpl> vector = null;
        if (node != null && node.getNodeType() == 1) {
            PathInfo pathInfo;
            Resource resource;
            int n;
            Vector vector2;
            if (!this.addResource.getResourceAliasManager().isAliasNode(string2, string)) {
                vector2 = this.addResource.getResources((Folder)node, string);
                int n2 = vector2.size();
                vector = new Vector<PathInfoImpl>(n2);
                for (n = 0; n < n2; ++n) {
                    resource = (Resource)vector2.elementAt(n);
                    this.addResource.checkLinkedCatalog((NodeImpl)((Object)resource));
                    resource = (Resource)this.addResource.checkNode(resource, string2 + "/" + resource.getName(), string);
                    if (resource.getResourceType() != by || (pathInfo = resource.toPathInfo(string)).isJDashboard() && !ServerEnv.isEnabledDashboard() || pathInfo.isVA() && !ServerEnv.isEnabledVA() || !ReportEnv.isLive() && pathInfo.isLiveReport()) continue;
                    vector.add(this.charAt((PathInfoImpl)pathInfo));
                }
            }
            vector2 = null;
            if (this.addResource.getResourceAliasManager().isAliasNode(string2, string) || this.addResource.getResourceAliasManager().isAliasSubNode(string2, string) || string2.equalsIgnoreCase("/")) {
                vector2 = this.addResource.getAliasChildrenByPath(string2, string);
            }
            if (vector2 != null && vector2.size() > 0) {
                if (vector == null) {
                    vector = new Vector(vector2.size());
                }
                for (n = 0; n < vector2.size(); ++n) {
                    Node node2 = (Node)vector2.elementAt(n);
                    if (node2.getNodeType() != 2 || (resource = (Resource)node2).getResourceType() != by) continue;
                    this.addResource.checkLinkedCatalog((NodeImpl)((Object)resource));
                    pathInfo = resource.toPathInfo(string);
                    if (pathInfo.isJDashboard() && !ServerEnv.isEnabledDashboard() || pathInfo.isVA() && !ServerEnv.isEnabledVA() || !ReportEnv.isLive() && pathInfo.isLiveReport()) continue;
                    vector.add(this.charAt((PathInfoImpl)pathInfo));
                }
            }
        }
        return vector;
    }

    private Vector add(String string, String string2, String[] stringArray) throws NoPrivilegeException, UnknownResource {
        Vector<File> vector = new Vector<File>();
        try {
            String string3;
            if (string2 != null && string2.length() > 0 && (string3 = this.getRealPath(string, string2)) != null && string3.length() > 0) {
                int n;
                int n2 = string3.lastIndexOf("/");
                int n3 = n2 = n2 > (n = string3.lastIndexOf(File.separator)) ? n2 : n;
                if (n2 >= 0) {
                    string3 = string3.substring(0, n2);
                }
                File file = new File(string3);
                String string4 = null;
                File[] fileArray = file.listFiles();
                block2: for (int i = 0; i < fileArray.length; ++i) {
                    String string5 = fileArray[i].getName();
                    if (string5.lastIndexOf(46) != -1) {
                        string4 = string5.substring(string5.lastIndexOf(46));
                    }
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (!stringArray[j].equalsIgnoreCase(string4)) continue;
                        vector.add(fileArray[i]);
                        continue block2;
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new UnknownResource(exception);
        }
        return vector;
    }

    @Override
    public Vector getFileSysFilesInPath(String string, String string2) throws RptServerException {
        return new Vector(1);
    }

    @Override
    public Vector getReports(String string, String string2) throws RptServerException {
        Vector<JRRemotePathInfo> vector = null;
        try {
            if (string2 != null && string2.startsWith("/USERFOLDERPATH")) {
                vector = new Vector<JRRemotePathInfo>(8);
                String string3 = this.getRealPath(string, string2);
                if (string3 != null) {
                    File file;
                    String[] stringArray;
                    int n;
                    int n2 = string3.lastIndexOf("/");
                    int n3 = n2 = n2 > (n = string3.lastIndexOf(File.separator)) ? n2 : n;
                    if (n2 >= 0) {
                        string3 = string3.substring(0, n2);
                    }
                    if ((stringArray = (file = new File(string3)).list((FilenameFilter)new WildcardMatcher("*.cls", true, 2))) != null && stringArray.length > 0) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            JRRemotePathInfo jRRemotePathInfo = new JRRemotePathInfo(string, string2 + (string2.endsWith("/") ? "" : "/") + stringArray[i], this.SEDU);
                            if (ServerEnv.shouldStartRMI()) {
                                UnicastRemoteObject.exportObject((Remote)jRRemotePathInfo, CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
                            }
                            vector.addElement(jRRemotePathInfo);
                        }
                    }
                }
                return vector;
            }
            return null;
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
    }

    private Vector addElement(String string, String string2, Vector vector, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws RptServerException {
        Vector<JRRemotePathInfo> vector2 = null;
        int n = vector == null ? 0 : vector.size();
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        AdminService adminService = httpRptServer.getAdminService();
        SecurityAdminService securityAdminService = adminService.getSecurityAdminService();
        String string3 = securityAdminService.getActiveRealm();
        if (n > 0) {
            vector2 = new Vector<JRRemotePathInfo>(n);
            try {
                for (int i = 0; i < n; ++i) {
                    JRRemotePathInfo jRRemotePathInfo;
                    String string4;
                    String string5 = (String)vector.elementAt(i);
                    int n2 = string5.length();
                    if (bl) {
                        string4 = string2 + (string2.endsWith("/") ? "" : "/") + string5.substring(0, n2 - 3);
                        if (!httpRptServer.getHttpUserSessionManager().getAuthenticator().isPermissionOk(string3, string, string4, "node_visible") || string5.charAt(n2 - 2) != '1') continue;
                        jRRemotePathInfo = new JRRemotePathInfo(string, string4, this.SEDU);
                        if (ServerEnv.shouldStartRMI()) {
                            UnicastRemoteObject.exportObject((Remote)jRRemotePathInfo, CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
                        }
                        vector2.addElement(jRRemotePathInfo);
                        continue;
                    }
                    if (bl2) {
                        string4 = string2 + (string2.endsWith("/") ? "" : "/") + string5.substring(0, n2 - 3);
                        if (!httpRptServer.getHttpUserSessionManager().getAuthenticator().isPermissionOk(string3, string, string4, "node_visible") || string5.charAt(n2 - 2) != '1') continue;
                        vector2.addElement(new JRRemotePathInfo(string, string4, this.SEDU));
                        continue;
                    }
                    if (bl3) {
                        string4 = string2 + (string2.endsWith("/") ? "" : "/") + string5.substring(0, n2 - 2);
                        if (!httpRptServer.getHttpUserSessionManager().getAuthenticator().isPermissionOk(string3, string, string4, "node_visible") || string5.charAt(n2 - 2) != '2') continue;
                        vector2.addElement(new JRRemotePathInfo(string, string4, this.SEDU));
                        continue;
                    }
                    if (bl4) {
                        string4 = string2 + (string2.endsWith("/") ? "" : "/") + string5.substring(0, n2 - 1);
                        if (!httpRptServer.getHttpUserSessionManager().getAuthenticator().isPermissionOk(string3, string, string4, "node_visible")) continue;
                        vector2.addElement(new JRRemotePathInfo(string, string4, this.SEDU));
                        continue;
                    }
                    string4 = string2 + (string2.endsWith("/") ? "" : "/") + string5.substring(0, n2 - 3);
                    if (!httpRptServer.getHttpUserSessionManager().getAuthenticator().isPermissionOk(string3, string, string4, "node_visible")) continue;
                    if (string5.endsWith("120")) {
                        jRRemotePathInfo = new JRRemotePathInfo(string, string2, this.SEDU, true);
                        if (ServerEnv.shouldStartRMI()) {
                            UnicastRemoteObject.exportObject((Remote)jRRemotePathInfo, CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
                        }
                        vector2.addElement(jRRemotePathInfo);
                        continue;
                    }
                    vector2.addElement(new JRRemotePathInfo(string, string4, this.SEDU));
                }
            }
            catch (Exception exception) {
                throw new RptServerException(exception);
            }
        }
        return vector2;
    }

    @Override
    public String getRoot() {
        return ServerEnv.getResourceRoot();
    }

    @Override
    public String getTempDir() {
        return this.add;
    }

    @Override
    public String getHistDir() {
        return this.addElement;
    }

    @Override
    public String getRealPath(String string, String string2) throws RptServerException, RemoteException {
        return this.getPathInfo(string, string2).getRealPath();
    }

    @Override
    public String getRptRealPath(String string, String string2, String string3) throws RptServerException, RemoteException {
        return this.getPathInfo(string, string3).getRealPath();
    }

    public RptResourceManager getRptResourceManager() {
        return this.SEDU;
    }

    @Override
    public String getSchedulePath() {
        String string;
        File file;
        String string2 = ServerEnv.realmsPath;
        if (!string2.endsWith(CSUtil.fileSep)) {
            string2 = string2 + CSUtil.fileSep;
        }
        if (!(file = new File(string = string2 + this.getRealm() + CSUtil.fileSep + "schedule" + CSUtil.fileSep)).exists()) {
            file.mkdir();
        }
        return string;
    }

    @Override
    public boolean isShared(String string, String string2) throws RptServerException {
        return this.getPathInfo(string, string2).isShared();
    }

    @Override
    public boolean isShared(String string, String string2, String string3) throws RptServerException {
        return this.getPathInfo(string, string3).isShared();
    }

    @Override
    public boolean isNodeExist(String string, String string2) throws RptServerException, RemoteException {
        return this.addResource.isNodeExist(string, string2);
    }

    @Override
    public String getHomePath() {
        String string = ServerEnv.homePath;
        if (string != null && !string.endsWith(CSUtil.fileSep)) {
            string = string + CSUtil.fileSep;
        }
        return string;
    }

    @Override
    public String getFontPath() {
        return ServerEnv.getFontPath();
    }

    @Override
    public Vector getImagesByCatalog(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        String[] stringArray = new String[]{".bmp", ".jpg", ".jpeg", ".gif", ".png"};
        return this.add(string, string2, stringArray);
    }

    @Override
    public Vector getReportsInPath(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        return this.SEDU(string, string2, (byte)2);
    }

    @Override
    public Vector getDashboardsInPath(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        Vector<PathInfo> vector = new Vector<PathInfo>();
        Vector vector2 = this.getReportsInPath(string, string2);
        for (PathInfo pathInfo : vector2) {
            if (!pathInfo.isJDashboard()) continue;
            vector.add(pathInfo);
        }
        return vector;
    }

    @Override
    public Vector getResultsInPath(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        return this.SEDU(string, string2, (byte)3);
    }

    @Override
    public Vector getFoldersInPath(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        if (string2.length() > 1 && string2.endsWith("/") && !string2.endsWith(">/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        Node node = this.addResource.getNodeByPath(string2, string);
        Vector<PathInfoImpl> vector = null;
        if (node != null && node.getNodeType() == 1) {
            Vector vector2;
            if (!this.addResource.getResourceAliasManager().isAliasNode(string2, string)) {
                vector2 = this.addResource.getSubFolders((Folder)node, string);
                int n = vector2.size();
                vector = new Vector<PathInfoImpl>(n);
                for (int i = 0; i < n; ++i) {
                    Node node2 = (Node)vector2.elementAt(i);
                    this.addResource.checkLinkedCatalog((NodeImpl)node2);
                    node2 = this.addResource.checkNode(node2, string2 + "/" + node2.getName(), string);
                    vector.add(this.charAt((PathInfoImpl)node2.toPathInfo(string)));
                }
            }
            vector2 = null;
            if (this.addResource.getResourceAliasManager().isAliasNode(string2, string) || this.addResource.getResourceAliasManager().isAliasSubNode(string2, string) || string2.equalsIgnoreCase("/")) {
                vector2 = this.addResource.getAliasChildrenByPath(string2, string);
            }
            if (vector2 != null) {
                for (Node node2 : vector2) {
                    Node node3 = node2;
                    if (node3.getNodeType() != 1) continue;
                    this.addResource.checkLinkedCatalog((NodeImpl)node3);
                    vector.add(this.charAt((PathInfoImpl)node3.toPathInfo(string)));
                }
            }
        }
        return vector;
    }

    @Override
    public String getRptRealPath(String string, String string2) throws RptServerException, RemoteException {
        return this.getPathInfo(string, string2).getRealPath();
    }

    @Override
    public Vector getRptRefResource(String string, String string2) throws RptServerException, RemoteException {
        try {
            Vector[] vectorArray = RefResource.getRptFiles(string2);
            Vector<String> vector = new Vector<String>();
            if (vectorArray != null) {
                for (int i = 0; i < vectorArray.length; ++i) {
                    Vector vector2 = vectorArray[i];
                    if (vector2 == null) continue;
                    for (int j = 0; j < vector2.size(); ++j) {
                        Object e = vector2.elementAt(j);
                        if (!(e instanceof String)) continue;
                        vector.addElement((String)e);
                    }
                }
            }
            return vector;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw new RptServerException(exception);
        }
    }

    private Vector addResource(String string, String string2, byte by) throws NoPrivilegeException, UnknownResource, RemoteException {
        Vector vector = null;
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node != null && node.getNodeType() == 2) {
            Resource resource = (Resource)node;
            this.addResource.checkLinkedCatalog((NodeImpl)((Object)resource));
            PathInfo pathInfo = resource.toPathInfo(string);
            if (pathInfo.isJDashboard() && !ServerEnv.isEnabledDashboard()) {
                return null;
            }
            if (pathInfo.isVA() && !ServerEnv.isEnabledVA()) {
                return null;
            }
            if (resource.getResourceType() == by) {
                vector = this.addResult(string, resource);
            }
        }
        return vector;
    }

    @Override
    public Vector getCatalogVersions(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        return this.addResource(string, string2, (byte)1);
    }

    @Override
    public Vector getLCVersions(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        return this.addResource(string, string2, (byte)4);
    }

    @Override
    public Vector getReportVersions(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        return this.addResource(string, string2, (byte)2);
    }

    @Override
    public Vector getResultVersions(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        Resource resource;
        Vector vector = null;
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node != null && node.getNodeType() == 2 && (resource = (Resource)node).getResourceType() == 2 && resource.getResult() != null) {
            vector = this.addResult(string, resource.getResult());
        }
        return vector;
    }

    @Override
    public Vector getResultDocVersions(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        return this.addResource(string, string2, (byte)3);
    }

    private Vector addResult(String string, Resource resource) throws NoPrivilegeException {
        Vector<VersionRecord> vector = null;
        Vector vector2 = this.addResource.getVersions(resource, string);
        vector = new Vector<VersionRecord>(vector2.size());
        for (int i = 0; i < vector2.size(); ++i) {
            vector.addElement(((Version)vector2.elementAt(i)).toVersionRecord(this.addResource, string));
        }
        return vector;
    }

    @Override
    public void removeNode(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        Node node;
        Node node2 = this.addResource.getNodeByPath(string2, string);
        if (node2.isDynamic()) {
            throw new NoPrivilegeException(630009);
        }
        if (node2 != null && (node = node2.getParent()).getNodeType() == 1) {
            this.addResource.removeChild((Folder)node, node2, string);
        }
    }

    @Override
    public VersionRecord addResource(String string, String string2, Hashtable hashtable, int n) throws NoPrivilegeException, NodeExistsException, UnknownResource, RemoteException {
        return this.addResource(string, string2, hashtable, null, n);
    }

    @Override
    public VersionRecord addResource(String string, String string2, Hashtable hashtable, Hashtable[] hashtableArray, int n) throws NoPrivilegeException, NodeExistsException, UnknownResource, RemoteException {
        return this.addResource(string, string2, false, hashtable, hashtableArray, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionRecord addResource(String string, String string2, boolean bl, Hashtable hashtable, Hashtable[] hashtableArray, int n) throws NoPrivilegeException, NodeExistsException, UnknownResource, RemoteException {
        StorageEnv.setThreadMember(n);
        try {
            String string3;
            Node node;
            VersionRecord versionRecord = null;
            if (hashtableArray != null) {
                hashtable.put("jrs.permission_values", hashtableArray);
            }
            if ((node = this.addResource.getNodeByPath(string2, string)) != null && node.getNodeType() == 1) {
                ResourceInfo resourceInfo;
                File file;
                string3 = (String)hashtable.get("jrs.node_name");
                if (string3 == null || string3.trim().length() == 0 || !CSUtil.isValidNodeName(string3)) {
                    throw new UnknownResource(string3);
                }
                Folder folder = (Folder)node;
                if (folder.isFakeFolder()) {
                    folder = this.addResource.upgradeFakeFolder(folder);
                }
                if ((file = this.append(null, hashtable)) != null) {
                    StorageEnv.setThreadMember(-1);
                }
                if ((resourceInfo = ResourceToolkit.createResourceInfo(hashtable, string, folder, bl, this.addResource)) != null) {
                    String[] stringArray;
                    if (resourceInfo.getResourceType() == 2 && hashtable.get("jrs.node_status") == null) {
                        hashtable.put("jrs.node_status", String.valueOf(1));
                    }
                    Version version = this.addResource.addResource(folder, hashtable, resourceInfo, string);
                    if (CSUtil.getBoolean((String)hashtable.get("jrs.folder_with_contents"), false) && (stringArray = this.addResultInReport(hashtable)) != null) {
                        File file2 = new File(stringArray[0]);
                        ResourceToolkit.importResources(file2, folder, false, true, true, bl, this.addResource, string, true, stringArray[1], hashtable);
                    }
                    versionRecord = version == null ? null : version.toVersionRecord(this.addResource, string);
                } else {
                    ServiceLogger.logError(2620028, new Object[]{string2, string, hashtable}, 2);
                }
                if (file != null) {
                    CSUtil.deleteFolderTree(file.getParentFile());
                }
            } else {
                ServiceLogger.logError(2620027, new Object[]{string2, string}, 2);
            }
            string3 = versionRecord;
            return string3;
        }
        finally {
            StorageEnv.setThreadMember(-1);
        }
    }

    private String[] addResultInReport(Hashtable hashtable) {
        String string;
        byte by = (byte)CSUtil.parseInt((String)hashtable.get("jrs.node_type"), -1);
        if (by == -1) {
            return null;
        }
        switch (by) {
            case 2: {
                string = (String)hashtable.get("jrs.catalog");
                break;
            }
            case 0: {
                string = (String)hashtable.get("jrs.report");
                break;
            }
            case 4: {
                string = (String)hashtable.get("jrs.lc");
                break;
            }
            default: {
                return null;
            }
        }
        File file = new File(string);
        if (file.exists()) {
            String[] stringArray = new String[]{file.getParent(), file.getName()};
            return stringArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionRecord addResultInReport(String string, String string2, Hashtable hashtable, int n) throws NoPrivilegeException, UnknownResource, RemoteException {
        StorageEnv.setThreadMember(n);
        try {
            ResourceInfo resourceInfo;
            Node node = this.addResource.getNodeByPath(string2, string);
            if (node != null && node.getNodeType() == 2 && ((Resource)node).getResourceType() == 2) {
                resourceInfo = ResourceToolkit.createResourceInfo(hashtable, string, null, false, this.addResource);
                if (resourceInfo != null) {
                    Version version = this.addResource.addResult((Resource)node, hashtable, resourceInfo, string);
                    if (version != null) {
                        VersionRecord versionRecord = version.toVersionRecord(this.addResource, string);
                        return versionRecord;
                    }
                } else {
                    ServiceLogger.logError(2620029, new Object[]{string2, string, hashtable}, 2);
                }
            }
            resourceInfo = null;
            return resourceInfo;
        }
        finally {
            StorageEnv.setThreadMember(-1);
        }
    }

    @Override
    public void removeVersion(String string, int n) throws NoPrivilegeException, RemoteException {
        if (n == -1) {
            throw new NoPrivilegeException(630009);
        }
        this.addResource.removeVersion(n, string);
    }

    @Override
    public String addFolder(String string, String string2, Hashtable hashtable) throws NoPrivilegeException, NodeExistsException, UnknownResource, RemoteException {
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node.getNodeType() == 1) {
            Object object;
            String string3 = (String)hashtable.get("jrs.deploy_from_file");
            if (string3 == null) {
                string3 = (String)hashtable.get("jrs.node_real_path");
            }
            string3 = WebSecurityUtil.validateFilePathStr(string3);
            String string4 = (String)hashtable.get("jrs.node_name");
            boolean bl = CSUtil.getBoolean((String)hashtable.get("jrs.only_deploy_files_and_subfolders"), false);
            boolean bl2 = CSUtil.getBoolean((String)hashtable.get("jrs.only_deploy_files"), false);
            if (!(bl || bl2 || string4 != null && string4.trim().length() != 0 && CSUtil.isValidNodeName(string4))) {
                throw new UnknownResource(string4);
            }
            if (!(string3 == null || string3.trim().length() == 0 || ((File)(object = new File(string3))).exists() && ((File)object).isDirectory())) {
                return null;
            }
            object = null;
            object = bl || bl2 ? (Folder)node : this.addResource.addSubFolder((Folder)node, hashtable, string);
            if (object != null) {
                if (object.isFakeFolder()) {
                    object = this.addResource.upgradeFakeFolder((Folder)object);
                }
                if ((CSUtil.getBoolean((String)hashtable.get("jrs.folder_with_contents"), false) || bl || bl2) && string3 != null && string3.trim().length() != 0) {
                    ResourceToolkit.importResources(new File(string3), (Folder)object, true, true, CSUtil.getBoolean((String)hashtable.get("jrs.node_no_real_path"), false), this.addResource, string, bl2, hashtable);
                }
                return object.getAbsolutePath();
            }
        }
        return null;
    }

    @Override
    public String createFolder(String string, String string2, String string3, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource, RemoteException {
        Node node;
        if (string3 == null) {
            return null;
        }
        hashtable.put("jrs.node_name", string3);
        if (hashtableArray != null) {
            hashtable.put("jrs.permission_values", hashtableArray);
        }
        if ((node = this.addResource.getNodeByPath(string2, string)).getNodeType() == 1) {
            String string4 = WebSecurityUtil.validateFilePathStr((String)hashtable.get("jrs.deploy_local_style_dir"));
            ResourceToolkit.saveStyleFiles(string4);
            hashtable.put("createOnly", "true");
            Folder folder = this.addResource.addSubFolder((Folder)node, hashtable, string);
            if (folder != null) {
                return folder.getAbsolutePath();
            }
        }
        return null;
    }

    @Override
    public void addResourcesToFolder(String string, String string2, String string3, boolean bl, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource, RemoteException {
        Folder folder;
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node != null && node.getNodeType() == 1 && ((Folder)node).isFakeFolder()) {
            node = this.addResource.upgradeFakeFolder((Folder)node);
        }
        if (hashtableArray != null) {
            hashtable.put("jrs.permission_values", hashtableArray);
        }
        if (string3 == null || string3.trim().length() == 0) {
            return;
        }
        File file = this.append(string3, hashtable);
        if (node.getNodeType() == 1 && (folder = (Folder)node) != null) {
            ResourceToolkit.importResources(file == null ? new File(string3) : file, folder, true, true, true, this.addResource, string, !bl, hashtable);
        }
        if (file != null) {
            CSUtil.deleteFolderTree(file.getParentFile());
        }
    }

    @Override
    public String addResourcesToFolder(String string, String string2, String string3, boolean bl, boolean bl2, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource, RemoteException {
        Folder folder;
        String string4 = null;
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node != null && node.getNodeType() == 1 && ((Folder)node).isFakeFolder()) {
            node = this.addResource.upgradeFakeFolder((Folder)node);
        }
        if (hashtableArray != null) {
            hashtable.put("jrs.permission_values", hashtableArray);
        }
        if (string3 == null || string3.trim().length() == 0) {
            return null;
        }
        File file = this.append(string3, hashtable);
        if (node.getNodeType() == 1 && (folder = (Folder)node) != null) {
            string4 = ResourceToolkit.importResources(file == null ? WebSecurityUtil.validateFilePath(string3) : file, folder, true, true, true, bl2, this.addResource, string, !bl, null, hashtable);
        }
        if (file != null) {
            CSUtil.deleteFolderTree(file.getParentFile());
        }
        return string4;
    }

    @Override
    public Vector getAllUsers(String string) throws RemoteException {
        SecurityService securityService = this.addResource.getSecurityService();
        if (securityService.isAdminUser(string)) {
            return securityService.getAllUsersName();
        }
        if (securityService.isOrganizationAdminUser(string)) {
            String string2 = CSUtil.parsePrincipalDisplayName(string)[0];
            try {
                List list = securityService.getAllUsers(string2);
                Vector<String> vector = new Vector<String>();
                for (User user : list) {
                    vector.add(user.getName());
                }
                return vector;
            }
            catch (NoSuchOrganizationException noSuchOrganizationException) {
                ServiceLogger.logError((Throwable)((Object)noSuchOrganizationException), 3);
            }
        }
        return null;
    }

    @Override
    public Vector getUsersByRole(String string, String string2) throws NoSuchRoleException, RemoteException {
        if (this.addResource.getSecurityService().isAdminUser(string)) {
            return this.addResource.getSecurityService().getUsersNameByRole(string2);
        }
        return null;
    }

    @Override
    public Vector getAllRoles(String string) throws RemoteException {
        SecurityService securityService = this.addResource.getSecurityService();
        if (securityService.isAdminUser(string)) {
            return securityService.getAllRolesName();
        }
        if (securityService.isOrganizationAdminUser(string)) {
            String string2 = CSUtil.parsePrincipalDisplayName(string)[0];
            try {
                List list = securityService.getAllRoles(string2);
                Vector<String> vector = new Vector<String>();
                for (Role role : list) {
                    vector.add(role.getName());
                }
                return vector;
            }
            catch (NoSuchOrganizationException noSuchOrganizationException) {
                ServiceLogger.logError((Throwable)((Object)noSuchOrganizationException), 3);
            }
        }
        return null;
    }

    @Override
    public Vector getRolesByUser(String string, String string2) throws NoSuchUserException, RemoteException {
        if (this.addResource.getSecurityService().isAdminUser(string)) {
            return this.addResource.getSecurityService().getRolesNameByUser(string2);
        }
        return null;
    }

    @Override
    public Vector getReferUsers(String string) throws NoSuchUserException, RemoteException {
        return this.addResource.getSecurityService().getReferUsers(string);
    }

    @Override
    public Vector getReferRoles(String string) throws NoSuchUserException, RemoteException {
        return this.addResource.getSecurityService().getReferRoles(string);
    }

    @Override
    public Vector getReferGroups(String string) throws NoSuchUserException, RemoteException {
        return this.addResource.getSecurityService().getReferGroups(string);
    }

    @Override
    public Hashtable[] getPermissions(String string, String string2, int n) throws NoPrivilegeException, UnknownResource, RemoteException {
        return this.addResource.getPermissions(string2, n, string);
    }

    @Override
    public Hashtable[] getInheritedPermissions(String string, String string2, int n) throws NoPrivilegeException, UnknownResource, RemoteException {
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
        String string3 = CSUtil.getVirtualResourcePathPrefix(stringArray[0]);
        if (string2 == null || string2.trim().equals(string3 + "/") || string2.trim().equals(string3 + "/COMPONENT_LIB")) {
            return null;
        }
        Hashtable[] hashtableArray = null;
        if (n > 0) {
            hashtableArray = this.getPermissions(string, string2, 0);
            return hashtableArray == null ? this.getInheritedPermissions(string, string2, 0) : hashtableArray;
        }
        if (n == 0) {
            String string4 = string2.substring(0, string2.lastIndexOf("/"));
            if (string4.equals(string3) || string4.length() == 0) {
                string4 = string4 + "/";
            }
            return (hashtableArray = this.getPermissions(string, string4, 0)) == null ? this.getInheritedPermissions(string, string4, 0) : hashtableArray;
        }
        return null;
    }

    @Override
    public void setPermissions(String string, String string2, int n, Hashtable[] hashtableArray) throws NoPrivilegeException, UnknownResource, RemoteException {
        this.addResource.setPermissions(string2, n, hashtableArray, string);
    }

    @Override
    public String getRealPathOfNode(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node == null) {
            throw new UnknownResource(string2);
        }
        switch (node.getNodeType()) {
            case 1: {
                return ((Folder)node).getRealPath();
            }
            case 2: {
                return ((Resource)node).getRealDir();
            }
        }
        throw new UnknownResource(string2);
    }

    @Override
    public int getLatestVersinNumber(String string) throws RemoteException, UnknownResource {
        return this.getLatestVersinNumber(string, "JReport_System_User");
    }

    @Override
    public int getLatestVersinNumber(String string, String string2) throws RemoteException, UnknownResource {
        try {
            Node node = this.addResource.getNodeByPath(string, string2);
            if (node.getNodeType() == 2) {
                return ((Resource)node).getLatestVersionNumber();
            }
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError(noPrivilegeException.getMessage());
        }
        return -1;
    }

    @Override
    public String getRealPath(String string, String string2, int n) throws RemoteException, NoPrivilegeException, UnknownResource {
        if (n < 1) {
            try {
                return this.getRealPath(string, string2);
            }
            catch (RptServerException rptServerException) {
                ServiceLogger.logError((Throwable)((Object)rptServerException), 6);
                return null;
            }
        }
        Version version = this.addResource.getVersion(string2, n, string);
        if (version != null) {
            return version.getEntity().getRealPath();
        }
        return null;
    }

    @Override
    public void setNodeProperties(String string, String string2, int n, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, UnknownResource, RemoteException {
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node.getNodeType() == 2 && n != 0 && !node.isDynamic()) {
            node = this.addResource.getVersion(string2, n, string);
        }
        try {
            this.addResource.setNodeProperties(node, hashtable, hashtableArray, string);
        }
        catch (NodeExistsException nodeExistsException) {
            throw new RemoteException("", (Throwable)((Object)nodeExistsException));
        }
    }

    @Override
    public void setNodeProperties(String string, String string2, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource, RemoteException {
        Node node = this.addResource.getNodeByPath(string2, string);
        hashtable.put("jrs.node_path", string2);
        this.addResource.setNodeProperties(node, hashtable, hashtableArray, string);
    }

    @Override
    public void setResultVersionProperties(String string, String string2, int n, Hashtable hashtable) throws NoPrivilegeException, UnknownResource, RemoteException {
        Version version;
        Resource resource;
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node != null && node.getNodeType() == 2 && (resource = (Resource)node).getResourceType() == 2 && resource.getResult() != null && (version = !resource.isDynamic() ? this.addResource.getVersion(resource.getResult().getAbsolutePath(), n, string) : this.addResource.getVersion(resource.getResult(), n, string)) != null) {
            try {
                this.addResource.setNodeProperties(version, hashtable, null, string);
            }
            catch (NodeExistsException nodeExistsException) {
                throw new RemoteException("", (Throwable)((Object)nodeExistsException));
            }
        }
    }

    @Override
    public boolean checkPermission(String string, String string2, Permission permission) throws NoSuchUserException, UnknownResource, RemoteException {
        return this.addResource.checkPermission(string, string2, permission);
    }

    @Override
    public boolean checkPermission(String string, int n, String string2, Permission permission) throws NoSuchUserException, UnknownResource, RemoteException {
        return this.addResource.checkPermission(string, n, string2, permission);
    }

    @Override
    public CatalogVersionRecord getCatalogVersion(String string, String string2, int n) throws NoPrivilegeException, UnknownResource, RemoteException {
        return (CatalogVersionRecord)this.addSubFolder(string, string2, n, (byte)1);
    }

    @Override
    public LCVersionRecord getLCVersion(String string, String string2, int n) throws NoPrivilegeException, UnknownResource, RemoteException {
        return (LCVersionRecord)this.addSubFolder(string, string2, n, (byte)4);
    }

    @Override
    public ReportVersionRecord getReportVersion(String string, String string2, int n) throws NoPrivilegeException, UnknownResource, RemoteException {
        return (ReportVersionRecord)this.addSubFolder(string, string2, n, (byte)2);
    }

    @Override
    public ResultVersionRecord getResultVersion(String string, String string2, int n) throws NoPrivilegeException, UnknownResource, RemoteException {
        Resource resource;
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node != null && node.getNodeType() == 2 && (resource = (Resource)node).getResourceType() == 2 && resource.getResult() != null) {
            Resource resource2 = resource.getResult();
            String string3 = resource2.getAbsolutePath();
            if (this.addResource.getResourceAliasManager().isAliasNode(string2, string) || this.addResource.getResourceAliasManager().isAliasSubNode(string2, string)) {
                string3 = string2 + string3.substring(resource.getAbsolutePath().length());
            }
            Version version = null;
            version = !resource.isDynamic() ? this.addResource.getVersion(string3, n, string) : this.addResource.getVersion(resource.getResult(), n, string);
            if (version != null) {
                return (ResultVersionRecord)version.toVersionRecord(this.addResource, string);
            }
        }
        return null;
    }

    @Override
    public ResultVersionRecord getResultVersionByNodeID(String string) throws NoPrivilegeException, UnknownResource, RemoteException {
        return this.addResource.getResultVersionRecord(string);
    }

    @Override
    public ResultVersionRecord getResultDocVersion(String string, String string2, int n) throws NoPrivilegeException, UnknownResource, RemoteException {
        return (ResultVersionRecord)this.addSubFolder(string, string2, n, (byte)3);
    }

    @Override
    public VersionRecord getVersion(String string, String string2, int n) throws NoPrivilegeException, UnknownResource, RemoteException {
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node != null && node.getNodeType() == 2) {
            Resource resource = (Resource)node;
            this.addResource.checkLinkedCatalog((NodeImpl)((Object)resource));
            PathInfo pathInfo = resource.toPathInfo(string);
            if (pathInfo.isJDashboard() && !ServerEnv.isEnabledDashboard()) {
                return null;
            }
            if (pathInfo.isVA() && !ServerEnv.isEnabledVA()) {
                return null;
            }
            Version version = this.addResource.getVersion(string2, n, string);
            if (version != null) {
                return version.toVersionRecord(this.addResource, string);
            }
        }
        return null;
    }

    private Object addSubFolder(String string, String string2, int n, byte by) throws NoPrivilegeException, UnknownResource, RemoteException {
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node != null && node.getNodeType() == 2) {
            Version version;
            Resource resource = (Resource)node;
            this.addResource.checkLinkedCatalog((NodeImpl)((Object)resource));
            PathInfo pathInfo = resource.toPathInfo(string);
            if (pathInfo.isJDashboard() && !ServerEnv.isEnabledDashboard()) {
                return null;
            }
            if (pathInfo.isVA() && !ServerEnv.isEnabledVA()) {
                return null;
            }
            if (resource.getResourceType() == by && (version = this.addResource.getVersion(string2, n, string)) != null) {
                return version.toVersionRecord(this.addResource, string);
            }
        }
        return null;
    }

    @Override
    public String getArchivePath(String string) {
        String string2 = this.addResource.getVersionService().getArchivePath(string);
        return string2.substring(this.addElement.length());
    }

    @Override
    public String getRptRealPath(String string, String string2, int n) throws Exception, RemoteException {
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node.getNodeType() == 2 && ((Resource)node).getResourceType() == 2) {
            Version version = this.addResource.getVersion(string2, n, string);
            ReportVersionRecord reportVersionRecord = (ReportVersionRecord)version.toVersionRecord(this.addResource, string);
            return reportVersionRecord.getRealPath();
        }
        return null;
    }

    @Override
    public String getArchivePath(String string, String string2) throws RemoteException {
        return this.addResource.getVersionService().getVersionFolderManager().getArchivePath(string, string2);
    }

    @Override
    public boolean deleteArchivePath(String string) throws RemoteException {
        return this.addResource.getVersionService().getVersionFolderManager().deleteArchivePath(string, true);
    }

    @Override
    public void setResultMaxVersionAmount(String string, String string2, int n) throws NoPrivilegeException, UnknownResource, RemoteException {
        Resource resource;
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node != null && node.getNodeType() == 2 && (resource = (Resource)node).getResourceType() == 2) {
            if (resource.isDynamic()) {
                this.addResource.setDynamicResultMaxVersionAmount(resource, n);
            } else {
                Resource resource2 = resource.getResult();
                if (resource2 == null) {
                    this.addResource.addResult(resource, n, string);
                } else {
                    this.addResource.setMaxVersionAmount(resource2, n);
                }
            }
        }
    }

    @Override
    public int getResultMaxVersionAmount(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        Resource resource;
        Node node = this.addResource.getNodeByPath(string2, string);
        if (node != null && node.getNodeType() == 2 && (resource = (Resource)node).getResourceType() == 2 && resource.getResult() != null) {
            if (!resource.isDynamic()) {
                return resource.getResult().getMaxVersionAmount();
            }
            return this.addResource.getDynamicResultMaxVersionAmount(resource.getAbsolutePath());
        }
        return 0;
    }

    @Override
    public boolean isAdminUser(String string) throws RemoteException {
        return this.addResource.getSecurityService().isAdminUser(string);
    }

    @Override
    public boolean isOrganizationAdminUser(String string) throws RemoteException {
        return this.addResource.getSecurityService().isOrganizationAdminUser(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishResultToVersion(String string, String string2, String string3, String string4, String string5, Properties properties, Properties properties2, String string6, int n) throws NoPrivilegeException, UnknownResource, RemoteException {
        StorageEnv.setThreadMember(n);
        try {
            String string7;
            Properties properties3 = this.addResultInReport.publishResultToVersion(string, string2, string3, string4, string5, properties, string6);
            Enumeration<Object> enumeration = properties2.keys();
            String string8 = (String)properties3.get("jrs.result");
            while (enumeration.hasMoreElements()) {
                String string9;
                boolean bl;
                string7 = (String)enumeration.nextElement();
                if (!string7.startsWith("jrs.report_sheet$") || !(bl = CSUtil.getBoolean(string9 = (String)properties2.get(string7), true))) continue;
                string7 = string7.substring("jrs.report_sheet".length() + 1);
                properties3.put(string7, string8);
            }
            if (string3.endsWith(".rst")) {
                properties3.put("jrs.rst_result", string8);
            }
            if (properties3.containsKey("jrs.param_file")) {
                properties2.remove("jrs.param_file");
            }
            properties3.putAll((Map<?, ?>)properties2);
            if (ServerEnv.isClusterEnabled()) {
                string7 = (String)properties3.remove("jrs.node_name");
                properties3.put("jrs.node_name", string7.replace('$', '-'));
            }
            this.addResultInReport(string6, string2, properties3, n);
        }
        finally {
            StorageEnv.setThreadMember(-1);
        }
    }

    @Override
    public Vector getAllInvalidDynamicNodes(String string) throws NoPrivilegeException, RemoteException {
        return this.addResource.getAllInvalidDynamicNodes(string);
    }

    @Override
    public void deleteInvalidDynamicNodes(String string, Vector vector) throws NoPrivilegeException, RemoteException {
        this.addResource.deleteInvalidDynamicNodes(string, vector);
    }

    @Override
    public void loadUserResAliasToMem(String string) {
        this.addResource.getResourceAliasManager().loadUserAliasToMem(string);
    }

    @Override
    public void rmUserResAliasFromMem(String string) {
        this.addResource.getResourceAliasManager().removeUserAliasFromMem(string);
    }

    @Override
    public String getInheritedLinkedCatalog(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        Node node = this.addResource.getNodeByPath(string2, string);
        return this.addResource.getInheritedLinkedCatalog(node, string);
    }

    @Override
    public boolean isCatalogLinked(String string, String string2) throws NoPrivilegeException, UnknownResource, RemoteException {
        return this.addResource.isCatalogLinked(string, string2);
    }

    @Override
    public void setResultVersionViewed(String string, String string2, int n, String string3, int n2) throws NoPrivilegeException, UnknownResource, RemoteException {
        this.addResource.setResultVersionViewed(string, string2, n, string3, n2);
    }

    @Override
    public Vector getEnabledCustomFieldNames() throws RemoteException {
        return this.addResource.getEnabledCustomFieldNames();
    }

    private File append(String string, Hashtable hashtable) throws RemoteException {
        if (ServerEnv.isClusterEnabled() && ServerEnv.hasClusterLicense()) {
            try {
                Object object;
                String string2;
                String string3;
                Member member = HttpUtil.getHttpRptServer().getClusterService().getLocalMember();
                String string4 = (String)hashtable.get("jrs.remote_host");
                String string5 = (String)hashtable.get("jrs.remote_port");
                if (string4 == null || string4.equals(member.getHost()) || ServerUtil.isLocalAddress(string4)) {
                    return null;
                }
                File file = new File(this.add + "upload" + System.currentTimeMillis());
                File file2 = new File(file, "deploy");
                String string6 = file2.getCanonicalPath();
                String string7 = "jrs.deploy_from_file";
                boolean bl = true;
                JRRemoteFileService jRRemoteFileService = new JRRemoteFileService(string4, Integer.parseInt(string5));
                if (string == null) {
                    string3 = (String)hashtable.get("jrs.deploy_from_file");
                    if (string3 == null) {
                        byte by = (byte)CSUtil.parseInt((String)hashtable.get("jrs.node_type"), -1);
                        if (by == -1) {
                            return null;
                        }
                        switch (by) {
                            case 2: {
                                string7 = "jrs.catalog";
                                break;
                            }
                            case 0: {
                                string7 = "jrs.report";
                                break;
                            }
                            case 4: {
                                string7 = "jrs.lc";
                                break;
                            }
                            default: {
                                return null;
                            }
                        }
                        string3 = (String)hashtable.get(string7);
                    }
                    if (string3 == null || !jRRemoteFileService.exists(string3)) {
                        return null;
                    }
                    if (jRRemoteFileService.isDirectory(string3)) {
                        string = string3;
                    } else {
                        bl = false;
                        string = jRRemoteFileService.getParent(string3);
                        string6 = new File(file2, jRRemoteFileService.getName(string3)).getCanonicalPath();
                    }
                }
                jRRemoteFileService.copyFromRemote(string, file2.getCanonicalPath(), bl);
                hashtable.put(string7, string6);
                string3 = (String)hashtable.get("jrs.deploy_local_font_dir");
                if (string3 != null && string3.trim().length() > 0 && jRRemoteFileService.isDirectory(string3)) {
                    File file3 = new File(file, "font");
                    jRRemoteFileService.copyFromRemote(string3, file3.getCanonicalPath(), false);
                    hashtable.put("jrs.deploy_local_font_dir", file3.getCanonicalPath());
                }
                if ((string2 = (String)hashtable.get("jrs.deploy_local_style_dir")) != null && string2.trim().length() > 0 && jRRemoteFileService.isDirectory(string2)) {
                    object = new File(file, "style");
                    jRRemoteFileService.copyFromRemote(string2, ((File)object).getCanonicalPath(), false);
                    hashtable.put("jrs.deploy_local_style_dir", ((File)object).getCanonicalPath());
                }
                if ((object = (String)hashtable.get("jrs.deploy_local_gisinfo_dir")) != null && ((String)object).trim().length() > 0 && jRRemoteFileService.isDirectory((String)object)) {
                    File file4 = new File(file, "gisinfo");
                    jRRemoteFileService.copyFromRemote((String)object, file4.getCanonicalPath(), false);
                    hashtable.put("jrs.deploy_local_gisinfo_dir", file4.getCanonicalPath());
                }
                return file2;
            }
            catch (Exception exception) {
                throw new RemoteException("", exception);
            }
        }
        return null;
    }

    @Override
    public List searchNodes(String string, String string2, int n) throws RemoteException {
        List list = this.addResource.searchNodes(string, string2, n);
        for (PathInfo pathInfo : list) {
            this.charAt((PathInfoImpl)pathInfo);
        }
        return list;
    }

    private PathInfoImpl charAt(PathInfoImpl pathInfoImpl) {
        if (!pathInfoImpl.isDynamic()) {
            String[] stringArray = CSUtil.parseVirtualResourcePath(pathInfoImpl.getPath());
            Map map = this.addResult.getNLSDisplays(stringArray[0], pathInfoImpl.getParentID(), pathInfoImpl.getName());
            pathInfoImpl.setDisplays(map);
        }
        return pathInfoImpl;
    }

    @Override
    public String getRootNodeDisplay(Locale locale) throws RemoteException {
        String string = null;
        TextNLSEntry textNLSEntry = this.addResult.getRootNLSEntry(locale);
        if (textNLSEntry != null) {
            string = textNLSEntry.getValueText();
        } else {
            Locale locale2 = NLSUtil.getParentLocale(locale);
            textNLSEntry = this.addResult.getRootNLSEntry(locale2);
            if (textNLSEntry != null) {
                string = textNLSEntry.getValueText();
            }
        }
        return string;
    }
}

