/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.admin;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.admin.AdminService;
import jet.server.api.admin.CatalogInfoManager;
import jet.server.api.admin.ClusterAdminService;
import jet.server.api.admin.ConnectionInfoProviderService;
import jet.server.api.admin.ConnectionPoolManager;
import jet.server.api.admin.DataManager;
import jet.server.api.admin.DynamicBVElementDisplayNameManager;
import jet.server.api.admin.DynamicConnectionManager;
import jet.server.api.admin.DynamicSecurityManager;
import jet.server.api.admin.OrganizationManager;
import jet.server.api.admin.ResourceAdminService;
import jet.server.api.admin.ResourceAliasManager;
import jet.server.api.admin.SecurityAdminService;
import jet.server.api.admin.cfg.ConfigService;
import jet.server.jrc.JRClusterService;
import jet.server.jrc.JRConnectionInfoProviderService;
import jet.server.jrc.JRDataService;
import jet.server.jrc.admin.JRCatalogInfoManager;
import jet.server.jrc.admin.JRClusterAdminService;
import jet.server.jrc.admin.JRConnectionPoolManager;
import jet.server.jrc.admin.JRDataManager;
import jet.server.jrc.admin.JRDynamicBVElementDisplayNameManager;
import jet.server.jrc.admin.JRDynamicConnectionManager;
import jet.server.jrc.admin.JRDynamicSecurityManager;
import jet.server.jrc.admin.JROrganizationManager;
import jet.server.jrc.admin.JRResourceAdminService;
import jet.server.jrc.admin.JRResourceAliasManager;
import jet.server.jrc.admin.JRSecurityAdminService;
import jet.server.jrserver.JRRptServer;
import jet.server.jrserver.cfg.JRConfigService;
import jet.server.log.ServiceLogger;

public class JRAdminService
implements AdminService {
    private JRSecurityAdminService SEDU = new JRSecurityAdminService();
    private JRClusterAdminService exportObject = null;
    private JRResourceAdminService getClusterService = null;
    private JRConfigService getDataService = null;
    private ConnectionPoolManager getRMIServerFixedPort = null;
    private DataManager logError = null;
    private ResourceAliasManager parseInt = null;
    private ConnectionInfoProviderService shouldStartRMI = null;
    private CatalogInfoManager unexportObject = null;
    private DynamicConnectionManager I = null;
    private OrganizationManager Z = null;
    private DynamicBVElementDisplayNameManager C = null;
    private DynamicSecurityManager B = null;

    public JRAdminService(JRRptServer jRRptServer) {
        this.getDataService = new JRConfigService(jRRptServer);
        this.getClusterService = new JRResourceAdminService();
        this.getRMIServerFixedPort = new JRConnectionPoolManager();
        JRClusterService jRClusterService = (JRClusterService)jRRptServer.getClusterService();
        if (jRClusterService != null) {
            this.exportObject = new JRClusterAdminService(jRClusterService, this.getDataService);
        }
        this.logError = new JRDataManager();
        this.parseInt = new JRResourceAliasManager();
        try {
            this.shouldStartRMI = new JRConnectionInfoProviderService();
            if (ServerEnv.shouldStartRMI()) {
                UnicastRemoteObject.exportObject((Remote)((Object)this.shouldStartRMI), CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        this.unexportObject = new JRCatalogInfoManager();
        this.I = new JRDynamicConnectionManager((JRDataService)jRRptServer.getDataService());
        this.C = new JRDynamicBVElementDisplayNameManager((JRDataService)jRRptServer.getDataService());
        this.Z = new JROrganizationManager();
        this.B = new JRDynamicSecurityManager(jRRptServer);
    }

    @Override
    public ClusterAdminService getClusterAdminService() {
        return this.exportObject;
    }

    @Override
    public ResourceAdminService getResourceAdminService() {
        return this.getClusterService;
    }

    @Override
    public SecurityAdminService getSecurityAdminService() {
        return this.SEDU;
    }

    @Override
    public ConfigService getConfigService() {
        return this.getDataService;
    }

    @Override
    public ConnectionPoolManager getConnectionPoolManager() {
        return this.getRMIServerFixedPort;
    }

    @Override
    public DataManager getDataManager() {
        return this.logError;
    }

    @Override
    public ResourceAliasManager getResourceAliasManager() {
        return this.parseInt;
    }

    @Override
    public ConnectionInfoProviderService getConnectionInfoProviderService() {
        return this.shouldStartRMI;
    }

    @Override
    public CatalogInfoManager getCatalogInfoManager() {
        return this.unexportObject;
    }

    @Override
    public DynamicConnectionManager getDynamicConnectionManager() {
        return this.I;
    }

    @Override
    public OrganizationManager getOrganizationManager() {
        return this.Z;
    }

    @Override
    public DynamicBVElementDisplayNameManager getDynamicBVElementDisplayNameManager() {
        return this.C;
    }

    @Override
    public DynamicSecurityManager getDynamicSecurityManager() {
        return this.B;
    }

    public void clearMem() {
        try {
            UnicastRemoteObject.unexportObject((JRConnectionInfoProviderService)this.shouldStartRMI, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            ServiceLogger.logError(noSuchObjectException);
        }
        this.shouldStartRMI = null;
    }
}

