/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.admin;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jet.cs.CSUtil;
import jet.cs.util.APIEnums;
import jet.server.api.RptServerException;
import jet.server.api.admin.DynamicBVElementDisplayNameManager;
import jet.server.api.admin.DynamicBVElementDisplayNameRecord;
import jet.server.api.cluster.ClusterException;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapFactory;
import jet.server.cluster.blocks.MapFlags;
import jet.server.cluster.blocks.MapListenerAdapter;
import jet.server.db.dynbvelename.DynamicBVElementDisplayNameDAO;
import jet.server.jrc.JRDataService;
import jet.server.log.ServiceLogger;

public class JRDynamicBVElementDisplayNameManager
implements DynamicBVElementDisplayNameManager {
    private DynamicBVElementDisplayNameDAO COMMON;
    private boolean SEDU;
    private Map add = null;
    private Map addListener = new HashMap();

    public JRDynamicBVElementDisplayNameManager(JRDataService jRDataService) {
        this.COMMON = new DynamicBVElementDisplayNameDAO(jRDataService.getDynamicDisplayNameTable(), jRDataService.getDynamicDisplayNameMappingTable());
        try {
            ClusterMap clusterMap = MapFactory.getCommonMap(this.getClass().getName());
            this.add = clusterMap;
            clusterMap.addListener(new MapListenerAdapter(){

                public void afterPut(String string, int n, Integer n2, DynamicBVElementDisplayNameRecord dynamicBVElementDisplayNameRecord, DynamicBVElementDisplayNameRecord dynamicBVElementDisplayNameRecord2, MapFlags mapFlags) {
                    ConcurrentHashMap<Integer, DynamicBVElementDisplayNameRecord> concurrentHashMap = (ConcurrentHashMap<Integer, DynamicBVElementDisplayNameRecord>)JRDynamicBVElementDisplayNameManager.this.addListener.get(dynamicBVElementDisplayNameRecord.getOrgName());
                    if (concurrentHashMap == null) {
                        concurrentHashMap = new ConcurrentHashMap<Integer, DynamicBVElementDisplayNameRecord>();
                        JRDynamicBVElementDisplayNameManager.this.addListener.put(dynamicBVElementDisplayNameRecord.getOrgName(), concurrentHashMap);
                    }
                    concurrentHashMap.put(dynamicBVElementDisplayNameRecord.getRecordID(), dynamicBVElementDisplayNameRecord);
                }

                public void afterRemove(String string, int n, Integer n2, DynamicBVElementDisplayNameRecord dynamicBVElementDisplayNameRecord, MapFlags mapFlags) {
                    if (dynamicBVElementDisplayNameRecord == null) {
                        return;
                    }
                    Map map = (Map)JRDynamicBVElementDisplayNameManager.this.addListener.get(dynamicBVElementDisplayNameRecord.getOrgName());
                    if (map != null) {
                        map.remove(dynamicBVElementDisplayNameRecord.getRecordID());
                    }
                }

                @Override
                public void afterDestroy(String string, int n) {
                    JRDynamicBVElementDisplayNameManager.this.addListener.clear();
                }
            });
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError((Throwable)((Object)clusterException));
            this.add = new ConcurrentHashMap();
        }
        this.COMMON();
    }

    private void COMMON() {
        if (this.SEDU) {
            return;
        }
        try {
            for (DynamicBVElementDisplayNameRecord dynamicBVElementDisplayNameRecord : this.COMMON.getDynamicDisplayNames(null, null)) {
                this.add.put(dynamicBVElementDisplayNameRecord.getRecordID(), dynamicBVElementDisplayNameRecord);
            }
            this.SEDU = false;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
    }

    public List getAllDynamicBVElementDisplayNames(String string, String string2) {
        if (string == null) {
            ArrayList arrayList = new ArrayList();
            this.SEDU(arrayList, this.add.values(), string2);
            return Collections.unmodifiableList(arrayList);
        }
        return this.getDynamicBVElementDisplayNames(string, string2);
    }

    public List getDynamicBVElementDisplayNames(String string, String string2) {
        ArrayList arrayList = new ArrayList();
        Map map = (Map)this.addListener.get(string);
        if (map != null) {
            this.SEDU(arrayList, map.values(), string2);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public int addDynamicBVElementDisplayName(DynamicBVElementDisplayNameRecord dynamicBVElementDisplayNameRecord, String string) throws RptServerException {
        try {
            dynamicBVElementDisplayNameRecord = dynamicBVElementDisplayNameRecord.clone();
            if (dynamicBVElementDisplayNameRecord.getPrincipal() == null || dynamicBVElementDisplayNameRecord.getPrincipal().trim().length() == 0) {
                dynamicBVElementDisplayNameRecord.setPrincipalType(APIEnums.PrincipalType.COMMON);
            }
            int n = this.COMMON.insertDynamicDisplayName(dynamicBVElementDisplayNameRecord);
            this.add.put(dynamicBVElementDisplayNameRecord.getRecordID(), dynamicBVElementDisplayNameRecord);
            return n;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            throw new RptServerException(sQLException);
        }
    }

    @Override
    public void updateDynamicBVElementDisplayName(DynamicBVElementDisplayNameRecord dynamicBVElementDisplayNameRecord, String string) throws RptServerException {
        try {
            dynamicBVElementDisplayNameRecord = dynamicBVElementDisplayNameRecord.clone();
            if (dynamicBVElementDisplayNameRecord.getPrincipal() == null || dynamicBVElementDisplayNameRecord.getPrincipal().trim().length() == 0) {
                dynamicBVElementDisplayNameRecord.setPrincipalType(APIEnums.PrincipalType.COMMON);
            }
            if (this.COMMON.updateDynamicDisplayName(dynamicBVElementDisplayNameRecord)) {
                this.add.put(dynamicBVElementDisplayNameRecord.getRecordID(), dynamicBVElementDisplayNameRecord);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            throw new RptServerException(sQLException);
        }
    }

    @Override
    public void removeDynamicBVElementDisplayName(int n, String string) throws RptServerException {
        try {
            this.COMMON.removeDynamicDisplayName(n);
            this.add.remove(n);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            throw new RptServerException(sQLException);
        }
    }

    private void SEDU(List list, Collection collection, String string) {
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
        String string2 = CSUtil.getVirtualResourcePathPrefix(stringArray[0]);
        for (DynamicBVElementDisplayNameRecord dynamicBVElementDisplayNameRecord : collection) {
            String string3 = dynamicBVElementDisplayNameRecord.getCatalog();
            if (string3.startsWith(string2 + "/USERFOLDERPATH" + "/") && !string3.startsWith(string2 + "/USERFOLDERPATH" + "/" + stringArray[1] + "/") || string3.startsWith(string2 + "/COMPONENT_LIB" + "/USERFOLDERPATH" + "/") && !string3.startsWith(string2 + "/COMPONENT_LIB" + "/USERFOLDERPATH" + "/" + stringArray[1] + "/")) continue;
            list.add(dynamicBVElementDisplayNameRecord.clone());
        }
    }
}

