/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.param;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import jet.exception.InvalidParameterException;
import jet.formula.ParamDesc;
import jet.parameter.runtime.ParameterRuntime;
import jet.server.log.ServiceLogger;

public class ParamDescsUtil {
    private Vector IsParameters;
    private Map SEDU = new HashMap();
    private boolean add;
    private int addAll;

    public ParamDescsUtil(List list) {
        this.setParams(list);
    }

    public ParamDescsUtil(ParamDesc[] paramDescArray) {
        this.setParams(paramDescArray);
    }

    protected ParamDescsUtil(ParamDescsUtil paramDescsUtil) {
        this.IsParameters = new Vector();
        for (ParamDesc paramDesc : paramDescsUtil.IsParameters) {
            ParamDesc paramDesc2 = (ParamDesc)paramDesc.clone();
            this.IsParameters.add(paramDesc2);
            this.SEDU.put(paramDesc2.getName(), paramDesc2);
        }
        this.add = paramDescsUtil.add;
        this.addAll = paramDescsUtil.addAll;
    }

    public void setParams(ParamDesc[] paramDescArray) {
        this.setParams(Arrays.asList(paramDescArray == null ? new ParamDesc[]{} : paramDescArray));
    }

    public void setParams(List vector) {
        if (vector == null) {
            vector = new Vector();
        }
        this.add = false;
        this.addAll = vector.size();
        HashSet hashSet = new HashSet(this.SEDU.keySet());
        this.SEDU.clear();
        for (ParamDesc paramDesc : vector) {
            this.SEDU.put(paramDesc.getName(), paramDesc);
            this.add = this.add || paramDesc.IsParameters() || paramDesc.isReferedBy();
        }
        if (hashSet.equals(this.SEDU.keySet()) && this.IsParameters != null) {
            vector = new Vector();
            for (ParamDesc paramDesc : this.IsParameters) {
                vector.add(this.SEDU.get(paramDesc.getName()));
            }
        }
        this.IsParameters = this.SEDU(vector);
        for (ParamDesc paramDesc : this.IsParameters) {
            String string;
            boolean bl = paramDesc.needLoadValueList();
            Vector vector2 = paramDesc.getValues();
            boolean bl2 = bl && !paramDesc.needLoadValueList();
            if (!bl2) continue;
            paramDesc.setDefaultIndex(0);
            if (!vector2.isEmpty() || (string = paramDesc.getDisplayValue(paramDesc.getValue(), Locale.getDefault())) == null || string.length() <= 0) continue;
            try {
                if (paramDesc.isMultipleValue()) {
                    paramDesc.setValue(new String[]{""}, Locale.getDefault());
                    continue;
                }
                paramDesc.setValue("", Locale.getDefault());
            }
            catch (InvalidParameterException invalidParameterException) {
                ServiceLogger.logError(invalidParameterException, 3);
            }
        }
    }

    private ParamDesc IsParameters(String string) {
        for (Map.Entry entry : this.SEDU.entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase(string)) continue;
            return (ParamDesc)entry.getValue();
        }
        return null;
    }

    public int size() {
        return this.addAll;
    }

    public boolean needValueChange() {
        return this.add;
    }

    public Collection getParamNames() {
        return this.SEDU.keySet();
    }

    public Vector getParams() {
        return this.IsParameters;
    }

    public Vector getSortedParams(List list) {
        return this.add(this.IsParameters, list);
    }

    public Vector getClonedParams() {
        Vector<ParamDesc> vector = new Vector<ParamDesc>();
        for (ParamDesc paramDesc : this.IsParameters) {
            vector.add((ParamDesc)paramDesc.clone());
        }
        return vector;
    }

    private Vector SEDU(List list) {
        Vector<ParamDesc> vector = new Vector<ParamDesc>();
        if (list == null) {
            return vector;
        }
        for (ParamDesc paramDesc : list) {
            if (vector.contains(paramDesc)) continue;
            int n = vector.size();
            if (paramDesc.IsParameters()) {
                for (int i = 0; i < vector.size(); ++i) {
                    if (((ParamDesc)vector.get(i)).IsParameters()) continue;
                    n = i;
                    break;
                }
            }
            if (paramDesc.isReferedBy() || paramDesc.isReferOther()) {
                n = this.addAll(paramDesc, vector);
            }
            vector.add(n, paramDesc);
        }
        return vector;
    }

    private Vector add(List list, List list2) {
        Vector<Object> vector = new Vector<Object>();
        if (list2 == null || list2.size() == 0) {
            vector.addAll(list);
            return vector;
        }
        for (String string : list2) {
            ParamDesc paramDesc = this.IsParameters(string);
            if (paramDesc == null) continue;
            int n = vector.size();
            if (paramDesc.isCascading()) {
                n = this.addAll(paramDesc, vector);
            }
            vector.add(n, paramDesc);
        }
        if (list.size() != vector.size()) {
            for (String string : list) {
                if (vector.contains(string)) continue;
                int n = vector.size();
                if (string.isCascading()) {
                    n = this.addAll((ParamDesc)string, vector);
                }
                vector.add(n, string);
            }
        }
        return vector;
    }

    private int addAll(ParamDesc paramDesc, List list) {
        Vector vector;
        int n;
        if (paramDesc.isReferedBy()) {
            n = list.size();
            vector = ParamDescsUtil.getReferedBy(paramDesc);
            for (Object object : vector) {
                int n2 = list.indexOf(object);
                if (n2 == -1) continue;
                n = Math.min(n, n2);
            }
            if (n != list.size()) {
                return n;
            }
        }
        if (paramDesc.isReferOther()) {
            n = -1;
            vector = ParamDescsUtil.getImportParams(paramDesc);
            for (Object object : vector) {
                ParamDesc paramDesc2 = this.IsParameters((String)object);
                int n3 = list.indexOf(paramDesc2);
                if (n3 == -1) continue;
                n = Math.max(n, n3 + 1);
            }
            if (n != -1) {
                return n;
            }
        }
        return list.size();
    }

    public static Vector getReferedBy(ParamDesc paramDesc) {
        return ParamDescsUtil.asList(null, paramDesc);
    }

    private static Vector asList(Vector vector, ParamDesc paramDesc) {
        if (paramDesc.isReferedBy()) {
            Object object;
            Vector vector2;
            if (vector == null) {
                vector = new Vector<Object>();
            }
            if ((vector2 = paramDesc.getReferedBy()) != null && !vector2.isEmpty()) {
                object = vector2.iterator();
                while (object.hasNext()) {
                    ParamDesc paramDesc2 = (ParamDesc)object.next();
                    if (vector.contains(paramDesc2)) continue;
                    vector.add(paramDesc2);
                    ParamDescsUtil.asList(vector, paramDesc2);
                }
            }
            Vector vector3 = vector2 = (object = paramDesc.getParameterRuntime()) == null ? null : object.getLowerLevelsByQuery();
            if (vector2 != null && !vector2.isEmpty()) {
                for (ParamDesc paramDesc3 : vector2) {
                    if (vector.contains(paramDesc3)) continue;
                    vector.add(paramDesc3);
                    ParamDescsUtil.asList(vector, paramDesc3);
                }
            }
        }
        return vector;
    }

    public static Vector getImportParams(ParamDesc paramDesc) {
        Vector vector = null;
        if (paramDesc.isReferOther()) {
            ParameterRuntime parameterRuntime;
            vector = new Vector();
            Vector vector2 = paramDesc.getImportParams();
            if (vector2 != null) {
                vector.addAll(vector2);
            }
            Vector vector3 = vector2 = (parameterRuntime = paramDesc.getParameterRuntime()) == null ? null : parameterRuntime.getParamsUsedInQuery();
            if (vector2 != null) {
                vector.addAll(vector2);
            }
        }
        return vector;
    }
}

