/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.paramlist;

import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import jet.cs.util.APIUtil;
import jet.server.api.UserPreferenceManager;
import jet.server.api.paramlist.ParamList;
import jet.server.api.paramlist.ParamValue;
import jet.server.api.paramlist.ReportParamList;
import jet.server.api.paramlist.SheetParamList;
import jet.server.intf.jrs.RemoteParameterRecorder;
import jet.server.jrserver.JRRptServer;
import jet.server.log.ServiceLogger;
import jet.server.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JRRemoteParameterRecorder
implements RemoteParameterRecorder {
    private static final long serialVersionUID = 7410598242537135023L;
    private String SEDU;
    private JRRptServer add;
    private Hashtable append;

    public JRRemoteParameterRecorder(JRRptServer jRRptServer, String string) throws RemoteException {
        this.SEDU = string;
        this.append = new Hashtable();
        this.add = jRRptServer;
    }

    private String SEDU(String string) {
        String string2 = this.SEDU + string + File.separator + "history-parameter.xml";
        return string2;
    }

    protected Document getDocument(String string) {
        return this.getDocument(string, false);
    }

    protected Document getDocument(String string, boolean bl) {
        Document document = null;
        document = this.append.containsKey(string) ? (Document)this.append.get(string) : XMLUtil.loadDocument(this.SEDU(string));
        if (bl && document != null) {
            this.append.put(string, document);
        }
        return document;
    }

    protected void save(String string, Document document) {
        if (document != null) {
            this.append.put(string, document);
            XMLUtil.saveDocument(document, this.SEDU(string));
        } else {
            this.append.remove(string);
            XMLUtil.deleteXMLFile(this.SEDU(string));
        }
    }

    @Override
    public Document getUserParameterRecords(String string) throws RemoteException {
        return this.getDocument(string, true);
    }

    @Override
    public void decreaseUserParameterRecordSize(String string, int n) throws RemoteException {
        Document document = this.getDocument(string);
        boolean bl = this.add(string);
        boolean bl2 = this.append(string);
        if (document == null) {
            return;
        }
        if (bl || bl2) {
            Element[] elementArray;
            Element element = document.getDocumentElement();
            for (Element element2 : elementArray = XMLUtil.getChildElements(element)) {
                List list = this.endsWith(element2, (byte)0);
                if (list == null || list.size() <= n) continue;
                for (int i = list.size() - 1; i >= n; --i) {
                    element2.removeChild((Node)list.get(i));
                }
            }
            this.save(string, document);
        }
    }

    @Override
    public void appendUsedParameter(String string, Document document) throws RemoteException {
        if (document == null) {
            return;
        }
        Document document2 = this.getDocument(string);
        if (document2 == null) {
            document2 = document;
        } else {
            String string2 = "report";
            Element element = document2.getDocumentElement();
            Element[] elementArray = XMLUtil.getChildElements(document.getDocumentElement());
            for (int i = 0; i < elementArray.length; ++i) {
                String string3 = XMLUtil.getAttribute(elementArray[i], string2);
                if (string3 == null || string3.trim().length() == 0) continue;
                Element element2 = XMLUtil.getElementByAttr(element, string2, string3);
                if (element2 == null) {
                    XMLUtil.insertElement(element, elementArray[i]);
                    continue;
                }
                Element[] elementArray2 = XMLUtil.getChildElements(elementArray[i]);
                for (int j = 0; j < elementArray2.length; ++j) {
                    XMLUtil.insertElement(element2, elementArray2[j]);
                }
            }
        }
        this.save(string, document2);
    }

    @Override
    public void modifyUsedParameter(String string, Document document) throws RemoteException {
        if (document == null) {
            return;
        }
        Document document2 = this.getDocument(string);
        if (document2 == null) {
            document2 = document;
        } else {
            Element element = document2.getDocumentElement();
            Element[] elementArray = XMLUtil.getChildElements(document.getDocumentElement());
            String string2 = "report";
            for (int i = 0; i < elementArray.length; ++i) {
                String string3 = XMLUtil.getAttribute(elementArray[i], string2);
                if (string3 == null || string3.trim().length() == 0) continue;
                Element element2 = XMLUtil.getElementByAttr(element, string2, string3);
                if (element2 == null) {
                    XMLUtil.insertElement(element, elementArray[i]);
                    continue;
                }
                Element[] elementArray2 = XMLUtil.getChildElements(elementArray[i]);
                for (int j = 0; j < elementArray2.length; ++j) {
                    byte by;
                    String string4 = this.equals(elementArray2[j]);
                    Element element3 = this.deleteXMLFile(element2, string4, by = this.equalsIgnoreCase(elementArray2[j]));
                    if (element3 != null) {
                        element2.removeChild(element3);
                    }
                    XMLUtil.insertElement(element2, elementArray2[j]);
                }
            }
        }
        this.save(string, document2);
    }

    @Override
    public void removeUsedParameter(String string, Document document) throws RemoteException {
        if (document == null) {
            return;
        }
        Document document2 = this.getDocument(string);
        if (document2 == null) {
            document2 = document;
        } else {
            Element element = document2.getDocumentElement();
            Element[] elementArray = XMLUtil.getChildElements(document.getDocumentElement());
            String string2 = "report";
            for (int i = 0; i < elementArray.length; ++i) {
                Element element2;
                String string3 = XMLUtil.getAttribute(elementArray[i], string2);
                if (string3 == null || string3.trim().length() == 0 || (element2 = XMLUtil.getElementByAttr(element, string2, string3)) == null) continue;
                Element[] elementArray2 = XMLUtil.getChildElements(elementArray[i]);
                for (int j = 0; j < elementArray2.length; ++j) {
                    byte by;
                    String string4 = this.equals(elementArray2[j]);
                    Element element3 = this.deleteXMLFile(element2, string4, by = this.equalsIgnoreCase(elementArray2[j]));
                    if (element3 == null) continue;
                    element2.removeChild(element3);
                }
                if (XMLUtil.getChildElement(element2) != null || this.error(element2)) continue;
                element.removeChild(element2);
            }
            if (XMLUtil.getChildElement(element) == null) {
                document2 = null;
            }
        }
        this.save(string, document2);
    }

    @Override
    public void deleteRptParameterRecords(String string) throws RemoteException {
        File file = new File(this.SEDU);
        if (!file.exists()) {
            return;
        }
        File file2 = null;
        String string2 = null;
        Document document = null;
        boolean bl = false;
        File[] fileArray = file.listFiles();
        String string3 = "report";
        for (int i = 0; i < fileArray.length; ++i) {
            file2 = fileArray[i];
            if (!file2.isDirectory()) continue;
            string2 = file2.getName();
            if (this.append.containsKey(string2)) {
                bl = true;
                document = (Document)this.append.get(string2);
            } else {
                document = XMLUtil.loadDocument(this.SEDU(string2));
            }
            if (document == null) continue;
            Element element = document.getDocumentElement();
            Element[] elementArray = XMLUtil.getChildElements(element);
            for (int j = 0; j < elementArray.length; ++j) {
                String string4 = XMLUtil.getAttribute(elementArray[j], string3);
                if (!string.equals(string4)) continue;
                element.removeChild(elementArray[j]);
                break;
            }
            if (bl) {
                this.append.put(string2, document);
            }
            XMLUtil.saveDocument(document, this.SEDU(string2));
        }
    }

    @Override
    public void deleteUserParameterRecord(String string) throws RemoteException {
        this.append.remove(string);
        File file = new File(this.SEDU(string));
        if (file.exists()) {
            file.delete();
        }
    }

    private boolean add(String string) {
        UserPreferenceManager userPreferenceManager = this.add.getUserPreferenceManager();
        Properties properties = userPreferenceManager.getUserPreference(string);
        return APIUtil.getBoolean(properties.getProperty("jrs.enable_save_used_parameter_values")) && APIUtil.getBoolean(properties.getProperty("jrs.isAuto_save_used_parameter_values"));
    }

    private boolean append(String string) {
        UserPreferenceManager userPreferenceManager = this.add.getUserPreferenceManager();
        Properties properties = userPreferenceManager.getUserPreference(string);
        return APIUtil.getBoolean(properties.getProperty("jrs.enable_save_used_parameter_values")) && !APIUtil.getBoolean(properties.getProperty("jrs.isAuto_save_used_parameter_values"));
    }

    private void appendChild(String string, String string2, String string3, byte by) {
        Document document = this.getDocument(string);
        if (document == null) {
            return;
        }
        Element element = document.getDocumentElement();
        Element element2 = XMLUtil.getElementByAttr(element, "report", string2);
        if (element2 == null) {
            return;
        }
        Element element3 = this.deleteXMLFile(element2, string3, by);
        if (element3 != null) {
            element2.removeChild(element3);
        }
        if (XMLUtil.getChildElement(element2) == null && !this.error(element2)) {
            element.removeChild(element2);
        }
        if (XMLUtil.getChildElement(element) == null) {
            document = null;
        }
        this.save(string, document);
    }

    private Element appendUsedParameter(String string, String string2, String string3, byte by) throws RemoteException {
        ServiceLogger.trace("ParamListManager:ParameterRecorder:findReportParamListNode...(reportPath=%s, reportParamListName=%s, reportParamListType=%s, userName=%s)", string2, string3, by, string);
        if (string3 == null || string3.trim().length() == 0) {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:findReportParamListNode: failed! reportParamListName is empty.", new Object[0]);
            return null;
        }
        Document document = this.getUserParameterRecords(string);
        if (document == null) {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:findReportParamListNode: failed! ducument is null.", new Object[0]);
            return null;
        }
        Element element = document.getDocumentElement();
        Element element2 = XMLUtil.getElementByAttr(element, "report", string2);
        if (element2 == null) {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:findReportParamListNode: failed! reportNode is null.", new Object[0]);
            return null;
        }
        Element[] elementArray = XMLUtil.getChildElements(element2);
        if (elementArray == null) {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:findReportParamListNode: failed! reportParamListNodes is null.", new Object[0]);
            return null;
        }
        Element element3 = null;
        for (Element element4 : elementArray) {
            String string4 = this.equals(element4);
            byte by2 = this.equalsIgnoreCase(element4);
            if (!string4.equals(string3) || by2 != by) continue;
            ServiceLogger.trace("ParamListManager:ParameterRecorder:findReportParamListNode: found!", new Object[0]);
            element3 = element4;
            break;
        }
        return element3;
    }

    private List containsKey(String string, String string2, byte by) throws RemoteException {
        ServiceLogger.trace("ParamListManager:ParameterRecorder:findReportParamListNodes...(reportPath=%s, reportParamListType=%s, userName=%s)", string2, by, string);
        Document document = this.getUserParameterRecords(string);
        if (document == null) {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:findReportParamListNodes: failed! ducument is null.", new Object[0]);
            return null;
        }
        Element element = document.getDocumentElement();
        Element element2 = XMLUtil.getElementByAttr(element, "report", string2);
        if (element2 == null) {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:findReportParamListNodes: failed! reportNode is null.", new Object[0]);
            return null;
        }
        Element[] elementArray = XMLUtil.getChildElements(element2);
        if (elementArray == null) {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:findReportParamListNodes: failed! reportParamListNodes is null.", new Object[0]);
            return null;
        }
        LinkedList<Element> linkedList = new LinkedList<Element>();
        for (Element element3 : elementArray) {
            byte by2 = this.equalsIgnoreCase(element3);
            if (by2 != by) continue;
            linkedList.add(element3);
        }
        return linkedList;
    }

    private void createElement(Element element, Map map) {
        if (map != null) {
            for (String string : map.keySet()) {
                String string2 = (String)map.get(string);
                element.setAttribute(string, string2);
            }
        }
    }

    private Map currentTimeMillis(Element element) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            for (int i = namedNodeMap.getLength() - 1; i >= 0; --i) {
                Node node = namedNodeMap.item(i);
                String string = node.getNodeName();
                String string2 = node.getNodeValue();
                hashMap.put(string, string2);
            }
        }
        return hashMap;
    }

    private boolean delete(Document document, Element element, ParamList paramList) {
        List<ParamValue> list = paramList.getParamValues();
        if (list == null) {
            return false;
        }
        for (ParamValue paramValue : list) {
            Element element2;
            block8: {
                String[] stringArray;
                String[] stringArray2;
                block6: {
                    block7: {
                        String string = paramValue.getName();
                        stringArray2 = paramValue.getValue();
                        stringArray = paramValue.getDisplayValue();
                        if (stringArray2 == null || stringArray2.length == 0) {
                            ServiceLogger.trace("ParamListManager:ParameterRecorder:createParamNodes failed! invalid parameter value(%s=%s).", string, stringArray2);
                            continue;
                        }
                        element2 = document.createElement("Param");
                        element2.setAttribute("name", string);
                        element2.setAttribute("type", paramValue.getType());
                        this.createElement(element2, paramValue.getAttributes());
                        if (stringArray2.length != 1) break block6;
                        if (!"\u0007".equals(stringArray2[0])) break block7;
                        Element element3 = document.createElement("Value");
                        element2.appendChild(element3);
                        element3.setAttribute("isAll", "true");
                        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null && stringArray[0].trim().length() > 0) {
                            element3.setTextContent(stringArray[0]);
                        }
                        break block8;
                    }
                    element2.setAttribute("value", stringArray2[0]);
                    if (stringArray == null || stringArray.length == 0 || stringArray[0] == null || stringArray[0].trim().length() <= 0) break block8;
                    element2.setAttribute("displayValue", stringArray[0]);
                    break block8;
                }
                if (stringArray == null || stringArray.length != stringArray2.length) {
                    ServiceLogger.error("ParamListManager:ParameterRecorder:createParamNodes warning! (value.length=%s, displayValue.length=%s)", stringArray2.length, stringArray == null ? 0 : stringArray.length);
                }
                for (int i = 0; i < stringArray2.length; ++i) {
                    Element element4 = document.createElement("Value");
                    element2.appendChild(element4);
                    element4.setAttribute("value", stringArray2[i]);
                    if (stringArray == null || stringArray.length <= i || stringArray[0] == null || stringArray[0].trim().length() <= 0) continue;
                    element4.setTextContent(stringArray[i]);
                }
            }
            element.appendChild(element2);
        }
        return true;
    }

    private Element deleteXMLFile(Element element, String string, byte by) {
        Element[] elementArray = XMLUtil.getChildElements(element);
        if (elementArray == null) {
            return null;
        }
        Element element2 = null;
        for (Element element3 : elementArray) {
            String string2 = this.equals(element3);
            byte by2 = this.equalsIgnoreCase(element3);
            if (!string2.equals(string) || by2 != by) continue;
            element2 = element3;
            break;
        }
        return element2;
    }

    private List endsWith(Element element, byte by) {
        Element[] elementArray = XMLUtil.getChildElements(element);
        if (elementArray == null) {
            return null;
        }
        LinkedList<Element> linkedList = new LinkedList<Element>();
        for (Element element2 : elementArray) {
            byte by2 = this.equalsIgnoreCase(element2);
            if (by2 != by) continue;
            linkedList.add(element2);
            break;
        }
        return linkedList;
    }

    private String equals(Element element) {
        String string = element.getAttribute("name");
        if (string == null || string.trim().length() == 0) {
            string = element.getNodeName();
        }
        return string;
    }

    private byte equalsIgnoreCase(Element element) {
        byte by = 0;
        String string = element.getAttribute("type");
        by = string != null && string.trim().length() > 0 ? Byte.parseByte(string) : ("true".equalsIgnoreCase(string = element.getAttribute("isAutosaveParam")) ? (byte)1 : 0);
        return by;
    }

    private boolean error(Element element) {
        String string = element.getAttribute("dontShowParam");
        return "true".equalsIgnoreCase(string);
    }

    private ReportParamList existReportParamList(Element element, String string) {
        if (element == null) {
            return null;
        }
        ReportParamList reportParamList = new ReportParamList(string, this.equalsIgnoreCase(element));
        reportParamList.setName(this.equals(element));
        Map map = this.currentTimeMillis(element);
        map.remove("name");
        map.remove("type");
        reportParamList.setAttributes(map);
        reportParamList.setSheetParamListMap(this.exists(element));
        reportParamList.setParamValues(this.getAttribute(element));
        return reportParamList;
    }

    private Map exists(Element element) {
        Element[] elementArray = XMLUtil.getChildElements(element);
        if (elementArray == null) {
            return null;
        }
        HashMap<String, SheetParamList> hashMap = new HashMap<String, SheetParamList>();
        for (Element element2 : elementArray) {
            String string = element2.getNodeName();
            if (!string.equalsIgnoreCase("SheetParamList")) continue;
            String string2 = element2.getAttribute("name");
            Map map = this.currentTimeMillis(element2);
            map.remove("name");
            List list = this.getAttribute(element2);
            SheetParamList sheetParamList = new SheetParamList(string2);
            sheetParamList.setParamValues(list);
            sheetParamList.setAttributes(map);
            hashMap.put(string2, sheetParamList);
        }
        return hashMap;
    }

    private String[] get(Element element) {
        String string = element.getAttribute("value");
        String string2 = element.getAttribute("displayValue");
        if (string == null || string.trim().length() == 0) {
            String string3;
            String string4 = element.getNodeName();
            if ("para".equals(string4)) {
                String string5 = element.getAttribute("ismultivalue_all");
                if ("true".equals(string5)) {
                    string = "\u0007";
                }
            } else if ("Value".equals(string4) && "true".equals(string3 = element.getAttribute("isAll"))) {
                string = "\u0007";
                string2 = element.getTextContent();
            }
        }
        return new String[]{string, string2};
    }

    private List getAttribute(Element element) {
        Element[] elementArray = XMLUtil.getChildElements(element);
        if (elementArray == null) {
            return null;
        }
        LinkedList<Serializable> linkedList = new LinkedList<Serializable>();
        for (Element element2 : elementArray) {
            Serializable serializable;
            Object object;
            Object object2;
            String string = element2.getNodeName();
            boolean bl = "para".equalsIgnoreCase(string);
            if (!"Param".equals(string) && !bl) continue;
            String string2 = element2.getAttribute("name");
            String string3 = element2.getAttribute("type");
            String[] stringArray = null;
            String[] stringArray2 = null;
            String[] stringArray3 = this.get(element2);
            String string4 = stringArray3[0];
            String string5 = stringArray3[1];
            if (string4 == null || string4.trim().length() == 0) {
                object2 = XMLUtil.getChildElements(element2);
                if (object2 != null) {
                    int n = ((Element[])object2).length;
                    stringArray = new String[n];
                    stringArray2 = new String[n];
                    for (int i = 0; i < n; ++i) {
                        Object object3 = object2[i];
                        if (!"Value".equals(object3.getNodeName())) continue;
                        stringArray3 = this.get((Element)object3);
                        object = stringArray3[0];
                        String string6 = stringArray3[1];
                        stringArray[i] = object;
                        if (string6 == null || string6.trim().length() <= 0) continue;
                        stringArray2[i] = string6;
                    }
                }
            } else {
                boolean bl2 = false;
                if (bl && string4 != null && string4.startsWith("[") && string4.endsWith("]")) {
                    serializable = new LinkedList();
                    StringTokenizer stringTokenizer = new StringTokenizer(string4.substring(1, string4.length() - 1), "][");
                    while (stringTokenizer.hasMoreElements()) {
                        serializable.add((String)stringTokenizer.nextElement());
                    }
                    stringArray = new String[serializable.size()];
                    for (int i = serializable.size() - 1; i >= 0; --i) {
                        stringArray[i] = (String)serializable.get(i);
                    }
                    if (string5 != null && string5.startsWith("[") && string5.endsWith("]")) {
                        LinkedList<String> linkedList2 = new LinkedList<String>();
                        object = new StringTokenizer(string4.substring(1, string5.length() - 1), "][");
                        while (((StringTokenizer)object).hasMoreElements()) {
                            linkedList2.add((String)stringTokenizer.nextElement());
                        }
                        stringArray2 = new String[linkedList2.size()];
                        for (int i = linkedList2.size() - 1; i >= 0; --i) {
                            stringArray2[i] = (String)linkedList2.get(i);
                        }
                    }
                    bl2 = true;
                }
                if (!bl2) {
                    if (string4 != null && string4.trim().length() != 0) {
                        stringArray = new String[]{string4};
                    }
                    if (string5 != null && string5.trim().length() > 0) {
                        stringArray2 = new String[]{string5};
                    }
                }
            }
            object2 = this.currentTimeMillis(element2);
            object2.remove("name");
            object2.remove("type");
            object2.remove("value");
            object2.remove("displayValue");
            serializable = new ParamValue(string2, string3, stringArray, stringArray2);
            ((ParamValue)serializable).setAttributes((Map<String, String>)object2);
            linkedList.add(serializable);
        }
        return linkedList;
    }

    private boolean getAttributes(Document document, String string, ReportParamList reportParamList) throws RemoteException {
        if (document == null) {
            return false;
        }
        Element element = document.getDocumentElement();
        Element element2 = XMLUtil.getElementByAttr(element, "report", string);
        if (element2 == null) {
            return false;
        }
        Element[] elementArray = XMLUtil.getChildElements(element2);
        if (elementArray == null) {
            return false;
        }
        for (Element element3 : elementArray) {
            byte by = this.equalsIgnoreCase(element3);
            List list = this.getAttribute(element3);
            Map map = this.exists(element3);
            if (by != reportParamList.getType() || !reportParamList.isParamValuesEquals(list) || !reportParamList.isSheetsEquals(map)) continue;
            return true;
        }
        return false;
    }

    private boolean getBoolean(Document document, String string, String string2, byte by) throws RemoteException {
        if (string2 == null || string2.trim().length() == 0) {
            return false;
        }
        if (document == null) {
            return false;
        }
        Element element = document.getDocumentElement();
        Element element2 = XMLUtil.getElementByAttr(element, "report", string);
        if (element2 == null) {
            return false;
        }
        Element[] elementArray = XMLUtil.getChildElements(element2);
        if (elementArray == null) {
            return false;
        }
        for (Element element3 : elementArray) {
            String string3 = this.equals(element3);
            byte by2 = this.equalsIgnoreCase(element3);
            if (!string3.equals(string2) || by2 != by) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean saveReportParamList(String string, ReportParamList reportParamList) throws RemoteException {
        Element[] elementArray;
        Element element;
        Node node;
        String string2;
        UserPreferenceManager userPreferenceManager = this.add.getUserPreferenceManager();
        Properties properties = userPreferenceManager.getUserPreference(string);
        boolean bl = this.add(string);
        boolean bl2 = this.append(string);
        int n = APIUtil.parseInt(properties.getProperty("max_autocomplete_list_num"));
        ServiceLogger.trace("ParamListManager:ParameterRecorder:saveReportParamList...(reportParamList=%s, userName=%s)", reportParamList, string);
        ServiceLogger.trace("ParamListManager:ParameterRecorder:saveReportParamList: load prefrence settings.(reportParamListMax=%s, autoSaveEnabled=%s, manualSaveEnabled=%s)", n, bl, bl2);
        if (reportParamList == null) {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:saveReportParamList failed! reportParamList is null.", new Object[0]);
            return false;
        }
        String string3 = reportParamList.getReportPath();
        if (string3 == null || string3.trim().length() == 0) {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:saveReportParamList failed! reportPath is empty.", new Object[0]);
            return false;
        }
        if (reportParamList.isDefault()) {
            string2 = "UserDefinedDefault";
        } else if (reportParamList.isAuto()) {
            if (!bl) {
                ServiceLogger.trace("ParamListManager:ParameterRecorder:saveReportParamList failed! autoSaveEnabled is false.", new Object[0]);
                return false;
            }
            string2 = "ParameterList" + String.valueOf(System.currentTimeMillis());
        } else if (reportParamList.isManual()) {
            if (!bl2) {
                ServiceLogger.trace("ParamListManager:ParameterRecorder:saveReportParamList failed! manualSaveEnabled is false.", new Object[0]);
                return false;
            }
            string2 = reportParamList.getName();
            if (string2 == null || string2.trim().length() == 0) {
                string2 = "ParameterList1";
            }
        } else {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:saveReportParamList failed! (type=%s)", reportParamList.getType());
            return false;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        Document document = this.getUserParameterRecords(string);
        if (document != null) {
            node = document.getDocumentElement();
            if (!reportParamList.isManual() && this.getAttributes(document, string3, reportParamList)) {
                ServiceLogger.trace("ParamListManager:ParameterRecorder:saveReportParamList failed! existed report parameter value list which values and type match with reportParamList.", new Object[0]);
                return false;
            }
            element = XMLUtil.getElementByAttr((Element)node, "report", string3);
            if (element != null) {
                if (reportParamList.isManual()) {
                    if (this.existReportParamList(string, string3, string2, (byte)0)) {
                        bl4 = true;
                    }
                } else if (reportParamList.isDefault() && this.getDefaultReportParamList(string, string3) != null) {
                    bl4 = true;
                }
                if (!bl4) {
                    elementArray = XMLUtil.getChildElements(element);
                    int n2 = 0;
                    for (Element object2 : elementArray) {
                        byte by = this.equalsIgnoreCase(object2);
                        if (by != reportParamList.getType()) continue;
                        ++n2;
                    }
                    if (n2 >= n) {
                        bl3 = true;
                    }
                }
            }
        }
        node = XMLUtil.newDocument();
        element = node.createElement("root");
        node.appendChild(element);
        ServiceLogger.trace("ParamListManager:ParameterRecorder:saveReportParamList: making report node...", new Object[0]);
        elementArray = node.createElement("history-parameter");
        element.appendChild((Node)elementArray);
        elementArray.setAttribute("report", string3);
        ServiceLogger.trace("ParamListManager:ParameterRecorder:saveReportParamList: making report parameter list node...", new Object[0]);
        Element element2 = node.createElement("ReportParamList");
        elementArray.appendChild(element2);
        element2.setAttribute("creattime", String.valueOf(System.currentTimeMillis()));
        element2.setAttribute("type", String.valueOf(reportParamList.getType()));
        element2.setAttribute("name", string2);
        this.createElement(element2, reportParamList.getAttributes());
        ServiceLogger.trace("ParamListManager:ParameterRecorder:saveReportParamList: making sheet parameter list nodes...", new Object[0]);
        Map<String, SheetParamList> map = reportParamList.getSheetParamListMap();
        if (map != null) {
            for (String string4 : map.keySet()) {
                SheetParamList sheetParamList = (SheetParamList)map.get(string4);
                Element element3 = node.createElement("SheetParamList");
                element2.appendChild(element3);
                element3.setAttribute("name", string4);
                this.createElement(element3, sheetParamList.getAttributes());
                ServiceLogger.trace("ParamListManager:ParameterRecorder:saveReportParamList: making sheet parameter nodes...", new Object[0]);
                this.delete((Document)node, element3, sheetParamList);
            }
        }
        ServiceLogger.trace("ParamListManager:ParameterRecorder:saveReportParamList: making report parameter nodes...", new Object[0]);
        this.delete((Document)node, element2, reportParamList);
        if (bl4) {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:saveReportParamList: modifying...", new Object[0]);
            this.modifyUsedParameter(string, (Document)node);
        } else {
            if (bl3) {
                Element[] elementArray2;
                Element element4;
                Element element5;
                Element element52 = null;
                Document document2 = this.getUserParameterRecords(string);
                if (document2 != null && (element5 = XMLUtil.getElementByAttr(element4 = document2.getDocumentElement(), "report", string3)) != null && (elementArray2 = XMLUtil.getChildElements(element5)) != null) {
                    long l = Long.MAX_VALUE;
                    for (Element element6 : elementArray2) {
                        long l2 = Long.parseLong(XMLUtil.getAttribute(element6, "creattime"));
                        if (l <= l2 || this.equalsIgnoreCase(element6) != reportParamList.getType()) continue;
                        l = l2;
                        element52 = element6;
                    }
                }
                if (element52 != null) {
                    String string4 = this.equals(element52);
                    ServiceLogger.trace("ParamListManager:ParameterRecorder:saveReportParamList: removing oldest...(%s)", string4);
                    this.appendChild(string, string3, string4, reportParamList.getType());
                }
            }
            ServiceLogger.trace("ParamListManager:ParameterRecorder:saveReportParamList: appending...", new Object[0]);
            this.appendUsedParameter(string, (Document)node);
        }
        ServiceLogger.trace("ParamListManager:ParameterRecorder:saveReportParamList: success!", new Object[0]);
        return true;
    }

    @Override
    public boolean existReportParamList(String string, String string2, String string3, byte by) throws RemoteException {
        ServiceLogger.trace("ParamListManager:ParameterRecorder:existReportParamList.(reportPath=%s, reportParamListName=%s, reportParamListType=%s, userName=%s)", string2, string3, by, string);
        return this.getBoolean(this.getUserParameterRecords(string), string2, string3, by);
    }

    @Override
    public boolean deleteReportParamList(String string, String string2, String string3, byte by) throws RemoteException {
        ServiceLogger.trace("ParamListManager:ParameterRecorder:deleteReportParamList...(reportPath=%s, reportParamListName=%s, reportParamListType=%s, userName=%s)", string2, string3, by, string);
        Element element = this.appendUsedParameter(string, string2, string3, by);
        if (element == null) {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:deleteReportParamList: failed! report parameter list not existed.", new Object[0]);
            return false;
        }
        this.appendChild(string, string2, string3, by);
        ServiceLogger.trace("ParamListManager:ParameterRecorder:deleteReportParamList: success!", new Object[0]);
        return true;
    }

    @Override
    public ReportParamList getReportParamList(String string, String string2, String string3, byte by) throws RemoteException {
        ServiceLogger.trace("ParamListManager:ParameterRecorder:getReportParamList...(reportPath=%s, reportParamListName=%s, reportParamListType=%s, userName=%s)", string2, string3, by, string);
        if (by != 1 && by != 0) {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:getReportParamList failed! invalid report parameter list type", new Object[0]);
            return null;
        }
        if (by == 1 && !this.add(string)) {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:getReportParamList failed! the current setting dont support auto saved parameter.", new Object[0]);
            return null;
        }
        if (by == 0 && !this.append(string)) {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:getReportParamList failed! the current setting dont support manual saved parameter.", new Object[0]);
            return null;
        }
        Element element = this.appendUsedParameter(string, string2, string3, by);
        ReportParamList reportParamList = this.existReportParamList(element, string2);
        ServiceLogger.trace("ParamListManager:ParameterRecorder:getReportParamList.(ret=%s)", reportParamList);
        return reportParamList;
    }

    @Override
    public ReportParamList getDefaultReportParamList(String string, String string2) throws RemoteException {
        ServiceLogger.trace("ParamListManager:ParameterRecorder:getDefaultReportParamList...(reportPath=%s, userName=%s)", string2, string);
        Element element = this.appendUsedParameter(string, string2, "UserDefinedDefault", (byte)2);
        ReportParamList reportParamList = this.existReportParamList(element, string2);
        ServiceLogger.trace("ParamListManager:ParameterRecorder:getReportParamList.(ret=%s)", reportParamList);
        return reportParamList;
    }

    @Override
    public List getReportParamLists(String string, String string2, byte by) throws RemoteException {
        Object object;
        Object object2;
        Object object3;
        ServiceLogger.trace("ParamListManager:ParameterRecorder:getReportParamList...(reportPath=%s, reportParamListType=%s, userName=%s)", string2, by, string);
        if (by != 1 && by != 0) {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:getReportParamList failed! invalid report parameter list type", new Object[0]);
            return null;
        }
        boolean bl = this.add(string);
        if (by == 1 && !bl) {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:getReportParamList failed! the current setting dont support auto saved parameter.", new Object[0]);
            return null;
        }
        boolean bl2 = this.append(string);
        if (by == 0 && !bl2) {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:getReportParamList failed! the current setting dont support manual saved parameter.", new Object[0]);
            return null;
        }
        List list = null;
        if (!bl) {
            list = this.containsKey(string, string2, (byte)1);
        } else if (!bl2) {
            list = this.containsKey(string, string2, (byte)0);
        }
        if (list != null) {
            object3 = list.iterator();
            while (object3.hasNext()) {
                object2 = (Element)object3.next();
                object = this.equals((Element)object2);
                byte by2 = this.equalsIgnoreCase((Element)object2);
                this.appendChild(string, string2, (String)object, by2);
            }
        }
        if ((object3 = this.containsKey(string, string2, by)) == null) {
            return null;
        }
        object2 = new LinkedList();
        object = object3.iterator();
        while (object.hasNext()) {
            Element element = (Element)object.next();
            object2.add(this.existReportParamList(element, string2));
        }
        return object2;
    }

    @Override
    public boolean isDontShowParamPage(String string, String string2) throws RemoteException {
        ServiceLogger.trace("ParamListManager:ParameterRecorder:isDontShowParamPage...(reportPath=%s, userName=%s)", string2, string);
        Document document = this.getUserParameterRecords(string);
        if (document == null) {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:isDontShowParamPage: false(document=null)", new Object[0]);
            return false;
        }
        Element element = document.getDocumentElement();
        Element element2 = XMLUtil.getElementByAttr(element, "report", string2);
        if (element2 == null) {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:isDontShowParamPage: false(reportNode=null)", new Object[0]);
            return false;
        }
        boolean bl = this.error(element2);
        ServiceLogger.trace("ParamListManager:ParameterRecorder:isDontShowParamPage: return %s", bl);
        return bl;
    }

    @Override
    public void setDontShowParamPage(String string, String string2, boolean bl) throws RemoteException {
        Element element;
        Element element2;
        ServiceLogger.trace("ParamListManager:ParameterRecorder:isDontShowParamPage...(reportPath=%s, dontShow=%s, userName=%s)", string2, bl, string);
        Document document = this.getUserParameterRecords(string);
        if (document == null) {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:isDontShowParamPage: create document! (document=null)", new Object[0]);
            document = XMLUtil.newDocument();
        }
        if ((element2 = document.getDocumentElement()) == null) {
            ServiceLogger.trace("ParamListManager:ParameterRecorder:isDontShowParamPage: create root node! (root=null)", new Object[0]);
            element2 = document.createElement("root");
            document.appendChild(element2);
        }
        if ((element = XMLUtil.getElementByAttr(element2, "report", string2)) == null) {
            element = document.createElement("history-parameter");
            element2.appendChild(element);
            element.setAttribute("report", string2);
        }
        String string3 = String.valueOf(bl);
        element.setAttribute("dontShowParam", string3);
        this.save(string, document);
    }
}

