/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.quartz;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.jrc.quartz.JRTrigger;
import jet.server.schedule.ExeTimeInfo;
import jet.server.schedule.SchdTools;
import org.quartz.Calendar;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class JRTimeQuartzTrigger
extends JRTrigger {
    private static final long serialVersionUID = 354365437454321L;
    private static final int LINE = 2299;
    private static final String SEDU = "startTime";
    private static final String append = "endTime";
    private static final String appendScript = "nextFireTime";
    private static final String before = "previousFireTime";
    private static final String booleanValue = "timesTriggered";
    private static final String currentTimeMillis = "timezone";
    private static final String equals = "exeTime";
    private static final String get = "isLaunchEvenIfExpired";
    private static final String getDefaultTimeZone = "taskName";
    private static final String getFireTimeAfter = "htTask";
    private static final String getGC = "timeoutValue";
    private static final String getID = "lastExeTime";
    private transient Date getIdBase = null;
    private transient Date getInstance = null;
    protected transient Date nextFireTime = null;
    private transient Date getLaunchType = null;
    private transient int getNextFireTime = 0;
    private transient String getProperty = CSUtil.getDefaultTimeZone();
    private transient GregorianCalendar getStartTime = null;
    private transient boolean getTask = false;
    protected transient String taskName = null;
    protected transient Properties htTask = null;
    private transient long getTime = 0L;
    private transient long getTimeZone = 0L;

    public JRTimeQuartzTrigger(String string, String string2) {
        super(string, string2);
    }

    public JRTimeQuartzTrigger(String string, String string2, String string3) {
        super(string, string2);
        this.getProperty = string3;
    }

    public void init(Properties properties, ExeTimeInfo exeTimeInfo) {
        SchdTools.removeScheduleProps(properties);
        this.htTask = properties;
        String string = (String)properties.get("jrs.task_id");
        if (string == null || string.trim().length() == 0) {
            string = SchdTools.getIdBase();
        }
        this.htTask.put("jrs.task_id", string);
        this.taskName = (String)properties.get("jrs.schedule_name");
        if (this.taskName == null) {
            this.taskName = (String)properties.get("jrs.task_name");
        }
        if (this.taskName == null || this.taskName.trim().length() == 0) {
            this.taskName = "";
        }
        this.htTask.put("jrs.schedule_name", this.taskName);
        long l = this.getTime = exeTimeInfo == null ? 0L : exeTimeInfo.getTimeoutValue();
        if (exeTimeInfo != null) {
            this.getStartTime = exeTimeInfo.getGC();
            this.getTask = exeTimeInfo.isLaunchEvenIfExpired();
        }
        this.htTask.put("jrs.launch_type", String.valueOf(this.getLaunchType()));
        String string2 = properties.getProperty("jrs.submit_time");
        long l2 = CSUtil.parseLong(string2, System.currentTimeMillis());
        this.setStartTime(new Date(l2));
    }

    public int getLaunchType() {
        return 1;
    }

    public Date computeFirstFireTime(Calendar calendar) {
        Date date = new Date(-1L);
        if (date.equals(this.getStartTime())) {
            return new Date(-1L);
        }
        this.nextFireTime = this.getStartTime();
        this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null) break;
            java.util.Calendar calendar2 = java.util.Calendar.getInstance();
            calendar2.setTime(this.nextFireTime);
            if (calendar2.get(1) <= 2299) continue;
            return null;
        }
        return this.nextFireTime;
    }

    public int executionComplete(JobExecutionContext jobExecutionContext, JobExecutionException jobExecutionException) {
        Properties properties = this.getTask();
        boolean bl = "jet.server.schedule.jrtasks.PublishCRDTask".equals(properties.getProperty("jrs.task_class"));
        if (jobExecutionException != null && jobExecutionException.refireImmediately()) {
            return 1;
        }
        if (jobExecutionException != null && jobExecutionException.unscheduleFiringTrigger()) {
            return 2;
        }
        if (jobExecutionException != null && jobExecutionException.unscheduleAllTriggers()) {
            return 4;
        }
        if (!this.mayFireAgain() && !bl) {
            return 3;
        }
        return 0;
    }

    public Date getEndTime() {
        return this.getInstance;
    }

    public Date getFinalFireTime() {
        return this.getIdBase;
    }

    public Date getFireTimeAfter(Date date) {
        if (date.before(this.getStartTime.getTime())) {
            return this.getStartTime.getTime();
        }
        return date;
    }

    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public Date getPreviousFireTime() {
        return this.getLaunchType;
    }

    public Date getStartTime() {
        return this.getIdBase;
    }

    public boolean mayFireAgain() {
        Date date = new Date(399, 11, 31, 23, 59, 59);
        Date date2 = this.getNextFireTime();
        return date2 != null && date2.before(date);
    }

    public void setEndTime(Date date) {
        this.getInstance = date;
    }

    public void setStartTime(Date date) {
        this.getIdBase = date;
    }

    public void triggered(Calendar calendar) {
        ++this.getNextFireTime;
        this.getLaunchType = this.nextFireTime;
        this.nextFireTime = new Date(399, 11, 31, 23, 59, 59);
    }

    public void updateAfterMisfire(Calendar calendar) {
        if (this.getTask) {
            this.LINE(new Date());
        }
        this.LINE(null);
    }

    private void LINE(Date date) {
        this.nextFireTime = date;
    }

    public void updateWithNewCalendar(Calendar calendar, long l) {
        if (this.getNextFireTime > 0 || calendar == null) {
            return;
        }
        Date date = new Date();
        if (date.before(this.getStartTime.getTime())) {
            this.nextFireTime = this.getStartTime.getTime();
        } else {
            long l2 = date.getTime() - this.getStartTime.getTime().getTime();
            if (l2 <= l) {
                this.nextFireTime = date;
            }
        }
    }

    protected boolean validateMisfireInstruction(int n) {
        return n == 0;
    }

    public Properties toProperties(Properties properties) {
        Properties properties2 = properties;
        if (properties2 == null) {
            properties2 = new Properties();
        }
        properties2.put("jrs.launch_type", String.valueOf(1));
        properties2.put("jrs.is_enabled", String.valueOf(super.isEnable()));
        if (this.getStartTime != null) {
            properties2.put("jrs.exe_year", String.valueOf(this.getStartTime.get(1)));
            properties2.put("jrs.exe_month", String.valueOf(this.getStartTime.get(2) + 1));
            properties2.put("jrs.exe_day", String.valueOf(this.getStartTime.get(5)));
            properties2.put("jrs.exe_hour", String.valueOf(this.getStartTime.get(11)));
            properties2.put("jrs.exe_min", String.valueOf(this.getStartTime.get(12)));
            properties2.put("jrs.exe_sec", String.valueOf(this.getStartTime.get(13)));
            properties2.put("jrs.next_exe_time", String.valueOf(this.getStartTime.getTime().getTime()));
            properties2.put("jrs.timezone", this.getStartTime.getTimeZone().getID());
            properties2.put("jrs.exe_date", this.getStartTime.getTime().toString());
        }
        return properties2;
    }

    public static String filterTimeQuartzTriggerScriptItems(Hashtable hashtable, boolean bl) {
        Vector vector = new Vector();
        CSUtil.appendScript(vector, hashtable, "jrs.launch_type", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_enabled", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.timezone", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_year", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_month", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_hour", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_min", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_sec", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.next_exe_time", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_date", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.next_exe_time", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.last_exe_time", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.last_exe_stat", true, bl);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append((String)vector.get(i)).append(CSUtil.LINE);
        }
        return stringBuffer.toString();
    }

    public long getLastExeTime() {
        return this.getTimeZone;
    }

    public void setLastExeTime(long l) {
        this.getTimeZone = l;
    }

    @Override
    protected void toProp() {
        super.toProp();
        if (null != this.getIdBase) {
            this.props.put(SEDU, this.getIdBase);
        }
        if (null != this.getInstance) {
            this.props.put(append, this.getInstance);
        }
        if (null != this.nextFireTime) {
            this.props.put(appendScript, this.nextFireTime);
        }
        if (null != this.getLaunchType) {
            this.props.put(before, this.getLaunchType);
        }
        this.props.put(booleanValue, (Object)this.getNextFireTime);
        if (null != this.getProperty) {
            this.props.put(currentTimeMillis, this.getProperty);
        }
        if (null != this.getStartTime) {
            this.props.put(equals, this.getStartTime);
        }
        this.props.put(get, (Object)this.getTask);
        if (null != this.taskName) {
            this.props.put(getDefaultTimeZone, this.taskName);
        }
        if (null != this.htTask) {
            this.props.put(getFireTimeAfter, this.htTask);
        }
        this.props.put(getGC, (Object)this.getTime);
        this.props.put(getID, (Object)this.getTimeZone);
    }

    @Override
    protected void restoreFromProp() {
        super.restoreFromProp();
        this.getIdBase = (Date)this.props.get(SEDU);
        this.getInstance = (Date)this.props.get(append);
        this.nextFireTime = (Date)this.props.get(appendScript);
        this.getLaunchType = (Date)this.props.get(before);
        this.getNextFireTime = (Integer)this.props.get(booleanValue);
        this.getProperty = (String)this.props.get(currentTimeMillis);
        this.getStartTime = (GregorianCalendar)this.props.get(equals);
        this.getTask = (Boolean)this.props.get(get);
        this.taskName = (String)this.props.get(getDefaultTimeZone);
        this.htTask = (Properties)this.props.get(getFireTimeAfter);
        this.getTime = (Long)this.props.get(getGC);
        this.getTimeZone = (Long)this.props.get(getID);
    }
}

