/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource;

import java.util.Hashtable;
import java.util.Vector;
import jet.ReportEnv;
import jet.cs.CSUtil;
import jet.server.api.PathInfo;
import jet.server.db.resource.ResourceNodeRecord;
import jet.server.intf.resource.Node;
import jet.server.intf.resource.Resource;
import jet.server.intf.resource.ResourceInfo;
import jet.server.intf.resource.Version;
import jet.server.intf.security.User;
import jet.server.jrc.resource.NodeImpl;
import jet.server.jrc.resource.PathInfoImpl;
import jet.server.util.RefResource;
import jet.server.util.StringUtils;
import jet.util.IntKeyHashtable;

public class ResourceImpl
extends NodeImpl
implements Resource {
    private ResourceNodeRecord SEDU;
    private IntKeyHashtable append;
    private ResourceInfo clear = null;
    private Resource elements = null;
    private boolean endsWith = false;

    public ResourceImpl(String string) {
        super(string);
        this.setNodeType((byte)2);
    }

    public ResourceImpl(ResourceNodeRecord resourceNodeRecord) {
        super(resourceNodeRecord);
        this.SEDU = resourceNodeRecord;
        this.append = new IntKeyHashtable();
    }

    @Override
    public void remove() {
        this.SEDU = null;
    }

    @Override
    public Vector getVersions(User user) {
        return this.append.elements();
    }

    public Vector getVersions() {
        return this.append.elements();
    }

    @Override
    public Version getVersion(int n, User user) {
        return (Version)this.append.get(n);
    }

    @Override
    public Version getVersion(int n) {
        return (Version)this.append.get(n);
    }

    @Override
    public void addVersion(Version version, User user) {
        this.append.put(version.getVersionNumber(), (Object)version);
    }

    @Override
    public void addVersion(Version version) {
        this.append.put(version.getVersionNumber(), (Object)version);
    }

    @Override
    public void removeVersion(int n, User user) {
        this.append.remove(n);
    }

    @Override
    public ResourceInfo getEntity() {
        return this.clear;
    }

    public void setEntity(ResourceInfo resourceInfo) {
        this.clear = resourceInfo;
        if (!ReportEnv.isLive() && resourceInfo != null && resourceInfo.getResourceType() == 2) {
            this.endsWith = RefResource.isLiveReport(resourceInfo.getRealPath());
        }
    }

    @Override
    public String getRealDir() {
        return this.SEDU.getRealPath();
    }

    public void setRealDir(String string) {
        this.SEDU.setRealPath(string);
    }

    @Override
    public int getMaxVersionAmount() {
        if (this.isArchiveNewVersion()) {
            return this.SEDU.getMaxVersionAmount();
        }
        return 0;
    }

    @Override
    public void setMaxVersionAmount(int n) {
        this.SEDU.setMaxVersionAmount(n);
    }

    @Override
    public byte getResourceType() {
        return this.SEDU.getResourceType();
    }

    @Override
    public byte getResourceSubType() {
        return this.SEDU.getResourceSubType();
    }

    @Override
    public Resource getResult() {
        return this.elements;
    }

    @Override
    public void setParent(Node node) {
        super.setParent(node);
        String string = node.getAbsolutePath();
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        this.setAbsolutePath(string + this.SEDU.getName());
    }

    @Override
    public PathInfo toPathInfo(String string) {
        PathInfoImpl pathInfoImpl = super.getPathInfo(string);
        pathInfoImpl.setResourceType(this.getResourceType());
        pathInfoImpl.setResourceSubType(this.getResourceSubType());
        pathInfoImpl.setMaxVersionAmount(this.getMaxVersionAmount());
        pathInfoImpl.setLatestVersionNumber(this.getLatestVersionNumber());
        pathInfoImpl.setArchiveNewVersion(this.isArchiveNewVersion());
        pathInfoImpl.setEnableArchivePolicy(this.isEnableArchivePolicy());
        String string2 = this.clear == null ? "" : this.clear.getRealPath();
        pathInfoImpl.setRealPath(string2);
        pathInfoImpl.setProfileName(this.SEDU.getProfileName());
        pathInfoImpl.setIsEnableNLS(this.isEnableNLS());
        pathInfoImpl.setStatus(this.getStatus());
        pathInfoImpl.setIsLiveReport(this.endsWith);
        return pathInfoImpl;
    }

    @Override
    public void setResult(Resource resource) {
        this.elements = resource;
    }

    @Override
    public void removeVersions() {
        this.append.clear();
        this.append = null;
    }

    @Override
    public String toString() {
        return "ResourceImpl[" + super.toString() + "]";
    }

    @Override
    public int getLatestVersionNumber() {
        if (this.clear != null) {
            return this.clear.getVersionNumber();
        }
        return 0;
    }

    @Override
    public boolean setProperties(Hashtable hashtable) {
        int n = CSUtil.parseInt((String)hashtable.get("jrs.maxversion"), 0);
        boolean bl = CSUtil.getBoolean((String)hashtable.get("jrs.archive_new_version"), false);
        boolean bl2 = CSUtil.getBoolean((String)hashtable.get("jrs.enable_archive_policy"), false);
        String string = (String)hashtable.get("jrs.profile");
        boolean bl3 = CSUtil.getBoolean((String)hashtable.get("jrs.enable_nls"), false);
        byte by = (byte)CSUtil.parseInt((String)hashtable.get("jrs.node_status"), 0);
        boolean bl4 = false;
        if (n != this.SEDU.getMaxVersionAmount() || bl != this.SEDU.isArchiveNewVersion() || bl2 != this.SEDU.isEnableArchivePolicy() || !StringUtils.equals(string, this.SEDU.getProfileName()) || bl3 != this.SEDU.isEnableNLS() || by != this.SEDU.getStatus()) {
            bl4 = true;
            this.SEDU.setMaxVersionAmount(n);
            this.SEDU.setArchiveNewVersion(bl);
            this.SEDU.setEnableArchivePolicy(bl2);
            this.SEDU.setProfileName(string);
            this.SEDU.setIsEnableNLS(bl3);
            this.SEDU.setStatus(by);
        }
        return bl4;
    }

    @Override
    public boolean isArchiveNewVersion() {
        if (this.isEnableArchivePolicy()) {
            return this.SEDU.isArchiveNewVersion();
        }
        return true;
    }

    @Override
    public boolean isEnableArchivePolicy() {
        return this.SEDU.isEnableArchivePolicy();
    }

    @Override
    public boolean isEnableNLS() {
        return this.SEDU.isEnableNLS();
    }

    @Override
    public void setIsEnableNLS(boolean bl) {
        this.SEDU.setIsEnableNLS(bl);
    }

    @Override
    public void setStatus(byte by) {
        this.SEDU.setStatus(by);
    }

    @Override
    public byte getStatus() {
        return this.SEDU.getStatus();
    }

    public boolean setStatusProps(Hashtable hashtable) {
        boolean bl = false;
        byte by = (byte)CSUtil.parseInt((String)hashtable.get("jrs.node_status"), 0);
        if (by != this.SEDU.getStatus()) {
            bl = true;
            this.SEDU.setStatus(by);
        }
        return bl;
    }
}

