/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource.lc;

import com.jinfonet.web.util.json.JSONArray;
import com.jinfonet.web.util.json.JSONException;
import com.jinfonet.web.util.json.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jet.server.ServerEnv;
import jet.server.api.RptServerException;
import jet.server.api.cluster.ClusterException;
import jet.server.api.lc.AliasMappingManager;
import jet.server.api.lc.FieldInfo;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.cluster.core.ClusterServer;
import jet.server.db.lc.AliasMappingKeyTable;
import jet.server.db.lc.AliasMappingTable;
import jet.server.intf.security.SecurityService;
import jet.server.jrc.resource.lc.JRFieldInfo;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.log.ServiceLogger;

public class AliasMappingManagerImpl
implements AliasMappingManager {
    private String SEDU = null;
    private AliasMappingKeyTable add = null;
    private ClusterMap clone = null;

    AliasMappingManagerImpl(String string) {
        this.SEDU = string;
    }

    public static AliasMappingManagerImpl getInstance(String string) throws RptServerException {
        AliasMappingManagerImpl aliasMappingManagerImpl = new AliasMappingManagerImpl(string);
        return aliasMappingManagerImpl;
    }

    public void setAliasMappingKeyTable(AliasMappingKeyTable aliasMappingKeyTable, AliasMappingTable aliasMappingTable) {
        this.add = aliasMappingKeyTable;
        aliasMappingKeyTable.setAliasMappingTable(aliasMappingTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws RptServerException {
        try {
            this.clone = MapFactory.getMap(MapAttr.aliasMappingMap);
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError((Throwable)((Object)clusterException));
        }
        if (!ServerEnv.isClusterEnabled() || ClusterServer.getMemberService().isCoordinator()) {
            Map map = null;
            try {
                map = this.add.queryAllAliasMapping();
            }
            catch (Exception exception) {
                throw new RptServerException(exception);
            }
            Iterator iterator = map.keySet().iterator();
            ClusterMap clusterMap = this.clone;
            synchronized (clusterMap) {
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.clone.put(string, map.get(string));
                }
            }
        }
    }

    private boolean isAdminUser(String string) {
        SecurityService securityService = UserDataToolkit.getSecurityService(this.SEDU);
        if (securityService == null) {
            return "admin".equals(string);
        }
        return securityService.isAdminUser(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveAliasMappings(Map map, String string) throws RptServerException {
        Object object;
        Object object22;
        if (!this.isAdminUser(string)) {
            throw new RptServerException(600036);
        }
        try {
            this.add.deleteAllAliasMapping();
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
        if (null == map) {
            return;
        }
        for (Object object22 : map.keySet()) {
            object = (List)map.get(object22);
            try {
                this.add.saveAliasMapping((String)object22, (List)object);
            }
            catch (Exception exception) {
                throw new RptServerException(exception);
            }
        }
        object22 = map.keySet().iterator();
        object = this.clone;
        synchronized (object) {
            for (String string2 : this.clone.keySet()) {
                if (map.containsKey(string2)) continue;
                this.clone.remove(string2);
            }
            while (object22.hasNext()) {
                String string2;
                string2 = (String)object22.next();
                List list = (List)map.get(string2);
                ArrayList arrayList = (ArrayList)((ArrayList)list).clone();
                this.clone.put(string2, arrayList);
            }
        }
    }

    public synchronized void removeAliasMappings(String string, String string2) throws RptServerException {
        if (null == string) {
            return;
        }
        if (!this.isAdminUser(string2)) {
            throw new RptServerException(600036);
        }
        try {
            this.add.deleteAliasMapping(string);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
        this.clone.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map getAllAlisasMappings() throws RptServerException {
        HashMap<String, ArrayList> hashMap = new HashMap<String, ArrayList>();
        ClusterMap clusterMap = this.clone;
        synchronized (clusterMap) {
            for (String string : this.clone.keySet()) {
                hashMap.put(string, (ArrayList)((ArrayList)this.clone.get(string)).clone());
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllKeys() throws RptServerException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = null;
        Object object = this.clone;
        synchronized (object) {
            iterator = this.clone.keySet().iterator();
        }
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            arrayList.add(object);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFieldsByKey(String string) throws RptServerException {
        if (null == string) {
            return null;
        }
        ArrayList arrayList = null;
        ClusterMap clusterMap = this.clone;
        synchronized (clusterMap) {
            arrayList = (ArrayList)((ArrayList)this.clone.get(string)).clone();
        }
        return arrayList;
    }

    @Override
    public FieldInfo parseFieldInfo(String string, String string2, String string3, String[] stringArray) throws RptServerException {
        return new JRFieldInfo(string, string2, string3, stringArray);
    }

    public Map parseAliasMapping(String string) throws RptServerException {
        HashMap hashMap = new HashMap();
        try {
            JSONObject jSONObject = new JSONObject(string);
            JSONObject jSONObject2 = jSONObject.optJSONObject("container");
            if (jSONObject2 != null) {
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    JSONArray jSONArray = jSONObject2.optJSONArray(string2);
                    ArrayList<JRFieldInfo> arrayList = new ArrayList<JRFieldInfo>();
                    if (jSONArray != null) {
                        for (int i = 0; i < jSONArray.length(); ++i) {
                            JSONObject jSONObject3 = jSONArray.optJSONObject(i);
                            if (jSONObject3 == null) continue;
                            JSONArray jSONArray2 = jSONObject3.optJSONArray("fieldDetails");
                            String[] stringArray = new String[jSONArray2.length()];
                            if (jSONArray2 != null) {
                                for (int j = 0; j < jSONArray2.length(); ++j) {
                                    stringArray[j] = jSONArray2.getString(j);
                                }
                            }
                            JRFieldInfo jRFieldInfo = new JRFieldInfo(jSONObject3.getString("catalog"), jSONObject3.getString("dataSource"), jSONObject3.getString("query"), stringArray);
                            arrayList.add(jRFieldInfo);
                        }
                    }
                    hashMap.put(string2, arrayList);
                }
            }
        }
        catch (JSONException jSONException) {
            throw new RptServerException(jSONException);
        }
        return hashMap;
    }
}

