/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.security.Principal;
import java.security.acl.NotOwnerException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.cs.jacl.JAcl;
import jet.cs.jacl.JAclEntry;
import jet.cs.jacl.JAclEntryImpl;
import jet.cs.jacl.JPermission;
import jet.cs.jacl.JPermissionImpl;
import jet.cs.jacl.SecurityData;
import jet.server.ServerEnv;
import jet.server.api.exception.NoSuchAclException;
import jet.server.jrc.security.AclDataManager;
import jet.server.jrc.security.AclExistException;
import jet.server.jrc.security.NoSuchAclEntryException;
import jet.server.jrc.security.PermissionUtil;
import jet.server.jrc.security.custom.SecurityUtil;
import jet.server.log.ServiceLogger;

public class AclManager {
    private AclDataManager ACCESS_ADVANCED_PROPERTIES;
    private SecurityData CREATE_ANALYSIS_REPORT;

    public AclManager(AclDataManager aclDataManager, SecurityData securityData) {
        this.ACCESS_ADVANCED_PROPERTIES = aclDataManager;
        this.CREATE_ANALYSIS_REPORT = securityData;
    }

    public JAcl getDefaultAcl() throws NoSuchAclException {
        JAcl jAcl = this.ACCESS_ADVANCED_PROPERTIES.getDefaultAcl();
        if (jAcl == null) {
            throw new NoSuchAclException(630007);
        }
        return jAcl;
    }

    public JAcl getAcl(String string, int n) throws NoSuchAclException {
        JAcl jAcl = this.ACCESS_ADVANCED_PROPERTIES.getAcl(string, n);
        return jAcl;
    }

    public JAclEntry getAclEntry(String string, int n, Principal principal, boolean bl) throws NoSuchAclException, NoSuchAclEntryException {
        return this.ACCESS_ADVANCED_PROPERTIES.getAclEntry(string, n, principal, bl);
    }

    public int setPermissions(String string, int n, Hashtable[] hashtableArray) {
        String string2;
        Principal principal;
        String string3;
        Enumeration enumeration;
        Hashtable[] hashtableArray2;
        if (hashtableArray == null || hashtableArray[0] == null && hashtableArray[1] == null && hashtableArray[2] == null) {
            this.ACCESS_ADVANCED_PROPERTIES.removeAcl(string, n);
            return -1;
        }
        boolean bl = ServerEnv.isEnableRoleBasedAuthorization();
        if (bl) {
            try {
                hashtableArray2 = this.ACCESS_ADVANCED_PROPERTIES(string, n, false);
                if (hashtableArray2 != null) {
                    hashtableArray[0] = hashtableArray2[0];
                    hashtableArray[2] = hashtableArray2[2];
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        try {
            this.getAcl(string, n);
            this.ACCESS_ADVANCED_PROPERTIES.removeAcl(string, n);
        }
        catch (NoSuchAclException noSuchAclException) {
            ServiceLogger.logDebug(5630092, new Object[]{string + "[" + n + "]"}, 5);
        }
        hashtableArray2 = new Hashtable[]{new Hashtable(), new Hashtable(), new Hashtable()};
        if (hashtableArray[0] != null) {
            enumeration = hashtableArray[0].keys();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                principal = this.CREATE_ANALYSIS_REPORT.getUser(string3);
                if (principal == null || (string2 = (String)hashtableArray[0].get(string3)) == null) continue;
                hashtableArray2[0].put(string3, string2);
            }
        }
        if (hashtableArray[1] != null) {
            enumeration = hashtableArray[1].keys();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                principal = this.CREATE_ANALYSIS_REPORT.getRole(string3);
                if (principal == null || (string2 = (String)hashtableArray[1].get(string3)) == null) continue;
                hashtableArray2[1].put(string3, string2);
            }
        }
        if (hashtableArray[2] != null) {
            enumeration = hashtableArray[2].keys();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                principal = this.CREATE_ANALYSIS_REPORT.getGroup(string3);
                if (principal == null || (string2 = (String)hashtableArray[2].get(string3)) == null) continue;
                hashtableArray2[2].put(string3, string2);
            }
        }
        try {
            this.ACCESS_ADVANCED_PROPERTIES.addAcl("system", string, n, hashtableArray2);
        }
        catch (AclExistException aclExistException) {
            ServiceLogger.logError((Throwable)((Object)aclExistException));
        }
        return 1;
    }

    public Hashtable[] getPermssions(String string, int n) throws NoSuchAclException, NotOwnerException {
        return this.ACCESS_ADVANCED_PROPERTIES(string, n, ServerEnv.isEnableRoleBasedAuthorization());
    }

    private Hashtable[] ACCESS_ADVANCED_PROPERTIES(String string, int n, boolean bl) throws NoSuchAclException, NotOwnerException {
        Hashtable[] hashtableArray = new Hashtable[]{new Hashtable(), new Hashtable(), new Hashtable()};
        JAcl jAcl = this.getAcl(string, n);
        Enumeration enumeration = jAcl.entries();
        while (enumeration.hasMoreElements()) {
            String string2;
            int n2;
            Vector vector;
            JAclEntry jAclEntry = (JAclEntry)enumeration.nextElement();
            if (jAclEntry.isNegative()) continue;
            Enumeration enumeration2 = jAclEntry.permissions();
            Principal principal = jAclEntry.getPrincipal();
            String string3 = principal.getName();
            if (principal instanceof BaseUser && !bl) {
                vector = new Vector();
                while (enumeration2.hasMoreElements()) {
                    vector.add(enumeration2.nextElement());
                }
                n2 = PermissionUtil.truePermisisonVectorToCode(vector);
                string2 = SecurityUtil.getStringFromPermissionCode(n2);
                hashtableArray[0].put(string3, string2);
                continue;
            }
            if (principal instanceof BaseRole) {
                vector = new Vector();
                while (enumeration2.hasMoreElements()) {
                    vector.add(enumeration2.nextElement());
                }
                n2 = PermissionUtil.truePermisisonVectorToCode(vector);
                string2 = SecurityUtil.getStringFromPermissionCode(n2);
                hashtableArray[1].put(string3, string2);
                continue;
            }
            if (bl) continue;
            vector = new Vector();
            while (enumeration2.hasMoreElements()) {
                vector.add(enumeration2.nextElement());
            }
            n2 = PermissionUtil.truePermisisonVectorToCode(vector);
            string2 = SecurityUtil.getStringFromPermissionCode(n2);
            hashtableArray[2].put(string3, string2);
        }
        return hashtableArray;
    }

    public boolean removeAcl(String string, int n) {
        return this.ACCESS_ADVANCED_PROPERTIES.removeAcl(string, n);
    }

    public boolean removeAclEntry(String string, int n, Principal principal) throws NoSuchAclException, NoSuchAclEntryException {
        if (string == null || principal == null) {
            return false;
        }
        return this.ACCESS_ADVANCED_PROPERTIES.remove(string, n, principal);
    }

    public JAcl getExtendAcl() throws NoSuchAclException {
        JAcl jAcl = this.ACCESS_ADVANCED_PROPERTIES.getExtendAcl();
        return jAcl;
    }

    public void setPrivileges(Principal principal, Vector vector) {
        JAclEntryImpl jAclEntryImpl = new JAclEntryImpl(principal.getName(), this.CREATE_ANALYSIS_REPORT);
        jAclEntryImpl.setPrincipal(principal);
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            if (string.equalsIgnoreCase("jrs.privilege_create_analysis_report")) {
                jAclEntryImpl.addPermission(JPermissionImpl.CREATE_ANALYSIS_REPORT);
            }
            if (string.equalsIgnoreCase("jrs.privilege_publish_report")) {
                jAclEntryImpl.addPermission(JPermissionImpl.DEPLOY_REPORT);
            }
            if (string.equalsIgnoreCase("jrs.privilege_access_advanced_properties")) {
                jAclEntryImpl.addPermission(JPermissionImpl.ACCESS_ADVANCED_PROPERTIES);
            }
            if (!string.equalsIgnoreCase("jrs.privilege_message_table_manipulation")) continue;
            jAclEntryImpl.addPermission(JPermissionImpl.MESSAGE_TABLE_MANIPULATION);
        }
        this.ACCESS_ADVANCED_PROPERTIES.addExtendAclEntry(jAclEntryImpl);
    }

    public Vector getPrivileges(Principal principal) {
        JAclEntry jAclEntry;
        JAcl jAcl;
        Vector<String> vector = new Vector<String>();
        try {
            jAcl = this.getExtendAcl();
        }
        catch (NoSuchAclException noSuchAclException) {
            jAcl = null;
        }
        if (jAcl != null && principal != null && (jAclEntry = jAcl.getJAclEntry(principal, true)) != null) {
            Enumeration enumeration = jAclEntry.permissions();
            while (enumeration.hasMoreElements()) {
                JPermission jPermission = (JPermission)enumeration.nextElement();
                if (jPermission.equals(JPermissionImpl.CREATE_ANALYSIS_REPORT)) {
                    vector.add("jrs.privilege_create_analysis_report");
                }
                if (jPermission.equals(JPermissionImpl.DEPLOY_REPORT)) {
                    vector.add("jrs.privilege_publish_report");
                    vector.add("jrs.privilege_deploy_report");
                }
                if (jPermission.equals(JPermissionImpl.ACCESS_ADVANCED_PROPERTIES)) {
                    vector.add("jrs.privilege_access_advanced_properties");
                }
                if (!jPermission.equals(JPermissionImpl.MESSAGE_TABLE_MANIPULATION)) continue;
                vector.add("jrs.privilege_message_table_manipulation");
            }
        }
        return vector;
    }

    public Vector getPrivilegedUsers(String string) {
        return this.ACCESS_ADVANCED_PROPERTIES.getPrivilegedUsers(PermissionUtil.turnStringToPrivilege(string));
    }

    public Vector getPrivilegedRoles(String string) {
        return this.ACCESS_ADVANCED_PROPERTIES.getPrivilegedRoles(PermissionUtil.turnStringToPrivilege(string));
    }

    public Vector getPrivilegedGroups(String string) {
        return this.ACCESS_ADVANCED_PROPERTIES.getPrivilegedGroups(PermissionUtil.turnStringToPrivilege(string));
    }

    public void addPrivilegedUsers(String string, Vector vector) {
        this.ACCESS_ADVANCED_PROPERTIES.addPrivilegedUsers(PermissionUtil.turnStringToPrivilege(string), vector);
    }

    public void addPrivilegedRoles(String string, Vector vector) {
        this.ACCESS_ADVANCED_PROPERTIES.addPrivilegedRoles(PermissionUtil.turnStringToPrivilege(string), vector);
    }

    public void addPrivilegedGroups(String string, Vector vector) {
        this.ACCESS_ADVANCED_PROPERTIES.addPrivilegedGroups(PermissionUtil.turnStringToPrivilege(string), vector);
    }

    public String removePrivilegedUsers(String string, Vector vector) {
        String string2 = this.ACCESS_ADVANCED_PROPERTIES.removePrivilegedUsers(PermissionUtil.turnStringToPrivilege(string), vector);
        return string2;
    }

    public String removePrivilegedRoles(String string, Vector vector) {
        String string2 = this.ACCESS_ADVANCED_PROPERTIES.removePrivilegedRoles(PermissionUtil.turnStringToPrivilege(string), vector);
        return string2;
    }

    public String removePrivilegedGroups(String string, Vector vector) {
        String string2 = this.ACCESS_ADVANCED_PROPERTIES.removePrivilegedGroups(PermissionUtil.turnStringToPrivilege(string), vector);
        return string2;
    }
}

