/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.security.acl.NotOwnerException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.cs.jacl.JAcl;
import jet.cs.jacl.JAclEntry;
import jet.cs.jacl.JAclEntryImpl;
import jet.server.api.custom.JRCustomerException;
import jet.server.event.EventHandler;
import jet.server.event.SelectorImpl;
import jet.server.event.Subscriber;
import jet.server.event.TopicEvent;
import jet.server.event.subscriber.SubscribeService;
import jet.server.intf.security.Group;
import jet.server.intf.security.PrincipalListener;
import jet.server.intf.security.Role;
import jet.server.intf.security.User;
import jet.server.jrc.security.PermissionUtil;
import jet.server.jrc.security.admin.JOrganizationImpl;
import jet.server.jrc.security.cache.CachedSecurityDataImpl;
import jet.server.jrc.security.config.intf.SecurityProvidersManager;
import jet.server.jrc.security.custom.SecurityUtil;
import jet.server.jrc.security.event.EventUtil;
import jet.server.log.ServiceLogger;

public class ExCachedSecurityDataImpl
extends CachedSecurityDataImpl
implements EventHandler {
    private Subscriber SEDU = null;
    String topic;

    public ExCachedSecurityDataImpl(String string, SecurityProvidersManager securityProvidersManager) {
        super(string, securityProvidersManager);
        SubscribeService subscribeService = SubscribeService.newInstance();
        this.SEDU = subscribeService.createSubscriber(this);
        try {
            this.SEDU.activate();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        this.topic = EventUtil.createTopic(string, "security_event_name");
        SelectorImpl selectorImpl = new SelectorImpl(this.topic, 32);
        selectorImpl.enableAll();
        this.SEDU.addSelector(selectorImpl);
        boolean bl = this.SEDU.isValid();
        if (bl) {
            this.start();
        }
    }

    public void start() {
        if (this.isStart()) {
            return;
        }
        try {
            this.SEDU.activate();
            ServiceLogger.logEvent(5630074, this.topic, 5);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public boolean isStart() {
        return this.SEDU.isActive();
    }

    public void stop() {
        if (!this.isStart()) {
            return;
        }
        try {
            this.SEDU.deactivate();
            ServiceLogger.logEvent(5630075, this.topic, 5);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public void process(TopicEvent topicEvent) {
        int n = topicEvent.getType();
        switch (n) {
            case 0: {
                this.securityCache.clear();
                break;
            }
            case 1: {
                Properties properties = (Properties)topicEvent.getData();
                this.addEntry(properties);
                break;
            }
            case 2: {
                Properties properties = (Properties)topicEvent.getData();
                this.addParentRole(properties);
                break;
            }
            case 3: {
                Properties properties = (Properties)topicEvent.getData();
                this.addSubUser(properties);
                break;
            }
            case 4: {
                Properties properties = (Properties)topicEvent.getData();
                this.createTopic(properties);
                break;
            }
            case 5: {
                Properties properties = (Properties)topicEvent.getData();
                this.equals(properties);
                break;
            }
            case 6: {
                Properties properties = (Properties)topicEvent.getData();
                this.finalize(properties);
                break;
            }
            case 7: {
                Properties properties = (Properties)topicEvent.getData();
                this.SEDU(properties);
                break;
            }
            case 8: {
                Properties properties = (Properties)topicEvent.getData();
                this.activate(properties);
                break;
            }
        }
    }

    private void SEDU(Properties properties) {
        String string = properties.getProperty("security_event_para_organization");
        this.getOrganization(string);
        this.createSubscriber(string + "\\" + "everyone", "everyone");
        this.addUser(string + "\\" + "admin", string + "\\" + "everyone");
        this.addUser(string + "\\" + "admin", string + "\\" + "administrators");
        Properties properties2 = new Properties();
        properties2.put("security_event_para_principal", string + "\\" + "administrators");
        properties2.put("security_event_para_principal_type", String.valueOf(2));
        this.finalize(properties2);
        for (PrincipalListener principalListener : this.principalListeners) {
            principalListener.addOrganization(string);
        }
    }

    private void activate(Properties properties) {
        String[] stringArray;
        String string = properties.getProperty("security_event_para_organization");
        JOrganizationImpl jOrganizationImpl = (JOrganizationImpl)this.getOrganization(string);
        Vector vector = jOrganizationImpl.getUsers();
        String[] stringArray2 = vector.iterator();
        while (stringArray2.hasNext()) {
            stringArray = (String[])stringArray2.next();
            this.addPrivilegeToAclEntry(string + "\\" + (String)stringArray);
        }
        for (String string2 : stringArray2 = this.securityCache.getAllRoleNames()) {
            if (!string2.startsWith(string + "\\")) continue;
            this.addRole(string2);
        }
        stringArray = this.securityCache.getAllGroupNames();
        for (String string3 : stringArray) {
            if (!string3.startsWith(string + "\\")) continue;
            this.addSubGroup(string3);
        }
        this.securityCache.removeOrganization(string);
        for (PrincipalListener principalListener : this.principalListeners) {
            principalListener.removeOrganization(string);
        }
    }

    private void addEntry(Properties properties) {
        String string = properties.getProperty("security_event_para_principal");
        if (string == null) {
            return;
        }
        String string2 = properties.getProperty("security_event_para_principal_type");
        if (string2 == null) {
            return;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(numberFormatException);
            return;
        }
        switch (n) {
            case 1: {
                this.addGroup(string);
                break;
            }
            case 2: {
                this.addOrganization(string);
                break;
            }
            case 3: {
                this.addParentGroup(string);
                break;
            }
        }
    }

    private void addGroup(String string) {
        this.getUser(string);
    }

    private void addOrganization(String string) {
        this.getRole(string);
    }

    private void addParentGroup(String string) {
        this.getGroup(string);
    }

    private void addParentRole(Properties properties) {
        String string = properties.getProperty("security_event_para_principal");
        if (string == null) {
            return;
        }
        String string2 = properties.getProperty("security_event_para_principal_type");
        if (string2 == null) {
            return;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(numberFormatException);
            return;
        }
        switch (n) {
            case 1: {
                this.addPrivilegeToAclEntry(string);
                break;
            }
            case 2: {
                this.addRole(string);
                break;
            }
            case 3: {
                this.addSubGroup(string);
                break;
            }
        }
        for (PrincipalListener principalListener : this.principalListeners) {
            principalListener.removePrincipal(string, n);
        }
    }

    private void addPrivilegeToAclEntry(String string) {
        User user = this.securityCache.getUser(string);
        if (user != null) {
            Object object2;
            Vector vector = user.getParentRoleNames();
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                object2 = this.securityCache.getQuietRole(string2);
                if (object2 == null) continue;
                object2.removeSubUser(string);
            }
            Vector vector2 = user.getGroupNames();
            for (int i = 0; i < vector2.size(); ++i) {
                object2 = (String)vector2.elementAt(i);
                Group group = this.securityCache.getQuietGroup((String)object2);
                if (group == null) continue;
                group.removeUser(string);
            }
            this.securityCache.removeUser(string);
            for (Object object2 : this.principalListeners) {
                object2.removePrincipal(string, 1);
            }
        } else {
            Object object;
            String[] stringArray = this.securityCache.getAllRoleNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                object = this.securityCache.getQuietRole(string3);
                if (object == null) continue;
                object.removeSubUser(string);
            }
            String[] stringArray2 = this.securityCache.getAllGroupNames();
            for (int i = 0; i < stringArray2.length; ++i) {
                object = stringArray2[i];
                Group group = this.securityCache.getQuietGroup((String)object);
                if (group == null) continue;
                group.removeUser(string);
            }
        }
        this.addRelation(string);
    }

    private void addRelation(String string) {
        String[] stringArray = this.securityCache.getAllAclNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            JAcl jAcl = this.securityCache.getAcl(string2);
            if (jAcl == null) continue;
            jAcl.removeJAclEntry(string, 1);
        }
    }

    private void addRole(String string) {
        Role role = this.securityCache.getRole(string);
        if (role != null) {
            Object object;
            Object object2;
            Object object3;
            Vector vector = role.getSubUserNames();
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                object3 = this.securityCache.getQuietUser(string2);
                if (object3 == null) continue;
                object3.removeParentRole(string);
            }
            Vector vector2 = role.getGroupNames();
            for (int i = 0; i < vector2.size(); ++i) {
                object3 = (String)vector2.elementAt(i);
                object2 = this.securityCache.getQuietGroup((String)object3);
                if (object2 == null) continue;
                object2.removeRole(string);
            }
            Vector vector3 = role.getSubRoleNames();
            for (int i = 0; i < vector3.size(); ++i) {
                object2 = (String)vector3.elementAt(i);
                object = this.securityCache.getQuietRole((String)object2);
                if (object == null) continue;
                object.removeParentRole(string);
            }
            Vector vector4 = role.getParentRoleNames();
            for (int i = 0; i < vector4.size(); ++i) {
                object = (String)vector4.elementAt(i);
                Role role2 = this.securityCache.getQuietRole((String)object);
                if (role2 == null) continue;
                role2.removeSubRole(string);
            }
            this.securityCache.removeRole(string);
        } else {
            Object object;
            Object object4;
            String[] stringArray = this.securityCache.getAllUserNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                object4 = this.securityCache.getQuietUser(string3);
                if (object4 == null || !object4.isHaveParentRole(string)) continue;
                object4.removeParentRole(string);
            }
            String[] stringArray2 = this.securityCache.getAllGroupNames();
            for (int i = 0; i < stringArray2.length; ++i) {
                object4 = stringArray2[i];
                object = this.securityCache.getQuietGroup((String)object4);
                if (object == null || !object.isHaveRole(string)) continue;
                object.removeRole(string);
            }
            String[] stringArray3 = this.securityCache.getAllRoleNames();
            for (int i = 0; i < stringArray3.length; ++i) {
                object = stringArray3[i];
                Role role3 = this.securityCache.getQuietRole((String)object);
                if (role3 == null) continue;
                if (role3.isHaveParentRole(string)) {
                    role3.removeParentRole(string);
                }
                if (!role3.isHaveSubRole(string)) continue;
                role3.removeSubRole(string);
            }
        }
        this.addSelector(string);
    }

    private void addSelector(String string) {
        String[] stringArray = this.securityCache.getAllAclNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            JAcl jAcl = this.securityCache.getAcl(string2);
            if (jAcl == null) continue;
            jAcl.removeJAclEntry(string, 2);
        }
    }

    private void addSubGroup(String string) {
        Group group = this.securityCache.getGroup(string);
        if (group != null) {
            Object object;
            Object object2;
            Object object3;
            Vector vector = group.getUserNames();
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                object3 = this.securityCache.getQuietUser(string2);
                if (object3 == null) continue;
                object3.removeGroup(string);
            }
            Vector vector2 = group.getRoleNames();
            for (int i = 0; i < vector2.size(); ++i) {
                object3 = (String)vector2.elementAt(i);
                object2 = this.securityCache.getQuietRole((String)object3);
                if (object2 == null) continue;
                object2.removeGroup(string);
            }
            Vector vector3 = group.getSubGroupNames();
            for (int i = 0; i < vector3.size(); ++i) {
                object2 = (String)vector3.elementAt(i);
                object = this.securityCache.getQuietGroup((String)object2);
                if (object == null) continue;
                object.removeParentGroup(string);
            }
            Vector vector4 = group.getParentGroupNames();
            for (int i = 0; i < vector4.size(); ++i) {
                object = (String)vector4.elementAt(i);
                Group group2 = this.securityCache.getQuietGroup((String)object);
                if (group2 == null) continue;
                group2.removeSubGroup(string);
            }
            this.securityCache.removeGroup(string);
        } else {
            Object object;
            Object object4;
            String[] stringArray = this.securityCache.getAllUserNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                object4 = this.securityCache.getQuietUser(string3);
                if (object4 == null || !object4.isHaveGroup(string)) continue;
                object4.removeGroup(string);
            }
            String[] stringArray2 = this.securityCache.getAllRoleNames();
            for (int i = 0; i < stringArray2.length; ++i) {
                object4 = stringArray2[i];
                object = this.securityCache.getQuietRole((String)object4);
                if (object == null || !object.isHaveGroup(string)) continue;
                object.removeGroup(string);
            }
            String[] stringArray3 = this.securityCache.getAllGroupNames();
            for (int i = 0; i < stringArray3.length; ++i) {
                object = stringArray3[i];
                Group group3 = this.securityCache.getQuietGroup((String)object);
                if (group3 == null) continue;
                if (group3.isHaveParentGroup(string)) {
                    group3.removeParentGroup(string);
                }
                if (!group3.isHaveSubGroup(string)) continue;
                group3.removeSubGroup(string);
            }
        }
        this.addSubRole(string);
    }

    private void addSubRole(String string) {
        String[] stringArray = this.securityCache.getAllAclNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            JAcl jAcl = this.securityCache.getAcl(string2);
            if (jAcl == null) continue;
            jAcl.removeJAclEntry(string, 3);
        }
    }

    private void addSubUser(Properties properties) {
        String string = properties.getProperty("security_event_para_parent_principal");
        String string2 = properties.getProperty("security_event_para_sub_principal");
        if (string == null || string2 == null) {
            return;
        }
        String string3 = properties.getProperty("security_event_para_parent_principal_type");
        String string4 = properties.getProperty("security_event_para_sub_principal_type");
        if (string3 == null || string4 == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(string3);
            n2 = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(numberFormatException);
            return;
        }
        block1 : switch (n) {
            case 1: {
                break;
            }
            case 2: {
                switch (n2) {
                    case 1: {
                        this.addUser(string2, string);
                        break block1;
                    }
                    case 3: {
                        this.clear(string2, string);
                        break block1;
                    }
                    case 2: {
                        this.createSubscriber(string2, string);
                        break block1;
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 1: {
                        this.append(string2, string);
                        break block1;
                    }
                    case 3: {
                        this.createAclName(string2, string);
                        break block1;
                    }
                    case 2: {
                        break block1;
                    }
                }
            }
        }
    }

    private void addUser(String string, String string2) {
        User user;
        Role role = this.securityCache.getRole(string2);
        if (role != null) {
            role.addSubUser(string);
        }
        if ((user = this.securityCache.getUser(string)) != null) {
            user.addParentRole(string2);
        }
        super.addRelation(this.roleUserMap, string2, string);
    }

    private void append(String string, String string2) {
        User user;
        Group group = this.securityCache.getGroup(string2);
        if (group != null) {
            group.addUser(string);
        }
        if ((user = this.securityCache.getUser(string)) != null) {
            user.addGroup(string2);
        }
        super.addRelation(this.groupUserMap, string2, string);
    }

    private void clear(String string, String string2) {
        Group group;
        Role role = this.securityCache.getRole(string2);
        if (role != null) {
            role.addGroup(string);
        }
        if ((group = this.securityCache.getGroup(string)) != null) {
            group.addRole(string2);
        }
        super.addRelation(this.roleGroupMap, string2, string);
    }

    private void createAclName(String string, String string2) {
        Group group;
        Group group2 = this.securityCache.getGroup(string2);
        if (group2 != null) {
            group2.addSubGroup(string);
        }
        if ((group = this.securityCache.getGroup(string)) != null) {
            group.addParentGroup(string2);
        }
        super.addRelation(this.subGroupMap, string2, string);
    }

    private void createSubscriber(String string, String string2) {
        Role role;
        Role role2 = this.securityCache.getRole(string2);
        if (role2 != null) {
            role2.addSubRole(string);
        }
        if ((role = this.securityCache.getRole(string)) != null) {
            role.addParentRole(string2);
        }
        super.addRelation(this.subRoleMap, string2, string);
    }

    private void createTopic(Properties properties) {
        String string = properties.getProperty("security_event_para_parent_principal");
        String string2 = properties.getProperty("security_event_para_sub_principal");
        if (string == null || string2 == null) {
            return;
        }
        String string3 = properties.getProperty("security_event_para_parent_principal_type");
        String string4 = properties.getProperty("security_event_para_sub_principal_type");
        if (string3 == null || string4 == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(string3);
            n2 = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(numberFormatException);
            return;
        }
        block1 : switch (n) {
            case 1: {
                break;
            }
            case 2: {
                switch (n2) {
                    case 1: {
                        this.deactivate(string2, string);
                        break block1;
                    }
                    case 3: {
                        this.dispose(string2, string);
                        break block1;
                    }
                    case 2: {
                        this.enableAll(string2, string);
                        break block1;
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 1: {
                        this.destroy(string2, string);
                        break block1;
                    }
                    case 3: {
                        this.elementAt(string2, string);
                        break block1;
                    }
                    case 2: {
                        break block1;
                    }
                }
            }
        }
    }

    private void deactivate(String string, String string2) {
        User user;
        Role role = this.securityCache.getRole(string2);
        if (role != null) {
            role.removeSubUser(string);
        }
        if ((user = this.securityCache.getUser(string)) != null) {
            user.removeParentRole(string2);
        }
        super.removeRelation(this.roleUserMap, string2, string);
    }

    private void destroy(String string, String string2) {
        User user;
        Group group = this.securityCache.getGroup(string2);
        if (group != null) {
            group.removeUser(string);
        }
        if ((user = this.securityCache.getUser(string)) != null) {
            user.removeGroup(string2);
        }
        super.removeRelation(this.groupUserMap, string2, string);
    }

    private void dispose(String string, String string2) {
        Role role;
        Group group = this.securityCache.getGroup(string);
        if (group != null) {
            group.removeRole(string2);
        }
        if ((role = this.securityCache.getRole(string2)) != null) {
            role.removeGroup(string);
        }
        super.removeRelation(this.roleGroupMap, string2, string);
    }

    private void elementAt(String string, String string2) {
        Group group;
        Group group2 = this.securityCache.getGroup(string);
        if (group2 != null) {
            group2.removeParentGroup(string2);
        }
        if ((group = this.securityCache.getGroup(string2)) != null) {
            group.removeSubGroup(string);
        }
        super.removeRelation(this.subGroupMap, string2, string);
    }

    private void enableAll(String string, String string2) {
        Role role;
        Role role2 = this.securityCache.getRole(string);
        if (role2 != null) {
            role2.removeParentRole(string2);
        }
        if ((role = this.securityCache.getRole(string2)) != null) {
            role.removeSubRole(string);
        }
        super.removeRelation(this.subRoleMap, string2, string);
    }

    private void equals(Properties properties) {
        String string = properties.getProperty("security_event_para_resource_path");
        String string2 = properties.getProperty("security_event_para_version_number");
        if (string == null || string2 == null) {
            return;
        }
        int n = -1;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(numberFormatException, 3);
            return;
        }
        String string3 = SecurityUtil.createAclName(string, n);
        JAcl jAcl = this.securityCache.getAcl(string3);
        if (jAcl != null) {
            this.securityCache.removeAcl(string3);
        }
        this.getAcl(string, n);
    }

    private void finalize(Properties properties) {
        String string = properties.getProperty("security_event_para_principal");
        if (string == null) {
            return;
        }
        String string2 = properties.getProperty("security_event_para_principal_type");
        if (string2 == null) {
            return;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(numberFormatException);
            return;
        }
        switch (n) {
            case 1: {
                this.get(string);
                break;
            }
            case 2: {
                this.getAcl(string);
                break;
            }
            case 3: {
                this.getAllAclNames(string);
                break;
            }
        }
    }

    private void get(String string) {
        Hashtable hashtable = null;
        try {
            hashtable = this.userPrivilegeProvider.getUserPrivileges(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
        }
        BaseUser baseUser = this.getUser(string);
        if (baseUser == null) {
            return;
        }
        if (hashtable != null) {
            JAcl jAcl = this.securityCache.getExtendAcl();
            if (jAcl == null) {
                this.getExtendAcl();
                return;
            }
            jAcl.removeJAclEntry(baseUser, true);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String[] stringArray = (String[])hashtable.get(string);
                if (!string2.equals(string)) continue;
                JAclEntry jAclEntry = new JAclEntryImpl(string, this);
                jAclEntry.setPrincipal(baseUser);
                int n = 0;
                n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames(stringArray);
                jAclEntry = PermissionUtil.addPrivilegeToAclEntry(jAclEntry, n);
                try {
                    jAcl.addEntry(baseUser, jAclEntry);
                }
                catch (NotOwnerException notOwnerException) {
                    ServiceLogger.logError(notOwnerException, 3);
                }
            }
        }
    }

    private void getAcl(String string) {
        Hashtable hashtable = null;
        try {
            hashtable = this.rolePrivilegeProvider.getRolePrivileges(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
        }
        BaseRole baseRole = this.getRole(string);
        if (baseRole == null) {
            return;
        }
        if (hashtable != null) {
            JAcl jAcl = this.securityCache.getExtendAcl();
            if (jAcl == null) {
                this.getExtendAcl();
                return;
            }
            jAcl.removeJAclEntry(baseRole, true);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String[] stringArray = (String[])hashtable.get(string);
                if (!string2.equals(string)) continue;
                JAclEntry jAclEntry = new JAclEntryImpl(string, this);
                jAclEntry.setPrincipal(baseRole);
                int n = 0;
                n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames(stringArray);
                jAclEntry = PermissionUtil.addPrivilegeToAclEntry(jAclEntry, n);
                try {
                    jAcl.addEntry(baseRole, jAclEntry);
                }
                catch (NotOwnerException notOwnerException) {
                    ServiceLogger.logError(notOwnerException, 3);
                }
            }
        }
    }

    private void getAllAclNames(String string) {
        Hashtable hashtable = null;
        try {
            hashtable = this.groupPrivilegeProvider.getGroupPrivileges(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
        }
        BaseGroup baseGroup = this.getGroup(string);
        if (baseGroup == null) {
            return;
        }
        if (hashtable != null) {
            JAcl jAcl = this.securityCache.getExtendAcl();
            if (jAcl == null) {
                this.getExtendAcl();
                return;
            }
            jAcl.removeJAclEntry(baseGroup, true);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String[] stringArray = (String[])hashtable.get(string);
                if (!string2.equals(string)) continue;
                JAclEntry jAclEntry = new JAclEntryImpl(string, this);
                jAclEntry.setPrincipal(baseGroup);
                int n = 0;
                n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames(stringArray);
                jAclEntry = PermissionUtil.addPrivilegeToAclEntry(jAclEntry, n);
                try {
                    jAcl.addEntry(baseGroup, jAclEntry);
                }
                catch (NotOwnerException notOwnerException) {
                    ServiceLogger.logError(notOwnerException, 3);
                }
            }
        }
    }

    public void destory() {
        this.SEDU.destroy();
        this.securityCache.clear();
        this.securityCache.dispose();
    }

    protected void finalize() throws Throwable {
        this.SEDU.destroy();
        this.securityCache.clear();
        this.securityCache.dispose();
        super.finalize();
    }
}

