/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.io.Serializable;
import java.util.Vector;
import jet.server.intf.security.Group;

public class GroupImpl
implements Group,
Serializable {
    private String name;
    private boolean builtin;
    private String description;
    private int type;
    private Vector parentGroupNames = new Vector();
    private Vector subGroupNames = new Vector();
    private Vector userNames = new Vector();
    private Vector roleNames = new Vector();
    private int parentGroupsFlag = 0;
    private int subGroupsFlag = 0;
    private int usersFlag = 0;
    private int rolesFlag = 0;

    public GroupImpl() {
    }

    public GroupImpl(String string) {
        this.name = string;
    }

    public GroupImpl(String string, boolean bl, String string2, int n) {
        this.name = string;
        this.builtin = bl;
        this.description = string2;
        this.type = n;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public boolean isBuiltin() {
        return this.builtin;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public int getMembersCount() {
        return this.subGroupNames.size() + this.userNames.size();
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setType(int n) {
        this.type = n;
    }

    @Override
    public int getUsersFlag() {
        return this.usersFlag;
    }

    @Override
    public int getRolesFlag() {
        return this.rolesFlag;
    }

    @Override
    public int getSubGroupsFlag() {
        return this.subGroupsFlag;
    }

    @Override
    public int getParentGroupsFlag() {
        return this.parentGroupsFlag;
    }

    @Override
    public Vector getParentGroupNames() {
        return this.parentGroupNames;
    }

    @Override
    public boolean isHaveParentGroup(String string) {
        return this.parentGroupNames.contains(string);
    }

    @Override
    public void addParentGroup(String string) {
        if (!this.parentGroupNames.contains(string)) {
            this.parentGroupNames.add(string);
            int n = string.hashCode();
            this.parentGroupsFlag ^= n;
        }
    }

    @Override
    public void removeParentGroup(String string) {
        if (this.parentGroupNames.contains(string)) {
            this.parentGroupNames.remove(string);
            int n = string.hashCode();
            this.parentGroupsFlag ^= n;
        }
    }

    @Override
    public void addSubGroup(String string) {
        if (!this.subGroupNames.contains(string)) {
            this.subGroupNames.add(string);
            int n = string.hashCode();
            this.subGroupsFlag ^= n;
        }
    }

    @Override
    public void removeSubGroup(String string) {
        if (this.subGroupNames.contains(string)) {
            this.subGroupNames.remove(string);
            int n = string.hashCode();
            this.subGroupsFlag ^= n;
        }
    }

    @Override
    public boolean isHaveSubGroup(String string) {
        return this.subGroupNames.contains(string);
    }

    @Override
    public Vector getSubGroupNames() {
        return this.subGroupNames;
    }

    @Override
    public void addUser(String string) {
        if (!this.userNames.contains(string)) {
            this.userNames.add(string);
            int n = string.hashCode();
            this.usersFlag ^= n;
        }
    }

    @Override
    public void removeUser(String string) {
        if (this.userNames.contains(string)) {
            this.userNames.remove(string);
            int n = string.hashCode();
            this.usersFlag ^= n;
        }
    }

    @Override
    public boolean isHaveUser(String string) {
        return this.userNames.contains(string);
    }

    @Override
    public Vector getUserNames() {
        return this.userNames;
    }

    @Override
    public void addRole(String string) {
        if (!this.roleNames.contains(string)) {
            this.roleNames.add(string);
            int n = string.hashCode();
            this.rolesFlag ^= n;
        }
    }

    @Override
    public void removeRole(String string) {
        if (this.roleNames.contains(string)) {
            this.roleNames.remove(string);
            int n = string.hashCode();
            this.rolesFlag ^= n;
        }
    }

    @Override
    public boolean isHaveRole(String string) {
        return this.roleNames.contains(string);
    }

    @Override
    public Vector getRoleNames() {
        return this.roleNames;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

