/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.io.File;
import java.util.Properties;
import jet.server.ServerEnv;
import jet.server.api.admin.security.JOrganization;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.SecurityListener;
import jet.server.api.custom.security.organization.OrganizationProvider;
import jet.server.api.exception.NoSuchOrganizationException;
import jet.server.api.exception.OrganizationExistsException;
import jet.server.intf.security.SecurityWebUIController;
import jet.server.jrc.security.ExCachedSecurityDataImpl;
import jet.server.jrc.security.admin.JOrganizationImpl;
import jet.server.jrc.security.custom.SecurityListenerSynImpl;
import jet.server.jrc.security.custom.db.organization.OrganizationProviderDBImpl;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;

public class OrganizationManager {
    private ExCachedSecurityDataImpl SEDU;
    OrganizationProvider orgProvider;
    SecurityListener listener;
    private String addOrganization;
    boolean isEnableEditOrg = true;
    boolean isEnableAddOrg = true;
    boolean isEnableRemoveOrg = true;

    public OrganizationManager(ExCachedSecurityDataImpl exCachedSecurityDataImpl, SecurityWebUIController securityWebUIController) {
        this.SEDU = exCachedSecurityDataImpl;
        this.addOrganization = exCachedSecurityDataImpl.getRealmName();
        this.isEnableEditOrg = securityWebUIController.isEditing(24);
        this.isEnableAddOrg = securityWebUIController.isEditing(26);
        this.isEnableRemoveOrg = securityWebUIController.isEditing(25);
        this.orgProvider = exCachedSecurityDataImpl.getOrganizationProvider();
        this.listener = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
    }

    public OrganizationManager(ExCachedSecurityDataImpl exCachedSecurityDataImpl) {
        this.SEDU = exCachedSecurityDataImpl;
        this.addOrganization = exCachedSecurityDataImpl.getRealmName();
        this.orgProvider = exCachedSecurityDataImpl.getOrganizationProvider();
        this.listener = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
    }

    public JOrganization getOrganization(String string) throws NoSuchOrganizationException {
        JOrganization jOrganization = this.SEDU.getOrganization(string);
        if (jOrganization == null) {
            throw new NoSuchOrganizationException(630097, new Object[]{string}, null);
        }
        return jOrganization;
    }

    public String addNewOrganization(String string, String string2, int n) throws OrganizationExistsException {
        if (!this.isEnableAddOrg) {
            return "SECURITY_ERR_ORG_PROVIDER_ADD";
        }
        if (string == null || string.trim().length() == 0) {
            return "SECURITY_ERR_98_EMPTY_ORG_NAME";
        }
        if (string.equals("System")) {
            return "SECURITY_ERR_116_RESERVED_NAME";
        }
        if (!OrganizationProviderDBImpl.isValidName(string)) {
            return "SECURITY_ERR_ORG_NAME_INVALID";
        }
        if (n < 0) {
            return "SECURITY_ERR_99_INVALIDE_USER_AMOUNT";
        }
        try {
            this.getOrganization(string);
            throw new OrganizationExistsException(630099, new Object[]{string}, null);
        }
        catch (NoSuchOrganizationException noSuchOrganizationException) {
            String string3;
            File file;
            Properties properties = new Properties();
            properties.put("organization_name", string);
            properties.put("organization_desc", string2);
            properties.put("organization_maxuser", String.valueOf(n));
            try {
                this.orgProvider.addOrganization(this.addOrganization, properties);
                this.listener.addOrganization(this.addOrganization, string);
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                return "SECURITY_ERR_100_FAIL_TO_ADD_ORG";
            }
            if (this.addOrganization.equals(ServerEnv.getActiveRealm()) && !(file = new File(string3 = ServerEnv.homePath + "logs", string)).exists()) {
                file.mkdirs();
            }
            return null;
        }
    }

    public String updateOrganization(String string, String string2, int n) throws NoSuchOrganizationException {
        if (!this.isEnableEditOrg) {
            return "SECURITY_ERR_ORG_PROVIDER_EDIT";
        }
        if (string == null || string.trim().length() == 0) {
            return "SECURITY_ERR_98_EMPTY_ORG_NAME";
        }
        if (n < 0) {
            return "SECURITY_ERR_99_INVALIDE_USER_AMOUNT";
        }
        JOrganizationImpl jOrganizationImpl = null;
        jOrganizationImpl = (JOrganizationImpl)this.getOrganization(string);
        if (n > 0 && jOrganizationImpl.getUserAmount() > n) {
            return "SECURITY_ERR_ORG_LESS_USER_AMOUNT;" + jOrganizationImpl.getUserAmount();
        }
        Properties properties = new Properties();
        properties.put("organization_name", string);
        properties.put("organization_desc", string2);
        properties.put("organization_maxuser", String.valueOf(n));
        try {
            this.orgProvider.setOrganization(this.addOrganization, properties);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return "SECURITY_ERR_101_FAIL_TO_UPDATE_ORG";
        }
        return null;
    }

    public String removeOrganization(String string) throws NoSuchOrganizationException {
        String string2;
        File file;
        if (!this.isEnableRemoveOrg) {
            return "SECURITY_ERR_ORG_PROVIDER_REMOVE";
        }
        if (string == null || string.trim().length() == 0) {
            return "SECURITY_ERR_98_EMPTY_ORG_NAME";
        }
        try {
            this.orgProvider.removeOrganization(this.addOrganization, string);
            this.listener.removeOrganization(this.addOrganization, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return "SECURITY_ERR_102_FAIL_TO_DEL_ORG";
        }
        if (this.addOrganization.equals(ServerEnv.getActiveRealm()) && (file = new File(string2 = ServerEnv.homePath + "logs", string)).exists()) {
            SchdTools.deleteDir(file.getAbsolutePath());
        }
        return null;
    }
}

