/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.server.ServerEnv;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.SecurityListener;
import jet.server.api.custom.security.relation.RoleGroupRelationProvider;
import jet.server.api.custom.security.relation.RoleUserRelationProvider;
import jet.server.api.custom.security.role.RoleProvider;
import jet.server.api.exception.GroupExistsException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.RoleExistsException;
import jet.server.intf.security.Group;
import jet.server.intf.security.Role;
import jet.server.intf.security.SecurityWebUIController;
import jet.server.jrc.security.ExCachedSecurityDataImpl;
import jet.server.jrc.security.cache.CachedSecurityDataImpl;
import jet.server.jrc.security.custom.SecurityListenerSynImpl;
import jet.server.jrc.security.custom.db.role.RoleProviderDBImpl;
import jet.server.log.ServiceLogger;

public class RoleDataManager {
    private String SEDU;
    private SecurityListener TAG_ROLE_DB_BUILDIN;
    private CachedSecurityDataImpl TAG_ROLE_DB_TYPE;
    protected RoleProvider roleProvider;
    protected RoleGroupRelationProvider roleGroupRelationProvider;
    protected RoleUserRelationProvider roleUserRelationProvider;
    boolean isEnableEditRole = true;
    boolean isEnableAddRole = true;
    boolean isEnableRemoveRole = true;
    boolean isEnableEditRoleSubRoleRelation = true;
    boolean isEnableEditRoleGroupRelation = true;

    public RoleDataManager(ExCachedSecurityDataImpl exCachedSecurityDataImpl, SecurityWebUIController securityWebUIController) {
        this.TAG_ROLE_DB_TYPE = exCachedSecurityDataImpl;
        this.SEDU = exCachedSecurityDataImpl.getRealmName();
        this.isEnableEditRole = securityWebUIController.isEditing(5);
        this.isEnableAddRole = securityWebUIController.isEditing(7);
        this.isEnableRemoveRole = securityWebUIController.isEditing(6);
        this.isEnableEditRoleSubRoleRelation = securityWebUIController.isEditing(21);
        this.isEnableEditRoleGroupRelation = securityWebUIController.isEditing(18);
        this.roleProvider = exCachedSecurityDataImpl.getRoleProvider();
        this.roleGroupRelationProvider = exCachedSecurityDataImpl.getRoleGroupRelationProvider();
        this.roleUserRelationProvider = exCachedSecurityDataImpl.getRoleUserRelationProvider();
        this.TAG_ROLE_DB_BUILDIN = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
    }

    public RoleDataManager(ExCachedSecurityDataImpl exCachedSecurityDataImpl) {
        this.TAG_ROLE_DB_TYPE = exCachedSecurityDataImpl;
        this.SEDU = exCachedSecurityDataImpl.getRealmName();
        this.roleProvider = exCachedSecurityDataImpl.getRoleProvider();
        this.roleGroupRelationProvider = exCachedSecurityDataImpl.getRoleGroupRelationProvider();
        this.roleUserRelationProvider = exCachedSecurityDataImpl.getRoleUserRelationProvider();
        this.TAG_ROLE_DB_BUILDIN = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
    }

    public synchronized String addNewRole(String string, String string2, int n) throws RoleExistsException {
        if (!this.isEnableAddRole) {
            return "SECURITY_ERR_ROLE_PROVIDER_ADD";
        }
        try {
            this.getBaseRole(string);
            throw new RoleExistsException(630082, (Object[])new String[]{string}, null);
        }
        catch (NoSuchRoleException noSuchRoleException) {
            ServiceLogger.logError((Throwable)((Object)noSuchRoleException), 3);
            Properties properties = new Properties();
            properties.setProperty("role_name", string);
            properties.setProperty("role_description", string2);
            properties.setProperty(RoleProviderDBImpl.TAG_ROLE_DB_TYPE, String.valueOf(n));
            properties.setProperty(RoleProviderDBImpl.TAG_ROLE_DB_BUILDIN, "false");
            try {
                this.roleProvider.addRole(this.SEDU, properties);
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError((Throwable)((Object)jRCustomerException));
                return "SECURITY_M_01001";
            }
            this.TAG_ROLE_DB_BUILDIN.addPrincipal(this.SEDU, string, 2);
            return null;
        }
    }

    public synchronized String removeRole(String string) throws NoSuchRoleException {
        if (!this.isEnableRemoveRole) {
            return "SECURITY_ERR_ROLE_PROVIDER_REMOVE";
        }
        this.getBaseRole(string);
        try {
            this.roleProvider.removeRole(this.SEDU, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return "SECURITY_M_01002";
        }
        this.TAG_ROLE_DB_BUILDIN.removePrincipal(this.SEDU, string, 2);
        return null;
    }

    public synchronized Role getRole(String string) throws NoSuchRoleException {
        Role role = this.TAG_ROLE_DB_TYPE.getIntegrityRole(string);
        if (role == null) {
            throw new NoSuchRoleException(630002, (Object[])new String[]{string}, null);
        }
        return role;
    }

    public synchronized BaseRole getBaseRole(String string) throws NoSuchRoleException {
        BaseRole baseRole = this.TAG_ROLE_DB_TYPE.getRole(string);
        if (baseRole == null) {
            throw new NoSuchRoleException(630002, (Object[])new String[]{string}, null);
        }
        return baseRole;
    }

    public synchronized String removeRoleFromParentRole(String string, String string2) throws NoSuchRoleException {
        if (!this.isEnableEditRoleSubRoleRelation) {
            return "SECURITY_ERR_ROLE_SUBROLE_PROVIDER_EDIT";
        }
        BaseRole baseRole = this.getBaseRole(string);
        BaseRole baseRole2 = this.getBaseRole(string2);
        if (!baseRole.getParentRoleNames().contains(string2)) {
            return "SECURITY_ERR_14_HAVE_NOT_PARENT";
        }
        if (!baseRole2.getSubRoleNames().contains(string)) {
            return "SECURITY_ERR_15_HAVE_NOT_SUBROLE";
        }
        try {
            this.roleProvider.removeSubRole(this.SEDU, string2, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return "SECURITY_M_04005";
        }
        this.TAG_ROLE_DB_BUILDIN.removeRelation(this.SEDU, string2, 2, string, 2);
        return null;
    }

    public synchronized String addRoleToParentRole(String string, String string2) throws NoSuchRoleException {
        if (!this.isEnableEditRoleSubRoleRelation) {
            return "SECURITY_ERR_ROLE_SUBROLE_PROVIDER_EDIT";
        }
        BaseRole baseRole = this.getBaseRole(string);
        BaseRole baseRole2 = this.getBaseRole(string2);
        if (baseRole.getParentRoleNames().contains(string2)) {
            String[] stringArray = new String[]{string, string2};
            return "SECURITY_ERR_17_HAVE_PARENT";
        }
        if (baseRole2.getSubRoleNames().contains(string)) {
            return "SECURITY_ERR_18_HAVE_SUBROLE";
        }
        if (ServerEnv.isEnableMultipleOrganization()) {
            String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
            String[] stringArray2 = CSUtil.parsePrincipalDisplayName(string2);
            if (stringArray2[0] != null) {
                if (stringArray[0] == null) {
                    return "SECURITY_ERR_112_NOT_BELONG_ORG_ROLE";
                }
                if (!stringArray2[0].equals(stringArray[0])) {
                    return "SECURITY_ERR_113_CROSS_ORG";
                }
            }
        }
        try {
            this.roleProvider.addSubRole(this.SEDU, string2, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return "SECURITY_M_04006";
        }
        catch (RoleExistsException roleExistsException) {
            ServiceLogger.logError((Throwable)((Object)roleExistsException));
            return "SECURITY_M_04023";
        }
        this.TAG_ROLE_DB_BUILDIN.addRelation(this.SEDU, string2, 2, string, 2);
        return null;
    }

    public synchronized String addGroupIntoRole(String string, String string2) throws NoSuchGroupException, NoSuchRoleException {
        if (!this.isEnableEditRoleGroupRelation) {
            return "SECURITY_ERR_ROLE_GROUP_PROVIDER_EDIT";
        }
        BaseGroup baseGroup = this.getBaseGroup(string);
        if (baseGroup.getRoleNames().contains(string2)) {
            return "SECURITY_ERR_86_GROUP_EXIST_ROLE";
        }
        BaseRole baseRole = this.getBaseRole(string2);
        if (baseRole.getGroupNames().contains(string)) {
            return "SECURITY_ERR_87_ROLE_EXIST_SUB_GROUP";
        }
        if (ServerEnv.isEnableMultipleOrganization()) {
            String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
            String[] stringArray2 = CSUtil.parsePrincipalDisplayName(string2);
            if (stringArray2[0] != null) {
                if (stringArray[0] == null) {
                    return "SECURITY_ERR_114_NOT_BELONG_ORG_ROLE";
                }
                if (!stringArray2[0].equals(stringArray[0])) {
                    return "SECURITY_ERR_115_CROSS_ORG";
                }
            }
        }
        try {
            this.roleGroupRelationProvider.addGroupToRole(this.SEDU, string2, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return "SECURITY_M_04007";
        }
        catch (GroupExistsException groupExistsException) {
            ServiceLogger.logError((Throwable)((Object)groupExistsException));
            return "SECURITY_M_04025";
        }
        this.TAG_ROLE_DB_BUILDIN.addRelation(this.SEDU, string2, 2, string, 3);
        return null;
    }

    public synchronized String removeGroupFromRole(String string, String string2) throws NoSuchGroupException, NoSuchRoleException {
        if (!this.isEnableEditRoleGroupRelation) {
            return "SECURITY_ERR_ROLE_GROUP_PROVIDER_EDIT";
        }
        BaseGroup baseGroup = this.getBaseGroup(string);
        if (!baseGroup.getRoleNames().contains(string2)) {
            return "SECURITY_ERR_89_GROUP_HAVE_NOT_ROLE";
        }
        BaseRole baseRole = this.getBaseRole(string2);
        if (!baseRole.getGroupNames().contains(string)) {
            return "SECURITY_ERR_90_ROLE_NOT_EXIST_SUB_GROUP";
        }
        try {
            this.roleGroupRelationProvider.removeGroupFromRole(this.SEDU, string2, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError((Throwable)((Object)jRCustomerException));
            return "SECURITY_M_04008";
        }
        this.TAG_ROLE_DB_BUILDIN.removeRelation(this.SEDU, string2, 2, string, 3);
        return null;
    }

    public BaseGroup getBaseGroup(String string) throws NoSuchGroupException {
        Group group = (Group)this.TAG_ROLE_DB_TYPE.getGroup(string);
        if (group == null) {
            throw new NoSuchGroupException(630001, (Object[])new String[]{string}, null);
        }
        return group;
    }

    public Enumeration getAllRoles() {
        Role[] roleArray = this.TAG_ROLE_DB_TYPE.getAllRoles();
        Vector<Role> vector = new Vector<Role>();
        for (int i = 0; i < roleArray.length; ++i) {
            Role role = roleArray[i];
            vector.add(role);
        }
        return vector.elements();
    }

    public Enumeration getAllRoleNames() {
        Role[] roleArray = this.TAG_ROLE_DB_TYPE.getAllRoles();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < roleArray.length; ++i) {
            Role role = roleArray[i];
            vector.add(role.getName());
        }
        return vector.elements();
    }
}

