/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.security.Principal;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.cs.jacl.JAcl;
import jet.server.ServerEnv;
import jet.server.api.Permissions;
import jet.server.api.admin.AdvancedPasswordRule;
import jet.server.api.admin.cfg.ConfigService;
import jet.server.api.admin.cfg.ConfigurationLDAP;
import jet.server.api.admin.security.JOrganization;
import jet.server.api.custom.security.AuthenticationProvider;
import jet.server.api.custom.security.AuthorizationProvider;
import jet.server.api.exception.GroupExistsException;
import jet.server.api.exception.InUseException;
import jet.server.api.exception.InvalidPasswordException;
import jet.server.api.exception.InvalidUserException;
import jet.server.api.exception.NoSuchAclException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchOrganizationException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.OrganizationExistsException;
import jet.server.api.exception.RoleExistsException;
import jet.server.api.exception.UserExistsException;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.intf.resource.Node;
import jet.server.intf.resource.Version;
import jet.server.intf.security.Comparator;
import jet.server.intf.security.ExSecurityData;
import jet.server.intf.security.Group;
import jet.server.intf.security.PrincipalListener;
import jet.server.intf.security.Role;
import jet.server.intf.security.SecurityProvider;
import jet.server.intf.security.SecurityService;
import jet.server.intf.security.SecurityWebUIController;
import jet.server.intf.security.User;
import jet.server.jrc.resource.VersionImpl;
import jet.server.jrc.security.AclDataManager;
import jet.server.jrc.security.AclManager;
import jet.server.jrc.security.AdvancedPasswordRuleImpl;
import jet.server.jrc.security.ExCachedSecurityDataImpl;
import jet.server.jrc.security.GroupComparator;
import jet.server.jrc.security.GroupDataManager;
import jet.server.jrc.security.GroupManagerImpl;
import jet.server.jrc.security.NameComparator;
import jet.server.jrc.security.NoSuchAclEntryException;
import jet.server.jrc.security.OrganizationManager;
import jet.server.jrc.security.RoleComparator;
import jet.server.jrc.security.RoleDataManager;
import jet.server.jrc.security.RoleManager;
import jet.server.jrc.security.Sorter;
import jet.server.jrc.security.UserComparator;
import jet.server.jrc.security.UserDataManager;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.security.UserImpl;
import jet.server.jrc.security.UserManager;
import jet.server.jrc.security.admin.JOrganizationImpl;
import jet.server.jrc.security.cache.CachedSecurityDataImpl;
import jet.server.jrc.security.custom.SecurityListenerSynImpl;
import jet.server.jrc.security.custom.db.SecurityDBEnv;
import jet.server.jrc.security.ldap.LDAPData;
import jet.server.jrc.security.ldap.intf.LDAPGroup;
import jet.server.jrc.security.ldap.intf.LDAPUser;
import jet.server.log.ServiceLogger;
import jet.server.util.StringUtils;
import jet.util.MiscTools;

public class SecurityServiceImpl
implements SecurityService,
SecurityProvider {
    UserManager userManager = null;
    RoleManager roleManager = null;
    AclManager aclManager = null;
    GroupManagerImpl groupManager = null;
    OrganizationManager orgManager = null;
    CachedSecurityDataImpl secData = null;
    SecurityWebUIController securityWebUIController = null;
    private static Hashtable P_DELETE = new Hashtable();
    private String P_GRANT;
    private AuthenticationProvider P_WRITE;
    private AuthorizationProvider SEDU;

    public SecurityServiceImpl(String string, ExCachedSecurityDataImpl exCachedSecurityDataImpl, SecurityWebUIController securityWebUIController) {
        this.P_GRANT = string;
        this.secData = exCachedSecurityDataImpl;
        this.securityWebUIController = securityWebUIController;
        SecurityListenerSynImpl securityListenerSynImpl = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
        UserDataManager userDataManager = new UserDataManager(exCachedSecurityDataImpl, securityWebUIController);
        RoleDataManager roleDataManager = new RoleDataManager(exCachedSecurityDataImpl, securityWebUIController);
        AclDataManager aclDataManager = new AclDataManager(exCachedSecurityDataImpl, securityWebUIController);
        GroupDataManager groupDataManager = new GroupDataManager(exCachedSecurityDataImpl, securityWebUIController);
        AdvancedPasswordRuleImpl advancedPasswordRuleImpl = new AdvancedPasswordRuleImpl();
        this.groupManager = new GroupManagerImpl(groupDataManager);
        this.userManager = new UserManager(userDataManager, advancedPasswordRuleImpl);
        this.roleManager = new RoleManager(roleDataManager);
        this.aclManager = new AclManager(aclDataManager, exCachedSecurityDataImpl);
        this.orgManager = new OrganizationManager(exCachedSecurityDataImpl, securityWebUIController);
        this.P_WRITE = exCachedSecurityDataImpl.getAuthenticationProvider();
        this.SEDU = exCachedSecurityDataImpl.getAuthorizationProvider();
        this.P_WRITE.addSecurityListener(securityListenerSynImpl);
    }

    public SecurityServiceImpl(String string, ExCachedSecurityDataImpl exCachedSecurityDataImpl) {
        this.P_GRANT = string;
        this.secData = exCachedSecurityDataImpl;
        SecurityListenerSynImpl securityListenerSynImpl = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
        UserDataManager userDataManager = new UserDataManager(exCachedSecurityDataImpl);
        RoleDataManager roleDataManager = new RoleDataManager(exCachedSecurityDataImpl);
        AclDataManager aclDataManager = new AclDataManager(exCachedSecurityDataImpl);
        GroupDataManager groupDataManager = new GroupDataManager(exCachedSecurityDataImpl);
        AdvancedPasswordRuleImpl advancedPasswordRuleImpl = new AdvancedPasswordRuleImpl();
        this.groupManager = new GroupManagerImpl(groupDataManager);
        this.userManager = new UserManager(userDataManager, advancedPasswordRuleImpl);
        this.roleManager = new RoleManager(roleDataManager);
        this.aclManager = new AclManager(aclDataManager, exCachedSecurityDataImpl);
        this.orgManager = new OrganizationManager(exCachedSecurityDataImpl);
        this.P_WRITE = exCachedSecurityDataImpl.getAuthenticationProvider();
        this.SEDU = exCachedSecurityDataImpl.getAuthorizationProvider();
        this.P_WRITE.addSecurityListener(securityListenerSynImpl);
    }

    @Override
    public boolean checkPrivilege(String string, String string2) {
        if (!ServerEnv.needSecurity()) {
            return true;
        }
        return this.SEDU.checkPrivilege(this.P_GRANT, string, string2);
    }

    @Override
    public boolean isAdminUser(Node node, String string) {
        String string2 = node.getAbsolutePath();
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
        String[] stringArray2 = CSUtil.parseVirtualResourcePath(string2);
        boolean bl = false;
        if (StringUtils.equals(stringArray2[0], stringArray[0])) {
            bl = stringArray[0] == null ? this.isAdminUser(string) : this.isOrganizationAdminUser(string);
        }
        return bl;
    }

    @Override
    public boolean checkPermission(Node node, String string, Permission permission) {
        if (!ServerEnv.needSecurity() || this.isAdminUser(node, string) || node.isOwnerOrCreator(string)) {
            return true;
        }
        Node node2 = node;
        if ((node2 = this.P_DELETE(node2)).getAclID() == -1 && UserDataToolkit.useBuiltinAuthorizationProvider()) {
            return false;
        }
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
        String[] stringArray2 = CSUtil.parseVirtualResourcePath(node.getAbsolutePath());
        if (stringArray[0] != null ? (stringArray2[0] != null ? !stringArray[0].equals(stringArray2[0]) : permission.equals(Permissions.P_WRITE) || permission.equals(Permissions.P_DELETE) || permission.equals(Permissions.P_GRANT)) : stringArray2[0] != null) {
            return false;
        }
        int n = -1;
        boolean bl = false;
        if (node2.getNodeType() == 3) {
            bl = true;
            n = ((Version)node2).getVersionNumber();
        }
        boolean bl2 = false;
        if (bl) {
            bl2 = this.SEDU.isPermissionOk(this.P_GRANT, string, node2.getParent().getAbsolutePath(), n, permission);
            ServiceLogger.logDebug(6630002, new Object[]{node.getParent().getAbsolutePath(), string, permission, String.valueOf(bl2)}, 6);
        } else {
            bl2 = this.SEDU.isPermissionOk(this.P_GRANT, string, node2.getAbsolutePath(), n, permission);
            ServiceLogger.logDebug(6630002, new Object[]{node.getAbsolutePath(), string, permission, String.valueOf(bl2)}, 6);
        }
        return bl2;
    }

    private Node P_DELETE(Node node) {
        if (!UserDataToolkit.useBuiltinAuthorizationProvider() || node.getAclID() != -1 || node.isRoot() || node.getAbsolutePath().endsWith("/COMPONENT_LIB")) {
            if (node.getNodeType() == 3 && node.isDynamic()) {
                return this.P_DELETE(node.getParent());
            }
            return node;
        }
        return this.P_DELETE(node.getParent());
    }

    @Override
    public boolean isValidUser(String string, String string2) {
        try {
            return this.isValidUserEx(string, string2);
        }
        catch (InvalidUserException invalidUserException) {
            return false;
        }
    }

    @Override
    public boolean isValidUserEx(String string, String string2) throws InvalidUserException {
        block8: {
            HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
            ConfigService configService = httpRptServer.getAdminService().getConfigService();
            ConfigurationLDAP configurationLDAP = configService.getConfigurationLDAP();
            boolean bl = false;
            String string3 = LDAPData.getProperty("enableLDAPSupport");
            if (string3 != null && string3.equals("true")) {
                bl = true;
            }
            boolean bl2 = false;
            String string4 = LDAPData.getProperty("enableAutoImportLDAPUser");
            if (string4 != null && string4.equals("true")) {
                bl2 = true;
            }
            try {
                User user = this.getIntegrityUser(string);
                int n = user.getAuthType();
                if (n == 0 || n == -1 || string.equals(SecurityDBEnv.getBuiltinAdminUserPwd(this.P_GRANT)[0])) {
                    return this.P_GRANT(string, string2);
                }
                if (n == 1 && bl) {
                    String string5 = user.getPassword();
                    if (string5 != null && string5.length() != 0) {
                        return configurationLDAP.isValidLDAPUserByDN(string, string5, string2);
                    }
                    return configurationLDAP.isValidLDAPUser(string, string2);
                }
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!bl || !bl2) break block8;
                String string6 = configurationLDAP.autoImportLDAPUser(string, string2);
                if (string6 != null) {
                    ServiceLogger.logDebug(string6);
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean P_GRANT(String string, String string2) throws InvalidUserException {
        boolean bl = false;
        bl = this.P_WRITE.isValidUser(this.P_GRANT, string, string2);
        if (this.isExpired(string)) {
            throw new InvalidUserException(630107, new String[]{this.P_GRANT, string}, null, 1);
        }
        return bl;
    }

    @Override
    public boolean isAdminUser(String string) {
        boolean bl = this.P_WRITE.isAdminUser(this.P_GRANT, string);
        return bl;
    }

    public static void removeKey(String string) {
        if (P_DELETE.containsKey(string)) {
            P_DELETE.remove(string);
        }
    }

    @Override
    public User getUser(String string) throws NoSuchUserException {
        if (string == null || string.length() == 0) {
            throw new NoSuchUserException(630004);
        }
        if (string.equals("JReport_System_User")) {
            return UserImpl.systemUser;
        }
        User user = (User)this.secData.getUser(string);
        if (user == null) {
            throw new NoSuchUserException(630003, new Object[]{string}, null);
        }
        return user;
    }

    @Override
    public User getIntegrityUser(String string) throws NoSuchUserException {
        if (string == null || string.length() == 0) {
            throw new NoSuchUserException(630004);
        }
        if (string.equals("JReport_System_User")) {
            return UserImpl.systemUser;
        }
        return this.userManager.getUser(string);
    }

    @Override
    public Vector getAllUsers() {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.userManager.getAllUsers();
        while (enumeration.hasMoreElements()) {
            object = (User)enumeration.nextElement();
            vector.add(object);
        }
        object = new UserComparator();
        Sorter.sort(vector, (Comparator)object);
        return vector;
    }

    @Override
    public Vector getUsersNameByRole(String string) throws NoSuchRoleException {
        return this.roleManager.getSubUserNames(string);
    }

    @Override
    public Role getRole(String string) throws NoSuchRoleException {
        return this.roleManager.getRole(string);
    }

    @Override
    public Vector getAllRoles() {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.roleManager.getAllRoles();
        while (enumeration.hasMoreElements()) {
            object = (Role)enumeration.nextElement();
            vector.add(object);
        }
        object = new RoleComparator();
        Sorter.sort(vector, (Comparator)object);
        return vector;
    }

    @Override
    public Vector getRolesNameByUser(String string) throws NoSuchUserException {
        return this.userManager.getParentRoleNames(string);
    }

    @Override
    public Group getGroup(String string) throws NoSuchGroupException {
        return this.groupManager.getGroup(string);
    }

    @Override
    public Vector getAllGroups() {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.groupManager.getAllGroups();
        while (enumeration.hasMoreElements()) {
            object = (Group)enumeration.nextElement();
            vector.add(object);
        }
        object = new GroupComparator();
        Sorter.sort(vector, (Comparator)object);
        return vector;
    }

    @Override
    public Vector getGroupsNameByUser(String string) throws NoSuchUserException {
        User user = this.getUser(string);
        return user.getGroupNames();
    }

    @Override
    public Vector getUsersNameByGroup(String string) throws NoSuchGroupException {
        Group group = this.getGroup(string);
        return group.getUserNames();
    }

    @Override
    public Vector getGroupsByUser(String string) throws NoSuchUserException {
        Vector<Group> vector = new Vector<Group>();
        User user = this.getUser(string);
        Vector vector2 = user.getGroupNames();
        for (int i = 0; i < vector2.size(); ++i) {
            String string2 = (String)vector2.elementAt(i);
            try {
                Group group = this.getGroup(string2);
                vector.add(group);
                continue;
            }
            catch (NoSuchGroupException noSuchGroupException) {
                ServiceLogger.logError((Throwable)((Object)noSuchGroupException));
            }
        }
        return vector;
    }

    @Override
    public Vector getUsersByGroup(String string) throws NoSuchGroupException {
        Group group = this.groupManager.getGroup(string);
        Vector<User> vector = new Vector<User>();
        Vector vector2 = group.getUserNames();
        for (int i = 0; i < vector2.size(); ++i) {
            String string2 = (String)vector2.elementAt(i);
            User user = null;
            try {
                user = this.getUser(string2);
            }
            catch (NoSuchUserException noSuchUserException) {
                ServiceLogger.logError((Throwable)((Object)noSuchUserException));
                continue;
            }
            vector.add(user);
        }
        return vector;
    }

    @Override
    public Vector getRolesByGroup(String string) throws NoSuchGroupException {
        Vector<Role> vector = new Vector<Role>();
        Group group = this.getGroup(string);
        Vector vector2 = group.getRoleNames();
        for (int i = 0; i < vector2.size(); ++i) {
            String string2 = (String)vector2.elementAt(i);
            try {
                Role role = this.getRole(string2);
                vector.add(role);
                continue;
            }
            catch (NoSuchRoleException noSuchRoleException) {
                ServiceLogger.logError((Throwable)((Object)noSuchRoleException));
            }
        }
        return vector;
    }

    @Override
    public Vector getGroupsByRole(String string) throws NoSuchRoleException {
        Vector<Group> vector = new Vector<Group>();
        Role role = this.getRole(string);
        Vector vector2 = role.getGroupNames();
        for (int i = 0; i < vector2.size(); ++i) {
            String string2 = (String)vector2.elementAt(i);
            try {
                Group group = this.getGroup(string2);
                vector.add(group);
                continue;
            }
            catch (NoSuchGroupException noSuchGroupException) {
                ServiceLogger.logError((Throwable)((Object)noSuchGroupException));
            }
        }
        return vector;
    }

    @Override
    public Hashtable[] getPermissions(Node node) {
        Hashtable[] hashtableArray;
        String string = node.getAbsolutePath();
        int n = -1;
        if (node.getNodeType() == 3) {
            hashtableArray = (Hashtable[])node;
            n = hashtableArray.getVersionNumber();
        }
        hashtableArray = new Hashtable[]{new Hashtable(), new Hashtable(), new Hashtable()};
        Hashtable[] hashtableArray2 = null;
        try {
            hashtableArray2 = this.aclManager.getPermssions(string, n);
        }
        catch (NotOwnerException notOwnerException) {
        }
        catch (NoSuchAclException noSuchAclException) {
            // empty catch block
        }
        if (hashtableArray2 != null) {
            return hashtableArray2;
        }
        return hashtableArray;
    }

    @Override
    public int setPermissions(Node node, String string, Hashtable[] hashtableArray) throws NoSuchAclException {
        String string2 = node.getAbsolutePath();
        int n = -1;
        if (node.getNodeType() == 3) {
            VersionImpl versionImpl = (VersionImpl)node;
            n = versionImpl.getVersionNumber();
        }
        return this.aclManager.setPermissions(string2, n, hashtableArray);
    }

    @Override
    public boolean removeUserPermissions(Node node, String string) throws NoSuchAclException, NoSuchAclEntryException {
        User user = null;
        try {
            user = this.getUser(string);
        }
        catch (NoSuchUserException noSuchUserException) {
            return false;
        }
        String string2 = node.getAbsolutePath();
        int n = -1;
        if (node.getNodeType() == 3) {
            VersionImpl versionImpl = (VersionImpl)node;
            n = versionImpl.getVersionNumber();
        }
        return this.aclManager.removeAclEntry(string2, n, user);
    }

    @Override
    public boolean removeRolePermissions(Node node, String string) throws NoSuchAclException, NoSuchAclEntryException {
        Role role = null;
        try {
            role = this.getRole(string);
        }
        catch (NoSuchRoleException noSuchRoleException) {
            return false;
        }
        String string2 = node.getAbsolutePath();
        int n = -1;
        if (node.getNodeType() == 3) {
            VersionImpl versionImpl = (VersionImpl)node;
            n = versionImpl.getVersionNumber();
        }
        return this.aclManager.removeAclEntry(string2, n, role);
    }

    @Override
    public boolean removeGroupPermissions(Node node, String string) throws NoSuchAclException, NoSuchAclEntryException {
        Group group = null;
        try {
            group = this.getGroup(string);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            return false;
        }
        String string2 = node.getAbsolutePath();
        int n = -1;
        if (node.getNodeType() == 3) {
            VersionImpl versionImpl = (VersionImpl)node;
            n = versionImpl.getVersionNumber();
        }
        return this.aclManager.removeAclEntry(string2, n, group);
    }

    public boolean addAcl(String string, String string2, int n, Hashtable[] hashtableArray) {
        this.aclManager.setPermissions(string2, n, hashtableArray);
        return true;
    }

    @Override
    public JAcl getAclByID(int n) {
        return null;
    }

    public JAcl getAcl(String string, int n) throws NoSuchAclException, NotOwnerException {
        return this.aclManager.getAcl(string, n);
    }

    @Override
    public String changePassword(boolean bl, String string, String string2, String string3, String string4) throws NoSuchUserException {
        if (!bl) {
            if (string.equals("guest")) {
                return "SECURITY_ERR_26_GUEST_NO_POWER_CHANGE_PS";
            }
            if (!this.isValidUser(string, string2)) {
                return "SECURITY_ERR_USER_PASSWORD_CHANGE";
            }
            if (!string.equals(string3) && !this.isAdminUser(string)) {
                return "SECURITY_ERR_27_USER_NO_POWER_CHANGE_PS";
            }
        } else if (this.isAdminUser(string) || this.isOrganizationAdminUser(string)) {
            if (!this.isValidUser(string, string2)) {
                return "SECURITY_ERR_USER_PASSWORD_CHANGE";
            }
        } else {
            return "SVR_125";
        }
        String string5 = null;
        User user = this.userManager.getUser(string3);
        if (user.getAuthType() == 1) {
            return "SECURITY_ERR_NOT_CHANGE_LDAP_USER_PASSWORD";
        }
        this.userManager.getUser(string);
        if (MiscTools.containChar((String)string4, (String)" :")) {
            return "SVR_26";
        }
        boolean bl2 = user.isEnableNullPS();
        if (!bl2) {
            if (string4 == null || string4.trim().length() == 0) {
                string5 = "SVR_27";
            } else {
                int n = user.getMinPSLength();
                if (string4.length() < n) {
                    string5 = "SVR_32";
                }
            }
        }
        if (string5 == null) {
            string5 = this.P_WRITE.changePassword(this.P_GRANT, string, string3, string2, string4);
        }
        if (string5 == null) {
            ServiceLogger.logManageSuccessEvent(this.P_GRANT, string3, 6630079, string3, 6);
        }
        return string5;
    }

    @Override
    public String changePasswordEx(boolean bl, String string, String string2, String string3, String string4) throws NoSuchUserException, InvalidPasswordException {
        if (!bl) {
            if (string.equals("guest")) {
                return "SECURITY_ERR_26_GUEST_NO_POWER_CHANGE_PS";
            }
            if (!this.isValidUser(string, string2)) {
                return "SECURITY_ERR_USER_PASSWORD_CHANGE";
            }
            if (!string.equals(string3) && !this.isAdminUser(string)) {
                return "SECURITY_ERR_27_USER_NO_POWER_CHANGE_PS";
            }
        } else if (this.isAdminUser(string) || this.isOrganizationAdminUser(string)) {
            if (!this.isValidUser(string, string2)) {
                return "SECURITY_ERR_USER_PASSWORD_CHANGE";
            }
        } else {
            return "SVR_125";
        }
        String string5 = null;
        User user = this.userManager.getUser(string3);
        if (user.getAuthType() == 1) {
            return "SECURITY_ERR_NOT_CHANGE_LDAP_USER_PASSWORD";
        }
        this.userManager.getUser(string);
        if (MiscTools.containChar((String)string4, (String)" :")) {
            return "SVR_26";
        }
        boolean bl2 = user.isEnableNullPS();
        if (!bl2) {
            if (string4 == null || string4.trim().length() == 0) {
                string5 = "SVR_27";
            } else {
                int n = user.getMinPSLength();
                if (string4.length() < n) {
                    string5 = "SVR_32";
                }
            }
        }
        AdvancedPasswordRule advancedPasswordRule = this.userManager.getPasswordRule();
        int n = string3.indexOf("\\");
        String string6 = null;
        String string7 = string3;
        if (n > 0) {
            string6 = string3.substring(0, n);
            string7 = string3.substring(n + 1);
        }
        String string8 = string2;
        advancedPasswordRule.validate(string6, string7, string8, string4);
        if (string5 == null) {
            string5 = this.P_WRITE.changePassword(this.P_GRANT, string, string3, string2, string4);
        }
        if (string5 == null) {
            ServiceLogger.logManageSuccessEvent(this.P_GRANT, string3, 6630079, string3, 6);
        }
        return string5;
    }

    @Override
    public String updateAttributes(String string, String string2, String string3, String string4, boolean bl, int n, Date date, boolean bl2, int n2, boolean bl3) throws NoSuchUserException {
        return this.userManager.updataAttributes(string, string2, string3, string4, bl, n, date, bl2, n2, bl3);
    }

    @Override
    public String addNewUser(String string, String string2, String string3, String string4, String string5, Date date, String string6, boolean bl, int n, Date date2, boolean bl2, int n2, boolean bl3) throws UserExistsException {
        String string7;
        if (string2 == null || string2.trim().length() == 0) {
            return "SVR_21";
        }
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
        JOrganizationImpl jOrganizationImpl = null;
        String string8 = string2;
        if (stringArray[0] != null) {
            string7 = stringArray[0];
            try {
                jOrganizationImpl = (JOrganizationImpl)this.getOrganization(string7);
                int n3 = jOrganizationImpl.getMaxUserNumber();
                if (n3 > 0 && n3 <= jOrganizationImpl.getUserAmount()) {
                    return "SECURITY_ERR_104_FAIL_TO_ADD_USER";
                }
            }
            catch (NoSuchOrganizationException noSuchOrganizationException) {
                return "SECURITY_ERR_105_ORG_NOT_EXIST";
            }
            if (string2.startsWith(string7 + "\\")) {
                string8 = string2.substring(string7.length() + 1);
            }
        }
        string7 = this.userManager.addNewUser(jOrganizationImpl == null ? null : jOrganizationImpl.getName(), string8, string3, string4, string5, date, string6, bl, n, date2, bl2, n2, bl3, false);
        if (jOrganizationImpl != null) {
            jOrganizationImpl.addUser(string8);
        }
        return string7;
    }

    @Override
    public String updataEvent(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws NoSuchUserException {
        return this.userManager.updataEvent(string, bl, bl2, bl3, bl4, bl5);
    }

    @Override
    public boolean getAuditState(String string, int n, boolean bl) throws NoSuchUserException {
        int n2 = 0;
        int n3 = 1;
        User user = this.getUser(string);
        if (user.isNoAudit()) {
            return false;
        }
        if (n == n2) {
            if (bl) {
                return user.isAccessEventSuc();
            }
            return user.isAccessEventFail();
        }
        if (n == n3) {
            if (bl) {
                return user.isManagementEventSuc();
            }
            return user.isManagementEventFail();
        }
        return true;
    }

    @Override
    public int getUserParentRolesCount(String string) throws NoSuchUserException {
        User user = this.getUser(string);
        return user.getParentRoleNames().size();
    }

    @Override
    public String addUserToParentRole(String string, String string2) throws NoSuchRoleException, NoSuchUserException {
        return this.userManager.addUserToParentRole(string, string2);
    }

    @Override
    public int getRoleSubMembersCount(String string) throws NoSuchRoleException {
        Role role = this.getRole(string);
        int n = role.getSubRoleNames().size();
        int n2 = role.getSubUserNames().size();
        int n3 = role.getGroupNames().size();
        return n + n3 + n2;
    }

    @Override
    public Vector getSubRolesByRole(String string) throws NoSuchRoleException {
        Vector<Role> vector = new Vector<Role>();
        Vector vector2 = this.roleManager.getSubRoleNames(string);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Role role = this.getRole(string2);
            vector.add(role);
        }
        return vector;
    }

    @Override
    public Vector getSubUsersByRole(String string) throws NoSuchRoleException {
        Vector<User> vector = new Vector<User>();
        Vector vector2 = this.roleManager.getSubUserNames(string);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            User user;
            String string2 = (String)enumeration.nextElement();
            try {
                user = this.getUser(string2);
            }
            catch (NoSuchUserException noSuchUserException) {
                continue;
            }
            vector.add(user);
        }
        return vector;
    }

    @Override
    public Vector getSubUsersNameByRole(String string) throws NoSuchRoleException {
        return this.roleManager.getSubUserNames(string);
    }

    @Override
    public Vector getAllUsersName() {
        Vector vector = new Vector();
        Enumeration enumeration = this.userManager.getAllUserNames();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    @Override
    public String addSubUserToRole(String string, String string2) throws NoSuchRoleException, NoSuchUserException {
        return this.userManager.addUserToParentRole(string, string2);
    }

    @Override
    public String addSubRoleToRole(String string, String string2) throws NoSuchRoleException {
        return this.roleManager.addRoleToParentRole(string, string2);
    }

    @Override
    public String addNewRole(String string, String string2, String string3) throws RoleExistsException {
        if (string == null || string.length() == 0) {
            return "SECURITY_ERR_20_ROLE_NAME_NULL";
        }
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string3);
        JOrganizationImpl jOrganizationImpl = null;
        String string4 = string;
        if (stringArray[0] != null) {
            String string5 = stringArray[0];
            try {
                jOrganizationImpl = (JOrganizationImpl)this.getOrganization(string5);
            }
            catch (NoSuchOrganizationException noSuchOrganizationException) {
                return "SECURITY_ERR_105_ORG_NOT_EXIST";
            }
            if (string.startsWith(string5 + "\\")) {
                string4 = string.substring(string5.length() + 1);
            }
        }
        return this.roleManager.addNewRole(jOrganizationImpl == null ? null : jOrganizationImpl.getName(), string4, string2, 0);
    }

    @Override
    public String removeRoleFromParentRole(String string, String string2) throws NoSuchRoleException {
        return this.roleManager.removeRoleFromParentRole(string, string2);
    }

    @Override
    public String removeUserFromParentRole(String string, String string2) throws NoSuchRoleException, NoSuchUserException {
        return this.userManager.removeUserFromParentRole(string, string2);
    }

    @Override
    public String removeUser(String string, String string2) throws NoSuchUserException, InUseException {
        String string3;
        if (string == null || string.trim().length() == 0) {
            return "SVR_21";
        }
        int n = string.indexOf("\\");
        JOrganizationImpl jOrganizationImpl = null;
        if (n > 0) {
            string3 = string.substring(0, n);
            try {
                jOrganizationImpl = (JOrganizationImpl)this.getOrganization(string3);
            }
            catch (NoSuchOrganizationException noSuchOrganizationException) {
                ServiceLogger.logError((Throwable)((Object)noSuchOrganizationException), 3);
            }
        }
        string3 = this.userManager.removeUser(string);
        if (jOrganizationImpl != null) {
            jOrganizationImpl.removeUser(string.substring(n + 1));
        }
        return string3;
    }

    @Override
    public String removeRole(String string) throws NoSuchRoleException, InUseException {
        return this.roleManager.removeRole(string);
    }

    @Override
    public Vector getAllRolesName() {
        Vector vector = new Vector();
        Enumeration enumeration = this.roleManager.getAllRoleNames();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    @Override
    public Vector getAllGroupsName() {
        Vector vector = new Vector();
        Enumeration enumeration = this.groupManager.getAllGroupNames();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        NameComparator nameComparator = new NameComparator();
        Sorter.sort(vector, (Comparator)nameComparator);
        return vector;
    }

    @Override
    public Vector getParentRolesByUser(String string) throws NoSuchUserException {
        Vector<Role> vector = new Vector<Role>();
        User user = this.getUser(string);
        Vector vector2 = user.getParentRoleNames();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Role role;
            String string2 = (String)enumeration.nextElement();
            try {
                role = this.roleManager.getRole(string2);
            }
            catch (NoSuchRoleException noSuchRoleException) {
                continue;
            }
            vector.add(role);
        }
        return vector;
    }

    @Override
    public AclManager getAclManager() {
        return this.aclManager;
    }

    @Override
    public RoleManager getRoleManager() {
        return this.roleManager;
    }

    @Override
    public UserManager getUserManager() {
        return this.userManager;
    }

    @Override
    public JAcl getDefaultAcl() throws NoSuchAclException {
        return this.aclManager.getDefaultAcl();
    }

    @Override
    public void addPrincipalListener(PrincipalListener principalListener) {
        this.secData.addPrincipalListener(principalListener);
    }

    @Override
    public void clearPermissions(Node node) {
        String string = node.getAbsolutePath();
        int n = -1;
        if (node.getNodeType() == 3) {
            VersionImpl versionImpl = (VersionImpl)node;
            n = versionImpl.getVersionNumber();
        }
        this.aclManager.removeAcl(string, n);
    }

    private boolean P_WRITE(User user) {
        boolean bl = user.isNeverExpire();
        Date date = user.getLastModifyTime();
        long l = date.getTime();
        int n = user.getExpireTime();
        int n2 = user.getAuthType();
        if (n2 == 1) {
            return false;
        }
        if (bl) {
            return false;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(System.currentTimeMillis());
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTimeInMillis(l);
        ((Calendar)gregorianCalendar2).add(5, n);
        return gregorianCalendar.after(gregorianCalendar2);
    }

    @Override
    public boolean isExpired(String string) {
        User user;
        try {
            user = this.getIntegrityUser(string);
        }
        catch (NoSuchUserException noSuchUserException) {
            return true;
        }
        return this.P_WRITE(user);
    }

    @Override
    public boolean isEditing(int n) {
        if (this.securityWebUIController != null) {
            return this.securityWebUIController.isEditing(n);
        }
        return false;
    }

    @Override
    public String[] getAllInheritRoleNames(String string) throws NoSuchUserException {
        LinkedList<String> linkedList = new LinkedList<String>();
        User user = this.getUser(string);
        Vector vector = user.getParentRoleNames();
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.elementAt(i);
            linkedList.add(string2);
            this.SEDU(string2, linkedList);
        }
        Vector vector2 = user.getGroupNames();
        for (int i = 0; i < vector2.size(); ++i) {
            String string3 = (String)vector2.elementAt(i);
            this.aclManager(string3, linkedList);
        }
        String[] stringArray = new String[linkedList.size()];
        linkedList.toArray(stringArray);
        return stringArray;
    }

    private void SEDU(String string, LinkedList linkedList) {
        Role role;
        try {
            role = this.getRole(string);
        }
        catch (NoSuchRoleException noSuchRoleException) {
            ServiceLogger.logError((Throwable)((Object)noSuchRoleException));
            return;
        }
        if (role != null) {
            Vector vector = role.getParentRoleNames();
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                linkedList.add(string2);
                this.SEDU(string2, linkedList);
            }
        }
    }

    private void aclManager(String string, LinkedList linkedList) {
        Group group;
        try {
            group = this.getGroup(string);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            ServiceLogger.logError((Throwable)((Object)noSuchGroupException));
            return;
        }
        if (group != null) {
            Vector vector = group.getRoleNames();
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                linkedList.add(string2);
                this.SEDU(string2, linkedList);
            }
        }
    }

    @Override
    public String[] getAllInheritGroupNames(String string) throws NoSuchUserException {
        LinkedList linkedList = new LinkedList();
        User user = this.getUser(string);
        Vector vector = user.getGroupNames();
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.elementAt(i);
            this.add(string2, linkedList);
        }
        String[] stringArray = new String[linkedList.size()];
        linkedList.toArray(stringArray);
        return stringArray;
    }

    private void add(String string, LinkedList linkedList) {
        Group group;
        try {
            group = this.getGroup(string);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            ServiceLogger.logError((Throwable)((Object)noSuchGroupException));
            return;
        }
        if (group != null) {
            Vector vector = group.getParentGroupNames();
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                linkedList.add(string2);
                this.add(string2, linkedList);
            }
        }
    }

    @Override
    public Vector getReferUsers(String string) throws NoSuchUserException {
        Vector vector = new Vector();
        NameComparator nameComparator = new NameComparator();
        boolean bl = this.isOrganizationAdminUser(string);
        if (bl || this.isAdminUser(string)) {
            Vector vector2 = this.getAllUsersName();
            String string2 = "";
            if (bl) {
                string2 = CSUtil.parsePrincipalDisplayName(string)[0] + "\\";
                int n = vector2.size();
                for (int i = n - 1; i >= 0; --i) {
                    if (CSUtil.isBelongOrganization((String)vector2.get(i))) continue;
                    vector2.remove(i);
                }
            }
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            vector.remove(string2 + "admin");
            vector.remove(string);
            Sorter.sort(vector, (Comparator)nameComparator);
            return this.addElement(vector, string, "admin");
        }
        User user = this.getUser(string);
        Vector vector3 = (Vector)user.getGroupNames().clone();
        Enumeration enumeration = vector3.elements();
        while (enumeration.hasMoreElements()) {
            Group group;
            String string3 = (String)enumeration.nextElement();
            try {
                group = this.groupManager.getGroup(string3);
            }
            catch (NoSuchGroupException noSuchGroupException) {
                ServiceLogger.logDebug(6630066, 6);
                continue;
            }
            Vector vector4 = group.getUserNames();
            Enumeration enumeration2 = vector4.elements();
            while (enumeration2.hasMoreElements()) {
                String string4 = (String)enumeration2.nextElement();
                if (vector.contains(string4) || string4.equals(string)) continue;
                vector.add(string4);
            }
        }
        Sorter.sort(vector, (Comparator)nameComparator);
        return this.addElement(vector, string, "admin");
    }

    @Override
    public Vector getReferRoles(String string) throws NoSuchUserException {
        this.userManager.getUser(string);
        Vector<String> vector = new Vector<String>();
        NameComparator nameComparator = new NameComparator();
        Enumeration enumeration = this.getAllRolesName().elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equals("administrators")) continue;
            vector.add(string2);
        }
        Sorter.sort(vector, (Comparator)nameComparator);
        return this.addElement(vector, string, "administrators");
    }

    @Override
    public Vector getReferGroups(String string) throws NoSuchUserException {
        this.userManager.getUser(string);
        Vector<String> vector = new Vector<String>();
        NameComparator nameComparator = new NameComparator();
        Enumeration enumeration = this.getAllGroupsName().elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            vector.add(string2);
        }
        Sorter.sort(vector, (Comparator)nameComparator);
        return this.addElement(vector, string, "");
    }

    private Vector addElement(Vector vector, String string, String string2) {
        if (!ServerEnv.isEnableMultipleOrganization()) {
            return vector;
        }
        Vector<String> vector2 = new Vector<String>();
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
        boolean bl = true;
        String string3 = null;
        boolean bl2 = false;
        if (stringArray[0] != null) {
            bl = false;
            string3 = stringArray[0] + "\\";
        } else {
            bl2 = this.isAdminUser(string);
        }
        if (bl) {
            for (String string4 : vector) {
                if (!bl2 && CSUtil.isBelongOrganization(string4)) continue;
                vector2.add(string4);
            }
        } else {
            for (String string5 : vector) {
                if (!string5.startsWith(string3) || string5.equals(string3 + string2)) continue;
                vector2.add(string5);
            }
        }
        return vector2;
    }

    @Override
    public Vector getImportedLDAPUsers() {
        Enumeration enumeration = this.userManager.getAllUsers();
        Vector<User> vector = new Vector<User>();
        while (enumeration.hasMoreElements()) {
            User user = (User)enumeration.nextElement();
            int n = user.getAuthType();
            if (n != 1) continue;
            vector.add(user);
        }
        return vector;
    }

    @Override
    public Vector getImportedLDAPUserNames() {
        Enumeration enumeration = this.userManager.getAllUsers();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            User user = (User)enumeration.nextElement();
            int n = user.getAuthType();
            if (n != 1) continue;
            vector.add(user.getName());
        }
        return vector;
    }

    @Override
    public Vector getImportedLDAPRoles() {
        Enumeration enumeration = this.roleManager.getAllRoles();
        Vector<Role> vector = new Vector<Role>();
        while (enumeration.hasMoreElements()) {
            Role role = (Role)enumeration.nextElement();
            int n = role.getType();
            if (n != 1) continue;
            vector.add(role);
        }
        return vector;
    }

    @Override
    public Vector getImportedLDAPRoleNames() {
        Enumeration enumeration = this.roleManager.getAllRoles();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            Role role = (Role)enumeration.nextElement();
            int n = role.getType();
            if (n != 1) continue;
            vector.add(role.getName());
        }
        return vector;
    }

    @Override
    public Vector getImportedLDAPGroups() {
        Enumeration enumeration = this.groupManager.getAllGroups();
        Vector<Group> vector = new Vector<Group>();
        while (enumeration.hasMoreElements()) {
            Group group = (Group)enumeration.nextElement();
            int n = group.getType();
            if (n != 1) continue;
            vector.add(group);
        }
        return vector;
    }

    @Override
    public Vector getImportedLDAPGroupNames() {
        Enumeration enumeration = this.groupManager.getAllGroups();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            Group group = (Group)enumeration.nextElement();
            int n = group.getType();
            if (n != 1) continue;
            vector.add(group.getName());
        }
        return vector;
    }

    @Override
    public String addLDAPUser(LDAPUser lDAPUser, boolean bl) {
        String string;
        String string2;
        String string3;
        Object object;
        String string4 = lDAPUser.getName();
        if (string4 == null) {
            return JSvrResource.getMessage("SECURITY_ERR_30_LDAP_NULL_NAME");
        }
        if (string4.equals("admin") || string4.equals("guest")) {
            Object[] objectArray = new String[]{"admin", "guest"};
            return JSvrResource.getMessage("SECURITY_ERR_31_IMPORTED_BUILDED_USER", objectArray);
        }
        try {
            object = this.getIntegrityUser(string4);
            if (object.getAuthType() == 1) {
                return null;
            }
            if (!bl) {
                return JSvrResource.getMessage("SECURITY_ERR_32_LDAP_USER_EXIST");
            }
            this.userManager.removeUser(string4);
        }
        catch (InUseException inUseException) {
            ServiceLogger.logDebug(6630067, string4, 6);
            return JSvrResource.getMessage("SECURITY_ERR_33_CAN_NOT_COVER", string4);
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError((Throwable)((Object)noSuchUserException), 3);
        }
        object = lDAPUser.getProperty("full_name");
        if (object == null) {
            object = "";
        }
        if ((string3 = lDAPUser.getProperty("description")) == null) {
            string3 = "";
        }
        if ((string2 = lDAPUser.getProperty("email")) == null) {
            string2 = "";
        }
        Date date = new Date(System.currentTimeMillis());
        String string5 = lDAPUser.getProperty("ldapuser_dn");
        if (string5 == null || string5.trim().length() == 0) {
            string5 = "";
        }
        String string6 = string5;
        boolean bl2 = true;
        int n = 0;
        Date date2 = new Date(System.currentTimeMillis());
        boolean bl3 = true;
        int n2 = 30;
        boolean bl4 = false;
        try {
            string = this.userManager.addNewUser(null, string4, (String)object, string3, string2, date, string6, bl2, n, date2, bl3, n2, bl4, true);
        }
        catch (UserExistsException userExistsException) {
            string = JSvrResource.getMessage("SECURITY_ERR_32_LDAP_USER_EXIST");
        }
        User user = null;
        try {
            user = this.getUser(string4);
        }
        catch (NoSuchUserException noSuchUserException) {
            return noSuchUserException.getMessage();
        }
        if (string == null) {
            ServiceLogger.logDebug(6630068, string4, 6);
            Vector vector = new Vector();
            this.setPrincipalPrivileges(user, vector);
            return null;
        }
        ServiceLogger.logDebug(string);
        ServiceLogger.logDebug(6630069, 6);
        return JSvrResource.getMessage("SECURITY_ERR_34_LDAP_USER_ADD_FAILED");
    }

    @Override
    public String addLDAPGroup(LDAPGroup lDAPGroup, boolean bl) {
        Group group;
        if (bl) {
            String string = lDAPGroup.getName();
            if (string == null || string.length() == 0) {
                return JSvrResource.getMessage("SVR_99");
            }
            String string2 = LDAPData.getProperty("groupAdminGroup");
            if (string.equals("administrators") || string.equals("everyone")) {
                Object[] objectArray = new String[]{"admin", "guest"};
                return JSvrResource.getMessage("SECURITY_ERR_35_IMPORTED_BUILDED_ROLE", objectArray);
            }
            String string3 = lDAPGroup.getProperty("description");
            String string4 = lDAPGroup.getProperty("group_dn");
            String string5 = null;
            try {
                string5 = this.roleManager.addNewRole(null, string, string4, 1);
            }
            catch (RoleExistsException roleExistsException) {
                ServiceLogger.logDebug(6630070, string, 6);
            }
            if (string5 != null) {
                return string5;
            }
            if (string2 != null && string2.length() != 0 && string.equals(string2)) {
                try {
                    this.roleManager.addRoleToParentRole(string, "administrators");
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    return JSvrResource.getMessage("SECURITY_ERR_36_NO_LDAP_ROLE", string);
                }
            }
            Vector vector = new Vector();
            Role role = null;
            try {
                role = this.getRole(string);
            }
            catch (NoSuchRoleException noSuchRoleException) {
                return noSuchRoleException.getMessage();
            }
            this.setPrincipalPrivileges(role, vector);
            return null;
        }
        String string = lDAPGroup.getName();
        if (string == null || string.length() == 0) {
            return JSvrResource.getMessage("SECURITY_ERR_73_GROUP_NAME_NULL");
        }
        String string6 = LDAPData.getProperty("groupAdminGroup");
        String string7 = lDAPGroup.getProperty("description");
        String string8 = lDAPGroup.getProperty("group_dn");
        String string9 = null;
        try {
            string9 = this.groupManager.addNewGroup(null, string, string8, 1);
        }
        catch (GroupExistsException groupExistsException) {
            ServiceLogger.logDebug(6630071, string, 6);
        }
        if (string9 != null) {
            return string9;
        }
        if (string6 != null && string6.length() != 0 && string.equals(string6)) {
            try {
                this.roleManager.addGroupIntoRole(string, "administrators");
            }
            catch (NoSuchRoleException noSuchRoleException) {
                return JSvrResource.getMessage("SECURITY_ERR_36_NO_LDAP_ROLE", string);
            }
            catch (NoSuchGroupException noSuchGroupException) {
                return JSvrResource.getMessage("SEUCRITY_ERR_63_GROUP_NOT_EXIST", string);
            }
        }
        try {
            group = this.getGroup(string);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            return noSuchGroupException.getMessage();
        }
        Vector vector = new Vector();
        this.setPrincipalPrivileges(group, vector);
        return null;
    }

    @Override
    public ExSecurityData getSecurityData() {
        return this.secData;
    }

    @Override
    public int getDefaultAclID() {
        return 1;
    }

    @Override
    public String getPassword(String string) throws NoSuchUserException {
        return this.userManager.getPassword(string);
    }

    @Override
    public synchronized boolean removeUserInherRelation(String string) {
        String string2;
        int n;
        User user;
        try {
            user = this.getUser(string);
        }
        catch (NoSuchUserException noSuchUserException) {
            return false;
        }
        Vector vector = (Vector)user.getParentRoleNames().clone();
        Vector vector2 = (Vector)user.getGroupNames().clone();
        for (n = 0; n < vector.size(); ++n) {
            string2 = (String)vector.elementAt(n);
            try {
                this.removeUserFromParentRole(string, string2);
                continue;
            }
            catch (NoSuchRoleException noSuchRoleException) {
                continue;
            }
            catch (NoSuchUserException noSuchUserException) {
                return false;
            }
        }
        for (n = 0; n < vector2.size(); ++n) {
            string2 = (String)vector2.elementAt(n);
            try {
                this.removeUserFromGroup(string, string2);
                continue;
            }
            catch (NoSuchGroupException noSuchGroupException) {
                continue;
            }
            catch (NoSuchUserException noSuchUserException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public synchronized boolean removeRoleInherRelation(String string) {
        String string2;
        int n;
        Role role;
        try {
            role = this.getRole(string);
        }
        catch (NoSuchRoleException noSuchRoleException) {
            return false;
        }
        Vector vector = (Vector)role.getSubUserNames().clone();
        Vector vector2 = (Vector)role.getGroupNames().clone();
        Vector vector3 = (Vector)role.getSubRoleNames().clone();
        Vector vector4 = (Vector)role.getParentRoleNames().clone();
        for (n = 0; n < vector.size(); ++n) {
            string2 = (String)vector.elementAt(n);
            try {
                this.removeUserFromParentRole(string2, string);
                continue;
            }
            catch (NoSuchUserException noSuchUserException) {
                continue;
            }
            catch (NoSuchRoleException noSuchRoleException) {
                // empty catch block
            }
        }
        for (n = 0; n < vector2.size(); ++n) {
            string2 = (String)vector2.elementAt(n);
            try {
                this.removeGroupFromRole(string2, string);
                continue;
            }
            catch (NoSuchGroupException noSuchGroupException) {
                continue;
            }
            catch (NoSuchRoleException noSuchRoleException) {
                // empty catch block
            }
        }
        for (n = 0; n < vector3.size(); ++n) {
            string2 = (String)vector3.elementAt(n);
            try {
                this.removeRoleFromParentRole(string2, string);
                continue;
            }
            catch (NoSuchRoleException noSuchRoleException) {
                // empty catch block
            }
        }
        for (n = 0; n < vector4.size(); ++n) {
            string2 = (String)vector4.elementAt(n);
            try {
                this.removeRoleFromParentRole(string, string2);
                continue;
            }
            catch (NoSuchRoleException noSuchRoleException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public boolean removeGroupInherRelation(String string) {
        String string2;
        int n;
        Group group;
        try {
            group = this.getGroup(string);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            return false;
        }
        Vector vector = (Vector)group.getUserNames().clone();
        Vector vector2 = (Vector)group.getSubGroupNames().clone();
        Vector vector3 = (Vector)group.getParentGroupNames().clone();
        Vector vector4 = (Vector)group.getRoleNames().clone();
        for (n = 0; n < vector.size(); ++n) {
            string2 = (String)vector.elementAt(n);
            try {
                this.removeUserFromGroup(string2, string);
                continue;
            }
            catch (NoSuchUserException noSuchUserException) {
                continue;
            }
            catch (NoSuchGroupException noSuchGroupException) {
                // empty catch block
            }
        }
        for (n = 0; n < vector2.size(); ++n) {
            string2 = (String)vector2.elementAt(n);
            try {
                this.removeSubGroupFromGroup(string2, string);
                continue;
            }
            catch (NoSuchGroupException noSuchGroupException) {
                // empty catch block
            }
        }
        for (n = 0; n < vector3.size(); ++n) {
            string2 = (String)vector3.elementAt(n);
            try {
                this.removeSubGroupFromGroup(string, string2);
                continue;
            }
            catch (NoSuchGroupException noSuchGroupException) {
                // empty catch block
            }
        }
        for (n = 0; n < vector4.size(); ++n) {
            string2 = (String)vector4.elementAt(n);
            try {
                this.removeGroupFromRole(string, string2);
                continue;
            }
            catch (NoSuchGroupException noSuchGroupException) {
                continue;
            }
            catch (NoSuchRoleException noSuchRoleException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public JAcl getExtendAcl() throws NoSuchAclException {
        return this.aclManager.getExtendAcl();
    }

    @Override
    public void setPrincipalPrivileges(Principal principal, Vector vector) {
        this.aclManager.setPrivileges(principal, vector);
    }

    @Override
    public Vector getPrincipalPrivileges(Principal principal) {
        return this.aclManager.getPrivileges(principal);
    }

    @Override
    public Vector getPrivilegedPrincipals(byte by, String string) {
        if (by == 1) {
            return this.aclManager.getPrivilegedUsers(string);
        }
        if (by == 2) {
            return this.aclManager.getPrivilegedRoles(string);
        }
        if (by == 3) {
            return this.aclManager.getPrivilegedGroups(string);
        }
        return new Vector();
    }

    @Override
    public void addPrivilegedPrincipal(String string, Vector vector, byte by) {
        if (by == 1) {
            this.aclManager.addPrivilegedUsers(string, vector);
        } else if (by == 2) {
            this.aclManager.addPrivilegedRoles(string, vector);
        } else if (by == 3) {
            this.aclManager.addPrivilegedGroups(string, vector);
        }
    }

    @Override
    public String removePrivilegedPrincipals(String string, Vector vector, byte by) {
        if (by == 1) {
            return this.aclManager.removePrivilegedUsers(string, vector);
        }
        if (by == 2) {
            return this.aclManager.removePrivilegedRoles(string, vector);
        }
        if (by == 3) {
            return this.aclManager.removePrivilegedGroups(string, vector);
        }
        return "SECURITY_ERR_NO_SUCH_PRINCIPALS";
    }

    @Override
    public String addNewGroup(String string, String string2, String string3) throws GroupExistsException {
        if (string == null || string.length() == 0) {
            return "SECURITY_ERR_73_GROUP_NAME_NULL";
        }
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string3);
        JOrganizationImpl jOrganizationImpl = null;
        String string4 = string;
        if (stringArray[0] != null) {
            String string5 = stringArray[0];
            try {
                jOrganizationImpl = (JOrganizationImpl)this.getOrganization(string5);
            }
            catch (NoSuchOrganizationException noSuchOrganizationException) {
                return "SECURITY_ERR_105_ORG_NOT_EXIST";
            }
            if (string.startsWith(string5 + "\\")) {
                string4 = string.substring(string5.length() + 1);
            }
        }
        return this.groupManager.addNewGroup(jOrganizationImpl == null ? null : jOrganizationImpl.getName(), string4, string2, 0);
    }

    @Override
    public String removeGroup(String string) throws InUseException, NoSuchGroupException {
        return this.groupManager.removeGroup(string);
    }

    @Override
    public String addSubGroupToGroup(String string, String string2) throws NoSuchGroupException {
        return this.groupManager.addGroupIntoParentGroup(string, string2);
    }

    @Override
    public String addUserToGroup(String string, String string2) throws NoSuchGroupException, NoSuchUserException {
        return this.userManager.addUserToGroup(string, string2);
    }

    @Override
    public String addGroupToRole(String string, String string2) throws NoSuchGroupException, NoSuchRoleException {
        return this.roleManager.addGroupIntoRole(string, string2);
    }

    @Override
    public String removeSubGroupFromGroup(String string, String string2) throws NoSuchGroupException {
        return this.groupManager.removeGroupFromParentGroup(string, string2);
    }

    @Override
    public String removeUserFromGroup(String string, String string2) throws NoSuchGroupException, NoSuchUserException {
        return this.userManager.removeUserFromGroup(string, string2);
    }

    @Override
    public String removeGroupFromRole(String string, String string2) throws NoSuchGroupException, NoSuchRoleException {
        return this.roleManager.removeGroupFromRole(string, string2);
    }

    @Override
    public Vector getSubGroupsByGroup(String string) throws NoSuchGroupException {
        Vector<Group> vector = new Vector<Group>();
        Group group = this.getGroup(string);
        Vector vector2 = group.getSubGroupNames();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Group group2 = this.getGroup(string2);
            vector.add(group2);
        }
        return vector;
    }

    @Override
    public Vector getAllUserNamesByReferedRole(String string) throws NoSuchRoleException, NoSuchGroupException {
        Vector vector = new Vector();
        this.addGroupIntoParentGroup(vector, this.getUsersNameByRole(string));
        Vector vector2 = this.getGroupsByRole(string);
        for (int i = 0; i < vector2.size(); ++i) {
            Group group = (Group)vector2.get(i);
            this.addGroupIntoParentGroup(vector, this.getAllContainedUserNamesByGroup(group.getName()));
        }
        Vector vector3 = this.roleManager.getSubRoleNames(string);
        for (int i = 0; i < vector3.size(); ++i) {
            this.addGroupIntoParentGroup(vector, this.getAllUserNamesByReferedRole((String)vector3.get(i)));
        }
        return vector;
    }

    @Override
    public Vector getAllContainedUserNamesByGroup(String string) throws NoSuchGroupException {
        Vector vector = new Vector();
        this.addGroupIntoParentGroup(vector, this.getUsersNameByGroup(string));
        Group group = this.getGroup(string);
        Vector vector2 = group.getSubGroupNames();
        for (int i = 0; i < vector2.size(); ++i) {
            this.addGroupIntoParentGroup(vector, this.getAllContainedUserNamesByGroup((String)vector2.get(i)));
        }
        return vector;
    }

    private void addGroupIntoParentGroup(Vector vector, Vector vector2) {
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            if (vector.contains(vector2.get(i))) continue;
            vector.add(vector2.get(i));
        }
    }

    @Override
    public JOrganization getOrganization(String string) throws NoSuchOrganizationException {
        if (string == null || string.length() == 0) {
            throw new NoSuchOrganizationException(630104);
        }
        JOrganization jOrganization = this.secData.getOrganization(string);
        if (jOrganization == null) {
            throw new NoSuchOrganizationException(630097, new Object[]{string}, null);
        }
        return jOrganization;
    }

    @Override
    public List getOrganizations() {
        JOrganization[] jOrganizationArray;
        ArrayList<JOrganization> arrayList = new ArrayList<JOrganization>();
        for (JOrganization jOrganization : jOrganizationArray = this.secData.getAllOrganizations()) {
            arrayList.add(jOrganization);
        }
        return arrayList;
    }

    @Override
    public String addOrganization(String string, String string2, int n, String string3) throws OrganizationExistsException {
        String string4 = this.orgManager.addNewOrganization(string, string2, n);
        if (string4 == null) {
            try {
                JOrganizationImpl jOrganizationImpl = (JOrganizationImpl)this.getOrganization(string);
                jOrganizationImpl.addUser("admin");
            }
            catch (NoSuchOrganizationException noSuchOrganizationException) {
                ServiceLogger.logError((Throwable)((Object)noSuchOrganizationException));
            }
        }
        return string4;
    }

    @Override
    public String updateOrganization(String string, String string2, int n, String string3) throws NoSuchOrganizationException {
        return this.orgManager.updateOrganization(string, string2, n);
    }

    @Override
    public String removeOrganization(String string, String string2) throws NoSuchOrganizationException {
        return this.orgManager.removeOrganization(string);
    }

    @Override
    public List getAllUsers(String string) throws NoSuchOrganizationException {
        JOrganizationImpl jOrganizationImpl = (JOrganizationImpl)this.getOrganization(string);
        ArrayList<User> arrayList = new ArrayList<User>();
        Vector vector = jOrganizationImpl.getUsers();
        for (String string2 : vector) {
            try {
                arrayList.add(this.getIntegrityUser(string + "\\" + string2));
            }
            catch (NoSuchUserException noSuchUserException) {
                ServiceLogger.logError((Throwable)((Object)noSuchUserException), 3);
            }
        }
        UserComparator userComparator = new UserComparator();
        Sorter.sort(arrayList, (Comparator)userComparator);
        return arrayList;
    }

    @Override
    public List getAllRoles(String string) throws NoSuchOrganizationException {
        JOrganization jOrganization = this.getOrganization(string);
        ArrayList<Role> arrayList = new ArrayList<Role>();
        Vector vector = this.getAllRoles();
        for (Role role : vector) {
            if (!role.getName().startsWith(string + "\\")) continue;
            arrayList.add(role);
        }
        return arrayList;
    }

    @Override
    public List getAllGroups(String string) throws NoSuchOrganizationException {
        JOrganization jOrganization = this.getOrganization(string);
        ArrayList<Group> arrayList = new ArrayList<Group>();
        Vector vector = this.getAllGroups();
        for (Group group : vector) {
            if (!group.getName().startsWith(string + "\\")) continue;
            arrayList.add(group);
        }
        return arrayList;
    }

    @Override
    public boolean isOrganizationAdminUser(String string) {
        int n = string.indexOf("\\");
        if (n <= 0) {
            return false;
        }
        String string2 = string.substring(0, n);
        JOrganization jOrganization = null;
        try {
            jOrganization = this.getOrganization(string2);
        }
        catch (NoSuchOrganizationException noSuchOrganizationException) {
            ServiceLogger.logError((Throwable)((Object)noSuchOrganizationException), 3);
            return false;
        }
        if (string.equals(string2 + "\\" + "admin")) {
            return true;
        }
        List list = this.getAllParentRolesNameByUser(string);
        return list.contains(string2 + "\\" + "administrators");
    }

    @Override
    public List getAllParentRolesNameByUser(String string) {
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        BaseUser baseUser = this.secData.getUser(string);
        if (baseUser == null) {
            return arrayList;
        }
        Vector vector = baseUser.getParentRoleNames();
        for (Object object2 : vector) {
            arrayList.add((String)object2);
            this.addNewGroup((String)object2, arrayList);
        }
        Vector vector2 = baseUser.getGroupNames();
        object2 = vector2.iterator();
        while (object2.hasNext()) {
            String string2 = (String)object2.next();
            this.addGroupIntoRole(string2, arrayList);
        }
        return arrayList;
    }

    private void addGroupIntoRole(String string, List list) {
        Object object2;
        BaseGroup baseGroup = this.secData.getGroup(string);
        if (baseGroup == null) {
            return;
        }
        Vector vector = baseGroup.getRoleNames();
        for (Object object2 : vector) {
            list.add(object2);
            this.addNewGroup((String)object2, list);
        }
        Vector vector2 = baseGroup.getParentGroupNames();
        object2 = vector2.iterator();
        while (object2.hasNext()) {
            String string2 = (String)object2.next();
            this.addGroupIntoRole(string2, list);
        }
    }

    private void addNewGroup(String string, List list) {
        BaseRole baseRole = this.secData.getRole(string);
        if (baseRole == null) {
            return;
        }
        Vector vector = baseRole.getParentRoleNames();
        for (String string2 : vector) {
            list.add(string2);
            this.addNewGroup(string2, list);
        }
    }

    private void addNewOrganization(String string, List list) {
        BaseGroup baseGroup = this.secData.getGroup(string);
        if (baseGroup == null) {
            return;
        }
        Vector vector = baseGroup.getParentGroupNames();
        for (String string2 : vector) {
            list.add(string2);
            this.addNewOrganization(string2, list);
        }
    }

    @Override
    public List getAllParentGroupsNameByUser(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        BaseUser baseUser = this.secData.getUser(string);
        if (baseUser == null) {
            return arrayList;
        }
        Vector vector = baseUser.getGroupNames();
        for (String string2 : vector) {
            arrayList.add(string2);
            this.addNewOrganization(string2, arrayList);
        }
        return arrayList;
    }
}

