/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.io.File;
import java.io.IOException;
import jet.cs.EncodeExProperties;
import jet.server.ServerEnv;
import jet.server.api.exception.BadRealmException;
import jet.server.jrc.security.Realm;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.log.ServiceLogger;

public class SharedPasswordRealm2
extends Realm {
    public SharedPasswordRealm2(String string) {
        super(string);
        if (string.trim().length() == 0) {
            return;
        }
        String string2 = ServerEnv.realmsPath + string + File.separator;
        this.realmDir = new File(string2);
    }

    public SharedPasswordRealm2(String string, String string2) {
        super(string2);
        if (string2.trim().length() == 0) {
            return;
        }
        String string3 = string + string2 + File.separator;
        this.realmDir = new File(string3);
    }

    public synchronized void save() {
        try {
            UserDataToolkit.saveRealmProperties(this.getProperties(), this.name);
        }
        catch (Exception exception) {
            ServiceLogger.logError(3630072, this.name, 3);
            exception.printStackTrace();
        }
    }

    public synchronized void oldSave(String string) {
        try {
            UserDataToolkit.saveOldRealmProperties(this.getProperties(), string, this.name);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized EncodeExProperties getProperties() throws IOException, BadRealmException {
        EncodeExProperties encodeExProperties = new EncodeExProperties();
        String string = ServerEnv.realmsPath + this.name + File.separator;
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        encodeExProperties.setProperty("name", this.name);
        encodeExProperties.setProperty("dir", string + " ");
        encodeExProperties.setProperty("scheme", this.scheme);
        return encodeExProperties;
    }

    public synchronized void load(String string) {
        String string2 = null;
        try {
            EncodeExProperties encodeExProperties = new EncodeExProperties();
            encodeExProperties.load(new File(string));
            this.name = encodeExProperties.getProperty("name", "");
            string2 = ServerEnv.realmsPath + this.name + File.separator;
            this.realmDir = new File(string2);
            if (!this.realmDir.exists()) {
                return;
            }
            this.scheme = encodeExProperties.getProperty("scheme", 0);
        }
        catch (IOException iOException) {
            return;
        }
    }
}

