/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.cube;

import com.jinfonet.security.control.JRGroup;
import com.jinfonet.security.control.JRRole;
import com.jinfonet.security.control.JRUser;
import com.jinfonet.security.loader.ServerPrincipalLoader;
import java.security.Principal;
import java.util.Properties;
import java.util.Vector;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.server.intf.security.ExSecurityData;
import jet.server.intf.security.Group;
import jet.server.intf.security.Role;
import jet.server.intf.security.User;
import jet.server.jrc.security.UserDataToolkit;

public class ServerPrincipalLoaderImpl
implements ServerPrincipalLoader {
    public Vector getUsers() {
        ExSecurityData exSecurityData = UserDataToolkit.getSecurityData();
        User[] userArray = exSecurityData.getAllUsers();
        Vector<JRUser> vector = new Vector<JRUser>();
        for (int i = 0; i < userArray.length; ++i) {
            User user = userArray[i];
            JRUser jRUser = this.SEDU(user);
            vector.add(jRUser);
        }
        return vector;
    }

    public Vector getRoles() {
        ExSecurityData exSecurityData = UserDataToolkit.getSecurityData();
        Role[] roleArray = exSecurityData.getAllRoles();
        Vector<JRRole> vector = new Vector<JRRole>();
        for (int i = 0; i < roleArray.length; ++i) {
            Role role = roleArray[i];
            JRRole jRRole = this.add(role);
            vector.add(jRRole);
        }
        return vector;
    }

    public Vector getGroups() {
        ExSecurityData exSecurityData = UserDataToolkit.getSecurityData();
        Group[] groupArray = exSecurityData.getAllGroups();
        Vector<JRGroup> vector = new Vector<JRGroup>();
        for (int i = 0; i < groupArray.length; ++i) {
            Group group = groupArray[i];
            JRGroup jRGroup = this.addParent(group);
            vector.add(jRGroup);
        }
        return vector;
    }

    public Vector[] getPrincipalNames() {
        ExSecurityData exSecurityData = UserDataToolkit.getSecurityData();
        Vector[] vectorArray = new Vector[3];
        vectorArray[0] = new Vector();
        User[] userArray = exSecurityData.getAllUsers();
        vectorArray[0] = new Vector();
        for (int i = 0; i < userArray.length; ++i) {
            User user = userArray[i];
            vectorArray[0].add(user.getName());
        }
        Role[] roleArray = exSecurityData.getAllRoles();
        vectorArray[1] = new Vector();
        for (int i = 0; i < roleArray.length; ++i) {
            Role role = roleArray[i];
            vectorArray[1].add(role.getName());
        }
        Group[] groupArray = exSecurityData.getAllGroups();
        vectorArray[2] = new Vector();
        for (int i = 0; i < groupArray.length; ++i) {
            Group group = groupArray[i];
            vectorArray[2].add(group.getName());
        }
        return vectorArray;
    }

    public Principal getPrincipal(String string, int n) {
        ExSecurityData exSecurityData = UserDataToolkit.getSecurityData();
        switch (n) {
            case 2: {
                BaseUser baseUser = exSecurityData.getUser(string);
                return this.SEDU(baseUser);
            }
            case 0: {
                BaseRole baseRole = exSecurityData.getRole(string);
                return this.add(baseRole);
            }
            case 1: {
                BaseGroup baseGroup = exSecurityData.getGroup(string);
                return this.addParent(baseGroup);
            }
        }
        return null;
    }

    private JRUser SEDU(BaseUser baseUser) {
        ExSecurityData exSecurityData = UserDataToolkit.getSecurityData();
        JRUser jRUser = null;
        if (baseUser != null) {
            Object object;
            Object object2;
            String string = baseUser.getName();
            String string2 = "Server User";
            jRUser = new JRUser(string, string2);
            jRUser.setEmail(baseUser.getEmail());
            jRUser.setSourceType(1);
            Vector vector = baseUser.getParentRoleNames();
            for (int i = 0; i < vector.size(); ++i) {
                String string3 = (String)vector.elementAt(i);
                object2 = exSecurityData.getRole(string3);
                object = this.add((BaseRole)object2);
                if (object == null) continue;
                jRUser.addParent((Principal)object);
            }
            Vector vector2 = baseUser.getGroupNames();
            for (int i = 0; i < vector2.size(); ++i) {
                object2 = (String)vector2.elementAt(i);
                object = exSecurityData.getGroup((String)object2);
                JRGroup jRGroup = this.addParent((BaseGroup)object);
                if (jRGroup == null) continue;
                jRUser.addParent((Principal)jRGroup);
            }
        }
        return jRUser;
    }

    private JRRole add(BaseRole baseRole) {
        ExSecurityData exSecurityData = UserDataToolkit.getSecurityData();
        JRRole jRRole = null;
        if (baseRole != null) {
            String string = baseRole.getName();
            String string2 = "Server Role";
            jRRole = new JRRole(string, string2);
            jRRole.setSourceType(1);
            Vector vector = baseRole.getParentRoleNames();
            for (int i = 0; i < vector.size(); ++i) {
                String string3 = (String)vector.elementAt(i);
                BaseRole baseRole2 = exSecurityData.getRole(string3);
                JRRole jRRole2 = this.add(baseRole2);
                if (jRRole2 == null) continue;
                jRRole.addParent((Principal)jRRole2);
            }
        }
        return jRRole;
    }

    private JRGroup addParent(BaseGroup baseGroup) {
        ExSecurityData exSecurityData = UserDataToolkit.getSecurityData();
        JRGroup jRGroup = null;
        if (baseGroup != null) {
            Object object;
            Object object2;
            String string = baseGroup.getName();
            String string2 = "Server Group";
            jRGroup = new JRGroup(string, string2);
            jRGroup.setSourceType(1);
            Vector vector = baseGroup.getParentGroupNames();
            for (int i = 0; i < vector.size(); ++i) {
                String string3 = (String)vector.elementAt(i);
                object2 = exSecurityData.getGroup(string3);
                object = this.addParent((BaseGroup)object2);
                if (object == null) continue;
                jRGroup.addParent((Principal)object);
            }
            Vector vector2 = baseGroup.getRoleNames();
            for (int i = 0; i < vector2.size(); ++i) {
                object2 = (String)vector2.elementAt(i);
                object = exSecurityData.getRole((String)object2);
                JRRole jRRole = this.add((BaseRole)object);
                if (jRRole == null) continue;
                jRGroup.addParent((Principal)jRRole);
            }
        }
        return jRGroup;
    }

    public void preLoad(Properties properties) throws Exception {
    }

    public void confirmLoading() {
    }

    public void recoverPreloadedPrincipals() {
    }

    public JRUser getUser(String string) {
        return null;
    }

    public JRRole getRole(String string) {
        return null;
    }

    public JRGroup getGroup(String string) {
        return null;
    }

    public JRUser removeUser(String string) {
        return null;
    }

    public JRRole removeRole(String string) {
        return null;
    }

    public JRGroup removeGroup(String string) {
        return null;
    }
}

