/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.io.Serializable;
import jet.reportLogic.objectInfo.bursting.BurstingRecipientSchema;
import jet.reportLogic.objectInfo.bursting.BurstingRecipientServerInformation;
import jet.server.api.BurstingRecipientInfo;

public class JRBurstingRecipientInfo
implements BurstingRecipientInfo,
Serializable {
    private boolean hasDiskRecipient;
    private boolean hasEmailRecipient;
    private boolean hasVersionRecipient;
    private boolean hasFTPRecipient;

    public JRBurstingRecipientInfo(BurstingRecipientSchema burstingRecipientSchema) {
        if (burstingRecipientSchema.getRecipientMappingDisk() != null) {
            this.hasDiskRecipient = true;
        }
        if (burstingRecipientSchema.getRecipientMappingFTP() != null) {
            this.hasFTPRecipient = true;
        }
        if (burstingRecipientSchema.getRecipientMappingMail() != null || this.getRecipientMapping(burstingRecipientSchema)) {
            this.hasEmailRecipient = true;
        }
        if (burstingRecipientSchema.getRecipientMappingServerVersionSystem() != null || this.SEDU(burstingRecipientSchema)) {
            this.hasVersionRecipient = true;
        }
    }

    private boolean SEDU(BurstingRecipientSchema burstingRecipientSchema) {
        BurstingRecipientServerInformation burstingRecipientServerInformation = burstingRecipientSchema.getRecipientServerInformationUser();
        if (burstingRecipientServerInformation != null && burstingRecipientServerInformation.getRecipientMapping() != null && burstingRecipientServerInformation.isUsePrivateFolder()) {
            return true;
        }
        burstingRecipientServerInformation = burstingRecipientSchema.getRecipientServerInformationGroup();
        if (burstingRecipientServerInformation != null && burstingRecipientServerInformation.getRecipientMapping() != null && burstingRecipientServerInformation.isUsePrivateFolder()) {
            return true;
        }
        burstingRecipientServerInformation = burstingRecipientSchema.getRecipientServerInformationRole();
        return burstingRecipientServerInformation != null && burstingRecipientServerInformation.getRecipientMapping() != null && burstingRecipientServerInformation.isUsePrivateFolder();
    }

    private boolean getRecipientMapping(BurstingRecipientSchema burstingRecipientSchema) {
        BurstingRecipientServerInformation burstingRecipientServerInformation = burstingRecipientSchema.getRecipientServerInformationUser();
        if (burstingRecipientServerInformation != null && burstingRecipientServerInformation.getRecipientMapping() != null && burstingRecipientServerInformation.isUserMail()) {
            return true;
        }
        burstingRecipientServerInformation = burstingRecipientSchema.getRecipientServerInformationGroup();
        if (burstingRecipientServerInformation != null && burstingRecipientServerInformation.getRecipientMapping() != null && burstingRecipientServerInformation.isUserMail()) {
            return true;
        }
        burstingRecipientServerInformation = burstingRecipientSchema.getRecipientServerInformationRole();
        return burstingRecipientServerInformation != null && burstingRecipientServerInformation.getRecipientMapping() != null && burstingRecipientServerInformation.isUserMail();
    }

    @Override
    public boolean hasDiskRecipient() {
        return this.hasDiskRecipient;
    }

    @Override
    public boolean hasEmailRecipient() {
        return this.hasEmailRecipient;
    }

    @Override
    public boolean hasFTPRecipient() {
        return this.hasFTPRecipient;
    }

    @Override
    public boolean hasVersionRecipient() {
        return this.hasVersionRecipient;
    }
}

