/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import com.jinfonet.util.loader.DynamicClassManager;
import com.jinfonet.web.modules.dashboard.DashboardListener;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jet.server.ServerEnv;
import jet.server.api.DashboardListenerInfo;
import jet.server.intf.jrs.ExtDashboardListenerManager;
import jet.server.intf.jrs.RemoteDashboardListenerManager;
import jet.server.log.ServiceLogger;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;
import jet.server.util.WebSecurityUtil;

public class JRDashboardListenerManager
implements ExtDashboardListenerManager {
    RemoteDashboardListenerManager remoteManager = null;

    public JRDashboardListenerManager(RemoteDashboardListenerManager remoteDashboardListenerManager) {
        this.remoteManager = remoteDashboardListenerManager;
    }

    @Override
    public boolean addDashboardListener(DashboardListenerInfo dashboardListenerInfo) {
        try {
            return this.remoteManager.addDashboardListener(dashboardListenerInfo);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return false;
        }
    }

    public boolean deleteDashboardListeners(List list) {
        try {
            return this.remoteManager.deleteDashboardListeners(list);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return false;
        }
    }

    @Override
    public DashboardListenerInfo getDashboardListenerByName(String string) {
        try {
            return this.remoteManager.getDashboardListenerByName(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public DashboardListenerInfo getDashboardListenerByTarget(String string) {
        try {
            return this.remoteManager.getDashboardListenerByTarget(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    public Vector getDashboardListeners() {
        try {
            return this.remoteManager.getDashboardListeners();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return new Vector();
        }
    }

    public boolean setMultiEnabled(List list, boolean bl) {
        try {
            return this.remoteManager.setMultiEnabled(list, bl);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return false;
        }
    }

    @Override
    public boolean updateDashboardListener(DashboardListenerInfo dashboardListenerInfo) {
        try {
            return this.remoteManager.updateDashboardListener(dashboardListenerInfo);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return false;
        }
    }

    @Override
    public DashboardListener getDashboardListenerByPath(String string) throws ClassNotFoundException, ClassCastException, InstantiationException, IllegalAccessException {
        ServiceLogger.logDebug("DashboardListenerManager getDashListenerByPath[path=" + string + "]......");
        DashboardListener dashboardListener = null;
        DashboardListenerInfo dashboardListenerInfo = null;
        dashboardListenerInfo = string == null ? this.getDashboardListenerByTarget("<CREATING>") : this.getDashboardListenerByTarget(string);
        if (dashboardListenerInfo != null) {
            ServiceLogger.logDebug("DashboardListenerManager find the class[" + dashboardListenerInfo.getClassName() + "] for " + string);
            String string2 = dashboardListenerInfo.getClassName();
            try {
                StorageEnv.getStorage().get(Storage.StorageRoot.DYNAMICCLASSES.getRootPath() + "/" + string2 + ".jar");
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 2);
            }
            String string3 = ServerEnv.getReportHome() + "dynamicclasses" + File.separator;
            DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
            dynamicClassManager.loadClasses(string3);
            Class clazz = dynamicClassManager.getClass(string2);
            ServiceLogger.logDebug("DashboardListenerManager return the class instance[" + clazz.getName() + "] for " + string);
            dashboardListener = (DashboardListener)clazz.newInstance();
        } else {
            ServiceLogger.logDebug("DashboardListenerManager Could not get class instance for " + string);
        }
        return dashboardListener;
    }

    public List getDashboardListenerImplClassNames(String string) {
        Class<DashboardListener> clazz = DashboardListener.class;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            string = WebSecurityUtil.validateFilePathStr(string);
            if (string != null) {
                JarFile jarFile = new JarFile(string);
                DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
                String string2 = new File(string).getParent();
                dynamicClassManager.loadClasses(string2);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                block2: while (enumeration.hasMoreElements()) {
                    Class<?>[] classArray;
                    JarEntry jarEntry = enumeration.nextElement();
                    String string3 = jarEntry.getName();
                    if (!string3.endsWith(".class")) continue;
                    string3 = string3.substring(0, string3.indexOf(".class"));
                    string3 = string3.replaceAll("/", ".");
                    Class clazz2 = dynamicClassManager.getClass(string3);
                    for (Class<?> clazz3 : classArray = clazz2.getInterfaces()) {
                        if (clazz2.isInterface() || !clazz.getName().equals(clazz3.getName())) continue;
                        arrayList.add(clazz2.getName());
                        continue block2;
                    }
                }
                jarFile.close();
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        return arrayList;
    }
}

