/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.security.acl.Permission;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import jet.JException;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.CatalogVersionRecord;
import jet.server.api.LCVersionRecord;
import jet.server.api.PathInfo;
import jet.server.api.ReportVersionRecord;
import jet.server.api.ResultVersionRecord;
import jet.server.api.RptServerException;
import jet.server.api.VersionRecord;
import jet.server.api.cluster.Member;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.NodeExistsException;
import jet.server.api.exception.UnknownResource;
import jet.server.api.http.HttpUtil;
import jet.server.cluster.ClusterEnv;
import jet.server.db.event.RecordEventListenerManager;
import jet.server.db.event.VersionEventListener;
import jet.server.intf.jrs.CustomizeControlManager;
import jet.server.intf.jrs.ExResourceManager;
import jet.server.intf.jrs.RemoteResourceManager;
import jet.server.jrc.JRRemoteResourceManager;
import jet.server.jrc.resource.PathInfoImpl;
import jet.server.jrc.resource.VersionRecordImpl;
import jet.server.log.ServiceLogger;
import jet.server.resource.RptResourceManager;
import jet.server.schedule.JRResultFiles;
import jet.server.schedule.JRServerEnv;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;
import jet.server.storage.StorageException;
import jet.server.storage.UnavailableStorageException;
import jet.server.util.ui.UITree;

public class JRResourceManager
implements ExResourceManager,
JRServerEnv {
    private RemoteResourceManager BuildNumber = null;
    private String HISTORY = null;
    private String I = null;
    private boolean SEDU = true;
    private CustomizeControlManager add = null;

    public JRResourceManager(String string, String string2, RemoteResourceManager remoteResourceManager) {
        this.HISTORY = string;
        this.I = string2;
        this.BuildNumber = remoteResourceManager;
        this.SEDU = ServerEnv.isShareMemoryNode();
    }

    public void setCustomizeControlManager(CustomizeControlManager customizeControlManager) {
        this.add = customizeControlManager;
    }

    public CustomizeControlManager getCustomizeControlManager() {
        return this.add;
    }

    @Override
    public String getMIMEType(String string) {
        try {
            return this.BuildNumber.getMIMEType(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public String[] getExtensions(String string) {
        try {
            return this.BuildNumber.getExtensions(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public String getRealm() {
        try {
            return this.BuildNumber.getRealm();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public String getRealmDir() {
        try {
            return this.BuildNumber.getRealmDir();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public PathInfo getPathInfo(String string, String string2) throws RptServerException {
        try {
            PathInfoImpl pathInfoImpl = (PathInfoImpl)this.BuildNumber.getPathInfo(string, string2);
            if (!ServerEnv.isShareMemoryNode()) {
                pathInfoImpl.setRealPath(this.getLocalPath(pathInfoImpl.getRealPath()));
            }
            return pathInfoImpl;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public Vector getSubpaths(String string, String string2) throws RptServerException {
        try {
            return this.getFoldersInPath(string, string2);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
    }

    public Vector getSubpathsAndCatalogs(String string, String string2) throws RptServerException {
        try {
            Vector vector = this.BuildNumber.getSubpathsAndCatalogs(string, string2);
            if (!ServerEnv.isShareMemoryNode()) {
                for (PathInfoImpl pathInfoImpl : vector) {
                    if (pathInfoImpl.isDir()) continue;
                    pathInfoImpl.setRealPath(this.getLocalPath(pathInfoImpl.getRealPath()));
                }
            }
            return vector;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getSubnodes(String string, String string2) throws RptServerException {
        try {
            Vector vector = this.BuildNumber.getSubnodes(string, string2);
            if (!ServerEnv.isShareMemoryNode()) {
                for (PathInfoImpl pathInfoImpl : vector) {
                    if (pathInfoImpl.isDir()) continue;
                    pathInfoImpl.setRealPath(this.getLocalPath(pathInfoImpl.getRealPath()));
                }
            }
            return vector;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public Vector getFileSysDirsInPath(String string, String string2) throws RptServerException {
        try {
            return this.getFoldersInPath(string, string2);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
    }

    public Vector getCatalogsInPath(String string, String string2) throws RptServerException {
        try {
            Vector vector = this.BuildNumber.getCatalogsInPath(string, string2);
            if (!ServerEnv.isShareMemoryNode()) {
                for (PathInfoImpl pathInfoImpl : vector) {
                    pathInfoImpl.setRealPath(this.getLocalPath(pathInfoImpl.getRealPath()));
                }
            }
            return vector;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getLCsInPath(String string, String string2) throws RptServerException {
        try {
            Vector vector = this.BuildNumber.getLCsInPath(string, string2);
            if (!ServerEnv.isShareMemoryNode()) {
                for (PathInfo pathInfo : vector) {
                    ((PathInfoImpl)pathInfo).setRealPath(this.getLocalPath(pathInfo.getRealPath()));
                }
            }
            return vector;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public Vector getFileSysFilesInPath(String string, String string2) throws RptServerException {
        Vector vector = this.getSubnodes(string, string2);
        Vector<PathInfo> vector2 = new Vector<PathInfo>();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            PathInfo pathInfo = (PathInfo)vector.elementAt(i);
            if (pathInfo.isDir()) continue;
            vector2.addElement(pathInfo);
        }
        return vector2;
    }

    @Override
    public Vector getReports(String string, String string2) throws RptServerException {
        String string3 = string2.substring(0, string2.lastIndexOf("/"));
        if (string3 == null || string3.length() == 0) {
            string3 = "/";
        }
        try {
            return this.getReportsInPath(string, string3);
        }
        catch (Exception exception) {
            throw new RptServerException(exception);
        }
    }

    @Override
    public String getRoot() {
        try {
            return this.BuildNumber.getRoot();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public String getTempDir() {
        String string = this.HISTORY;
        if (ServerEnv.isSharedTempDir()) {
            string = ServerEnv.getSharedTempDir();
        }
        if (string != null && !string.endsWith(CSUtil.fileSep)) {
            string = string + CSUtil.fileSep;
        }
        return string;
    }

    @Override
    public String getHistDir() {
        return this.I;
    }

    @Override
    public String getRemoteHistFile(String string) {
        try {
            if (string.startsWith(this.I)) {
                string = string.substring(this.I.length());
            }
            String string2 = this.BuildNumber.getHistDir() + string;
            return string2;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public String getHistFile(String string) {
        try {
            if (string.startsWith(this.I)) {
                string = string.substring(this.I.length());
            }
            return StorageEnv.getStorage().get(Storage.StorageRoot.HISTORY, string).getCanonicalPath();
        }
        catch (IOException iOException) {
            if (string.startsWith(this.I)) {
                return string;
            }
            return this.I + string;
        }
        catch (UnavailableStorageException unavailableStorageException) {
            ServiceLogger.logError(unavailableStorageException.getMessage(), 3);
        }
        catch (StorageException storageException) {
            ServiceLogger.logError((Throwable)((Object)storageException));
        }
        return null;
    }

    public String getAdminHomePath() {
        try {
            return this.BuildNumber.getHomePath();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public String getRealmPath() {
        try {
            return this.BuildNumber.getRealmDir();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public String getRemoteHistDir() {
        try {
            return this.BuildNumber.getHistDir();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public String getLocalPath(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        try {
            string2 = this.BuildNumber.getHistDir();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
        if (string.startsWith(string2)) {
            int n = string2.length();
            String string3 = string.substring(n);
            return this.getHistDir() + string3;
        }
        return string;
    }

    @Override
    public String getRealPath(String string, String string2, int n) throws Exception {
        String string3 = this.BuildNumber.getRealPath(string, string2, n);
        boolean bl = this.getPathInfo(string, string2).isDynamic();
        boolean bl2 = false;
        if (bl) {
            String string4 = string2.substring(0, string2.lastIndexOf("/"));
            if (string4 == null || string4.length() == 0) {
                string4 = "/";
            }
            bl2 = this.getPathInfo(string, string4).isShared();
        }
        return this.BuildNumber(string3, bl, bl2);
    }

    @Override
    public String getURLForCatalogReferedFile(String string, String string2, String string3, int n) {
        String string4 = string2.substring(0, string2.lastIndexOf(File.separator));
        String string5 = "";
        string5 = !string4.endsWith(File.separator) ? string4 + File.separator + string3 : string4 + string3;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ServerEnv.getJSPWebAppName("jsp.webapp.sendfile")).append("?").append("jrs.file").append("=").append(string5).append("&").append("jrs.uid").append("=").append(string);
        return stringBuffer.toString();
    }

    public String checkRealPath(String string) throws Exception {
        return this.BuildNumber(string, false, false);
    }

    private String BuildNumber(String string, boolean bl, boolean bl2) throws Exception {
        if (!bl) {
            String string2 = this.getRemoteHistDir();
            String string3 = string.substring(string2.length());
            VersionEventListener versionEventListener = RecordEventListenerManager.getActiveInstance().getVersionEventListener();
            try {
                versionEventListener.get(string3);
            }
            catch (IOException iOException) {
                throw new JException("get file " + string3 + " failed. " + iOException);
            }
            catch (StorageException storageException) {
                throw new JException("get file " + string3 + " failed. " + (Object)((Object)storageException));
            }
        }
        return this.getLocalPath(string);
    }

    @Override
    public String getRealPath(String string, String string2) throws Exception {
        String string3 = this.BuildNumber.getRealPath(string, string2);
        PathInfo pathInfo = this.getPathInfo(string, string2);
        boolean bl = pathInfo.isDynamic();
        boolean bl2 = false;
        if (pathInfo.isDir()) {
            return string3;
        }
        if (bl) {
            String string4 = string2.substring(0, string2.lastIndexOf("/"));
            if (string4 == null || string4.length() == 0) {
                string4 = "/";
            }
            bl2 = this.getPathInfo(string, string4).isShared();
        }
        return this.BuildNumber(string3, bl, bl2);
    }

    public String getRptRealPath(String string, String string2) throws Exception {
        return this.getRptRealPath(string, string2, false);
    }

    public String getRptRealPath(String string, String string2, boolean bl) throws Exception {
        boolean bl2 = this.getPathInfo(string, string2).isDynamic();
        boolean bl3 = false;
        String string3 = this.BuildNumber.getRptRealPath(string, string2);
        return this.BuildNumber(string3, bl2, bl3);
    }

    @Override
    public String getRptRealPath(String string, String string2, String string3) throws Exception {
        return this.getRptRealPath(string, string2, string3, false);
    }

    public String getRptRealPath(String string, String string2, int n) throws Exception {
        boolean bl = this.getPathInfo(string, string2).isDynamic();
        boolean bl2 = false;
        String string3 = this.BuildNumber.getRptRealPath(string, string2, n);
        return this.BuildNumber(string3, bl, bl2);
    }

    public String getRptRealPath(String string, String string2, String string3, boolean bl) throws Exception {
        boolean bl2 = this.getPathInfo(string, string3).isDynamic();
        boolean bl3 = false;
        String string4 = this.BuildNumber.getRptRealPath(string, string2, string3);
        return this.BuildNumber(string4, bl2, bl3);
    }

    @Override
    public void prepareRslt(String string) {
    }

    @Override
    public void completeRslt(String string, Object object) {
    }

    @Override
    public String getInitParameter(String string) {
        return null;
    }

    @Override
    public Enumeration getInitParameterNames() {
        return null;
    }

    public String getHomePath() {
        String string = ServerEnv.homePath;
        if (string != null && !string.endsWith(CSUtil.fileSep)) {
            string = string + CSUtil.fileSep;
        }
        return string;
    }

    public int getBuildNumber() {
        return ServerEnv.BuildNumber;
    }

    @Override
    public String getSchedulePath() {
        String string;
        File file;
        String string2 = ServerEnv.realmsPath;
        if (!string2.endsWith(CSUtil.fileSep)) {
            string2 = string2 + CSUtil.fileSep;
        }
        if (!(file = new File(string = string2 + this.getRealm() + CSUtil.fileSep + "schedule" + CSUtil.fileSep)).exists()) {
            file.mkdir();
        }
        return string;
    }

    public RptResourceManager getRptResourceManager() {
        if (this.BuildNumber instanceof JRRemoteResourceManager) {
            return ((JRRemoteResourceManager)this.BuildNumber).getRptResourceManager();
        }
        return null;
    }

    @Override
    public Vector getImagesByCatalog(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            Vector vector = this.BuildNumber.getImagesByCatalog(string, string2);
            if (!ServerEnv.isShareMemoryNode()) {
                Vector<String> vector2 = new Vector<String>();
                for (String string3 : vector) {
                    vector2.add(this.getLocalPath(string3));
                }
                return vector2;
            }
            return vector;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getReportsInPath(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            Vector vector = this.BuildNumber.getReportsInPath(string, string2);
            if (!ServerEnv.isShareMemoryNode()) {
                for (PathInfoImpl pathInfoImpl : vector) {
                    pathInfoImpl.setRealPath(this.getLocalPath(pathInfoImpl.getRealPath()));
                }
            }
            return vector;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.logError((Throwable)((Object)rptServerException));
        }
        return null;
    }

    public Vector getDashboardsInPath(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            Vector vector = this.BuildNumber.getDashboardsInPath(string, string2);
            if (!ServerEnv.isShareMemoryNode()) {
                for (PathInfo pathInfo : vector) {
                    ((PathInfoImpl)pathInfo).setRealPath(this.getLocalPath(pathInfo.getRealPath()));
                }
            }
            return vector;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.logError((Throwable)((Object)rptServerException));
        }
        return null;
    }

    @Override
    public Vector getResultsInPath(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            Vector vector = this.BuildNumber.getResultsInPath(string, string2);
            if (!ServerEnv.isShareMemoryNode()) {
                for (PathInfoImpl pathInfoImpl : vector) {
                    pathInfoImpl.setRealPath(this.getLocalPath(pathInfoImpl.getRealPath()));
                }
            }
            return vector;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.logError((Throwable)((Object)rptServerException));
        }
        return null;
    }

    public Vector getFoldersInPath(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            return this.BuildNumber.getFoldersInPath(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getCatalogVersions(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            Vector vector = this.BuildNumber.getCatalogVersions(string, string2);
            if (!ServerEnv.isShareMemoryNode()) {
                for (VersionRecordImpl versionRecordImpl : vector) {
                    versionRecordImpl.setRealPath(this.getLocalPath(versionRecordImpl.getRealPath()));
                }
            }
            return vector;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getLCVersions(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            Vector vector = this.BuildNumber.getLCVersions(string, string2);
            if (!ServerEnv.isShareMemoryNode()) {
                for (LCVersionRecord lCVersionRecord : vector) {
                    ((VersionRecordImpl)((Object)lCVersionRecord)).setRealPath(this.getLocalPath(lCVersionRecord.getRealPath()));
                }
            }
            return vector;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getReportVersions(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            Vector vector = this.BuildNumber.getReportVersions(string, string2);
            if (!ServerEnv.isShareMemoryNode()) {
                for (VersionRecordImpl versionRecordImpl : vector) {
                    versionRecordImpl.setRealPath(this.getLocalPath(versionRecordImpl.getRealPath()));
                }
            }
            return vector;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getResultVersions(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            return this.BuildNumber.getResultVersions(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public ResultVersionRecord getResultVersionByNodeID(String string) throws NoPrivilegeException, UnknownResource {
        try {
            return this.BuildNumber.getResultVersionByNodeID(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public Vector getResultDocVersions(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            return this.BuildNumber.getResultDocVersions(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public void setResultMaxVersionAmount(String string, String string2, int n) throws NoPrivilegeException, UnknownResource {
        try {
            this.BuildNumber.setResultMaxVersionAmount(string, string2, n);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public int getResultMaxVersionAmount(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            return this.BuildNumber.getResultMaxVersionAmount(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return -1;
    }

    @Override
    public void removeNode(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            this.BuildNumber.removeNode(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    private void HISTORY(Hashtable hashtable) {
        if (ServerEnv.isClusterEnabled() && ServerEnv.hasClusterLicense()) {
            Member member = HttpUtil.getHttpRptServer().getClusterService().getLocalMember();
            hashtable.put("jrs.remote_host", member.getHost());
            hashtable.put("jrs.remote_port", member.getPort());
        }
    }

    @Override
    public VersionRecord addResource(String string, String string2, Hashtable hashtable) throws NoPrivilegeException, NodeExistsException, UnknownResource {
        this.HISTORY(hashtable);
        try {
            VersionRecord versionRecord = this.BuildNumber.addResource(string, string2, hashtable, ClusterEnv.getMemberID());
            if (!ServerEnv.isShareMemoryNode()) {
                ((VersionRecordImpl)versionRecord).setRealPath(this.getLocalPath(versionRecord.getRealPath()));
            }
            return versionRecord;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public VersionRecord addResource(String string, String string2, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource {
        this.HISTORY(hashtable);
        try {
            VersionRecord versionRecord = this.BuildNumber.addResource(string, string2, hashtable, hashtableArray, ClusterEnv.getMemberID());
            if (!ServerEnv.isShareMemoryNode()) {
                ((VersionRecordImpl)versionRecord).setRealPath(this.getLocalPath(versionRecord.getRealPath()));
            }
            return versionRecord;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public VersionRecord addResource(String string, String string2, boolean bl, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource {
        this.HISTORY(hashtable);
        try {
            VersionRecord versionRecord = this.BuildNumber.addResource(string, string2, bl, hashtable, hashtableArray, ClusterEnv.getMemberID());
            if (!ServerEnv.isShareMemoryNode()) {
                ((VersionRecordImpl)versionRecord).setRealPath(this.getLocalPath(versionRecord.getRealPath()));
            }
            return versionRecord;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public String addFolder(String string, String string2, Hashtable hashtable) throws NoPrivilegeException, NodeExistsException, UnknownResource {
        try {
            return this.BuildNumber.addFolder(string, string2, hashtable);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public String createFolder(String string, String string2, String string3, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource {
        try {
            return this.BuildNumber.createFolder(string, string2, string3, hashtable, hashtableArray);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public void addResourcesToFolder(String string, String string2, String string3, boolean bl, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource {
        this.HISTORY(hashtable);
        try {
            this.BuildNumber.addResourcesToFolder(string, string2, string3, bl, hashtable, hashtableArray);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public String addResourcesToFolder(String string, String string2, String string3, boolean bl, boolean bl2, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource {
        String string4 = null;
        this.HISTORY(hashtable);
        try {
            string4 = this.BuildNumber.addResourcesToFolder(string, string2, string3, bl, bl2, hashtable, hashtableArray);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return string4;
    }

    @Override
    public Vector getAllUsers(String string) {
        try {
            return this.BuildNumber.getAllUsers(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public Vector getUsersByRole(String string, String string2) throws NoSuchRoleException {
        try {
            return this.BuildNumber.getUsersByRole(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public Vector getAllRoles(String string) {
        try {
            return this.BuildNumber.getAllRoles(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public Vector getRolesByUser(String string, String string2) throws NoSuchUserException {
        try {
            return this.BuildNumber.getRolesByUser(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public Vector getReferRoles(String string) throws NoSuchUserException {
        try {
            return this.BuildNumber.getReferRoles(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public Vector getReferGroups(String string) throws NoSuchUserException {
        try {
            return this.BuildNumber.getReferGroups(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public Vector getReferUsers(String string) throws NoSuchUserException {
        try {
            return this.BuildNumber.getReferUsers(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public Hashtable[] getPermissions(String string, String string2, int n) throws NoPrivilegeException, UnknownResource {
        try {
            return this.BuildNumber.getPermissions(string, string2, n);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public Hashtable[] getInheritedPermissions(String string, String string2, int n) throws NoPrivilegeException, UnknownResource {
        try {
            return this.BuildNumber.getInheritedPermissions(string, string2, n);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public void setPermissions(String string, String string2, int n, Hashtable[] hashtableArray) throws NoPrivilegeException, UnknownResource {
        try {
            this.BuildNumber.setPermissions(string, string2, n, hashtableArray);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public VersionRecord addResultInReport(String string, String string2, Hashtable hashtable) throws NoPrivilegeException, UnknownResource {
        try {
            return this.BuildNumber.addResultInReport(string, string2, hashtable, ClusterEnv.getMemberID());
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public void removeVersion(String string, String string2) throws NoPrivilegeException {
        int n;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(204805, String.valueOf(string2), 6);
            return;
        }
        try {
            this.BuildNumber.removeVersion(string, n);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public String getRealPathOfNode(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            String string3 = this.BuildNumber.getRealPathOfNode(string, string2);
            if (!ServerEnv.isShareMemoryNode()) {
                string3 = this.getLocalPath(string3);
            }
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public String refreshFolders(String string) {
        String string2 = null;
        try {
            UITree uITree = this.BuildNumber.refreshFolders(string);
            string2 = string == null || string.trim().length() == 0 ? ServerEnv.realmsPath + "folders.xml" : ServerEnv.realmsPath + CSUtil.replWithEsc(string) + ".xml";
            uITree.toXML(string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return string2;
    }

    @Override
    public InputStream getResourceTreeInputStream(String string, String ... stringArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (String string2 : stringArray) {
                if (string2.equals(".lc") || string2.equals(".wls") || string2.equals(".cls") || string2.equals(".dsh") || string2.equals(".va")) {
                    arrayList2.add(string2);
                    continue;
                }
                arrayList.add(string2);
            }
            UITree uITree = this.BuildNumber.getUiTree(string, arrayList, arrayList2, null);
            if (uITree.toXML(byteArrayOutputStream)) {
                return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public InputStream getResourceTreeInputStream(String string, int n, String[] stringArray, String[] stringArray2, Locale locale) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (String string2 : stringArray) {
                arrayList.add(string2);
            }
            for (String string2 : stringArray2) {
                arrayList2.add(string2);
            }
            UITree uITree = this.BuildNumber.getUiTree(string, arrayList, arrayList2, locale);
            switch (n) {
                case 0: {
                    if (!uITree.toXML(byteArrayOutputStream)) break;
                    return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                }
                case 1: {
                    if (!uITree.toJSON(byteArrayOutputStream)) break;
                    return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                }
            }
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public InputStream getResourceTreeInputStreamByType(String string, int n, String ... stringArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (String string2 : stringArray) {
                if (string2.equals(".lc") || string2.equals(".wls") || string2.equals(".cls") || string2.equals(".dsh") || string2.equals(".va")) {
                    arrayList2.add(string2);
                    continue;
                }
                arrayList.add(string2);
            }
            UITree uITree = this.BuildNumber.getUiTree(string, arrayList, arrayList2, null);
            switch (n) {
                case 0: {
                    if (!uITree.toXML(byteArrayOutputStream)) break;
                    return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                }
                case 1: {
                    if (!uITree.toJSON(byteArrayOutputStream)) break;
                    return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                }
            }
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public int getLatestVersionNumber(String string) throws UnknownResource {
        try {
            return this.BuildNumber.getLatestVersinNumber(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return -1;
    }

    @Override
    public int getLatestVersionNumber(String string, String string2) throws UnknownResource {
        try {
            return this.BuildNumber.getLatestVersinNumber(string, string2);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return -1;
    }

    @Override
    public void setNodeProperties(String string, String string2, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, NodeExistsException, UnknownResource {
        try {
            this.BuildNumber.setNodeProperties(string, string2, hashtable, hashtableArray);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public void setNodeProperties(String string, String string2, int n, Hashtable hashtable, Hashtable[] hashtableArray) throws NoPrivilegeException, UnknownResource {
        if (CSUtil.getBoolean((String)hashtable.get("jrs.need_expire"))) {
            int n2 = CSUtil.parseInt((String)hashtable.get("jrs.auto_delete_method"), 0);
            if (n2 == 0) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.add(5, CSUtil.parseInt((String)hashtable.get("jrs.expire_days")));
                Date date = new Date(gregorianCalendar.getTime().getTime());
                hashtable.put("jrs.expired_time", date);
            } else {
                int n3 = CSUtil.parseInt((String)hashtable.get("jrs.auto_delete_year"), 1900) - 1900;
                int n4 = CSUtil.parseInt((String)hashtable.get("jrs.auto_delete_month"), 1) - 1;
                int n5 = CSUtil.parseInt((String)hashtable.get("jrs.auto_delete_date"), 0);
                Date date = new Date(n3, n4, n5);
                hashtable.put("jrs.expired_time", date);
            }
        }
        try {
            this.BuildNumber.setNodeProperties(string, string2, n, hashtable, hashtableArray);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public void setResultVersionProperties(String string, String string2, int n, Hashtable hashtable) throws NoPrivilegeException, UnknownResource {
        if (CSUtil.getBoolean((String)hashtable.get("jrs.need_expire"))) {
            int n2 = CSUtil.parseInt((String)hashtable.get("jrs.auto_delete_method"), 0);
            if (n2 == 0) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.add(5, CSUtil.parseInt((String)hashtable.get("jrs.expire_days")));
                Date date = new Date(gregorianCalendar.getTime().getTime());
                hashtable.put("jrs.expired_time", date);
            } else {
                int n3 = CSUtil.parseInt((String)hashtable.get("jrs.auto_delete_year"), 1900) - 1900;
                int n4 = CSUtil.parseInt((String)hashtable.get("jrs.auto_delete_month"), 1) - 1;
                int n5 = CSUtil.parseInt((String)hashtable.get("jrs.auto_delete_date"), 0);
                Date date = new Date(n3, n4, n5);
                hashtable.put("jrs.expired_time", date);
            }
        }
        try {
            this.BuildNumber.setResultVersionProperties(string, string2, n, hashtable);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public CatalogVersionRecord getCatalogVersion(String string, String string2, int n) throws NoPrivilegeException, UnknownResource {
        try {
            CatalogVersionRecord catalogVersionRecord = this.BuildNumber.getCatalogVersion(string, string2, n);
            if (!ServerEnv.isShareMemoryNode()) {
                ((VersionRecordImpl)((Object)catalogVersionRecord)).setRealPath(this.getLocalPath(catalogVersionRecord.getRealPath()));
            }
            return catalogVersionRecord;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public VersionRecord getVersion(String string, String string2, int n) throws NoPrivilegeException, UnknownResource {
        try {
            VersionRecord versionRecord = this.BuildNumber.getVersion(string, string2, n);
            if (!ServerEnv.isShareMemoryNode()) {
                ((VersionRecordImpl)versionRecord).setRealPath(this.getLocalPath(versionRecord.getRealPath()));
            }
            return versionRecord;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public LCVersionRecord getLCVersion(String string, String string2, int n) throws NoPrivilegeException, UnknownResource {
        try {
            LCVersionRecord lCVersionRecord = this.BuildNumber.getLCVersion(string, string2, n);
            if (!ServerEnv.isShareMemoryNode()) {
                ((VersionRecordImpl)((Object)lCVersionRecord)).setRealPath(this.getLocalPath(lCVersionRecord.getRealPath()));
            }
            return lCVersionRecord;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public ReportVersionRecord getReportVersion(String string, String string2, int n) throws NoPrivilegeException, UnknownResource {
        try {
            ReportVersionRecord reportVersionRecord = this.BuildNumber.getReportVersion(string, string2, n);
            if (!ServerEnv.isShareMemoryNode()) {
                ((VersionRecordImpl)((Object)reportVersionRecord)).setRealPath(this.getLocalPath(reportVersionRecord.getRealPath()));
            }
            return reportVersionRecord;
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public ResultVersionRecord getResultVersion(String string, String string2, int n) throws NoPrivilegeException, UnknownResource {
        try {
            return this.BuildNumber.getResultVersion(string, string2, n);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public ResultVersionRecord getResultDocVersion(String string, String string2, int n) throws NoPrivilegeException, UnknownResource {
        try {
            return this.BuildNumber.getResultDocVersion(string, string2, n);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    @Override
    public String getArchivePath(String string) {
        try {
            String string2 = this.BuildNumber.getArchivePath(string);
            File file = new File(this.I, string2);
            file.mkdirs();
            try {
                return file.getCanonicalPath();
            }
            catch (IOException iOException) {
                return this.I + string2;
            }
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return null;
    }

    public boolean deleteArchivePath(String string) {
        try {
            return this.BuildNumber.deleteArchivePath(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return false;
    }

    public String getFileWithoutHistDir(String string) {
        String string2;
        String string3 = string;
        try {
            string2 = this.BuildNumber.getHistDir();
        }
        catch (RemoteException remoteException) {
            string2 = this.getHistDir();
        }
        int n = string2.length();
        if (string3.startsWith(string2)) {
            string3 = string3.substring(n);
        }
        return string3;
    }

    public String getArchiveRstByRealPath(String string, String string2) {
        int n;
        String string3;
        String string4 = string;
        try {
            string3 = this.BuildNumber.getHistDir();
        }
        catch (RemoteException remoteException) {
            string3 = this.getHistDir();
        }
        int n2 = string3.length();
        if (string4.startsWith(string3)) {
            string4 = string4.substring(n2);
        }
        if ((n = string4.lastIndexOf(".")) > 0) {
            boolean bl = false;
            String[] stringArray = JRResultFiles.suffixs;
            String string5 = string4.toLowerCase();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string5.equals(stringArray[i])) continue;
                bl = true;
                break;
            }
            if (bl) {
                string4 = string4.substring(0, n);
            }
        }
        n = string4.lastIndexOf(File.separator);
        String string6 = "";
        if (n < 0) {
            string6 = string4;
        } else {
            if (n + 1 <= string4.length()) {
                string6 = string4.substring(n + 1);
            }
            string4 = string4.substring(0, n);
        }
        if (string6.length() > 0) {
            int n3;
            int n4 = string6.indexOf(string2);
            if (n4 == 0) {
                string6 = string6.substring(string2.length());
            }
            if ((n3 = string6.lastIndexOf("_")) > 0) {
                string6 = string6.substring(0, n3);
            }
            if (n4 == 0) {
                string6 = string2 + string6;
            }
        }
        return string4 + File.separator + string6;
    }

    @Override
    public boolean isAdminUser(String string) {
        try {
            return this.BuildNumber.isAdminUser(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return false;
    }

    @Override
    public boolean isOrganizationAdminUser(String string) {
        try {
            return this.BuildNumber.isOrganizationAdminUser(string);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return false;
    }

    @Override
    public boolean checkPermission(String string, String string2, Permission permission) throws NoSuchUserException, UnknownResource {
        try {
            return this.BuildNumber.checkPermission(string2, string, permission);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return false;
    }

    @Override
    public boolean checkPermission(String string, String string2, int n, Permission permission) throws NoSuchUserException, UnknownResource {
        try {
            return this.BuildNumber.checkPermission(string2, n, string, permission);
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return false;
    }

    public void publishResultToVersion(String string, String string2, String string3, String string4, String string5, Properties properties, Properties properties2, String string6) throws NoPrivilegeException, UnknownResource {
        try {
            this.BuildNumber.publishResultToVersion(string, string2, string3, string4, string5, properties, properties2, string6, ClusterEnv.getMemberID());
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public void loadUserResAliasToMem(String string) {
        try {
            this.BuildNumber.loadUserResAliasToMem(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public void rmUserResAliasFromMem(String string) {
        try {
            this.BuildNumber.rmUserResAliasFromMem(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public String getInheritedLinkedCatalog(String string, String string2) throws NoPrivilegeException, UnknownResource {
        String string3 = null;
        try {
            string3 = this.BuildNumber.getInheritedLinkedCatalog(string, string2);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return string3;
    }

    @Override
    public boolean isNodeExist(String string, String string2) {
        try {
            return this.BuildNumber.isNodeExist(string, string2);
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.logError((Throwable)((Object)rptServerException));
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return false;
    }

    @Override
    public boolean isCatalogLinked(String string, String string2) throws NoPrivilegeException, UnknownResource {
        try {
            return this.BuildNumber.isCatalogLinked(string, string2);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return false;
        }
    }

    @Override
    public void setResultVersionViewed(String string, String string2, int n, String string3, int n2) throws NoPrivilegeException, UnknownResource {
        try {
            this.BuildNumber.setResultVersionViewed(string, string2, n, string3, n2);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    @Override
    public Vector getEnabledCustomFieldNames() {
        try {
            return this.BuildNumber.getEnabledCustomFieldNames();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public List searchNodes(String string, String string2, int n) {
        try {
            return this.BuildNumber.searchNodes(string, string2, n);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }

    @Override
    public String getRootNodeDisplay(Locale locale) {
        try {
            return this.BuildNumber.getRootNodeDisplay(locale);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            return null;
        }
    }
}

