/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver;

import java.util.Hashtable;
import java.util.Map;
import jet.server.api.TempResultOwnerManager;
import jet.server.api.cluster.ClusterException;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.jrserver.TempRstRec;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;

public class JRTempResultOwnerManager
implements TempResultOwnerManager {
    long timeout = SchdTools.TIMEOUT;
    Map htTempResults;

    public JRTempResultOwnerManager() {
        try {
            this.htTempResults = MapFactory.getMap(MapAttr.JRTempResultOwnerManager);
        }
        catch (ClusterException clusterException) {
            this.htTempResults = new Hashtable();
            ServiceLogger.logError((Throwable)((Object)clusterException));
        }
    }

    @Override
    public void setTimeout(long l) {
        this.timeout = l;
    }

    @Override
    public void registerOwner(String string, String string2) {
        String string3 = string + ":" + string2;
        TempRstRec tempRstRec = (TempRstRec)this.htTempResults.get(string3);
        if (tempRstRec == null) {
            tempRstRec = new TempRstRec(string, string2);
            this.htTempResults.put(string3, tempRstRec);
        } else {
            tempRstRec.regTime = System.currentTimeMillis();
        }
        ++tempRstRec.ref;
    }

    @Override
    public boolean isOwner(String string, String string2) {
        String string3 = string + ":" + string2;
        TempRstRec tempRstRec = (TempRstRec)this.htTempResults.get(string3);
        return tempRstRec != null;
    }

    @Override
    public void removeOwner(String string, String string2) {
        String string3 = string + ":" + string2;
        TempRstRec tempRstRec = (TempRstRec)this.htTempResults.get(string3);
        if (tempRstRec != null) {
            --tempRstRec.ref;
            if (tempRstRec.ref <= 0) {
                this.htTempResults.remove(string3);
            }
        }
    }

    @Override
    public void removeOwnersIfTimeout() {
        for (Map.Entry entry : this.htTempResults.entrySet()) {
            String string = (String)entry.getKey();
            TempRstRec tempRstRec = (TempRstRec)entry.getValue();
            if (tempRstRec == null || System.currentTimeMillis() - tempRstRec.regTime <= this.timeout) continue;
            this.htTempResults.remove(string);
        }
    }
}

