/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import java.util.Properties;
import jet.cs.CSUtil;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.admin.cfg.ConfigurationAdvanced;
import jet.server.db.cfg.PropsTable;
import jet.server.db.core.GlobalDataService;
import jet.server.jrserver.JRRptServer;
import jet.server.log.ServiceLogger;

public class JRConfigurationAdvanced
implements ConfigurationAdvanced {
    private ExProperties J = new ExProperties();
    private String MIN_RESULT_LIFE = ServerEnv.getServPropName();
    private Properties SEDU = new Properties();
    JRRptServer rptServer = null;
    PropsTable propTable = null;
    boolean isCluster = ServerEnv.isClusterEnabled();

    public JRConfigurationAdvanced(JRRptServer jRRptServer) {
        this.rptServer = jRRptServer;
        if (this.isCluster) {
            GlobalDataService globalDataService = GlobalDataService.getInstance();
            this.propTable = globalDataService.getPropsTable();
        } else {
            this.loadProperties();
        }
    }

    @Override
    public void loadProperties() {
        try {
            this.J = ServerEnv.getServerProps();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void saveProperty(String string, String string2) {
        try {
            if (this.isCluster) {
                ServerEnv.registerProperty(string, string2);
                this.propTable.updateProp("server.properties", string, string2);
            } else {
                this.saveProperty();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void saveProperty() {
        try {
            this.J.save(this.MIN_RESULT_LIFE, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public void setUserSessionTimeout(int n) {
        this.J.setProperty("server.session.timeout", n);
        this.SEDU.put("server.session.timeout", String.valueOf(n));
        this.saveProperty();
    }

    @Override
    public int getUserSessionTimeout() {
        return CSUtil.parseInt(this.SEDU.getProperty("server.session.timeout"), ServerEnv.getSessionTimeout());
    }

    @Override
    public void setViewReportTimeout(int n) {
        this.J.setProperty("web.timeouts.report_wait", n);
        this.SEDU.put("web.timeouts.report_wait", String.valueOf(n));
        this.saveProperty();
    }

    @Override
    public int getViewReportTimeout() {
        return CSUtil.parseInt(this.SEDU.getProperty("web.timeouts.report_wait"), ServerEnv.getViewReportTimeout());
    }

    @Override
    public void setAdminPort(int n) {
        this.J.setProperty("httpserver.admin.port", n);
        this.SEDU.put("httpserver.admin.port", String.valueOf(n));
        this.saveProperty();
    }

    @Override
    public int getAdminPort() {
        return CSUtil.parseInt(this.SEDU.getProperty("httpserver.admin.port"), ServerEnv.getAdminPort());
    }

    @Override
    public void setReportResultLife(long l) {
        l = l < ServerEnv.MIN_RESULT_LIFE ? ServerEnv.MIN_RESULT_LIFE : l;
        this.J.setProperty("resource.result.life", l);
        this.SEDU.put("resource.result.life", String.valueOf(l));
        this.saveProperty();
    }

    @Override
    public long getReportResultLife() {
        return CSUtil.parseLong(this.SEDU.getProperty("resource.result.life"), ServerEnv.getResultLife());
    }

    @Override
    public void setEnginePriority(int n) {
        this.J.setProperty("engine.priority", n);
        this.SEDU.put("engine.priority", String.valueOf(n));
        this.saveProperty();
    }

    @Override
    public int getEnginePriority() {
        return CSUtil.parseInt(this.SEDU.getProperty("engine.priority"), ServerEnv.getInternalEnginePriority());
    }

    @Override
    public void setEnableJSP(boolean bl) {
    }

    @Override
    public boolean getEnableJSP() {
        return true;
    }

    @Override
    public void setEnableSecurityCheck(boolean bl) {
        this.J.setProperty("server.security", bl);
        this.SEDU.put("server.security", String.valueOf(bl));
        this.saveProperty("server.security", String.valueOf(bl));
    }

    @Override
    public boolean getEnableSecurityCheck() {
        return CSUtil.getBoolean(this.SEDU.getProperty("server.security"), ServerEnv.needSecurity());
    }

    @Override
    public void setEnablePublishTempToVersion(boolean bl) {
        this.J.setProperty("server.version.from.temp", bl);
        this.SEDU.put("server.version.from.temp", String.valueOf(bl));
        this.saveProperty("server.version.from.temp", String.valueOf(bl));
    }

    @Override
    public boolean getEnablePublishTempToVersion() {
        return CSUtil.getBoolean(this.SEDU.getProperty("server.version.from.temp"), ServerEnv.isPublishTempToVersion());
    }

    @Override
    public void setConnectionKeepAlive(boolean bl) {
        this.J.setProperty("server.connection.keepalive", bl);
        this.SEDU.put("server.connection.keepalive", String.valueOf(bl));
        this.saveProperty();
    }

    @Override
    public boolean getConnectionKeepAlive() {
        return CSUtil.getBoolean(this.SEDU.getProperty("server.connection.keepalive"), ServerEnv.keepAlive());
    }

    @Override
    public void setScheduleShouldRun(boolean bl) {
        this.J.setProperty("server.schedule_should_run", bl);
        this.SEDU.put("server.schedule_should_run", String.valueOf(bl));
        this.saveProperty();
    }

    @Override
    public boolean getScheduleShouldRun() {
        return CSUtil.getBoolean(this.SEDU.getProperty("server.schedule_should_run"), ServerEnv.shouldSchedule());
    }

    @Override
    public void setEngineDefaultLanguage(String string) {
        this.J.setProperty("engine.default_language", string);
        this.SEDU.put("engine.default_language", String.valueOf(string));
        this.saveProperty();
    }

    @Override
    public String getEngineDefaultLanguage() {
        String string = (String)this.SEDU.get("engine.default_language");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getEngineDefaultLanguage();
    }

    @Override
    public void setMaxCompletedRecordCount(int n) {
        this.J.setProperty("server.completed.max_count", n);
        this.SEDU.put("server.completed.max_count", String.valueOf(n));
        this.saveProperty("server.completed.max_count", String.valueOf(n));
    }

    @Override
    public int getMaxCompletedRecordCount() {
        return CSUtil.parseInt(this.SEDU.getProperty("server.completed.max_count"), ServerEnv.getMaxCompletedRecordCount());
    }

    @Override
    public boolean isEnableMultipleLogin() {
        return CSUtil.getBoolean(this.SEDU.getProperty("server.enableMultipleLogin"), ServerEnv.isEnableMultipleLogin());
    }

    @Override
    public void setEnableMultipleLogin(boolean bl) {
        this.J.setProperty("server.enableMultipleLogin", bl);
        this.SEDU.put("server.enableMultipleLogin", String.valueOf(bl));
        this.saveProperty();
    }

    @Override
    public boolean isEnableDynamicResource() {
        return CSUtil.getBoolean(this.SEDU.getProperty("server.enableDynamicResource"), ServerEnv.isEnableDynamicResource());
    }

    @Override
    public void setEnableDynamicResource(boolean bl) {
        this.J.setProperty("server.enableDynamicResource", bl);
        this.SEDU.put("server.enableDynamicResource", String.valueOf(bl));
        this.saveProperty("server.enableDynamicResource", String.valueOf(bl));
    }

    @Override
    public void setEnableRoleBasedAuthorization(boolean bl) {
        this.J.setProperty("server.rolebased.authorization", bl);
        this.SEDU.put("server.rolebased.authorization", String.valueOf(bl));
        this.saveProperty();
    }

    @Override
    public void setEnableDisplayUserPermissionUI(boolean bl) {
        this.J.setProperty("server.ui.set_permissions.user", bl);
        this.SEDU.put("server.ui.set_permissions.user", String.valueOf(bl));
        this.saveProperty();
    }

    @Override
    public void setEnableDisplayRolePermissionUI(boolean bl) {
        this.J.setProperty("server.ui.set_permissions.role", bl);
        this.SEDU.put("server.ui.set_permissions.role", String.valueOf(bl));
        this.saveProperty();
    }

    @Override
    public void setEnableDisplayGroupPermissionUI(boolean bl) {
        this.J.setProperty("server.ui.set_permissions.group", bl);
        this.SEDU.put("server.ui.set_permissions.group", String.valueOf(bl));
        this.saveProperty();
    }

    @Override
    public boolean isEnableRoleBasedAuthorization() {
        return CSUtil.getBoolean(this.SEDU.getProperty("server.rolebased.authorization"), ServerEnv.isEnableRoleBasedAuthorization());
    }

    @Override
    public boolean isEnableDispalyUserPermissionUI() {
        return CSUtil.getBoolean(this.SEDU.getProperty("server.ui.set_permissions.user"), ServerEnv.isEnableDispalyUserPermissionUI());
    }

    @Override
    public boolean isEnableDispalyRolePermissionUI() {
        return CSUtil.getBoolean(this.SEDU.getProperty("server.ui.set_permissions.role"), ServerEnv.isEnableDispalyRolePermissionUI());
    }

    @Override
    public boolean isEnableDispalyGroupPermissionUI() {
        return CSUtil.getBoolean(this.SEDU.getProperty("server.ui.set_permissions.group"), ServerEnv.isEnableDispalyGroupPermissionUI());
    }

    @Override
    public int getPermissionAlgorithmType() {
        return CSUtil.parseInt(this.SEDU.getProperty("server.permission.algorithm"), ServerEnv.getPermissionAlgorithmType());
    }

    @Override
    public void setPermissionAlgorithmType(int n) {
        if (n != 0 && n != 1) {
            n = 0;
        }
        this.J.setProperty("server.permission.algorithm", n);
        this.SEDU.put("server.permission.algorithm", String.valueOf(n));
        this.saveProperty();
    }

    @Override
    public boolean isEnableTaskDuration() {
        return CSUtil.getBoolean(this.SEDU.getProperty("task.duration.enable"), ServerEnv.isEnableTaskDuration());
    }

    @Override
    public void setEnableTaskDuration(boolean bl) {
        this.J.setProperty("task.duration.enable", bl);
        this.SEDU.put("task.duration.enable", String.valueOf(bl));
        this.saveProperty();
    }

    @Override
    public int getTaskDurationCheckPeriod() {
        return CSUtil.parseInt(this.SEDU.getProperty("task.duration.check_cycle"), ServerEnv.getTimeoutsCheckCycle());
    }

    @Override
    public void setTaskDurationCheckPeriod(int n) {
        this.J.setProperty("task.duration.check_cycle", n);
        this.SEDU.put("task.duration.check_cycle", String.valueOf(n));
        this.saveProperty();
    }

    @Override
    public boolean isEnableLinkedCatalog() {
        return CSUtil.getBoolean(this.SEDU.getProperty("server.resource.enable_linked_catalog"), ServerEnv.isEnableLinkedCatalog());
    }

    @Override
    public void setEnableLinkedCatalog(boolean bl) {
        this.J.setProperty("server.resource.enable_linked_catalog", bl);
        this.SEDU.put("server.resource.enable_linked_catalog", String.valueOf(bl));
        this.saveProperty();
    }

    @Override
    public String getLinkedCatalog() {
        String string = (String)this.SEDU.get("server.resource.linked_catalog");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getLinkedCatalog();
    }

    @Override
    public void setLinkedCatalog(String string) {
        if (string == null) {
            this.J.remove("server.resource.linked_catalog");
            this.SEDU.remove("server.resource.linked_catalog");
        } else {
            this.J.setProperty("server.resource.linked_catalog", string);
            this.SEDU.put("server.resource.linked_catalog", string);
        }
        this.saveProperty();
    }

    @Override
    public boolean isPromptTaskQueueFull() {
        return CSUtil.getBoolean(this.SEDU.getProperty("web.prompt.taskqueue_full"), ServerEnv.isPromptTaskQueueFull());
    }

    @Override
    public boolean isPromptActionQueueFull() {
        return CSUtil.getBoolean(this.SEDU.getProperty("web.prompt.actionqueue_full"), ServerEnv.isPromptActionQueueFull());
    }

    @Override
    public void setPromptTaskQueueFull(boolean bl) {
        this.J.setProperty("web.prompt.taskqueue_full", bl);
        this.SEDU.put("web.prompt.taskqueue_full", String.valueOf(bl));
        this.saveProperty();
    }

    @Override
    public void setPromptActionQueueFull(boolean bl) {
        this.J.setProperty("web.prompt.actionqueue_full", bl);
        this.SEDU.put("web.prompt.actionqueue_full", String.valueOf(bl));
        this.saveProperty();
    }

    @Override
    public boolean isShowNameWithPostfix() {
        return CSUtil.getBoolean(this.SEDU.getProperty("web.page.option.show_name_with_postfix"), ServerEnv.isShowNameWithPostfix());
    }

    @Override
    public void setShowNameWithPostfix(boolean bl) {
        this.J.setProperty("web.page.option.show_name_with_postfix", bl);
        this.SEDU.put("web.page.option.show_name_with_postfix", String.valueOf(bl));
        this.saveProperty();
    }

    @Override
    public boolean isShowNameWithPostfixForWebViewer() {
        return CSUtil.getBoolean(this.SEDU.getProperty("web.viewer.option.show_name_with_postfix"), ServerEnv.isShowNameWithPostfixForWebViewer());
    }

    @Override
    public void setShowNameWithPostfixForWebViewer(boolean bl) {
        this.J.setProperty("web.viewer.option.show_name_with_postfix", bl);
        this.SEDU.put("web.viewer.option.show_name_with_postfix", String.valueOf(bl));
        this.saveProperty();
    }

    @Override
    public boolean isAdvancedPasswordEnabled() {
        return CSUtil.getBoolean(this.SEDU.getProperty("server.security.advanced_password.enabled"), ServerEnv.isAdvancedPasswordEnabled());
    }

    @Override
    public void setAdvancedPasswordEnabled(boolean bl) {
        this.J.setProperty("server.security.advanced_password.enabled", bl);
        this.SEDU.put("server.security.advanced_password.enabled", String.valueOf(bl));
        this.saveProperty();
    }

    @Override
    public boolean isAdvancedPasswordLimitedMinLength() {
        return CSUtil.getBoolean(this.SEDU.getProperty("server.security.advanced_password.limited_min_length"), ServerEnv.isAdvancedPasswordLimitedMinLength());
    }

    @Override
    public void setAdvancedPasswordLimitedMinLength(boolean bl) {
        this.J.setProperty("server.security.advanced_password.limited_min_length", bl);
        this.SEDU.put("server.security.advanced_password.limited_min_length", String.valueOf(bl));
        this.saveProperty();
    }

    @Override
    public int getAdvancedPasswordMinLength() {
        return CSUtil.parseInt(this.SEDU.getProperty("server.security.advanced_password.min_length"), ServerEnv.getAdvancedPasswordMinLength());
    }

    @Override
    public void setAdvancedPasswordMinLength(int n) {
        this.J.setProperty("server.security.advanced_password.min_length", n);
        this.SEDU.put("server.security.advanced_password.min_length", String.valueOf(n));
        this.saveProperty();
    }

    @Override
    public boolean isAdvancedPasswordContainsUppercase() {
        return CSUtil.getBoolean(this.SEDU.getProperty("server.security.advanced_password.contains_uppercase"), ServerEnv.isAdvancedPasswordContainsUppercase());
    }

    @Override
    public void setAdvancedPasswordContainsUppercase(boolean bl) {
        this.J.setProperty("server.security.advanced_password.contains_uppercase", bl);
        this.SEDU.put("server.security.advanced_password.contains_uppercase", String.valueOf(bl));
        this.saveProperty();
    }

    @Override
    public boolean isAdvancedPasswordContainsLowercase() {
        return CSUtil.getBoolean(this.SEDU.getProperty("server.security.advanced_password.contains_lowercase"), ServerEnv.isAdvancedPasswordContainsLowercase());
    }

    @Override
    public void setAdvancedPasswordContainsLowercase(boolean bl) {
        this.J.setProperty("server.security.advanced_password.contains_lowercase", bl);
        this.SEDU.put("server.security.advanced_password.contains_lowercase", String.valueOf(bl));
        this.saveProperty();
    }

    @Override
    public boolean isAdvancedPasswordContainsNumber() {
        return CSUtil.getBoolean(this.SEDU.getProperty("server.security.advanced_password.contains_number"), ServerEnv.isAdvancedPasswordContainsNumber());
    }

    @Override
    public void setAdvancedPasswordContainsNumber(boolean bl) {
        this.J.setProperty("server.security.advanced_password.contains_number", bl);
        this.SEDU.put("server.security.advanced_password.contains_number", String.valueOf(bl));
        this.saveProperty();
    }

    @Override
    public boolean isAdvancedPasswordContainsSymbols() {
        return CSUtil.getBoolean(this.SEDU.getProperty("server.security.advanced_password.contains_symbols"), ServerEnv.isAdvancedPasswordContainsSymbols());
    }

    @Override
    public void setAdvancedPasswordContainsSymbols(boolean bl) {
        this.J.setProperty("server.security.advanced_password.contains_symbols", bl);
        this.SEDU.put("server.security.advanced_password.contains_number", String.valueOf(bl));
        this.saveProperty();
    }

    @Override
    public boolean isAdvancedPasswordUserDefinedRule() {
        return CSUtil.getBoolean(this.SEDU.getProperty("server.security.advanced_password.user_defined_rule"), ServerEnv.isAdvancedPasswordUserDefinedRule());
    }

    @Override
    public void setAdvancedPasswordUserDefinedRule(boolean bl) {
        this.J.setProperty("server.security.advanced_password.user_defined_rule", bl);
        this.SEDU.put("server.security.advanced_password.user_defined_rule", String.valueOf(bl));
        this.saveProperty();
    }

    @Override
    public String getAdvancedPasswordUserDefinedRuleClassName() {
        String string = this.SEDU.getProperty("server.security.advanced_password.user_defined_rule_class_name");
        if (string == null) {
            return "";
        }
        return string;
    }

    @Override
    public void setAdvancedPasswordUserDefinedRuleClassName(String string) {
        if (string == null) {
            string = "";
        }
        this.J.setProperty("server.security.advanced_password.user_defined_rule_class_name", string);
        this.SEDU.put("server.security.advanced_password.user_defined_rule_class_name", String.valueOf(string));
        this.saveProperty();
    }
}

