/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import com.jinfonet.resstore.ResourceLoadException;
import com.jinfonet.resstore.ResourceNotFoundException;
import com.jinfonet.resstore.loader.CacheableLoader;
import com.jinfonet.resstore.loader.CachedObject;
import com.jinfonet.resstore.loader.CatalogID;
import com.jinfonet.resstore.loader.CatalogIDImpl;
import com.jinfonet.resstore.loader.ImageID;
import com.jinfonet.resstore.loader.ImageIDImpl;
import com.jinfonet.resstore.loader.ReportID;
import com.jinfonet.resstore.loader.ReportIDImpl;
import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jet.cs.CSUtil;
import jet.cs.ExProperties;
import jet.cs.util.APIUtil;
import jet.server.ServerEnv;
import jet.server.api.admin.cfg.ConfigurationCache;
import jet.server.db.cfg.PropsTable;
import jet.server.db.core.GlobalDataService;
import jet.server.jrc.resource.ResourceTreeManagerImpl;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.version.SimpleVersionInfo;
import jet.server.log.ServiceLogger;
import jet.server.resstore.ServerMemoryStore;
import jet.server.resstore.ServerResourceStore;
import jet.server.resstore.ServerResourceStoreFactory;
import jet.server.util.ResourceConvertor;
import jet.web.dhtml.DHTMLClientService;
import jet.web.dhtml.DHTMLServiceFactory;

public class JRConfigurationCache
implements ConfigurationCache {
    private ExProperties SEDU = null;
    private String add = null;
    private Hashtable addElement = new Hashtable(2);
    private Hashtable append = new Hashtable(2);
    private HashSet compile = new HashSet(2);
    boolean isCluster = false;
    PropsTable probTable = null;
    public static Hashtable resources = new Hashtable(2);

    public JRConfigurationCache() {
        this.loadProperties();
        this.isCluster = ServerEnv.isClusterEnabled();
        if (this.isCluster) {
            GlobalDataService globalDataService = GlobalDataService.getInstance();
            this.probTable = globalDataService.getPropsTable();
        }
    }

    private ServerResourceStore SEDU() {
        return ServerResourceStoreFactory.getInstance().getResourceStore(null);
    }

    @Override
    public void loadProperties() {
        try {
            this.SEDU = ServerEnv.getServerProps();
            this.add();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        this.add = ServerEnv.getServPropName();
    }

    private void add() {
        String string;
        String string2;
        StringTokenizer stringTokenizer;
        String string3 = this.SEDU.getProperty("performance.preloadedcats");
        if (string3 != null && string3.trim().length() > 0) {
            stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                string = (String)resources.get(string2);
                this.addElement.put(string == null ? string2 : string, string2);
            }
        }
        if ((string3 = this.SEDU.getProperty("performance.preloadedrpts")) != null && string3.trim().length() > 0) {
            stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (!string2.endsWith(")")) {
                    string2 = string2 + "(None)";
                }
                this.append.put((string = (String)resources.get(string2)) == null ? string2 : string, string2);
            }
        }
    }

    @Override
    public void saveProperties() {
        try {
            this.SEDU.save(this.add, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public void setEnableCacheCatelog(boolean bl) {
        this.get("performance.cachecat", String.valueOf(bl), false);
        this.SEDU().getMemoryStore().getCatalogLoader().setCacheEnabled(bl);
    }

    @Override
    public boolean getEnableCacheCatelog() {
        return this.SEDU.getProperty("performance.cachecat", true);
    }

    @Override
    public void setEnableCacheReport(boolean bl) {
        this.get("performance.cacherpt", String.valueOf(bl), false);
        this.SEDU().getMemoryStore().getReportLoader().setCacheEnabled(bl);
    }

    @Override
    public boolean getEnableCacheReport() {
        return this.SEDU.getProperty("performance.cacherpt", true);
    }

    @Override
    public void setEnableCacheImage(boolean bl) {
        this.get("performance.cacheimg", String.valueOf(bl), false);
        this.SEDU().getMemoryStore().getImageLoader().setCacheEnabled(bl);
    }

    @Override
    public boolean getEnableCacheImage() {
        return this.SEDU.getProperty("performance.cacheimg", true);
    }

    @Override
    public boolean getDisplayImageDetail() {
        return this.SEDU.getProperty("performance.showimgdetail", true);
    }

    @Override
    public void setDisplayImageDetail(boolean bl) {
        this.get("performance.showimgdetail", String.valueOf(bl), false);
    }

    @Override
    public void setMaxCacheCatalogSize(int n) {
        this.get("performance.catpoolsize", String.valueOf(n), false);
        this.SEDU().getMemoryStore().getCatalogLoader().setMaxSize(n);
    }

    @Override
    public int getMaxCacheCatalogSize() {
        return this.SEDU.getProperty("performance.catpoolsize", 10);
    }

    @Override
    public void setMaxCacheReportSize(int n) {
        this.get("performance.rptpoolsize", String.valueOf(n), false);
        this.SEDU().getMemoryStore().getReportLoader().setMaxSize(n);
    }

    @Override
    public int getMaxCacheReportSize() {
        return this.SEDU.getProperty("performance.rptpoolsize", 10);
    }

    @Override
    public void setMaxCacheImageSize(int n) {
        this.get("performance.imgpoolsize", String.valueOf(n), false);
        this.SEDU().getMemoryStore().getImageLoader().setMaxSpace(0x100000L * (long)n);
    }

    @Override
    public int getMaxCacheImageSize() {
        return this.SEDU.getProperty("performance.imgpoolsize", 10);
    }

    public boolean setCachedCatalogs(Vector vector) {
        boolean bl = false;
        ServerMemoryStore serverMemoryStore = this.SEDU().getMemoryStore();
        for (String string : vector) {
            try {
                serverMemoryStore.loadCatalog(new File(string));
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                ServiceLogger.logError(resourceNotFoundException, 3);
                bl = true;
            }
            catch (ResourceLoadException resourceLoadException) {
                ServiceLogger.logError(resourceLoadException, 3);
                bl = true;
            }
        }
        return !bl;
    }

    private String addElement(String string, String string2) {
        return ResourceConvertor.getInstance().getCatRealPath(string, string2);
    }

    @Override
    public Vector getCachedImages() {
        Vector<File> vector = new Vector<File>();
        List list = this.SEDU().getMemoryStore().getImageLoader().getKeys();
        for (ImageID imageID : list) {
            vector.addElement(new File(imageID.getCatFile().getParentFile(), imageID.getImageName()));
        }
        return vector;
    }

    @Override
    public void appendImage(String string, String string2, String string3) {
        String string4 = this.addElement(string3, string);
        File file = new File(string4);
        String string5 = file.getParent();
        if (!string5.endsWith(File.separator)) {
            string5 = string5 + File.separator;
        }
        File file2 = new File(string5 + string2);
        this.compile.add(file2.getAbsolutePath());
        try {
            this.SEDU().getMemoryStore().loadImage(file, string2);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            ServiceLogger.logError(resourceNotFoundException, 3);
        }
        catch (ResourceLoadException resourceLoadException) {
            ServiceLogger.logError(resourceLoadException, 3);
        }
    }

    @Override
    public void removeImage(String string, String string2, String string3) {
        String string4 = this.addElement(string3, string);
        this.compile.remove(string4);
        File file = new File(string4);
        this.SEDU().getMemoryStore().getImageLoader().remove((Object)new ImageIDImpl(file, string2));
    }

    @Override
    public void removeAllImages() {
        this.compile.removeAll(this.compile);
        List list = this.SEDU().getMemoryStore().getImageLoader().getKeys();
        this.SEDU().getMemoryStore().getImageLoader().removeAll(list);
    }

    @Override
    public String getImageBelongedCatalog(String string) {
        File file = null;
        String string2 = new File(string).getName();
        List list = this.SEDU().getMemoryStore().getImageLoader().getKeys();
        for (ImageID imageID : list) {
            if (!string2.equals(imageID.getImageName())) continue;
            file = imageID.getCatFile();
        }
        if (file != null) {
            return this.elementAt(file, null);
        }
        return "";
    }

    @Override
    public boolean lockCachedImage(String string, String string2, String string3) {
        String string4 = this.addElement(string3, string);
        File file = new File(string4);
        ImageIDImpl imageIDImpl = new ImageIDImpl(file, string2);
        this.SEDU().getMemoryStore().getImageLoader().lock((Object)imageIDImpl);
        CachedObject cachedObject = this.SEDU().getMemoryStore().getImageLoader().get((Object)imageIDImpl);
        return cachedObject != null && cachedObject.isLocked();
    }

    @Override
    public boolean unlockCachedImage(String string, String string2, String string3) {
        String string4 = this.addElement(string3, string);
        File file = new File(string4);
        ImageIDImpl imageIDImpl = new ImageIDImpl(file, string2);
        this.SEDU().getMemoryStore().getImageLoader().unlock((Object)imageIDImpl);
        CachedObject cachedObject = this.SEDU().getMemoryStore().getImageLoader().get((Object)imageIDImpl);
        return cachedObject == null || !cachedObject.isLocked();
    }

    @Override
    public boolean isLockedImage(String string, String string2, String string3) {
        String string4 = this.addElement(string3, string);
        File file = new File(string4);
        ImageIDImpl imageIDImpl = new ImageIDImpl(file, string2);
        CachedObject cachedObject = this.SEDU().getMemoryStore().getImageLoader().get((Object)imageIDImpl);
        return cachedObject != null && cachedObject.isLocked();
    }

    @Override
    public boolean isCacheAllImages() {
        return this.SEDU.getProperty("performance.cacheallimg", true);
    }

    @Override
    public void setCacheAllImages(boolean bl) {
        this.get("performance.cacheallimg", String.valueOf(bl), false);
        if (bl) {
            this.SEDU().getMemoryStore().getImageLoader().setMaxSpace(Long.MAX_VALUE);
        }
    }

    @Override
    public long getUsedImageCacheSize() {
        return this.SEDU().getMemoryStore().getImageLoader().getUsedSpace();
    }

    @Override
    public long getAnImageSize(String string, String string2, String string3) {
        String string4 = this.addElement(string3, string);
        File file = new File(string4);
        ImageIDImpl imageIDImpl = new ImageIDImpl(file, string2);
        CachedObject cachedObject = this.SEDU().getMemoryStore().getImageLoader().get((Object)imageIDImpl);
        return cachedObject == null ? 0L : cachedObject.length();
    }

    @Override
    public boolean setCachedCatalogs(String string, Vector vector) {
        Vector vector2 = this.append(string, vector);
        boolean bl = false;
        for (String string2 : vector2) {
            try {
                this.SEDU().getMemoryStore().loadCatalog(new File(string2));
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                bl = true;
                ServiceLogger.logError(resourceNotFoundException, 3);
            }
            catch (ResourceLoadException resourceLoadException) {
                bl = true;
                ServiceLogger.logError(resourceLoadException, 3);
            }
        }
        return !bl;
    }

    @Override
    public Vector getCachedCatalogs() {
        Vector<String> vector = new Vector<String>();
        List list = this.SEDU().getMemoryStore().getCatalogLoader().getKeys();
        if (list != null) {
            vector = new Vector();
            for (CatalogID catalogID : list) {
                vector.add(this.elementAt(catalogID.getFile(), null));
            }
        }
        return vector;
    }

    @Override
    public boolean setCachedReports(Vector vector) {
        boolean bl = false;
        ServerMemoryStore serverMemoryStore = this.SEDU().getMemoryStore();
        for (String string : vector) {
            try {
                serverMemoryStore.loadReport(new File(string), null, null);
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                ServiceLogger.logError(resourceNotFoundException, 3);
                bl = true;
            }
            catch (ResourceLoadException resourceLoadException) {
                ServiceLogger.logError(resourceLoadException, 3);
                bl = true;
            }
        }
        return !bl;
    }

    @Override
    public boolean setCachedReportsWithStyles(Vector vector) {
        Pattern pattern = Pattern.compile("^(.*)\\((.*)\\)$");
        boolean bl = false;
        ServerMemoryStore serverMemoryStore = this.SEDU().getMemoryStore();
        for (String string : vector) {
            try {
                Matcher matcher = pattern.matcher(string);
                if (matcher.matches()) {
                    serverMemoryStore.loadReport(new File(matcher.group(1)), matcher.group(2), null);
                    continue;
                }
                serverMemoryStore.loadReport(new File(string), null, null);
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                ServiceLogger.logError(resourceNotFoundException, 3);
                bl = true;
            }
            catch (ResourceLoadException resourceLoadException) {
                ServiceLogger.logError(resourceLoadException, 3);
                bl = true;
            }
        }
        return !bl;
    }

    @Override
    public boolean setCachedReportsWithStyles(String string, Vector vector) {
        Vector vector2 = this.compile(string, vector);
        return this.setCachedReportsWithStyles(vector2);
    }

    @Override
    public Vector getCachedReports() {
        Vector<String> vector = new Vector<String>();
        List list = this.SEDU().getMemoryStore().getReportLoader().getKeys();
        if (list != null) {
            for (ReportID reportID : list) {
                vector.add(this.elementAt(reportID.getFile(), reportID.getStyleGroup()));
            }
        }
        return vector;
    }

    @Override
    public Vector getCachedReportsWithStyles() {
        Vector<String> vector = new Vector<String>();
        List list = this.SEDU().getMemoryStore().getReportLoader().getKeys();
        if (list != null) {
            for (ReportID reportID : list) {
                vector.add(this.elementAt(reportID.getFile(), reportID.getStyleGroup()));
            }
        }
        return vector;
    }

    @Override
    public void unloadCatalogs(Vector vector) {
        CacheableLoader cacheableLoader = this.SEDU().getMemoryStore().getCatalogLoader();
        for (String string : vector) {
            cacheableLoader.remove((Object)new CatalogIDImpl(new File(string)));
        }
    }

    @Override
    public void unloadCatalogs(String string, Vector vector) {
        Vector vector2 = this.append(string, vector);
        this.unloadCatalogs(vector2);
    }

    @Override
    public void unloadReports(Vector vector) {
        CacheableLoader cacheableLoader = this.SEDU().getMemoryStore().getReportLoader();
        for (String string : vector) {
            cacheableLoader.remove((Object)new ReportIDImpl(new File(string), null, null));
        }
    }

    @Override
    public void unloadReportsWithStyles(Vector vector) {
        Pattern pattern = Pattern.compile("^(.*)\\((.*)\\)$");
        CacheableLoader cacheableLoader = this.SEDU().getMemoryStore().getReportLoader();
        for (String string : vector) {
            File file;
            Matcher matcher = pattern.matcher(string);
            String string2 = null;
            if (matcher.matches()) {
                file = new File(matcher.group(1));
                string2 = matcher.group(2);
            } else {
                file = new File(string);
            }
            cacheableLoader.remove((Object)new ReportIDImpl(file, string2, null));
        }
    }

    @Override
    public void unloadReportsWithStyles(String string, Vector vector) {
        Vector vector2 = this.compile(string, vector);
        this.unloadReportsWithStyles(vector2);
    }

    @Override
    public void setSecurityUserCacheSize(int n) {
        this.get("server.security.user.cache.size", String.valueOf(n), false);
    }

    @Override
    public int getSecurityUserCacheSize() {
        return this.SEDU.getProperty("server.security.user.cache.size", 1000);
    }

    @Override
    public void setSecurityRoleCacheSize(int n) {
        this.get("server.security.role.cache.size", String.valueOf(n), false);
    }

    @Override
    public int getSecurityRoleCacheSize() {
        return this.SEDU.getProperty("server.security.role.cache.size", 50);
    }

    @Override
    public void setSecurityGroupCacheSize(int n) {
        this.get("server.security.group.cache.size", String.valueOf(n), false);
    }

    @Override
    public int getSecurityGroupCacheSize() {
        return this.SEDU.getProperty("server.security.group.cache.size", 50);
    }

    @Override
    public void setSecurityProtectionCacheSize(int n) {
        this.get("server.security.protection.cache.size", String.valueOf(n), false);
    }

    @Override
    public int getSecurityProectionCacheSize() {
        return this.SEDU.getProperty("server.security.protection.cache.size", 100);
    }

    @Override
    public void setSecurityCacheExpireTime(int n) {
        this.get("server.security.user.cache.expiretime", String.valueOf(n), false);
    }

    @Override
    public int getSecurityCacheExpireTime() {
        return this.SEDU.getProperty("server.security.user.cache.expiretime", 180);
    }

    private Vector append(String string, Vector vector) {
        if (vector == null || vector.isEmpty()) {
            return vector;
        }
        Vector<String> vector2 = new Vector<String>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = ResourceConvertor.getInstance().getCatRealPath(string, (String)vector.elementAt(i));
            this.addElement.put(string2, (String)vector.elementAt(i));
            vector2.add(string2);
        }
        return vector2;
    }

    private Vector compile(String string, Vector vector) {
        if (vector == null || vector.isEmpty()) {
            return vector;
        }
        Vector<String> vector2 = new Vector<String>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = ResourceConvertor.getInstance().getRptRealPath(string, (String)vector.elementAt(i));
            this.append.put(string2, (String)vector.elementAt(i));
            vector2.add(string2);
        }
        return vector2;
    }

    private String elementAt(File file, String string) {
        String string2;
        ResourceTreeManagerImpl resourceTreeManagerImpl = UserDataToolkit.getResourceManager(ServerEnv.getActiveRealm());
        SimpleVersionInfo simpleVersionInfo = resourceTreeManagerImpl == null ? null : resourceTreeManagerImpl.getResourceVersionByDiskPath(file.getPath());
        String string3 = string2 = simpleVersionInfo == null ? file.getPath() : simpleVersionInfo.getResourcePath() + "-V" + simpleVersionInfo.getVersionNumber();
        if (string != null) {
            string2 = string2 + "(" + string + ")";
        }
        return string2;
    }

    private Vector endsWith(Vector vector) {
        if (vector == null || vector.isEmpty()) {
            return vector;
        }
        Vector<String> vector2 = new Vector<String>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            String string2 = (String)this.addElement.get(string);
            if (string2 != null) {
                vector2.add(string2);
                continue;
            }
            vector2.add(string);
            this.addElement.put(string, string);
        }
        return vector2;
    }

    private Vector equals(Vector vector) {
        if (vector == null || vector.isEmpty()) {
            return vector;
        }
        Vector<String> vector2 = new Vector<String>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            String string2 = (String)this.append.get(string);
            if (string2 != null) {
                vector2.add(string2);
                continue;
            }
            vector2.add(string);
            this.addElement.put(string, string);
        }
        return vector2;
    }

    @Override
    public int getEngineSortBufferSize() {
        return this.SEDU.getProperty("engine.sort.buffer_size", -1);
    }

    @Override
    public void setEngineSortBufferSize(int n) {
        this.get("engine.sort.buffer_size", String.valueOf(n), false);
        DHTMLClientService dHTMLClientService = DHTMLServiceFactory.getDHTMLClientService();
        dHTMLClientService.notify_change_engine_dosort_buffer_size(n);
    }

    @Override
    public void setCRDMemoryUsage(int n) {
        this.get("server.crd.memory.usage", Integer.toString(n), true);
        this.SEDU().getMemoryStore().getCrdCache().setMaxMemorySize((long)n * 0x100000L);
    }

    @Override
    public int getCRDMemoryUsage() {
        if (this.isCluster) {
            return APIUtil.parseInt(ServerEnv.getPropertyFromClusterRegistry("server.crd.memory.usage"), 4);
        }
        return this.SEDU.getProperty("server.crd.memory.usage", 4);
    }

    @Override
    public long getExpiredTime() {
        if (this.isCluster) {
            return APIUtil.parseLong(ServerEnv.getPropertyFromClusterRegistry("server.autocache.expired.time"), 0);
        }
        return this.SEDU.getProperty("server.autocache.expired.time", 0);
    }

    @Override
    public int getMaxDiskUsage() {
        if (this.isCluster) {
            return APIUtil.parseInt(ServerEnv.getPropertyFromClusterRegistry("server.autocache.max.disk.usage"), 512);
        }
        return this.SEDU.getProperty("server.autocache.max.disk.usage", 512);
    }

    @Override
    public boolean isAutoCache() {
        if (this.isCluster) {
            return APIUtil.getBoolean(ServerEnv.getPropertyFromClusterRegistry("server.autocache.enabled"), false);
        }
        return this.SEDU.getProperty("server.autocache.enabled", false);
    }

    @Override
    public boolean isNeverExpire() {
        if (this.isCluster) {
            return APIUtil.getBoolean(ServerEnv.getPropertyFromClusterRegistry("server.autocache.never.expire"), true);
        }
        return this.SEDU.getProperty("server.autocache.never.expire", true);
    }

    @Override
    public void setEnableAutoCache(boolean bl) {
        this.get("server.autocache.enabled", Boolean.toString(bl), true);
        UserDataToolkit.getJDataService(null).setEnableAutoCache(bl);
    }

    @Override
    public void setExpiredTime(long l) {
        this.get("server.autocache.expired.time", Long.toString(l), true);
    }

    @Override
    public void setMaxDiskUsage(int n) {
        this.get("server.autocache.max.disk.usage", Integer.toString(n), true);
        ServerResourceStoreFactory.getInstance().getResourceStore(null).getDiskStore().getCrdAutoCacheDiskStore().getSpaceAllocator().setMaxSpace((long)n * 0x100000L);
    }

    @Override
    public void setNeverExpire(boolean bl) {
        this.get("server.autocache.never.expire", Boolean.toString(bl), true);
    }

    @Override
    public double getMaxCubeMemory() {
        if (this.isCluster) {
            return CSUtil.parseFloat(ServerEnv.getPropertyFromClusterRegistry("server.cube.maxmemory"), 0.0f);
        }
        return CSUtil.parseFloat(this.SEDU.getProperty("server.cube.maxmemory", "0"), 0.0f);
    }

    @Override
    public void setMaxCubeMemory(double d) {
        this.get("server.cube.maxmemory", Double.toString(d), true);
        this.SEDU().getMemoryStore().getCubeSpaceAllocator().setMaxSpace((long)(d * 1048576.0));
    }

    private void get(String string, String string2, boolean bl) {
        try {
            if (bl && this.isCluster) {
                ServerEnv.registerProperty(string, string2);
                this.probTable.updateProp("server.properties", string, string2);
            } else {
                this.SEDU.put(string, string2);
                this.saveProperties();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }
}

