/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.export.mail.mailconfig;
import jet.server.ServerEnv;
import jet.server.api.admin.cfg.ConfigurationMail;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.cluster.blocks.MapFlags;
import jet.server.cluster.blocks.MapListenerAdapter;
import jet.server.cluster.util.ClusterInitLocker;
import jet.server.db.cfg.PropsTable;
import jet.server.db.core.GlobalDataService;
import jet.server.jrserver.JRRptServer;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;
import jet.server.util.ServerUtil;

public class JRConfigurationMail
extends MapListenerAdapter
implements ConfigurationMail {
    private static final String CompressMail = "mailconfig.properties";
    private ClusterMap I;
    Properties p = null;
    JRRptServer rptServer = null;
    PropsTable probTable = null;
    boolean isCluster = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRConfigurationMail(JRRptServer jRRptServer) {
        this.rptServer = jRRptServer;
        this.p = new Properties();
        this.isCluster = ServerEnv.isClusterEnabled();
        try {
            this.I = MapFactory.getMap(MapAttr.mailconfig_properties);
            this.I.addListener(this);
            if (this.isCluster) {
                GlobalDataService globalDataService = GlobalDataService.getInstance();
                this.probTable = globalDataService.getPropsTable();
                if (!ClusterInitLocker.hasInited(this.I.getName())) {
                    try {
                        Properties properties = this.probTable.queryProp(CompressMail);
                        if (properties.isEmpty()) {
                            properties = SchdTools.loadMailConfig();
                            this.probTable.doUpdateProp(CompressMail, properties, true);
                        }
                        this.I.putAll((Map)properties);
                    }
                    finally {
                        ClusterInitLocker.setInited(this.I.getName());
                    }
                }
            } else {
                Properties properties = SchdTools.loadMailConfig();
                this.I.putAll((Map)properties);
            }
            this.p.putAll((Map<?, ?>)this.I);
            SchdTools.setMailConfig(this.p);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void afterPut(String string, int n, String string2, String string3, String string4, MapFlags mapFlags) {
        this.p.put(string2, string3);
        try {
            SchdTools.setMailConfig(this.p);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    private void CompressMail(String string, String string2) {
        try {
            this.I.put(string, string2);
            if (this.isCluster) {
                this.probTable.updateProp(CompressMail, string, string2);
            } else {
                SchdTools.saveMailConfig(this.p);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public void setMailServer(String string) {
        if (string != null) {
            this.CompressMail("smtp.server", string);
        }
    }

    @Override
    public String getMailServer() {
        String string = (String)this.I.get("smtp.server");
        if (string == null) {
            string = mailconfig.SMTPServerIP == null ? "" : mailconfig.SMTPServerIP;
        }
        return string;
    }

    @Override
    public void setMailPort(int n) {
        this.CompressMail("smtp.server.port", String.valueOf(n));
    }

    @Override
    public int getMailPort() {
        int n = 25;
        return CSUtil.parseInt((String)this.I.get("smtp.server.port"), n);
    }

    @Override
    public void setMailBox(String string) {
        if (string != null) {
            this.CompressMail("mailbox", string);
        }
    }

    @Override
    public String getMailBox() {
        String string = (String)this.I.get("mailbox");
        if (string == null) {
            string = mailconfig.MyMailAddress == null ? "" : mailconfig.MyMailAddress;
        }
        return string;
    }

    @Override
    public void setMailFormat(int n) {
        this.CompressMail("default.format", String.valueOf(n));
    }

    @Override
    public int getDefaultMailFormat() {
        return CSUtil.parseInt((String)this.I.get("default.format"), mailconfig.defaultIndex);
    }

    @Override
    public Vector getMailFormats() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < mailconfig.mailformat.length; ++i) {
            vector.addElement(mailconfig.mailformat[i]);
        }
        return vector;
    }

    @Override
    public void setEnableCompress(boolean bl) {
        this.CompressMail("compress.mail", String.valueOf(bl));
    }

    @Override
    public boolean getEnableCompress() {
        return CSUtil.getBoolean((String)this.I.get("compress.mail"), mailconfig.CompressMail);
    }

    @Override
    public void setMaxMailSize(int n) {
        this.CompressMail("Tag_MaxMailSize", String.valueOf(n));
    }

    @Override
    public int getMaxMailSize() {
        return CSUtil.parseInt((String)this.I.get("Tag_MaxMailSize"), mailconfig.maxMailSize);
    }

    @Override
    public void setMaxMailPage(int n) {
        this.CompressMail("Tag_MaxMailPage", String.valueOf(n));
    }

    @Override
    public int getMaxMailPage() {
        return CSUtil.parseInt((String)this.I.get("Tag_MaxMailPage"), -1);
    }

    @Override
    public void setSplitBy(int n) {
        this.CompressMail("Tag_SplitBy", String.valueOf(n));
    }

    @Override
    public int getSplitBy() {
        return CSUtil.parseInt((String)this.I.get("Tag_SplitBy"), 0);
    }

    @Override
    public boolean getAuthentication() {
        return CSUtil.getBoolean((String)this.I.get("smtp.authentication"), false);
    }

    @Override
    public void setAuthentication(boolean bl) {
        this.CompressMail("smtp.authentication", String.valueOf(bl));
    }

    @Override
    public boolean getSSL() {
        return CSUtil.getBoolean((String)this.I.get("smtp.SSL"), false);
    }

    @Override
    public void setSSL(boolean bl) {
        this.CompressMail("smtp.SSL", String.valueOf(bl));
    }

    @Override
    public String getEncoding() {
        String string = (String)this.I.get("mail.encoding");
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public void setEncoding(String string) {
        this.CompressMail("mail.encoding", string);
    }

    @Override
    public String getAuthenticationUser() {
        String string = (String)this.I.get("smtp.user");
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public void setAuthenticationUser(String string) {
        this.CompressMail("smtp.user", string);
    }

    @Override
    public String getAuthenticationPassword() {
        String string = (String)this.I.get("smtp.password");
        string = string == null ? "" : ServerUtil.decode(string);
        return string;
    }

    @Override
    public void setAuthenticationPassword(String string) {
        String string2 = ServerUtil.encode(string);
        this.CompressMail("smtp.password", string2);
    }
}

