/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.dynamiccon;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.CatConnectionInfo;
import jet.server.api.RptServer;
import jet.server.api.RptServerException;
import jet.server.api.dynamiccon.DynamicConnection;
import jet.server.api.dynamiccon.DynamicConnectionProvider;
import jet.server.api.dynamiccon.DynamicConnectionService;
import jet.server.jrc.admin.JRDynamicConnectionManager;
import jet.server.jrserver.dynamiccon.AdapterCatDynamicConnection;
import jet.server.jrserver.dynamiccon.DefaultDynamicConnectionProvider;
import jet.server.log.ServiceLogger;

public class JRDynamicConnectionService
implements DynamicConnectionService {
    private RptServer SEDU;
    private DynamicConnectionProvider add;
    private boolean containsKey;

    public JRDynamicConnectionService(RptServer rptServer, JRDynamicConnectionManager jRDynamicConnectionManager) {
        this.SEDU = rptServer;
        String string = ServerEnv.getCustomDynamicConnectionProvider();
        if (string != null && !string.isEmpty()) {
            try {
                this.add = (DynamicConnectionProvider)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                ServiceLogger.logError("Load customer DynamicConnectionProvider failed.");
                ServiceLogger.logError(exception);
            }
        }
        if (this.add == null) {
            ServiceLogger.logDebug("Use default DynamicConnectionProvider.");
            this.add = new DefaultDynamicConnectionProvider(jRDynamicConnectionManager);
        }
        this.containsKey = this.add instanceof DefaultDynamicConnectionProvider;
    }

    private DynamicConnection SEDU(String string, String string2, int n, String string3) throws RptServerException {
        Object object;
        if (this.containsKey) {
            return null;
        }
        Object object2 = null;
        Vector<CatConnectionInfo> vector = this.SEDU.getCatalogInfo(string, string2, n).getCatConnectionInfos();
        Hashtable hashtable = new Hashtable();
        for (CatConnectionInfo object3 : vector) {
            List<CatConnectionInfo> list;
            if (!"JDBC Connection".equals(object3.getType())) continue;
            object = object3.getDatasourceName();
            if (!hashtable.containsKey(object)) {
                list = new ArrayList();
                hashtable.put(object, list);
            }
            list = (List)hashtable.get(object);
            list.add(object3);
        }
        List list = (List)hashtable.get(string3);
        if (1 == list.size()) {
            object2 = (CatConnectionInfo)list.get(0);
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (CatConnectionInfo)iterator.next();
                if (!object.isDefaultConnection()) continue;
                object2 = object;
                break;
            }
        }
        if (object2 == null) {
            return null;
        }
        return new AdapterCatDynamicConnection((CatConnectionInfo)object2);
    }

    private DynamicConnection add(String string, String string2, int n, String string3, String string4) throws RptServerException {
        if (null == string4) {
            return this.SEDU(string, string2, n, string3);
        }
        if (this.containsKey) {
            return null;
        }
        CatConnectionInfo catConnectionInfo = null;
        Vector<CatConnectionInfo> vector = this.SEDU.getCatalogInfo(string, string2, n).getCatConnectionInfos();
        for (CatConnectionInfo catConnectionInfo2 : vector) {
            if (!"JDBC Connection".equals(catConnectionInfo2.getType()) || !catConnectionInfo2.getDatasourceName().equals(string3) || !catConnectionInfo2.getName().equals(string4)) continue;
            catConnectionInfo = catConnectionInfo2;
            break;
        }
        if (catConnectionInfo == null) {
            return null;
        }
        return new AdapterCatDynamicConnection(catConnectionInfo);
    }

    @Override
    public DynamicConnection[] getAvailableDynamicConnections(String string, String string2, int n, String string3) throws RptServerException {
        if (!ServerEnv.needSecurity()) {
            return null;
        }
        DynamicConnection dynamicConnection = this.SEDU(string, string2, n, string3);
        return this.containsKey(string, string2, n, string3, dynamicConnection);
    }

    @Override
    public DynamicConnection[] getAvailableDynamicConnections(String string, String string2, int n, String string3, String string4) throws RptServerException {
        if (null == string4) {
            return this.getAvailableDynamicConnections(string, string2, n, string3);
        }
        if (!ServerEnv.needSecurity()) {
            return null;
        }
        DynamicConnection dynamicConnection = this.add(string, string2, n, string3, string4);
        return this.equals(string, string2, n, string3, string4, dynamicConnection);
    }

    @Override
    public DynamicConnection[] getAvailableDynamicConnections(String string, String string2, int n, String string3, DynamicConnection dynamicConnection) throws RptServerException {
        if (dynamicConnection == null) {
            return null;
        }
        if (!ServerEnv.needSecurity()) {
            return null;
        }
        return this.containsKey(string, string2, n, string3, dynamicConnection);
    }

    @Override
    public DynamicConnection[] getAvailableDynamicConnections(String string, String string2, int n, String string3, String string4, DynamicConnection dynamicConnection) throws RptServerException {
        if (null == string4) {
            return this.getAvailableDynamicConnections(string, string2, n, string3, dynamicConnection);
        }
        if (dynamicConnection == null) {
            return null;
        }
        if (!ServerEnv.needSecurity()) {
            return null;
        }
        return this.equals(string, string2, n, string3, string4, dynamicConnection);
    }

    private DynamicConnection[] containsKey(String string, String string2, int n, String string3, DynamicConnection dynamicConnection) throws RptServerException {
        Object object;
        Object object3 = null;
        Vector<CatConnectionInfo> vector = this.SEDU.getCatalogInfo(string, string2, n).getCatConnectionInfos();
        Hashtable hashtable = new Hashtable();
        for (CatConnectionInfo object22 : vector) {
            List<CatConnectionInfo> list;
            if (!"JDBC Connection".equals(object22.getType())) continue;
            object = object22.getDatasourceName();
            if (!hashtable.containsKey(object)) {
                list = new ArrayList();
                hashtable.put(object, list);
            }
            list = (List)hashtable.get(object);
            list.add(object22);
        }
        List list = (List)hashtable.get(string3);
        if (1 == list.size()) {
            object3 = (CatConnectionInfo)list.get(0);
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (CatConnectionInfo)iterator.next();
                if (!object.isDefaultConnection()) continue;
                object3 = object;
                break;
            }
        }
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
        if (null == object3) {
            return this.add.getAvailableDynamicConnections(stringArray[0], stringArray[1], string2, string3, dynamicConnection);
        }
        return this.add.getAvailableDynamicConnections(stringArray[0], stringArray[1], string2, string3, object3.getName(), dynamicConnection);
    }

    private DynamicConnection[] equals(String string, String string2, int n, String string3, String string4, DynamicConnection dynamicConnection) throws RptServerException {
        if (null == string4) {
            return this.containsKey(string, string2, n, string3, dynamicConnection);
        }
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
        return this.add.getAvailableDynamicConnections(stringArray[0], stringArray[1], string2, string3, string4, dynamicConnection);
    }

    @Override
    public DynamicConnection getDynamicConnection(String string, String string2, int n, String string3, String string4) throws RptServerException {
        DynamicConnection dynamicConnection = this.SEDU(string, string2, n, string3);
        return this.forName(string, string2, n, string3, string4, dynamicConnection);
    }

    @Override
    public DynamicConnection getDynamicConnection(String string, String string2, int n, String string3, String string4, String string5) throws RptServerException {
        DynamicConnection dynamicConnection = this.SEDU(string, string2, n, string3);
        if (null == string4) {
            return this.getDynamicConnection(string, string2, n, string3, string5);
        }
        return this.get(string, string2, n, string3, string4, string5, dynamicConnection);
    }

    @Override
    public DynamicConnection getDynamicConnection(String string, String string2, int n, String string3, String string4, DynamicConnection dynamicConnection) throws RptServerException {
        if (dynamicConnection == null) {
            return null;
        }
        return this.forName(string, string2, n, string3, string4, dynamicConnection);
    }

    @Override
    public DynamicConnection getDynamicConnection(String string, String string2, int n, String string3, String string4, String string5, DynamicConnection dynamicConnection) throws RptServerException {
        if (null == string4) {
            return this.getDynamicConnection(string, string2, n, string3, string5, dynamicConnection);
        }
        if (dynamicConnection == null) {
            return null;
        }
        return this.get(string, string2, n, string3, string4, string5, dynamicConnection);
    }

    private DynamicConnection forName(String string, String string2, int n, String string3, String string4, DynamicConnection dynamicConnection) throws RptServerException {
        Object object;
        Object object3 = null;
        Vector<CatConnectionInfo> vector = this.SEDU.getCatalogInfo(string, string2, n).getCatConnectionInfos();
        Hashtable hashtable = new Hashtable();
        for (CatConnectionInfo object22 : vector) {
            List<CatConnectionInfo> list;
            if (!"JDBC Connection".equals(object22.getType())) continue;
            object = object22.getDatasourceName();
            if (!hashtable.containsKey(object)) {
                list = new ArrayList();
                hashtable.put(object, list);
            }
            list = (List)hashtable.get(object);
            list.add(object22);
        }
        List list = (List)hashtable.get(string3);
        if (1 == list.size()) {
            object3 = (CatConnectionInfo)list.get(0);
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (CatConnectionInfo)iterator.next();
                if (!object.isDefaultConnection()) continue;
                object3 = object;
                break;
            }
        }
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
        if (null == object3) {
            return this.add.getDynamicConnection(stringArray[0], stringArray[1], string2, string3, dynamicConnection, string4);
        }
        return this.add.getDynamicConnection(stringArray[0], stringArray[1], string2, string3, object3.getName(), dynamicConnection, string4);
    }

    private DynamicConnection get(String string, String string2, int n, String string3, String string4, String string5, DynamicConnection dynamicConnection) throws RptServerException {
        if (null == string4) {
            return this.forName(string, string2, n, string3, string5, dynamicConnection);
        }
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
        return this.add.getDynamicConnection(stringArray[0], stringArray[1], string2, string3, string4, dynamicConnection, string5);
    }
}

