/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.ibus;

import com.jinfonet.ibus.InfoLifeCycleType;
import com.jinfonet.ibus.InformationContainer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import jet.server.cluster.ClusterRuntimeException;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.log.ServiceLogger;

public class JRInformationContainer
implements InformationContainer {
    private ClusterMap $SwitchMap$com$jinfonet$ibus$InfoLifeCycleType = null;
    private ClusterMap EXPIRE_TABLE = null;
    private ClusterMap LONG_TIME_OBJECTS = null;
    private ClusterMap ONCE_TIME_OBJECTS = null;

    public JRInformationContainer(String string) throws Exception {
        ServiceLogger.logDebug("iContainerImpl::iContainerImpl: idSuffix=" + string, 5);
        this.$SwitchMap$com$jinfonet$ibus$InfoLifeCycleType = MapFactory.getMapByName(MapAttr.makeMapName(MapAttr.LONG_TIME_OBJECTS, string));
        this.EXPIRE_TABLE = MapFactory.getMapByName(MapAttr.makeMapName(MapAttr.SPECIFIED_TIEM_OBJECTS, string));
        this.LONG_TIME_OBJECTS = MapFactory.getMapByName(MapAttr.makeMapName(MapAttr.ONCE_TIME_OBJECTS, string));
        this.ONCE_TIME_OBJECTS = MapFactory.getMapByName(MapAttr.makeMapName(MapAttr.EXPIRE_TABLE, string));
    }

    @Override
    public void putInfo(String string, Serializable serializable, InfoLifeCycleType infoLifeCycleType, Object ... objectArray) {
        if (this.LONG_TIME_OBJECTS.containsKey(string)) {
            Object object = this.LONG_TIME_OBJECTS.remove(string);
            ServiceLogger.logDebug("iContainerImpl::putInfo: oldObj=" + object + ", life cycle type= " + (Object)((Object)infoLifeCycleType) + ", key= " + string + ", object= " + serializable, 6);
        } else if (this.EXPIRE_TABLE.containsKey(string)) {
            Object object = this.EXPIRE_TABLE.remove(string);
            ServiceLogger.logDebug("iContainerImpl::putInfo: oldObj=" + object + ", life cycle type= " + (Object)((Object)infoLifeCycleType) + ", key= " + string + ", object= " + serializable, 6);
        } else if (this.$SwitchMap$com$jinfonet$ibus$InfoLifeCycleType.containsKey(string)) {
            Object object = this.$SwitchMap$com$jinfonet$ibus$InfoLifeCycleType.remove(string);
            ServiceLogger.logDebug("iContainerImpl::putInfo: oldObj=" + object + ", life cycle type= " + (Object)((Object)infoLifeCycleType) + ", key= " + string + ", object= " + serializable, 6);
        }
        switch (infoLifeCycleType) {
            case ONCE_TIME: {
                this.LONG_TIME_OBJECTS.put(string, serializable);
                ServiceLogger.logDebug("Put info into container, life cycle type= " + (Object)((Object)infoLifeCycleType) + ", key= " + string + ", object= " + serializable, 7);
                break;
            }
            case LONG_TIME: {
                this.$SwitchMap$com$jinfonet$ibus$InfoLifeCycleType.put(string, serializable);
                ServiceLogger.logDebug("Put info into container, life cycle type= " + (Object)((Object)infoLifeCycleType) + ", key= " + string + ", object= " + serializable, 7);
                break;
            }
            case SPECIFIED_TIME: {
                if (null != objectArray && 1 == objectArray.length && null != objectArray[0]) {
                    Object object = objectArray[0];
                    ServiceLogger.logDebug("Put info into container, life cycle type= " + (Object)((Object)infoLifeCycleType) + ", key= " + string + ", object= " + serializable + ", life_cycle= " + object, 7);
                    Date date = null;
                    if (object instanceof Date) {
                        date = (Date)object;
                        if (date.before(new Date())) {
                            ServiceLogger.logDebug("The put object has expired, life cycle type= " + (Object)((Object)infoLifeCycleType) + ", key= " + string + ", object= " + serializable + ", life_cycle= " + date, 6);
                            return;
                        }
                    } else if (object instanceof Long) {
                        long l = (Long)object;
                        date = new Date(System.currentTimeMillis() + l);
                        if (date.before(new Date())) {
                            ServiceLogger.logDebug("The put object has expired, life cycle type= " + (Object)((Object)infoLifeCycleType) + ", key= " + string + ", object= " + serializable + ", life_cycle= " + (Long)object, 6);
                            return;
                        }
                        this.ONCE_TIME_OBJECTS.put(string, date);
                    } else if (object instanceof Integer) {
                        int n = (Integer)object;
                        date = new Date(System.currentTimeMillis() + (long)n);
                        if (date.before(new Date())) {
                            ServiceLogger.logDebug("The put object has expired, life cycle type= " + (Object)((Object)infoLifeCycleType) + ", key= " + string + ", object= " + serializable + ", life_cycle= " + (Integer)object, 6);
                            return;
                        }
                    } else {
                        ServiceLogger.logDebug("Unspoorted life cycle object, life cycle type= " + (Object)((Object)infoLifeCycleType) + ", key= " + string + ", object= " + serializable + ", life_cycle= " + object, 6);
                        return;
                    }
                    this.ONCE_TIME_OBJECTS.put(string, date);
                    this.EXPIRE_TABLE.put(string, serializable);
                    break;
                }
                ServiceLogger.logDebug("No life cycle object, life cycle type= " + (Object)((Object)infoLifeCycleType) + ", key= " + string + ", object= " + serializable, 6);
                break;
            }
            default: {
                ServiceLogger.logDebug("Unsupport life cycle type= " + (Object)((Object)infoLifeCycleType) + ", key= " + string + ", object= " + serializable, 6);
            }
        }
    }

    @Override
    public Serializable getInfo(String string) {
        if (this.LONG_TIME_OBJECTS.containsKey(string)) {
            return (Serializable)this.LONG_TIME_OBJECTS.remove(string);
        }
        if (this.EXPIRE_TABLE.containsKey(string)) {
            Date date = (Date)this.ONCE_TIME_OBJECTS.get(string);
            if (date.before(new Date())) {
                this.ONCE_TIME_OBJECTS.remove(string);
                Object object = this.EXPIRE_TABLE.remove(string);
                ServiceLogger.logDebug("Has object expire:  key= " + string + ", object= " + object, 6);
                return null;
            }
            return (Serializable)this.EXPIRE_TABLE.get(string);
        }
        if (this.$SwitchMap$com$jinfonet$ibus$InfoLifeCycleType.containsKey(string)) {
            return (Serializable)this.$SwitchMap$com$jinfonet$ibus$InfoLifeCycleType.get(string);
        }
        return null;
    }

    @Override
    public boolean removeInfo(String string) {
        if (this.LONG_TIME_OBJECTS.containsKey(string)) {
            this.LONG_TIME_OBJECTS.remove(string);
            return true;
        }
        if (this.EXPIRE_TABLE.containsKey(string)) {
            this.ONCE_TIME_OBJECTS.remove(string);
            this.EXPIRE_TABLE.remove(string);
            return true;
        }
        if (this.$SwitchMap$com$jinfonet$ibus$InfoLifeCycleType.containsKey(string)) {
            this.$SwitchMap$com$jinfonet$ibus$InfoLifeCycleType.remove(string);
            return true;
        }
        return false;
    }

    @Override
    public List getAllInfo() {
        List<Object> list = Collections.synchronizedList(new ArrayList());
        for (String string : this.LONG_TIME_OBJECTS.keySet()) {
            list.add(this.LONG_TIME_OBJECTS.remove(string));
        }
        for (String string : this.EXPIRE_TABLE.keySet()) {
            Date date = (Date)this.ONCE_TIME_OBJECTS.get(string);
            if (date.before(new Date())) {
                this.ONCE_TIME_OBJECTS.remove(string);
                Object object = this.EXPIRE_TABLE.remove(string);
                ServiceLogger.logDebug("Has object expire:  key= " + string + ", object= " + object, 6);
                continue;
            }
            list.add(this.EXPIRE_TABLE.get(string));
        }
        for (String string : this.$SwitchMap$com$jinfonet$ibus$InfoLifeCycleType.keySet()) {
            list.add(this.$SwitchMap$com$jinfonet$ibus$InfoLifeCycleType.get(string));
        }
        return list;
    }

    protected void expire() {
        Date date = new Date();
        try {
            for (String string : this.ONCE_TIME_OBJECTS.keySet()) {
                Date date2 = (Date)this.ONCE_TIME_OBJECTS.get(string);
                if (!date2.before(date)) continue;
                this.ONCE_TIME_OBJECTS.remove(string);
                Object object = this.EXPIRE_TABLE.remove(string);
                ServiceLogger.logDebug("Has object expire:  key= " + string + ", object= " + object, 6);
            }
        }
        catch (ClusterRuntimeException clusterRuntimeException) {
            ServiceLogger.logError(clusterRuntimeException, 3);
        }
    }
}

