/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.rmi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.InvalidUserSessionException;
import jet.server.api.TooManyUsersException;
import jet.server.api.UserSession;
import jet.server.api.UserSessionManager;
import jet.server.api.rmi.RemoteAuthenticator;
import jet.server.api.rmi.RemoteUserSessionManager;
import jet.server.jrrmisvr.JRAuthenticator;
import jet.server.jrserver.JRUserSessionManager;
import jet.server.jrserver.rmi.JRRemoteAuthenticator;

public class JRRemoteUserSessionManager
extends UnicastRemoteObject
implements RemoteUserSessionManager {
    private UserSessionManager SEDU = null;
    private RemoteAuthenticator add = null;

    public JRRemoteUserSessionManager(UserSessionManager userSessionManager) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.SEDU = userSessionManager;
    }

    @Override
    public void setAuthenticator(RemoteAuthenticator remoteAuthenticator) throws RemoteException {
        this.SEDU.setAuthenticator(new JRAuthenticator(remoteAuthenticator));
    }

    @Override
    public RemoteAuthenticator getAuthenticator() throws RemoteException {
        if (this.add == null) {
            this.add = new JRRemoteAuthenticator(this.SEDU.getAuthenticator());
        }
        return this.add;
    }

    @Override
    public void setDefaultMaxInactiveInterval(int n) throws RemoteException {
        this.SEDU.setDefaultMaxInactiveInterval(n);
    }

    @Override
    public int getDefaultMaxInactiveInterval() throws RemoteException {
        return this.SEDU.getDefaultMaxInactiveInterval();
    }

    @Override
    public UserSession login(String string, String string2, String string3) throws RemoteException, TooManyUsersException {
        return this.SEDU.login(string, string2, string3, null);
    }

    @Override
    public UserSession login(String string, String string2, String string3, boolean bl, boolean bl2) throws RemoteException, TooManyUsersException {
        return ((JRUserSessionManager)this.SEDU).login(string, string2, string3, null, bl, bl2);
    }

    @Override
    public UserSession loginExternalAuthorized(String string, String string2) throws RemoteException, TooManyUsersException {
        return this.SEDU.loginExternalAuthorized(string, string2, null);
    }

    @Override
    public void logout(String string) throws RemoteException {
        UserSession userSession = this.SEDU.getUserSession(string);
        this.SEDU.logout(userSession);
    }

    @Override
    public UserSession getUserSession(String string) throws RemoteException {
        return this.SEDU.getUserSession(string);
    }

    @Override
    public Vector getAllUserSessions() throws RemoteException {
        Vector vector = new Vector();
        Enumeration enumeration = this.SEDU.getAllUserSessions();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    @Override
    public Vector getAllWaitUserSessions() throws RemoteException {
        Vector vector = new Vector();
        Enumeration enumeration = this.SEDU.getAllWaitUserSessions();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    @Override
    public void refreshLastAccessTime(String string) throws RemoteException, InvalidUserSessionException {
        this.SEDU.refreshLastAccessTime(string);
    }

    @Override
    public boolean isWait(String string) {
        return this.SEDU.isWait(string);
    }

    @Override
    public void putSessions(String string) {
        UserSession userSession = this.SEDU.getUserSession(string);
        this.SEDU.putSessions(userSession);
    }

    @Override
    public boolean needSecurity() {
        return this.SEDU.needSecurity();
    }

    @Override
    public long getLastLoginTime(String string) throws RemoteException {
        return this.SEDU.getLastLoginTime(string);
    }

    @Override
    public long getLastLogoutTime(String string) throws RemoteException {
        return this.SEDU.getLastLogoutTime(string);
    }

    @Override
    public void updateUserSession(UserSession userSession) throws RemoteException, InvalidUserSessionException {
        this.SEDU.updateUserSession(userSession);
    }
}

